require '_h2ph_pre.ph';

unless(defined(&HEADER_PEM_H)) {
    eval 'sub HEADER_PEM_H () {1;}' unless defined(&HEADER_PEM_H);
    unless(defined(&OPENSSL_NO_BIO)) {
	require 'openssl/bio.ph';
    }
    unless(defined(&OPENSSL_NO_STACK)) {
	require 'openssl/stack.ph';
    }
    require 'openssl/evp.ph';
    require 'openssl/x509.ph';
    require 'openssl/pem2.ph';
    require 'openssl/e_os2.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub PEM_BUFSIZE () {1024;}' unless defined(&PEM_BUFSIZE);
    eval 'sub PEM_OBJ_UNDEF () {0;}' unless defined(&PEM_OBJ_UNDEF);
    eval 'sub PEM_OBJ_X509 () {1;}' unless defined(&PEM_OBJ_X509);
    eval 'sub PEM_OBJ_X509_REQ () {2;}' unless defined(&PEM_OBJ_X509_REQ);
    eval 'sub PEM_OBJ_CRL () {3;}' unless defined(&PEM_OBJ_CRL);
    eval 'sub PEM_OBJ_SSL_SESSION () {4;}' unless defined(&PEM_OBJ_SSL_SESSION);
    eval 'sub PEM_OBJ_PRIV_KEY () {10;}' unless defined(&PEM_OBJ_PRIV_KEY);
    eval 'sub PEM_OBJ_PRIV_RSA () {11;}' unless defined(&PEM_OBJ_PRIV_RSA);
    eval 'sub PEM_OBJ_PRIV_DSA () {12;}' unless defined(&PEM_OBJ_PRIV_DSA);
    eval 'sub PEM_OBJ_PRIV_DH () {13;}' unless defined(&PEM_OBJ_PRIV_DH);
    eval 'sub PEM_OBJ_PUB_RSA () {14;}' unless defined(&PEM_OBJ_PUB_RSA);
    eval 'sub PEM_OBJ_PUB_DSA () {15;}' unless defined(&PEM_OBJ_PUB_DSA);
    eval 'sub PEM_OBJ_PUB_DH () {16;}' unless defined(&PEM_OBJ_PUB_DH);
    eval 'sub PEM_OBJ_DHPARAMS () {17;}' unless defined(&PEM_OBJ_DHPARAMS);
    eval 'sub PEM_OBJ_DSAPARAMS () {18;}' unless defined(&PEM_OBJ_DSAPARAMS);
    eval 'sub PEM_OBJ_PRIV_RSA_PUBLIC () {19;}' unless defined(&PEM_OBJ_PRIV_RSA_PUBLIC);
    eval 'sub PEM_ERROR () {30;}' unless defined(&PEM_ERROR);
    eval 'sub PEM_DEK_DES_CBC () {40;}' unless defined(&PEM_DEK_DES_CBC);
    eval 'sub PEM_DEK_IDEA_CBC () {45;}' unless defined(&PEM_DEK_IDEA_CBC);
    eval 'sub PEM_DEK_DES_EDE () {50;}' unless defined(&PEM_DEK_DES_EDE);
    eval 'sub PEM_DEK_DES_ECB () {60;}' unless defined(&PEM_DEK_DES_ECB);
    eval 'sub PEM_DEK_RSA () {70;}' unless defined(&PEM_DEK_RSA);
    eval 'sub PEM_DEK_RSA_MD2 () {80;}' unless defined(&PEM_DEK_RSA_MD2);
    eval 'sub PEM_DEK_RSA_MD5 () {90;}' unless defined(&PEM_DEK_RSA_MD5);
    eval 'sub PEM_MD_MD2 () { &NID_md2;}' unless defined(&PEM_MD_MD2);
    eval 'sub PEM_MD_MD5 () { &NID_md5;}' unless defined(&PEM_MD_MD5);
    eval 'sub PEM_MD_SHA () { &NID_sha;}' unless defined(&PEM_MD_SHA);
    eval 'sub PEM_MD_MD2_RSA () { &NID_md2WithRSAEncryption;}' unless defined(&PEM_MD_MD2_RSA);
    eval 'sub PEM_MD_MD5_RSA () { &NID_md5WithRSAEncryption;}' unless defined(&PEM_MD_MD5_RSA);
    eval 'sub PEM_MD_SHA_RSA () { &NID_sha1WithRSAEncryption;}' unless defined(&PEM_MD_SHA_RSA);
    eval 'sub PEM_STRING_X509_OLD () {"X509 CERTIFICATE";}' unless defined(&PEM_STRING_X509_OLD);
    eval 'sub PEM_STRING_X509 () {"CERTIFICATE";}' unless defined(&PEM_STRING_X509);
    eval 'sub PEM_STRING_X509_TRUSTED () {"TRUSTED CERTIFICATE";}' unless defined(&PEM_STRING_X509_TRUSTED);
    eval 'sub PEM_STRING_X509_REQ_OLD () {"NEW CERTIFICATE REQUEST";}' unless defined(&PEM_STRING_X509_REQ_OLD);
    eval 'sub PEM_STRING_X509_REQ () {"CERTIFICATE REQUEST";}' unless defined(&PEM_STRING_X509_REQ);
    eval 'sub PEM_STRING_X509_CRL () {"X509 CRL";}' unless defined(&PEM_STRING_X509_CRL);
    eval 'sub PEM_STRING_EVP_PKEY () {"ANY PRIVATE KEY";}' unless defined(&PEM_STRING_EVP_PKEY);
    eval 'sub PEM_STRING_PUBLIC () {"PUBLIC KEY";}' unless defined(&PEM_STRING_PUBLIC);
    eval 'sub PEM_STRING_RSA () {"RSA PRIVATE KEY";}' unless defined(&PEM_STRING_RSA);
    eval 'sub PEM_STRING_RSA_PUBLIC () {"RSA PUBLIC KEY";}' unless defined(&PEM_STRING_RSA_PUBLIC);
    eval 'sub PEM_STRING_DSA () {"DSA PRIVATE KEY";}' unless defined(&PEM_STRING_DSA);
    eval 'sub PEM_STRING_DSA_PUBLIC () {"DSA PUBLIC KEY";}' unless defined(&PEM_STRING_DSA_PUBLIC);
    eval 'sub PEM_STRING_PKCS7 () {"PKCS7";}' unless defined(&PEM_STRING_PKCS7);
    eval 'sub PEM_STRING_PKCS8 () {"ENCRYPTED PRIVATE KEY";}' unless defined(&PEM_STRING_PKCS8);
    eval 'sub PEM_STRING_PKCS8INF () {"PRIVATE KEY";}' unless defined(&PEM_STRING_PKCS8INF);
    eval 'sub PEM_STRING_DHPARAMS () {"DH PARAMETERS";}' unless defined(&PEM_STRING_DHPARAMS);
    eval 'sub PEM_STRING_SSL_SESSION () {"SSL SESSION PARAMETERS";}' unless defined(&PEM_STRING_SSL_SESSION);
    eval 'sub PEM_STRING_DSAPARAMS () {"DSA PARAMETERS";}' unless defined(&PEM_STRING_DSAPARAMS);
    eval 'sub PEM_TYPE_ENCRYPTED () {10;}' unless defined(&PEM_TYPE_ENCRYPTED);
    eval 'sub PEM_TYPE_MIC_ONLY () {20;}' unless defined(&PEM_TYPE_MIC_ONLY);
    eval 'sub PEM_TYPE_MIC_CLEAR () {30;}' unless defined(&PEM_TYPE_MIC_CLEAR);
    eval 'sub PEM_TYPE_CLEAR () {40;}' unless defined(&PEM_TYPE_CLEAR);
    unless(defined(&OPENSSL_NO_STACK)) {
    } else {
    }
    if(defined(&OPENSSL_NO_FP_API)) {
	eval 'sub IMPLEMENT_PEM_read_fp {
	    local($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_read_fp);
	eval 'sub IMPLEMENT_PEM_write_fp {
	    local($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_write_fp);
	eval 'sub IMPLEMENT_PEM_write_cb_fp {
	    local($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_write_cb_fp);
    } else {
	eval 'sub IMPLEMENT_PEM_read_fp {
	    local($name, $type, $str, $asn1) = @_;
    	    eval q($type * &PEM_read_$name(\'FILE\' * &fp, $type ** &x,  &pem_password_cb * &cb,  &void * &u){  &return( &PEM_ASN1_read((\'char\' *(*)()) &d2i_$asn1, $str, &fp, &x,  &cb, &u)); });
	}' unless defined(&IMPLEMENT_PEM_read_fp);
	eval 'sub IMPLEMENT_PEM_write_fp {
	    local($name, $type, $str, $asn1) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x) {  &return( &PEM_ASN1_write(( &int (*)()) &i2d_$asn1,$str, &fp,  &x,  &NULL, &NULL,0, &NULL, &NULL)); });
	}' unless defined(&IMPLEMENT_PEM_write_fp);
	eval 'sub IMPLEMENT_PEM_write_cb_fp {
	    local($name, $type, $str, $asn1) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u) {  &return( &PEM_ASN1_write(( &int (*)()) &i2d_$asn1,$str, &fp,  &x, &enc, &kstr, &klen, &cb, &u)); });
	}' unless defined(&IMPLEMENT_PEM_write_cb_fp);
    }
    eval 'sub IMPLEMENT_PEM_read_bio {
        local($name, $type, $str, $asn1) = @_;
	    eval q($type * &PEM_read_bio_$name( &BIO * &bp, $type ** &x,  &pem_password_cb * &cb,  &void * &u){  &return( &PEM_ASN1_read_bio((\'char\' *(*)()) &d2i_$asn1, $str, &bp,  &x, &cb, &u)); });
    }' unless defined(&IMPLEMENT_PEM_read_bio);
    eval 'sub IMPLEMENT_PEM_write_bio {
        local($name, $type, $str, $asn1) = @_;
	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x) {  &return( &PEM_ASN1_write_bio(( &int (*)()) &i2d_$asn1,$str, &bp,  &x,  &NULL, &NULL,0, &NULL, &NULL)); });
    }' unless defined(&IMPLEMENT_PEM_write_bio);
    eval 'sub IMPLEMENT_PEM_write_cb_bio {
        local($name, $type, $str, $asn1) = @_;
	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u) {  &return( &PEM_ASN1_write_bio(( &int (*)()) &i2d_$asn1,$str, &bp,  &x, &enc, &kstr, &klen, &cb, &u)); });
    }' unless defined(&IMPLEMENT_PEM_write_cb_bio);
    eval 'sub IMPLEMENT_PEM_write {
        local($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_write_bio($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_fp($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_write);
    eval 'sub IMPLEMENT_PEM_write_cb {
        local($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_write_cb_bio($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_cb_fp($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_write_cb);
    eval 'sub IMPLEMENT_PEM_read {
        local($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_read_bio($name, $type, $str, $asn1)  &IMPLEMENT_PEM_read_fp($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_read);
    eval 'sub IMPLEMENT_PEM_rw {
        local($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_read($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_rw);
    eval 'sub IMPLEMENT_PEM_rw_cb {
        local($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_read($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_cb($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_rw_cb);
    if(defined( &OPENSSL_SYS_WIN16) || defined( &OPENSSL_NO_FP_API)) {
	eval 'sub DECLARE_PEM_read_fp {
	    local($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_read_fp);
	eval 'sub DECLARE_PEM_write_fp {
	    local($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_fp);
	eval 'sub DECLARE_PEM_write_cb_fp {
	    local($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_cb_fp);
    } else {
	eval 'sub DECLARE_PEM_read_fp {
	    local($name, $type) = @_;
    	    eval q($type * &PEM_read_$name(\'FILE\' * &fp, $type ** &x,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_read_fp);
	eval 'sub DECLARE_PEM_write_fp {
	    local($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x););
	}' unless defined(&DECLARE_PEM_write_fp);
	eval 'sub DECLARE_PEM_write_cb_fp {
	    local($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_write_cb_fp);
    }
    unless(defined(&OPENSSL_NO_BIO)) {
	eval 'sub DECLARE_PEM_read_bio {
	    local($name, $type) = @_;
    	    eval q($type * &PEM_read_bio_$name( &BIO * &bp, $type ** &x,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_read_bio);
	eval 'sub DECLARE_PEM_write_bio {
	    local($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x););
	}' unless defined(&DECLARE_PEM_write_bio);
	eval 'sub DECLARE_PEM_write_cb_bio {
	    local($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_write_cb_bio);
    } else {
	eval 'sub DECLARE_PEM_read_bio {
	    local($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_read_bio);
	eval 'sub DECLARE_PEM_write_bio {
	    local($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_bio);
	eval 'sub DECLARE_PEM_write_cb_bio {
	    local($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_cb_bio);
    }
    eval 'sub DECLARE_PEM_write {
        local($name, $type) = @_;
	    eval q( &DECLARE_PEM_write_bio($name, $type)  &DECLARE_PEM_write_fp($name, $type));
    }' unless defined(&DECLARE_PEM_write);
    eval 'sub DECLARE_PEM_write_cb {
        local($name, $type) = @_;
	    eval q( &DECLARE_PEM_write_cb_bio($name, $type)  &DECLARE_PEM_write_cb_fp($name, $type));
    }' unless defined(&DECLARE_PEM_write_cb);
    eval 'sub DECLARE_PEM_read {
        local($name, $type) = @_;
	    eval q( &DECLARE_PEM_read_bio($name, $type)  &DECLARE_PEM_read_fp($name, $type));
    }' unless defined(&DECLARE_PEM_read);
    eval 'sub DECLARE_PEM_rw {
        local($name, $type) = @_;
	    eval q( &DECLARE_PEM_read($name, $type)  &DECLARE_PEM_write($name, $type));
    }' unless defined(&DECLARE_PEM_rw);
    eval 'sub DECLARE_PEM_rw_cb {
        local($name, $type) = @_;
	    eval q( &DECLARE_PEM_read($name, $type)  &DECLARE_PEM_write_cb($name, $type));
    }' unless defined(&DECLARE_PEM_rw_cb);
    if(defined(&SSLEAY_MACROS)) {
	eval 'sub PEM_write_SSL_SESSION {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_SSL_SESSION,  &PEM_STRING_SSL_SESSION,$fp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_SSL_SESSION);
	eval 'sub PEM_write_X509 {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_X509, &PEM_STRING_X509,$fp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_X509);
	eval 'sub PEM_write_X509_REQ {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write( ( &int (*)()) &i2d_X509_REQ, &PEM_STRING_X509_REQ,$fp,$x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_X509_REQ);
	eval 'sub PEM_write_X509_CRL {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_X509_CRL, &PEM_STRING_X509_CRL, $fp,$x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_X509_CRL);
	eval 'sub PEM_write_RSAPrivateKey {
	    local($fp,$x,$enc,$kstr,$klen,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_RSAPrivateKey, &PEM_STRING_RSA,$fp, $x,$enc,$kstr,$klen,$cb,$u));
	}' unless defined(&PEM_write_RSAPrivateKey);
	eval 'sub PEM_write_RSAPublicKey {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_RSAPublicKey,  &PEM_STRING_RSA_PUBLIC,$fp,$x, &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_RSAPublicKey);
	eval 'sub PEM_write_DSAPrivateKey {
	    local($fp,$x,$enc,$kstr,$klen,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_DSAPrivateKey, &PEM_STRING_DSA,$fp, $x,$enc,$kstr,$klen,$cb,$u));
	}' unless defined(&PEM_write_DSAPrivateKey);
	eval 'sub PEM_write_PrivateKey {
	    local($bp,$x,$enc,$kstr,$klen,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_PrivateKey, ((-> &type ==  &EVP_PKEY_DSA)? &PEM_STRING_DSA: &PEM_STRING_RSA), $bp,$x,$enc,$kstr,$klen,$cb,$u));
	}' unless defined(&PEM_write_PrivateKey);
	eval 'sub PEM_write_PKCS7 {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_PKCS7, &PEM_STRING_PKCS7,$fp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_PKCS7);
	eval 'sub PEM_write_DHparams {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_DHparams, &PEM_STRING_DHPARAMS,$fp, $x, &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_DHparams);
	eval 'sub PEM_write_NETSCAPE_CERT_SEQUENCE {
	    local($fp,$x) = @_;
    	    eval q( &PEM_ASN1_write(( &int (*)()) &i2d_NETSCAPE_CERT_SEQUENCE,  &PEM_STRING_X509,$fp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_NETSCAPE_CERT_SEQUENCE);
	eval 'sub PEM_read_SSL_SESSION {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_SSL_SESSION, &PEM_STRING_SSL_SESSION,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_SSL_SESSION);
	eval 'sub PEM_read_X509 {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_X509, &PEM_STRING_X509,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_X509);
	eval 'sub PEM_read_X509_REQ {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_X509_REQ, &PEM_STRING_X509_REQ,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_X509_REQ);
	eval 'sub PEM_read_X509_CRL {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_X509_CRL, &PEM_STRING_X509_CRL,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_X509_CRL);
	eval 'sub PEM_read_RSAPrivateKey {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_RSAPrivateKey, &PEM_STRING_RSA,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_RSAPrivateKey);
	eval 'sub PEM_read_RSAPublicKey {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_RSAPublicKey, &PEM_STRING_RSA_PUBLIC,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_RSAPublicKey);
	eval 'sub PEM_read_DSAPrivateKey {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_DSAPrivateKey, &PEM_STRING_DSA,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_DSAPrivateKey);
	eval 'sub PEM_read_PrivateKey {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_PrivateKey, &PEM_STRING_EVP_PKEY,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_PrivateKey);
	eval 'sub PEM_read_PKCS7 {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_PKCS7, &PEM_STRING_PKCS7,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_PKCS7);
	eval 'sub PEM_read_DHparams {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_DHparams, &PEM_STRING_DHPARAMS,$fp,$x,$cb,$u));
	}' unless defined(&PEM_read_DHparams);
	eval 'sub PEM_read_NETSCAPE_CERT_SEQUENCE {
	    local($fp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read( (\'char\' *(*)()) &d2i_NETSCAPE_CERT_SEQUENCE, &PEM_STRING_X509,$fp, $x,$cb,$u));
	}' unless defined(&PEM_read_NETSCAPE_CERT_SEQUENCE);
	eval 'sub PEM_write_bio_SSL_SESSION {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_SSL_SESSION,  &PEM_STRING_SSL_SESSION,$bp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_SSL_SESSION);
	eval 'sub PEM_write_bio_X509 {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_X509, &PEM_STRING_X509,$bp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_X509);
	eval 'sub PEM_write_bio_X509_REQ {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio( ( &int (*)()) &i2d_X509_REQ, &PEM_STRING_X509_REQ,$bp,$x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_X509_REQ);
	eval 'sub PEM_write_bio_X509_CRL {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_X509_CRL, &PEM_STRING_X509_CRL, $bp,$x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_X509_CRL);
	eval 'sub PEM_write_bio_RSAPrivateKey {
	    local($bp,$x,$enc,$kstr,$klen,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_RSAPrivateKey, &PEM_STRING_RSA, $bp,$x,$enc,$kstr,$klen,$cb,$u));
	}' unless defined(&PEM_write_bio_RSAPrivateKey);
	eval 'sub PEM_write_bio_RSAPublicKey {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_RSAPublicKey,  &PEM_STRING_RSA_PUBLIC, $bp,$x, &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_RSAPublicKey);
	eval 'sub PEM_write_bio_DSAPrivateKey {
	    local($bp,$x,$enc,$kstr,$klen,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_DSAPrivateKey, &PEM_STRING_DSA, $bp,$x,$enc,$kstr,$klen,$cb,$u));
	}' unless defined(&PEM_write_bio_DSAPrivateKey);
	eval 'sub PEM_write_bio_PrivateKey {
	    local($bp,$x,$enc,$kstr,$klen,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_PrivateKey, ((-> &type ==  &EVP_PKEY_DSA)? &PEM_STRING_DSA: &PEM_STRING_RSA), $bp,$x,$enc,$kstr,$klen,$cb,$u));
	}' unless defined(&PEM_write_bio_PrivateKey);
	eval 'sub PEM_write_bio_PKCS7 {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_PKCS7, &PEM_STRING_PKCS7,$bp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_PKCS7);
	eval 'sub PEM_write_bio_DHparams {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_DHparams, &PEM_STRING_DHPARAMS, $bp,$x, &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_DHparams);
	eval 'sub PEM_write_bio_DSAparams {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_DSAparams,  &PEM_STRING_DSAPARAMS,$bp,$x, &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_DSAparams);
	eval 'sub PEM_write_bio_NETSCAPE_CERT_SEQUENCE {
	    local($bp,$x) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_NETSCAPE_CERT_SEQUENCE,  &PEM_STRING_X509,$bp, $x,  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_NETSCAPE_CERT_SEQUENCE);
	eval 'sub PEM_read_bio_SSL_SESSION {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_SSL_SESSION, &PEM_STRING_SSL_SESSION,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_SSL_SESSION);
	eval 'sub PEM_read_bio_X509 {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_X509, &PEM_STRING_X509,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_X509);
	eval 'sub PEM_read_bio_X509_REQ {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_X509_REQ, &PEM_STRING_X509_REQ,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_X509_REQ);
	eval 'sub PEM_read_bio_X509_CRL {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_X509_CRL, &PEM_STRING_X509_CRL,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_X509_CRL);
	eval 'sub PEM_read_bio_RSAPrivateKey {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_RSAPrivateKey, &PEM_STRING_RSA,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_RSAPrivateKey);
	eval 'sub PEM_read_bio_RSAPublicKey {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_RSAPublicKey, &PEM_STRING_RSA_PUBLIC,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_RSAPublicKey);
	eval 'sub PEM_read_bio_DSAPrivateKey {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_DSAPrivateKey, &PEM_STRING_DSA,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_DSAPrivateKey);
	eval 'sub PEM_read_bio_PrivateKey {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_PrivateKey, &PEM_STRING_EVP_PKEY,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_PrivateKey);
	eval 'sub PEM_read_bio_PKCS7 {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_PKCS7, &PEM_STRING_PKCS7,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_PKCS7);
	eval 'sub PEM_read_bio_DHparams {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_DHparams, &PEM_STRING_DHPARAMS,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_DHparams);
	eval 'sub PEM_read_bio_DSAparams {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_DSAparams, &PEM_STRING_DSAPARAMS,$bp,$x,$cb,$u));
	}' unless defined(&PEM_read_bio_DSAparams);
	eval 'sub PEM_read_bio_NETSCAPE_CERT_SEQUENCE {
	    local($bp,$x,$cb,$u) = @_;
    	    eval q( &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_NETSCAPE_CERT_SEQUENCE, &PEM_STRING_X509,$bp, $x,$cb,$u));
	}' unless defined(&PEM_read_bio_NETSCAPE_CERT_SEQUENCE);
    }
    if(1) {
    } else {
    }
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    unless(defined(&OPENSSL_SYS_WIN16)) {
    }
    unless(defined(&SSLEAY_MACROS)) {
	require 'openssl/symhacks.ph';
	unless(defined(&OPENSSL_NO_RSA)) {
	}
	unless(defined(&OPENSSL_NO_DSA)) {
	}
	unless(defined(&OPENSSL_NO_DH)) {
	}
    }
    eval 'sub PEM_F_D2I_PKCS8PRIVATEKEY_BIO () {120;}' unless defined(&PEM_F_D2I_PKCS8PRIVATEKEY_BIO);
    eval 'sub PEM_F_D2I_PKCS8PRIVATEKEY_FP () {121;}' unless defined(&PEM_F_D2I_PKCS8PRIVATEKEY_FP);
    eval 'sub PEM_F_DEF_CALLBACK () {100;}' unless defined(&PEM_F_DEF_CALLBACK);
    eval 'sub PEM_F_LOAD_IV () {101;}' unless defined(&PEM_F_LOAD_IV);
    eval 'sub PEM_F_PEM_ASN1_READ () {102;}' unless defined(&PEM_F_PEM_ASN1_READ);
    eval 'sub PEM_F_PEM_ASN1_READ_BIO () {103;}' unless defined(&PEM_F_PEM_ASN1_READ_BIO);
    eval 'sub PEM_F_PEM_ASN1_WRITE () {104;}' unless defined(&PEM_F_PEM_ASN1_WRITE);
    eval 'sub PEM_F_PEM_ASN1_WRITE_BIO () {105;}' unless defined(&PEM_F_PEM_ASN1_WRITE_BIO);
    eval 'sub PEM_F_PEM_DO_HEADER () {106;}' unless defined(&PEM_F_PEM_DO_HEADER);
    eval 'sub PEM_F_PEM_F_DO_PK8KEY_FP () {122;}' unless defined(&PEM_F_PEM_F_DO_PK8KEY_FP);
    eval 'sub PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY () {118;}' unless defined(&PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY);
    eval 'sub PEM_F_PEM_GET_EVP_CIPHER_INFO () {107;}' unless defined(&PEM_F_PEM_GET_EVP_CIPHER_INFO);
    eval 'sub PEM_F_PEM_READ () {108;}' unless defined(&PEM_F_PEM_READ);
    eval 'sub PEM_F_PEM_READ_BIO () {109;}' unless defined(&PEM_F_PEM_READ_BIO);
    eval 'sub PEM_F_PEM_SEALFINAL () {110;}' unless defined(&PEM_F_PEM_SEALFINAL);
    eval 'sub PEM_F_PEM_SEALINIT () {111;}' unless defined(&PEM_F_PEM_SEALINIT);
    eval 'sub PEM_F_PEM_SIGNFINAL () {112;}' unless defined(&PEM_F_PEM_SIGNFINAL);
    eval 'sub PEM_F_PEM_WRITE () {113;}' unless defined(&PEM_F_PEM_WRITE);
    eval 'sub PEM_F_PEM_WRITE_BIO () {114;}' unless defined(&PEM_F_PEM_WRITE_BIO);
    eval 'sub PEM_F_PEM_WRITE_BIO_PKCS8PRIVATEKEY () {119;}' unless defined(&PEM_F_PEM_WRITE_BIO_PKCS8PRIVATEKEY);
    eval 'sub PEM_F_PEM_X509_INFO_READ () {115;}' unless defined(&PEM_F_PEM_X509_INFO_READ);
    eval 'sub PEM_F_PEM_X509_INFO_READ_BIO () {116;}' unless defined(&PEM_F_PEM_X509_INFO_READ_BIO);
    eval 'sub PEM_F_PEM_X509_INFO_WRITE_BIO () {117;}' unless defined(&PEM_F_PEM_X509_INFO_WRITE_BIO);
    eval 'sub PEM_R_BAD_BASE64_DECODE () {100;}' unless defined(&PEM_R_BAD_BASE64_DECODE);
    eval 'sub PEM_R_BAD_DECRYPT () {101;}' unless defined(&PEM_R_BAD_DECRYPT);
    eval 'sub PEM_R_BAD_END_LINE () {102;}' unless defined(&PEM_R_BAD_END_LINE);
    eval 'sub PEM_R_BAD_IV_CHARS () {103;}' unless defined(&PEM_R_BAD_IV_CHARS);
    eval 'sub PEM_R_BAD_PASSWORD_READ () {104;}' unless defined(&PEM_R_BAD_PASSWORD_READ);
    eval 'sub PEM_R_ERROR_CONVERTING_PRIVATE_KEY () {115;}' unless defined(&PEM_R_ERROR_CONVERTING_PRIVATE_KEY);
    eval 'sub PEM_R_NOT_DEK_INFO () {105;}' unless defined(&PEM_R_NOT_DEK_INFO);
    eval 'sub PEM_R_NOT_ENCRYPTED () {106;}' unless defined(&PEM_R_NOT_ENCRYPTED);
    eval 'sub PEM_R_NOT_PROC_TYPE () {107;}' unless defined(&PEM_R_NOT_PROC_TYPE);
    eval 'sub PEM_R_NO_START_LINE () {108;}' unless defined(&PEM_R_NO_START_LINE);
    eval 'sub PEM_R_PROBLEMS_GETTING_PASSWORD () {109;}' unless defined(&PEM_R_PROBLEMS_GETTING_PASSWORD);
    eval 'sub PEM_R_PUBLIC_KEY_NO_RSA () {110;}' unless defined(&PEM_R_PUBLIC_KEY_NO_RSA);
    eval 'sub PEM_R_READ_KEY () {111;}' unless defined(&PEM_R_READ_KEY);
    eval 'sub PEM_R_SHORT_HEADER () {112;}' unless defined(&PEM_R_SHORT_HEADER);
    eval 'sub PEM_R_UNSUPPORTED_CIPHER () {113;}' unless defined(&PEM_R_UNSUPPORTED_CIPHER);
    eval 'sub PEM_R_UNSUPPORTED_ENCRYPTION () {114;}' unless defined(&PEM_R_UNSUPPORTED_ENCRYPTION);
    if(defined(&__cplusplus)) {
    }
}
1;
