require '_h2ph_pre.ph';

unless(defined(&BT_ADDR)) {
    sub BT_ADDR () {	0x;}
}
unless(defined(&BT_CMAP)) {
    sub BT_CMAP () {	0x4;}
}
unless(defined(&BT_CTRL)) {
    sub BT_CTRL () {	0x8;}
}
unless(defined(&BT_OMAP)) {
    sub BT_OMAP () {	0xc;}
}
unless(defined(&BT_D4M3)) {
    sub BT_D4M3 {
	local($x) = @_;
	eval q((((($x) >> 2) << 1) + (($x) >> 2)));
    }
}
unless(defined(&BT_D4M4)) {
    sub BT_D4M4 {
	local($x) = @_;
	eval q((($x) & ~3));
    }
}
unless(defined(&CGSIX_ROM_OFFSET)) {
    sub CGSIX_ROM_OFFSET () {	0x;}
}
unless(defined(&CGSIX_BT_OFFSET)) {
    sub CGSIX_BT_OFFSET () {	0x200000;}
}
unless(defined(&CGSIX_BT_SIZE)) {
    sub CGSIX_BT_SIZE () {	($sizeof{ &u_int32_t} * 4);}
}
unless(defined(&CGSIX_DHC_OFFSET)) {
    sub CGSIX_DHC_OFFSET () {	0x240000;}
}
unless(defined(&CGSIX_ALT_OFFSET)) {
    sub CGSIX_ALT_OFFSET () {	0x280000;}
}
unless(defined(&CGSIX_FHC_OFFSET)) {
    sub CGSIX_FHC_OFFSET () {	0x300000;}
}
unless(defined(&CGSIX_FHC_SIZE)) {
    sub CGSIX_FHC_SIZE () {	($sizeof{ &u_int32_t} * 1);}
}
unless(defined(&CGSIX_THC_OFFSET)) {
    sub CGSIX_THC_OFFSET () {	0x301000;}
}
unless(defined(&CGSIX_THC_SIZE)) {
    sub CGSIX_THC_SIZE () {	($sizeof{ &u_int32_t} * 640);}
}
unless(defined(&CGSIX_FBC_OFFSET)) {
    sub CGSIX_FBC_OFFSET () {	0x700000;}
}
unless(defined(&CGSIX_FBC_SIZE)) {
    sub CGSIX_FBC_SIZE () {	0x1000;}
}
unless(defined(&CGSIX_TEC_OFFSET)) {
    sub CGSIX_TEC_OFFSET () {	0x701000;}
}
unless(defined(&CGSIX_TEC_SIZE)) {
    sub CGSIX_TEC_SIZE () {	($sizeof{ &u_int32_t} * 3);}
}
unless(defined(&CGSIX_VID_OFFSET)) {
    sub CGSIX_VID_OFFSET () {	0x800000;}
}
unless(defined(&CGSIX_VID_SIZE)) {
    sub CGSIX_VID_SIZE () {	(1024* 1024);}
}
unless(defined(&CG6_FHC)) {
    sub CG6_FHC () {	0x;}
}
unless(defined(&FHC_FBID_MASK)) {
    sub FHC_FBID_MASK () {	0xff000000;}
}
unless(defined(&FHC_FBID_SHIFT)) {
    sub FHC_FBID_SHIFT () {	24;}
}
unless(defined(&FHC_REV_MASK)) {
    sub FHC_REV_MASK () {	0xf00000;}
}
unless(defined(&FHC_REV_SHIFT)) {
    sub FHC_REV_SHIFT () {	20;}
}
unless(defined(&FHC_FROP_DISABLE)) {
    sub FHC_FROP_DISABLE () {	0x80000;}
}
unless(defined(&FHC_ROW_DISABLE)) {
    sub FHC_ROW_DISABLE () {	0x40000;}
}
unless(defined(&FHC_SRC_DISABLE)) {
    sub FHC_SRC_DISABLE () {	0x20000;}
}
unless(defined(&FHC_DST_DISABLE)) {
    sub FHC_DST_DISABLE () {	0x10000;}
}
unless(defined(&FHC_RESET)) {
    sub FHC_RESET () {	0x8000;}
}
unless(defined(&FHC_LEBO)) {
    sub FHC_LEBO () {	0x2000;}
}
unless(defined(&FHC_RES_MASK)) {
    sub FHC_RES_MASK () {	0x1800;}
}
unless(defined(&FHC_RES_1024)) {
    sub FHC_RES_1024 () {	0x;}
}
unless(defined(&FHC_RES_1152)) {
    sub FHC_RES_1152 () {	0x800;}
}
unless(defined(&FHC_RES_1280)) {
    sub FHC_RES_1280 () {	0x1000;}
}
unless(defined(&FHC_RES_1600)) {
    sub FHC_RES_1600 () {	0x1800;}
}
unless(defined(&FHC_CPU_MASK)) {
    sub FHC_CPU_MASK () {	0x600;}
}
unless(defined(&FHC_CPU_SPARC)) {
    sub FHC_CPU_SPARC () {	0x;}
}
unless(defined(&FHC_CPU_68020)) {
    sub FHC_CPU_68020 () {	0x200;}
}
unless(defined(&FHC_CPU_386)) {
    sub FHC_CPU_386 () {	0x400;}
}
unless(defined(&FHC_TEST)) {
    sub FHC_TEST () {	0x100;}
}
unless(defined(&FHC_TESTX_MASK)) {
    sub FHC_TESTX_MASK () {	0xf0;}
}
unless(defined(&FHC_TESTX_SHIFT)) {
    sub FHC_TESTX_SHIFT () {	4;}
}
unless(defined(&FHC_TESTY_MASK)) {
    sub FHC_TESTY_MASK () {	0xf;}
}
unless(defined(&FHC_TESTY_SHIFT)) {
    sub FHC_TESTY_SHIFT () {	0;}
}
unless(defined(&CG6_FBC_MODE)) {
    sub CG6_FBC_MODE () {	0x4;}
}
unless(defined(&CG6_FBC_CLIP)) {
    sub CG6_FBC_CLIP () {	0x8;}
}
unless(defined(&CG6_FBC_S)) {
    sub CG6_FBC_S () {	0x10;}
}
unless(defined(&CG6_FBC_DRAW)) {
    sub CG6_FBC_DRAW () {	0x14;}
}
unless(defined(&CG6_FBC_BLIT)) {
    sub CG6_FBC_BLIT () {	0x18;}
}
unless(defined(&CG6_FBC_X0)) {
    sub CG6_FBC_X0 () {	0x80;}
}
unless(defined(&CG6_FBC_Y0)) {
    sub CG6_FBC_Y0 () {	0x84;}
}
unless(defined(&CG6_FBC_X1)) {
    sub CG6_FBC_X1 () {	0x90;}
}
unless(defined(&CG6_FBC_Y1)) {
    sub CG6_FBC_Y1 () {	0x94;}
}
unless(defined(&CG6_FBC_X2)) {
    sub CG6_FBC_X2 () {	0xa0;}
}
unless(defined(&CG6_FBC_Y2)) {
    sub CG6_FBC_Y2 () {	0xa4;}
}
unless(defined(&CG6_FBC_X3)) {
    sub CG6_FBC_X3 () {	0xb0;}
}
unless(defined(&CG6_FBC_Y3)) {
    sub CG6_FBC_Y3 () {	0xb4;}
}
unless(defined(&CG6_FBC_OFFX)) {
    sub CG6_FBC_OFFX () {	0xc0;}
}
unless(defined(&CG6_FBC_OFFY)) {
    sub CG6_FBC_OFFY () {	0xc4;}
}
unless(defined(&CG6_FBC_CLIPMINX)) {
    sub CG6_FBC_CLIPMINX () {	0xe0;}
}
unless(defined(&CG6_FBC_CLIPMINY)) {
    sub CG6_FBC_CLIPMINY () {	0xe4;}
}
unless(defined(&CG6_FBC_CLIPMAXX)) {
    sub CG6_FBC_CLIPMAXX () {	0xf0;}
}
unless(defined(&CG6_FBC_CLIPMAXY)) {
    sub CG6_FBC_CLIPMAXY () {	0xf4;}
}
unless(defined(&CG6_FBC_FG)) {
    sub CG6_FBC_FG () {	0x100;}
}
unless(defined(&CG6_FBC_ALU)) {
    sub CG6_FBC_ALU () {	0x108;}
}
unless(defined(&CG6_FBC_ARECTX)) {
    sub CG6_FBC_ARECTX () {	0x900;}
}
unless(defined(&CG6_FBC_ARECTY)) {
    sub CG6_FBC_ARECTY () {	0x904;}
}
unless(defined(&FBC_MODE_VAL)) {
    sub FBC_MODE_VAL () {	( 0x200000 | 0x20000 | 0x8000 | 0x2000 | 0x1000 | 0x200 | 0x80 );}
}
unless(defined(&FBC_MODE_MASK)) {
    sub FBC_MODE_MASK () {	( 0x300000 | 0x60000 | 0x18000 | 0x6000 | 0x1800 | 0x600 | 0x180 );}
}
unless(defined(&FBC_S_GXINPROGRESS)) {
    sub FBC_S_GXINPROGRESS () {	0x10000000;}
}
unless(defined(&FBC_BLIT_UNKNOWN)) {
    sub FBC_BLIT_UNKNOWN () {	0x80000000;}
}
unless(defined(&FBC_BLIT_GXFULL)) {
    sub FBC_BLIT_GXFULL () {	0x20000000;}
}
unless(defined(&FBC_DRAW_UNKNOWN)) {
    sub FBC_DRAW_UNKNOWN () {	0x80000000;}
}
unless(defined(&FBC_DRAW_GXFULL)) {
    sub FBC_DRAW_GXFULL () {	0x20000000;}
}
unless(defined(&FBC_ALU_COPY)) {
    sub FBC_ALU_COPY () {	( 0x80000000 | 0x20000000 | 0x800000 | 0x | 0x | 0x8000000 | 0x1000000 | 0xcccc );}
}
unless(defined(&FBC_ALU_FILL)) {
    sub FBC_ALU_FILL () {	( 0x80000000 | 0x20000000 | 0x800000 | 0x | 0x | 0x8000000 | 0x1000000 | 0xff00 );}
}
unless(defined(&FBC_ALU_FLIP)) {
    sub FBC_ALU_FLIP () {	( 0x80000000 | 0x20000000 | 0x800000 | 0x | 0x | 0x8000000 | 0x1000000 | 0x5555 );}
}
unless(defined(&CG6_TEC_MV)) {
    sub CG6_TEC_MV () {	0x;}
}
unless(defined(&CG6_TEC_CLIP)) {
    sub CG6_TEC_CLIP () {	0x4;}
}
unless(defined(&CG6_TEC_VDC)) {
    sub CG6_TEC_VDC () {	0x8;}
}
unless(defined(&CG6_THC_HSYNC1)) {
    sub CG6_THC_HSYNC1 () {	0x800;}
}
unless(defined(&CG6_THC_HSYNC2)) {
    sub CG6_THC_HSYNC2 () {	0x804;}
}
unless(defined(&CG6_THC_HSYNC3)) {
    sub CG6_THC_HSYNC3 () {	0x808;}
}
unless(defined(&CG6_THC_VSYNC1)) {
    sub CG6_THC_VSYNC1 () {	0x80c;}
}
unless(defined(&CG6_THC_VSYNC2)) {
    sub CG6_THC_VSYNC2 () {	0x810;}
}
unless(defined(&CG6_THC_REFRESH)) {
    sub CG6_THC_REFRESH () {	0x814;}
}
unless(defined(&CG6_THC_MISC)) {
    sub CG6_THC_MISC () {	0x818;}
}
unless(defined(&CG6_THC_CURSXY)) {
    sub CG6_THC_CURSXY () {	0x8fc;}
}
unless(defined(&CG6_THC_CURSMASK)) {
    sub CG6_THC_CURSMASK () {	0x900;}
}
unless(defined(&CG6_THC_CURSBITS)) {
    sub CG6_THC_CURSBITS () {	0x980;}
}
unless(defined(&THC_CURSOFF)) {
    sub THC_CURSOFF () {	((65536-32) | ((65536-32) << 16));}
}
unless(defined(&THC_MISC_REV_M)) {
    sub THC_MISC_REV_M () {	0xf0000;}
}
unless(defined(&THC_MISC_REV_S)) {
    sub THC_MISC_REV_S () {	16;}
}
unless(defined(&THC_MISC_RESET)) {
    sub THC_MISC_RESET () {	0x1000;}
}
unless(defined(&THC_MISC_VIDEN)) {
    sub THC_MISC_VIDEN () {	0x400;}
}
unless(defined(&THC_MISC_SYNC)) {
    sub THC_MISC_SYNC () {	0x200;}
}
unless(defined(&THC_MISC_VSYNC)) {
    sub THC_MISC_VSYNC () {	0x100;}
}
unless(defined(&THC_MISC_SYNCEN)) {
    sub THC_MISC_SYNCEN () {	0x80;}
}
unless(defined(&THC_MISC_CURSRES)) {
    sub THC_MISC_CURSRES () {	0x40;}
}
unless(defined(&THC_MISC_INTEN)) {
    sub THC_MISC_INTEN () {	0x20;}
}
unless(defined(&THC_MISC_INTR)) {
    sub THC_MISC_INTR () {	0x10;}
}
unless(defined(&THC_MISC_CYCLS)) {
    sub THC_MISC_CYCLS () {	0xf;}
}
unless(defined(&CG6_USER_FBC)) {
    sub CG6_USER_FBC () {	0x70000000;}
}
unless(defined(&CG6_USER_TEC)) {
    sub CG6_USER_TEC () {	0x70001000;}
}
unless(defined(&CG6_USER_BTREGS)) {
    sub CG6_USER_BTREGS () {	0x70002000;}
}
unless(defined(&CG6_USER_FHC)) {
    sub CG6_USER_FHC () {	0x70004000;}
}
unless(defined(&CG6_USER_THC)) {
    sub CG6_USER_THC () {	0x70005000;}
}
unless(defined(&CG6_USER_ROM)) {
    sub CG6_USER_ROM () {	0x70006000;}
}
unless(defined(&CG6_USER_RAM)) {
    sub CG6_USER_RAM () {	0x70016000;}
}
unless(defined(&CG6_USER_DHC)) {
    sub CG6_USER_DHC () {	0x80000000;}
}
unless(defined(&THC_READ)) {
    sub THC_READ {
	local($sc,$r) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_thc_regs, ($r)));
    }
}
unless(defined(&THC_WRITE)) {
    sub THC_WRITE {
	local($sc,$r,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_thc_regs, ($r), ($v)));
    }
}
unless(defined(&TEC_READ)) {
    sub TEC_READ {
	local($sc,$r) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_tec_regs, ($r)));
    }
}
unless(defined(&TEC_WRITE)) {
    sub TEC_WRITE {
	local($sc,$r,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_tec_regs, ($r), ($v)));
    }
}
unless(defined(&FHC_READ)) {
    sub FHC_READ {
	local($sc) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_fhc_regs,  &CG6_FHC));
    }
}
unless(defined(&FHC_WRITE)) {
    sub FHC_WRITE {
	local($sc,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_fhc_regs,  &CG6_FHC, ($v)));
    }
}
unless(defined(&FBC_READ)) {
    sub FBC_READ {
	local($sc,$r) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_fbc_regs, ($r)));
    }
}
unless(defined(&FBC_WRITE)) {
    sub FBC_WRITE {
	local($sc,$r,$v) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_fbc_regs, ($r), ($v)));
    }
}
unless(defined(&BT_WRITE)) {
    sub BT_WRITE {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_bt_regs, ($reg), ($val)));
    }
}
unless(defined(&BT_READ)) {
    sub BT_READ {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_bt_regs, ($reg)));
    }
}
unless(defined(&BT_BARRIER)) {
    sub BT_BARRIER {
	local($sc,$reg,$flags) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_bustag, ($sc)-> &sc_bt_regs, ($reg), $sizeof{ &u_int32_t}, ($flags)));
    }
}
unless(defined(&CG6_BLIT_WAIT)) {
    sub CG6_BLIT_WAIT {
	local($sc) = @_;
	eval q( &while (( &FBC_READ($sc,  &CG6_FBC_BLIT) & ( &FBC_BLIT_UNKNOWN| &FBC_BLIT_GXFULL)) == ( &FBC_BLIT_UNKNOWN| &FBC_BLIT_GXFULL)));
    }
}
unless(defined(&CG6_DRAW_WAIT)) {
    sub CG6_DRAW_WAIT {
	local($sc) = @_;
	eval q( &while (( &FBC_READ($sc,  &CG6_FBC_DRAW) & ( &FBC_DRAW_UNKNOWN| &FBC_DRAW_GXFULL)) == ( &FBC_DRAW_UNKNOWN| &FBC_DRAW_GXFULL)));
    }
}
unless(defined(&CG6_DRAIN)) {
    sub CG6_DRAIN {
	local($sc) = @_;
	eval q( &while ( &FBC_READ($sc,  &CG6_FBC_S) &  &FBC_S_GXINPROGRESS));
    }
}
unless(defined(&CG6_CFFLAG_NOACCEL)) {
    sub CG6_CFFLAG_NOACCEL () {	0x1;}
}
1;
