require '_h2ph_pre.ph';

unless(defined(&HEADER_BIO_H)) {
    eval 'sub HEADER_BIO_H () {1;}' unless defined(&HEADER_BIO_H);
    unless(defined(&OPENSSL_NO_FP_API)) {
	require 'stdio.ph';
    }
    require 'stdarg.ph';
    require 'ssl/crypto.ph';
    require 'ssl/e_os2.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub BIO_TYPE_NONE () {0;}' unless defined(&BIO_TYPE_NONE);
    eval 'sub BIO_TYPE_MEM () {(1|0x0400);}' unless defined(&BIO_TYPE_MEM);
    eval 'sub BIO_TYPE_FILE () {(2|0x0400);}' unless defined(&BIO_TYPE_FILE);
    eval 'sub BIO_TYPE_FD () {(4|0x0400|0x0100);}' unless defined(&BIO_TYPE_FD);
    eval 'sub BIO_TYPE_SOCKET () {(5|0x0400|0x0100);}' unless defined(&BIO_TYPE_SOCKET);
    eval 'sub BIO_TYPE_NULL () {(6|0x0400);}' unless defined(&BIO_TYPE_NULL);
    eval 'sub BIO_TYPE_SSL () {(7|0x0200);}' unless defined(&BIO_TYPE_SSL);
    eval 'sub BIO_TYPE_MD () {(8|0x0200);}' unless defined(&BIO_TYPE_MD);
    eval 'sub BIO_TYPE_BUFFER () {(9|0x0200);}' unless defined(&BIO_TYPE_BUFFER);
    eval 'sub BIO_TYPE_CIPHER () {(10|0x0200);}' unless defined(&BIO_TYPE_CIPHER);
    eval 'sub BIO_TYPE_BASE64 () {(11|0x0200);}' unless defined(&BIO_TYPE_BASE64);
    eval 'sub BIO_TYPE_CONNECT () {(12|0x0400|0x0100);}' unless defined(&BIO_TYPE_CONNECT);
    eval 'sub BIO_TYPE_ACCEPT () {(13|0x0400|0x0100);}' unless defined(&BIO_TYPE_ACCEPT);
    eval 'sub BIO_TYPE_PROXY_CLIENT () {(14|0x0200);}' unless defined(&BIO_TYPE_PROXY_CLIENT);
    eval 'sub BIO_TYPE_PROXY_SERVER () {(15|0x0200);}' unless defined(&BIO_TYPE_PROXY_SERVER);
    eval 'sub BIO_TYPE_NBIO_TEST () {(16|0x0200);}' unless defined(&BIO_TYPE_NBIO_TEST);
    eval 'sub BIO_TYPE_NULL_FILTER () {(17|0x0200);}' unless defined(&BIO_TYPE_NULL_FILTER);
    eval 'sub BIO_TYPE_BER () {(18|0x0200);}' unless defined(&BIO_TYPE_BER);
    eval 'sub BIO_TYPE_BIO () {(19|0x0400);}' unless defined(&BIO_TYPE_BIO);
    eval 'sub BIO_TYPE_LINEBUFFER () {(20|0x0200);}' unless defined(&BIO_TYPE_LINEBUFFER);
    eval 'sub BIO_TYPE_DESCRIPTOR () {0x0100;}' unless defined(&BIO_TYPE_DESCRIPTOR);
    eval 'sub BIO_TYPE_FILTER () {0x0200;}' unless defined(&BIO_TYPE_FILTER);
    eval 'sub BIO_TYPE_SOURCE_SINK () {0x0400;}' unless defined(&BIO_TYPE_SOURCE_SINK);
    eval 'sub BIO_NOCLOSE () {0x00;}' unless defined(&BIO_NOCLOSE);
    eval 'sub BIO_CLOSE () {0x01;}' unless defined(&BIO_CLOSE);
    eval 'sub BIO_CTRL_RESET () {1;}' unless defined(&BIO_CTRL_RESET);
    eval 'sub BIO_CTRL_EOF () {2;}' unless defined(&BIO_CTRL_EOF);
    eval 'sub BIO_CTRL_INFO () {3;}' unless defined(&BIO_CTRL_INFO);
    eval 'sub BIO_CTRL_SET () {4;}' unless defined(&BIO_CTRL_SET);
    eval 'sub BIO_CTRL_GET () {5;}' unless defined(&BIO_CTRL_GET);
    eval 'sub BIO_CTRL_PUSH () {6;}' unless defined(&BIO_CTRL_PUSH);
    eval 'sub BIO_CTRL_POP () {7;}' unless defined(&BIO_CTRL_POP);
    eval 'sub BIO_CTRL_GET_CLOSE () {8;}' unless defined(&BIO_CTRL_GET_CLOSE);
    eval 'sub BIO_CTRL_SET_CLOSE () {9;}' unless defined(&BIO_CTRL_SET_CLOSE);
    eval 'sub BIO_CTRL_PENDING () {10;}' unless defined(&BIO_CTRL_PENDING);
    eval 'sub BIO_CTRL_FLUSH () {11;}' unless defined(&BIO_CTRL_FLUSH);
    eval 'sub BIO_CTRL_DUP () {12;}' unless defined(&BIO_CTRL_DUP);
    eval 'sub BIO_CTRL_WPENDING () {13;}' unless defined(&BIO_CTRL_WPENDING);
    eval 'sub BIO_CTRL_SET_CALLBACK () {14;}' unless defined(&BIO_CTRL_SET_CALLBACK);
    eval 'sub BIO_CTRL_GET_CALLBACK () {15;}' unless defined(&BIO_CTRL_GET_CALLBACK);
    eval 'sub BIO_CTRL_SET_FILENAME () {30;}' unless defined(&BIO_CTRL_SET_FILENAME);
    eval 'sub BIO_FP_READ () {0x02;}' unless defined(&BIO_FP_READ);
    eval 'sub BIO_FP_WRITE () {0x04;}' unless defined(&BIO_FP_WRITE);
    eval 'sub BIO_FP_APPEND () {0x08;}' unless defined(&BIO_FP_APPEND);
    eval 'sub BIO_FP_TEXT () {0x10;}' unless defined(&BIO_FP_TEXT);
    eval 'sub BIO_FLAGS_READ () {0x01;}' unless defined(&BIO_FLAGS_READ);
    eval 'sub BIO_FLAGS_WRITE () {0x02;}' unless defined(&BIO_FLAGS_WRITE);
    eval 'sub BIO_FLAGS_IO_SPECIAL () {0x04;}' unless defined(&BIO_FLAGS_IO_SPECIAL);
    eval 'sub BIO_FLAGS_RWS () {( &BIO_FLAGS_READ| &BIO_FLAGS_WRITE| &BIO_FLAGS_IO_SPECIAL);}' unless defined(&BIO_FLAGS_RWS);
    eval 'sub BIO_FLAGS_SHOULD_RETRY () {0x08;}' unless defined(&BIO_FLAGS_SHOULD_RETRY);
    eval 'sub BIO_GHBN_CTRL_HITS () {1;}' unless defined(&BIO_GHBN_CTRL_HITS);
    eval 'sub BIO_GHBN_CTRL_MISSES () {2;}' unless defined(&BIO_GHBN_CTRL_MISSES);
    eval 'sub BIO_GHBN_CTRL_CACHE_SIZE () {3;}' unless defined(&BIO_GHBN_CTRL_CACHE_SIZE);
    eval 'sub BIO_GHBN_CTRL_GET_ENTRY () {4;}' unless defined(&BIO_GHBN_CTRL_GET_ENTRY);
    eval 'sub BIO_GHBN_CTRL_FLUSH () {5;}' unless defined(&BIO_GHBN_CTRL_FLUSH);
    eval 'sub BIO_FLAGS_BASE64_NO_NL () {0x100;}' unless defined(&BIO_FLAGS_BASE64_NO_NL);
    eval 'sub BIO_FLAGS_MEM_RDONLY () {0x200;}' unless defined(&BIO_FLAGS_MEM_RDONLY);
    eval 'sub BIO_set_flags {
        local($b,$f) = @_;
	    eval q((($b)-> &flags|=($f)));
    }' unless defined(&BIO_set_flags);
    eval 'sub BIO_get_flags {
        local($b) = @_;
	    eval q((($b)-> &flags));
    }' unless defined(&BIO_get_flags);
    eval 'sub BIO_set_retry_special {
        local($b) = @_;
	    eval q((($b)-> &flags|=( &BIO_FLAGS_IO_SPECIAL| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_set_retry_special);
    eval 'sub BIO_set_retry_read {
        local($b) = @_;
	    eval q((($b)-> &flags|=( &BIO_FLAGS_READ| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_set_retry_read);
    eval 'sub BIO_set_retry_write {
        local($b) = @_;
	    eval q((($b)-> &flags|=( &BIO_FLAGS_WRITE| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_set_retry_write);
    eval 'sub BIO_clear_flags {
        local($b,$f) = @_;
	    eval q((($b)-> &flags&= ~($f)));
    }' unless defined(&BIO_clear_flags);
    eval 'sub BIO_clear_retry_flags {
        local($b) = @_;
	    eval q((($b)-> &flags&= ~( &BIO_FLAGS_RWS| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_clear_retry_flags);
    eval 'sub BIO_get_retry_flags {
        local($b) = @_;
	    eval q((($b)-> &flags( &BIO_FLAGS_RWS| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_get_retry_flags);
    eval 'sub BIO_should_read {
        local($a) = @_;
	    eval q((($a)-> &flags &  &BIO_FLAGS_READ));
    }' unless defined(&BIO_should_read);
    eval 'sub BIO_should_write {
        local($a) = @_;
	    eval q((($a)-> &flags &  &BIO_FLAGS_WRITE));
    }' unless defined(&BIO_should_write);
    eval 'sub BIO_should_io_special {
        local($a) = @_;
	    eval q((($a)-> &flags &  &BIO_FLAGS_IO_SPECIAL));
    }' unless defined(&BIO_should_io_special);
    eval 'sub BIO_retry_type {
        local($a) = @_;
	    eval q((($a)-> &flags &  &BIO_FLAGS_RWS));
    }' unless defined(&BIO_retry_type);
    eval 'sub BIO_should_retry {
        local($a) = @_;
	    eval q((($a)-> &flags &  &BIO_FLAGS_SHOULD_RETRY));
    }' unless defined(&BIO_should_retry);
    eval 'sub BIO_RR_SSL_X509_LOOKUP () {0x01;}' unless defined(&BIO_RR_SSL_X509_LOOKUP);
    eval 'sub BIO_RR_CONNECT () {0x02;}' unless defined(&BIO_RR_CONNECT);
    eval 'sub BIO_RR_ACCEPT () {0x03;}' unless defined(&BIO_RR_ACCEPT);
    eval 'sub BIO_CB_FREE () {0x01;}' unless defined(&BIO_CB_FREE);
    eval 'sub BIO_CB_READ () {0x02;}' unless defined(&BIO_CB_READ);
    eval 'sub BIO_CB_WRITE () {0x03;}' unless defined(&BIO_CB_WRITE);
    eval 'sub BIO_CB_PUTS () {0x04;}' unless defined(&BIO_CB_PUTS);
    eval 'sub BIO_CB_GETS () {0x05;}' unless defined(&BIO_CB_GETS);
    eval 'sub BIO_CB_CTRL () {0x06;}' unless defined(&BIO_CB_CTRL);
    eval 'sub BIO_CB_RETURN () {0x80;}' unless defined(&BIO_CB_RETURN);
    eval 'sub BIO_CB_return {
        local($a) = @_;
	    eval q((($a)| &BIO_CB_RETURN)));
    }' unless defined(&BIO_CB_return);
    eval 'sub BIO_cb_pre {
        local($a) = @_;
	    eval q((!(($a) &BIO_CB_RETURN)));
    }' unless defined(&BIO_cb_pre);
    eval 'sub BIO_cb_post {
        local($a) = @_;
	    eval q((($a) &BIO_CB_RETURN));
    }' unless defined(&BIO_cb_post);
    eval 'sub BIO_set_callback {
        local($b,$cb) = @_;
	    eval q((($b)-> &callback=($cb)));
    }' unless defined(&BIO_set_callback);
    eval 'sub BIO_set_callback_arg {
        local($b,$arg) = @_;
	    eval q((-> &cb_arg=($arg)));
    }' unless defined(&BIO_set_callback_arg);
    eval 'sub BIO_get_callback_arg {
        local($b) = @_;
	    eval q((($b)-> &cb_arg));
    }' unless defined(&BIO_get_callback_arg);
    eval 'sub BIO_get_callback {
        local($b) = @_;
	    eval q((($b)-> &callback));
    }' unless defined(&BIO_get_callback);
    eval 'sub BIO_method_name {
        local($b) = @_;
	    eval q((($b)-> ($method->{name})));
    }' unless defined(&BIO_method_name);
    eval 'sub BIO_method_type {
        local($b) = @_;
	    eval q((($b)-> ($method->{type})));
    }' unless defined(&BIO_method_type);
    unless(defined(&OPENSSL_SYS_WIN16)) {
    } else {
    }
    eval 'sub BIO_CONN_S_BEFORE () {1;}' unless defined(&BIO_CONN_S_BEFORE);
    eval 'sub BIO_CONN_S_GET_IP () {2;}' unless defined(&BIO_CONN_S_GET_IP);
    eval 'sub BIO_CONN_S_GET_PORT () {3;}' unless defined(&BIO_CONN_S_GET_PORT);
    eval 'sub BIO_CONN_S_CREATE_SOCKET () {4;}' unless defined(&BIO_CONN_S_CREATE_SOCKET);
    eval 'sub BIO_CONN_S_CONNECT () {5;}' unless defined(&BIO_CONN_S_CONNECT);
    eval 'sub BIO_CONN_S_OK () {6;}' unless defined(&BIO_CONN_S_OK);
    eval 'sub BIO_CONN_S_BLOCKED_CONNECT () {7;}' unless defined(&BIO_CONN_S_BLOCKED_CONNECT);
    eval 'sub BIO_CONN_S_NBIO () {8;}' unless defined(&BIO_CONN_S_NBIO);
    eval 'sub BIO_C_SET_CONNECT () {100;}' unless defined(&BIO_C_SET_CONNECT);
    eval 'sub BIO_C_DO_STATE_MACHINE () {101;}' unless defined(&BIO_C_DO_STATE_MACHINE);
    eval 'sub BIO_C_SET_NBIO () {102;}' unless defined(&BIO_C_SET_NBIO);
    eval 'sub BIO_C_SET_PROXY_PARAM () {103;}' unless defined(&BIO_C_SET_PROXY_PARAM);
    eval 'sub BIO_C_SET_FD () {104;}' unless defined(&BIO_C_SET_FD);
    eval 'sub BIO_C_GET_FD () {105;}' unless defined(&BIO_C_GET_FD);
    eval 'sub BIO_C_SET_FILE_PTR () {106;}' unless defined(&BIO_C_SET_FILE_PTR);
    eval 'sub BIO_C_GET_FILE_PTR () {107;}' unless defined(&BIO_C_GET_FILE_PTR);
    eval 'sub BIO_C_SET_FILENAME () {108;}' unless defined(&BIO_C_SET_FILENAME);
    eval 'sub BIO_C_SET_SSL () {109;}' unless defined(&BIO_C_SET_SSL);
    eval 'sub BIO_C_GET_SSL () {110;}' unless defined(&BIO_C_GET_SSL);
    eval 'sub BIO_C_SET_MD () {111;}' unless defined(&BIO_C_SET_MD);
    eval 'sub BIO_C_GET_MD () {112;}' unless defined(&BIO_C_GET_MD);
    eval 'sub BIO_C_GET_CIPHER_STATUS () {113;}' unless defined(&BIO_C_GET_CIPHER_STATUS);
    eval 'sub BIO_C_SET_BUF_MEM () {114;}' unless defined(&BIO_C_SET_BUF_MEM);
    eval 'sub BIO_C_GET_BUF_MEM_PTR () {115;}' unless defined(&BIO_C_GET_BUF_MEM_PTR);
    eval 'sub BIO_C_GET_BUFF_NUM_LINES () {116;}' unless defined(&BIO_C_GET_BUFF_NUM_LINES);
    eval 'sub BIO_C_SET_BUFF_SIZE () {117;}' unless defined(&BIO_C_SET_BUFF_SIZE);
    eval 'sub BIO_C_SET_ACCEPT () {118;}' unless defined(&BIO_C_SET_ACCEPT);
    eval 'sub BIO_C_SSL_MODE () {119;}' unless defined(&BIO_C_SSL_MODE);
    eval 'sub BIO_C_GET_MD_CTX () {120;}' unless defined(&BIO_C_GET_MD_CTX);
    eval 'sub BIO_C_GET_PROXY_PARAM () {121;}' unless defined(&BIO_C_GET_PROXY_PARAM);
    eval 'sub BIO_C_SET_BUFF_READ_DATA () {122;}' unless defined(&BIO_C_SET_BUFF_READ_DATA);
    eval 'sub BIO_C_GET_CONNECT () {123;}' unless defined(&BIO_C_GET_CONNECT);
    eval 'sub BIO_C_GET_ACCEPT () {124;}' unless defined(&BIO_C_GET_ACCEPT);
    eval 'sub BIO_C_SET_SSL_RENEGOTIATE_BYTES () {125;}' unless defined(&BIO_C_SET_SSL_RENEGOTIATE_BYTES);
    eval 'sub BIO_C_GET_SSL_NUM_RENEGOTIATES () {126;}' unless defined(&BIO_C_GET_SSL_NUM_RENEGOTIATES);
    eval 'sub BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT () {127;}' unless defined(&BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT);
    eval 'sub BIO_C_FILE_SEEK () {128;}' unless defined(&BIO_C_FILE_SEEK);
    eval 'sub BIO_C_GET_CIPHER_CTX () {129;}' unless defined(&BIO_C_GET_CIPHER_CTX);
    eval 'sub BIO_C_SET_BUF_MEM_EOF_RETURN () {130;}' unless defined(&BIO_C_SET_BUF_MEM_EOF_RETURN);
    eval 'sub BIO_C_SET_BIND_MODE () {131;}' unless defined(&BIO_C_SET_BIND_MODE);
    eval 'sub BIO_C_GET_BIND_MODE () {132;}' unless defined(&BIO_C_GET_BIND_MODE);
    eval 'sub BIO_C_FILE_TELL () {133;}' unless defined(&BIO_C_FILE_TELL);
    eval 'sub BIO_C_GET_SOCKS () {134;}' unless defined(&BIO_C_GET_SOCKS);
    eval 'sub BIO_C_SET_SOCKS () {135;}' unless defined(&BIO_C_SET_SOCKS);
    eval 'sub BIO_C_SET_WRITE_BUF_SIZE () {136;}' unless defined(&BIO_C_SET_WRITE_BUF_SIZE);
    eval 'sub BIO_C_GET_WRITE_BUF_SIZE () {137;}' unless defined(&BIO_C_GET_WRITE_BUF_SIZE);
    eval 'sub BIO_C_MAKE_BIO_PAIR () {138;}' unless defined(&BIO_C_MAKE_BIO_PAIR);
    eval 'sub BIO_C_DESTROY_BIO_PAIR () {139;}' unless defined(&BIO_C_DESTROY_BIO_PAIR);
    eval 'sub BIO_C_GET_WRITE_GUARANTEE () {140;}' unless defined(&BIO_C_GET_WRITE_GUARANTEE);
    eval 'sub BIO_C_GET_READ_REQUEST () {141;}' unless defined(&BIO_C_GET_READ_REQUEST);
    eval 'sub BIO_C_SHUTDOWN_WR () {142;}' unless defined(&BIO_C_SHUTDOWN_WR);
    eval 'sub BIO_C_NREAD0 () {143;}' unless defined(&BIO_C_NREAD0);
    eval 'sub BIO_C_NREAD () {144;}' unless defined(&BIO_C_NREAD);
    eval 'sub BIO_C_NWRITE0 () {145;}' unless defined(&BIO_C_NWRITE0);
    eval 'sub BIO_C_NWRITE () {146;}' unless defined(&BIO_C_NWRITE);
    eval 'sub BIO_C_RESET_READ_REQUEST () {147;}' unless defined(&BIO_C_RESET_READ_REQUEST);
    eval 'sub BIO_set_app_data {
        local($s,$arg) = @_;
	    eval q( &BIO_set_ex_data($s,0,$arg));
    }' unless defined(&BIO_set_app_data);
    eval 'sub BIO_get_app_data {
        local($s) = @_;
	    eval q( &BIO_get_ex_data($s,0));
    }' unless defined(&BIO_get_app_data);
    eval 'sub BIO_set_conn_hostname {
        local($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT,0,$name));
    }' unless defined(&BIO_set_conn_hostname);
    eval 'sub BIO_set_conn_port {
        local($b,$port) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT,1,$port));
    }' unless defined(&BIO_set_conn_port);
    eval 'sub BIO_set_conn_ip {
        local($b,$ip) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT,2,$ip));
    }' unless defined(&BIO_set_conn_ip);
    eval 'sub BIO_set_conn_int_port {
        local($b,$port) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT,3,$port));
    }' unless defined(&BIO_set_conn_int_port);
    eval 'sub BIO_get_conn_hostname {
        local($b) = @_;
	    eval q( &BIO_ptr_ctrl($b, &BIO_C_GET_CONNECT,0));
    }' unless defined(&BIO_get_conn_hostname);
    eval 'sub BIO_get_conn_port {
        local($b) = @_;
	    eval q( &BIO_ptr_ctrl($b, &BIO_C_GET_CONNECT,1));
    }' unless defined(&BIO_get_conn_port);
    eval 'sub BIO_get_conn_ip {
        local($b) = @_;
	    eval q( &BIO_ptr_ctrl($b, &BIO_C_GET_CONNECT,2));
    }' unless defined(&BIO_get_conn_ip);
    eval 'sub BIO_get_conn_int_port {
        local($b) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_GET_CONNECT,3));
    }' unless defined(&BIO_get_conn_int_port);
    eval 'sub BIO_set_nbio {
        local($b,$n) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_NBIO,($n), &NULL));
    }' unless defined(&BIO_set_nbio);
    eval 'sub BIO_set_accept_port {
        local($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_ACCEPT,0,$name));
    }' unless defined(&BIO_set_accept_port);
    eval 'sub BIO_get_accept_port {
        local($b) = @_;
	    eval q( &BIO_ptr_ctrl($b, &BIO_C_GET_ACCEPT,0));
    }' unless defined(&BIO_get_accept_port);
    eval 'sub BIO_set_nbio_accept {
        local($b,$n) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_ACCEPT,1,($n)?\\"a\\": &NULL));
    }' unless defined(&BIO_set_nbio_accept);
    eval 'sub BIO_set_accept_bios {
        local($b,$bio) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_ACCEPT,2,$bio));
    }' unless defined(&BIO_set_accept_bios);
    eval 'sub BIO_BIND_NORMAL () {0;}' unless defined(&BIO_BIND_NORMAL);
    eval 'sub BIO_BIND_REUSEADDR_IF_UNUSED () {1;}' unless defined(&BIO_BIND_REUSEADDR_IF_UNUSED);
    eval 'sub BIO_BIND_REUSEADDR () {2;}' unless defined(&BIO_BIND_REUSEADDR);
    eval 'sub BIO_set_bind_mode {
        local($b,$mode) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BIND_MODE,$mode, &NULL));
    }' unless defined(&BIO_set_bind_mode);
    eval 'sub BIO_get_bind_mode {
        local($b,$mode) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_BIND_MODE,0, &NULL));
    }' unless defined(&BIO_get_bind_mode);
    eval 'sub BIO_do_connect {
        local($b) = @_;
	    eval q( &BIO_do_handshake($b));
    }' unless defined(&BIO_do_connect);
    eval 'sub BIO_do_accept {
        local($b) = @_;
	    eval q( &BIO_do_handshake($b));
    }' unless defined(&BIO_do_accept);
    eval 'sub BIO_do_handshake {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_DO_STATE_MACHINE,0, &NULL));
    }' unless defined(&BIO_do_handshake);
    eval 'sub BIO_set_url {
        local($b,$url) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_PROXY_PARAM,0,($url)));
    }' unless defined(&BIO_set_url);
    eval 'sub BIO_set_proxies {
        local($b,$p) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_PROXY_PARAM,1,($p)));
    }' unless defined(&BIO_set_proxies);
    eval 'sub BIO_set_filter_bio {
        local($b,$s) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_PROXY_PARAM,2,($s)));
    }' unless defined(&BIO_set_filter_bio);
    eval 'sub BIO_set_proxy_cb {
        local($b,$cb) = @_;
	    eval q( &BIO_callback_ctrl($b, &BIO_C_SET_PROXY_PARAM,3,( &void *(*$cb)())));
    }' unless defined(&BIO_set_proxy_cb);
    eval 'sub BIO_set_proxy_header {
        local($b,$sk) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_PROXY_PARAM,4,$sk));
    }' unless defined(&BIO_set_proxy_header);
    eval 'sub BIO_set_no_connect_return {
        local($b,$bool) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_PROXY_PARAM,5,$bool));
    }' unless defined(&BIO_set_no_connect_return);
    eval 'sub BIO_get_proxy_header {
        local($b,$skp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_PROXY_PARAM,0,$skp));
    }' unless defined(&BIO_get_proxy_header);
    eval 'sub BIO_get_proxies {
        local($b,$pxy_p) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_PROXY_PARAM,1,($pxy_p)));
    }' unless defined(&BIO_get_proxies);
    eval 'sub BIO_get_url {
        local($b,$url) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_PROXY_PARAM,2,($url)));
    }' unless defined(&BIO_get_url);
    eval 'sub BIO_get_no_connect_return {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_PROXY_PARAM,5, &NULL));
    }' unless defined(&BIO_get_no_connect_return);
    eval 'sub BIO_set_fd {
        local($b,$fd,$c) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_FD,$c,$fd));
    }' unless defined(&BIO_set_fd);
    eval 'sub BIO_get_fd {
        local($b,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_FD,0,$c));
    }' unless defined(&BIO_get_fd);
    eval 'sub BIO_set_fp {
        local($b,$fp,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILE_PTR,$c,$fp));
    }' unless defined(&BIO_set_fp);
    eval 'sub BIO_get_fp {
        local($b,$fpp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_FILE_PTR,0,$fpp));
    }' unless defined(&BIO_get_fp);
    eval 'sub BIO_seek {
        local($b,$ofs) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_FILE_SEEK,$ofs, &NULL));
    }' unless defined(&BIO_seek);
    eval 'sub BIO_tell {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_FILE_TELL,0, &NULL));
    }' unless defined(&BIO_tell);
    if(defined(&CONST_STRICT)) {
    } else {
	eval 'sub BIO_read_filename {
	    local($b,$name) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_READ,$name));
	}' unless defined(&BIO_read_filename);
    }
    eval 'sub BIO_write_filename {
        local($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_WRITE,$name));
    }' unless defined(&BIO_write_filename);
    eval 'sub BIO_append_filename {
        local($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_APPEND,$name));
    }' unless defined(&BIO_append_filename);
    eval 'sub BIO_rw_filename {
        local($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_READ| &BIO_FP_WRITE,$name));
    }' unless defined(&BIO_rw_filename);
    eval 'sub BIO_set_ssl {
        local($b,$ssl,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_SSL,$c,$ssl));
    }' unless defined(&BIO_set_ssl);
    eval 'sub BIO_get_ssl {
        local($b,$sslp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_SSL,0,$sslp));
    }' unless defined(&BIO_get_ssl);
    eval 'sub BIO_set_ssl_mode {
        local($b,$client) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SSL_MODE,$client, &NULL));
    }' unless defined(&BIO_set_ssl_mode);
    eval 'sub BIO_set_ssl_renegotiate_bytes {
        local($b,$num) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_SSL_RENEGOTIATE_BYTES,$num, &NULL););
    }' unless defined(&BIO_set_ssl_renegotiate_bytes);
    eval 'sub BIO_get_num_renegotiates {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_SSL_NUM_RENEGOTIATES,0, &NULL););
    }' unless defined(&BIO_get_num_renegotiates);
    eval 'sub BIO_set_ssl_renegotiate_timeout {
        local($b,$seconds) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT,$seconds, &NULL););
    }' unless defined(&BIO_set_ssl_renegotiate_timeout);
    eval 'sub BIO_get_mem_data {
        local($b,$pp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_INFO,0,$pp));
    }' unless defined(&BIO_get_mem_data);
    eval 'sub BIO_set_mem_buf {
        local($b,$bm,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUF_MEM,$c,$bm));
    }' unless defined(&BIO_set_mem_buf);
    eval 'sub BIO_get_mem_ptr {
        local($b,$pp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_BUF_MEM_PTR,0,$pp));
    }' unless defined(&BIO_get_mem_ptr);
    eval 'sub BIO_set_mem_eof_return {
        local($b,$v) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUF_MEM_EOF_RETURN,$v, &NULL));
    }' unless defined(&BIO_set_mem_eof_return);
    eval 'sub BIO_get_buffer_num_lines {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_BUFF_NUM_LINES,0, &NULL));
    }' unless defined(&BIO_get_buffer_num_lines);
    eval 'sub BIO_set_buffer_size {
        local($b,$size) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUFF_SIZE,$size, &NULL));
    }' unless defined(&BIO_set_buffer_size);
    eval 'sub BIO_set_read_buffer_size {
        local($b,$size) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_BUFF_SIZE,$size,0));
    }' unless defined(&BIO_set_read_buffer_size);
    eval 'sub BIO_set_write_buffer_size {
        local($b,$size) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_BUFF_SIZE,$size,1));
    }' unless defined(&BIO_set_write_buffer_size);
    eval 'sub BIO_set_buffer_read_data {
        local($b,$buf,$num) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUFF_READ_DATA,$num,$buf));
    }' unless defined(&BIO_set_buffer_read_data);
    eval 'sub BIO_dup_state {
        local($b,$ret) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_DUP,0,($ret)));
    }' unless defined(&BIO_dup_state);
    eval 'sub BIO_reset {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_RESET,0, &NULL));
    }' unless defined(&BIO_reset);
    eval 'sub BIO_eof {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_EOF,0, &NULL));
    }' unless defined(&BIO_eof);
    eval 'sub BIO_set_close {
        local($b,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_SET_CLOSE,($c), &NULL));
    }' unless defined(&BIO_set_close);
    eval 'sub BIO_get_close {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_GET_CLOSE,0, &NULL));
    }' unless defined(&BIO_get_close);
    eval 'sub BIO_pending {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_PENDING,0, &NULL));
    }' unless defined(&BIO_pending);
    eval 'sub BIO_wpending {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_WPENDING,0, &NULL));
    }' unless defined(&BIO_wpending);
    eval 'sub BIO_flush {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_FLUSH,0, &NULL));
    }' unless defined(&BIO_flush);
    eval 'sub BIO_get_info_callback {
        local($b,$cbp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_GET_CALLBACK,0, $cbp));
    }' unless defined(&BIO_get_info_callback);
    eval 'sub BIO_set_info_callback {
        local($b,$cb) = @_;
	    eval q( &BIO_callback_ctrl($b, &BIO_CTRL_SET_CALLBACK,$cb));
    }' unless defined(&BIO_set_info_callback);
    eval 'sub BIO_buffer_get_num_lines {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_GET,0, &NULL));
    }' unless defined(&BIO_buffer_get_num_lines);
    eval 'sub BIO_set_write_buf_size {
        local($b,$size) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_WRITE_BUF_SIZE,$size, &NULL));
    }' unless defined(&BIO_set_write_buf_size);
    eval 'sub BIO_get_write_buf_size {
        local($b,$size) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_WRITE_BUF_SIZE,$size, &NULL));
    }' unless defined(&BIO_get_write_buf_size);
    eval 'sub BIO_make_bio_pair {
        local($b1,$b2) = @_;
	    eval q( &BIO_ctrl($b1, &BIO_C_MAKE_BIO_PAIR,0,$b2));
    }' unless defined(&BIO_make_bio_pair);
    eval 'sub BIO_destroy_bio_pair {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_DESTROY_BIO_PAIR,0, &NULL));
    }' unless defined(&BIO_destroy_bio_pair);
    eval 'sub BIO_shutdown_wr {
        local($b) = @_;
	    eval q( &BIO_ctrl($b,  &BIO_C_SHUTDOWN_WR, 0,  &NULL));
    }' unless defined(&BIO_shutdown_wr);
    eval 'sub BIO_get_write_guarantee {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_WRITE_GUARANTEE,0, &NULL));
    }' unless defined(&BIO_get_write_guarantee);
    eval 'sub BIO_get_read_request {
        local($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_READ_REQUEST,0, &NULL));
    }' unless defined(&BIO_get_read_request);
    unless(defined(&OPENSSL_NO_FP_API)) {
	if(defined( &OPENSSL_SYS_WIN16)  && defined( &_WINDLL)) {
	    eval 'sub BIO_s_file () { &BIO_s_file_internal;}' unless defined(&BIO_s_file);
	    eval 'sub BIO_new_file () { &BIO_new_file_internal;}' unless defined(&BIO_new_file);
	    eval 'sub BIO_new_fp () { &BIO_new_fp_internal;}' unless defined(&BIO_new_fp);
	} else {
	    eval 'sub BIO_s_file_internal () { &BIO_s_file;}' unless defined(&BIO_s_file_internal);
	    eval 'sub BIO_new_file_internal () { &BIO_new_file;}' unless defined(&BIO_new_file_internal);
	    eval 'sub BIO_new_fp_internal () { &BIO_s_file;}' unless defined(&BIO_new_fp_internal);
	}
    }
    unless(defined(&OPENSSL_SYS_WIN16)) {
    } else {
    }
    unless(defined(&OPENSSL_SYS_OS2)) {
    }
    if(defined(&OPENSSL_SYS_VMS)) {
    }
    eval 'sub BIO_F_ACPT_STATE () {100;}' unless defined(&BIO_F_ACPT_STATE);
    eval 'sub BIO_F_BIO_ACCEPT () {101;}' unless defined(&BIO_F_BIO_ACCEPT);
    eval 'sub BIO_F_BIO_BER_GET_HEADER () {102;}' unless defined(&BIO_F_BIO_BER_GET_HEADER);
    eval 'sub BIO_F_BIO_CTRL () {103;}' unless defined(&BIO_F_BIO_CTRL);
    eval 'sub BIO_F_BIO_GETHOSTBYNAME () {120;}' unless defined(&BIO_F_BIO_GETHOSTBYNAME);
    eval 'sub BIO_F_BIO_GETS () {104;}' unless defined(&BIO_F_BIO_GETS);
    eval 'sub BIO_F_BIO_GET_ACCEPT_SOCKET () {105;}' unless defined(&BIO_F_BIO_GET_ACCEPT_SOCKET);
    eval 'sub BIO_F_BIO_GET_HOST_IP () {106;}' unless defined(&BIO_F_BIO_GET_HOST_IP);
    eval 'sub BIO_F_BIO_GET_PORT () {107;}' unless defined(&BIO_F_BIO_GET_PORT);
    eval 'sub BIO_F_BIO_MAKE_PAIR () {121;}' unless defined(&BIO_F_BIO_MAKE_PAIR);
    eval 'sub BIO_F_BIO_NEW () {108;}' unless defined(&BIO_F_BIO_NEW);
    eval 'sub BIO_F_BIO_NEW_FILE () {109;}' unless defined(&BIO_F_BIO_NEW_FILE);
    eval 'sub BIO_F_BIO_NEW_MEM_BUF () {126;}' unless defined(&BIO_F_BIO_NEW_MEM_BUF);
    eval 'sub BIO_F_BIO_NREAD () {123;}' unless defined(&BIO_F_BIO_NREAD);
    eval 'sub BIO_F_BIO_NREAD0 () {124;}' unless defined(&BIO_F_BIO_NREAD0);
    eval 'sub BIO_F_BIO_NWRITE () {125;}' unless defined(&BIO_F_BIO_NWRITE);
    eval 'sub BIO_F_BIO_NWRITE0 () {122;}' unless defined(&BIO_F_BIO_NWRITE0);
    eval 'sub BIO_F_BIO_PUTS () {110;}' unless defined(&BIO_F_BIO_PUTS);
    eval 'sub BIO_F_BIO_READ () {111;}' unless defined(&BIO_F_BIO_READ);
    eval 'sub BIO_F_BIO_SOCK_INIT () {112;}' unless defined(&BIO_F_BIO_SOCK_INIT);
    eval 'sub BIO_F_BIO_WRITE () {113;}' unless defined(&BIO_F_BIO_WRITE);
    eval 'sub BIO_F_BUFFER_CTRL () {114;}' unless defined(&BIO_F_BUFFER_CTRL);
    eval 'sub BIO_F_CONN_CTRL () {127;}' unless defined(&BIO_F_CONN_CTRL);
    eval 'sub BIO_F_CONN_STATE () {115;}' unless defined(&BIO_F_CONN_STATE);
    eval 'sub BIO_F_FILE_CTRL () {116;}' unless defined(&BIO_F_FILE_CTRL);
    eval 'sub BIO_F_FILE_READ () {130;}' unless defined(&BIO_F_FILE_READ);
    eval 'sub BIO_F_LINEBUFFER_CTRL () {129;}' unless defined(&BIO_F_LINEBUFFER_CTRL);
    eval 'sub BIO_F_MEM_READ () {128;}' unless defined(&BIO_F_MEM_READ);
    eval 'sub BIO_F_MEM_WRITE () {117;}' unless defined(&BIO_F_MEM_WRITE);
    eval 'sub BIO_F_SSL_NEW () {118;}' unless defined(&BIO_F_SSL_NEW);
    eval 'sub BIO_F_WSASTARTUP () {119;}' unless defined(&BIO_F_WSASTARTUP);
    eval 'sub BIO_R_ACCEPT_ERROR () {100;}' unless defined(&BIO_R_ACCEPT_ERROR);
    eval 'sub BIO_R_BAD_FOPEN_MODE () {101;}' unless defined(&BIO_R_BAD_FOPEN_MODE);
    eval 'sub BIO_R_BAD_HOSTNAME_LOOKUP () {102;}' unless defined(&BIO_R_BAD_HOSTNAME_LOOKUP);
    eval 'sub BIO_R_BROKEN_PIPE () {124;}' unless defined(&BIO_R_BROKEN_PIPE);
    eval 'sub BIO_R_CONNECT_ERROR () {103;}' unless defined(&BIO_R_CONNECT_ERROR);
    eval 'sub BIO_R_EOF_ON_MEMORY_BIO () {127;}' unless defined(&BIO_R_EOF_ON_MEMORY_BIO);
    eval 'sub BIO_R_ERROR_SETTING_NBIO () {104;}' unless defined(&BIO_R_ERROR_SETTING_NBIO);
    eval 'sub BIO_R_ERROR_SETTING_NBIO_ON_ACCEPTED_SOCKET () {105;}' unless defined(&BIO_R_ERROR_SETTING_NBIO_ON_ACCEPTED_SOCKET);
    eval 'sub BIO_R_ERROR_SETTING_NBIO_ON_ACCEPT_SOCKET () {106;}' unless defined(&BIO_R_ERROR_SETTING_NBIO_ON_ACCEPT_SOCKET);
    eval 'sub BIO_R_GETHOSTBYNAME_ADDR_IS_NOT_AF_INET () {107;}' unless defined(&BIO_R_GETHOSTBYNAME_ADDR_IS_NOT_AF_INET);
    eval 'sub BIO_R_INVALID_ARGUMENT () {125;}' unless defined(&BIO_R_INVALID_ARGUMENT);
    eval 'sub BIO_R_INVALID_IP_ADDRESS () {108;}' unless defined(&BIO_R_INVALID_IP_ADDRESS);
    eval 'sub BIO_R_IN_USE () {123;}' unless defined(&BIO_R_IN_USE);
    eval 'sub BIO_R_KEEPALIVE () {109;}' unless defined(&BIO_R_KEEPALIVE);
    eval 'sub BIO_R_NBIO_CONNECT_ERROR () {110;}' unless defined(&BIO_R_NBIO_CONNECT_ERROR);
    eval 'sub BIO_R_NO_ACCEPT_PORT_SPECIFIED () {111;}' unless defined(&BIO_R_NO_ACCEPT_PORT_SPECIFIED);
    eval 'sub BIO_R_NO_HOSTNAME_SPECIFIED () {112;}' unless defined(&BIO_R_NO_HOSTNAME_SPECIFIED);
    eval 'sub BIO_R_NO_PORT_DEFINED () {113;}' unless defined(&BIO_R_NO_PORT_DEFINED);
    eval 'sub BIO_R_NO_PORT_SPECIFIED () {114;}' unless defined(&BIO_R_NO_PORT_SPECIFIED);
    eval 'sub BIO_R_NO_SUCH_FILE () {128;}' unless defined(&BIO_R_NO_SUCH_FILE);
    eval 'sub BIO_R_NULL_PARAMETER () {115;}' unless defined(&BIO_R_NULL_PARAMETER);
    eval 'sub BIO_R_TAG_MISMATCH () {116;}' unless defined(&BIO_R_TAG_MISMATCH);
    eval 'sub BIO_R_UNABLE_TO_BIND_SOCKET () {117;}' unless defined(&BIO_R_UNABLE_TO_BIND_SOCKET);
    eval 'sub BIO_R_UNABLE_TO_CREATE_SOCKET () {118;}' unless defined(&BIO_R_UNABLE_TO_CREATE_SOCKET);
    eval 'sub BIO_R_UNABLE_TO_LISTEN_SOCKET () {119;}' unless defined(&BIO_R_UNABLE_TO_LISTEN_SOCKET);
    eval 'sub BIO_R_UNINITIALIZED () {120;}' unless defined(&BIO_R_UNINITIALIZED);
    eval 'sub BIO_R_UNSUPPORTED_METHOD () {121;}' unless defined(&BIO_R_UNSUPPORTED_METHOD);
    eval 'sub BIO_R_WRITE_TO_READ_ONLY_BIO () {126;}' unless defined(&BIO_R_WRITE_TO_READ_ONLY_BIO);
    eval 'sub BIO_R_WSASTARTUP () {122;}' unless defined(&BIO_R_WSASTARTUP);
    if(defined(&__cplusplus)) {
    }
}
1;
