require '_h2ph_pre.ph';

unless(defined(&_POWERPC_PMAP_H_)) {
    eval 'sub _POWERPC_PMAP_H_ () {1;}' unless defined(&_POWERPC_PMAP_H_);
    require 'machine/pte.ph';
    unless(defined(&_LOCORE)) {
    }
    eval 'sub SR_TYPE () {0x80000000;}' unless defined(&SR_TYPE);
    eval 'sub SR_SUKEY () {0x40000000;}' unless defined(&SR_SUKEY);
    eval 'sub SR_PRKEY () {0x20000000;}' unless defined(&SR_PRKEY);
    eval 'sub SR_NOEXEC () {0x10000000;}' unless defined(&SR_NOEXEC);
    eval 'sub SR_VSID () {0x00ffffff;}' unless defined(&SR_VSID);
    unless(defined(&_LOCORE)) {
	eval 'sub VP_SR_SIZE () {16;}' unless defined(&VP_SR_SIZE);
	eval 'sub VP_SR_MASK () {( &VP_SR_SIZE-1);}' unless defined(&VP_SR_MASK);
	eval 'sub VP_SR_POS () {28;}' unless defined(&VP_SR_POS);
	eval 'sub VP_IDX1_SIZE () {256;}' unless defined(&VP_IDX1_SIZE);
	eval 'sub VP_IDX1_MASK () {( &VP_IDX1_SIZE-1);}' unless defined(&VP_IDX1_MASK);
	eval 'sub VP_IDX1_POS () {20;}' unless defined(&VP_IDX1_POS);
	eval 'sub VP_IDX2_SIZE () {256;}' unless defined(&VP_IDX2_SIZE);
	eval 'sub VP_IDX2_MASK () {( &VP_IDX2_SIZE-1);}' unless defined(&VP_IDX2_MASK);
	eval 'sub VP_IDX2_POS () {12;}' unless defined(&VP_IDX2_POS);
	eval 'sub PMAP_CACHE_DEFAULT () {0;}' unless defined(&PMAP_CACHE_DEFAULT);
	eval 'sub PMAP_CACHE_CI () {1;}' unless defined(&PMAP_CACHE_CI);
	eval 'sub PMAP_CACHE_WT () {2;}' unless defined(&PMAP_CACHE_WT);
	eval 'sub PMAP_CACHE_WB () {3;}' unless defined(&PMAP_CACHE_WB);
	if(defined(&_KERNEL)) {
	    eval 'sub pmap_kernel () {
	        eval q(( &kernel_pmap_));
	    }' unless defined(&pmap_kernel);
	    eval 'sub pmap_clear_modify {
	        local($page) = @_;
    		eval q(( &pteclrbits( &VM_PAGE_TO_PHYS($page),  &PTE_CHG,  &TRUE)));
	    }' unless defined(&pmap_clear_modify);
	    eval 'sub pmap_clear_reference {
	        local($page) = @_;
    		eval q(( &pteclrbits( &VM_PAGE_TO_PHYS($page),  &PTE_REF,  &TRUE)));
	    }' unless defined(&pmap_clear_reference);
	    eval 'sub pmap_is_modified {
	        local($page) = @_;
    		eval q(( &pteclrbits( &VM_PAGE_TO_PHYS($page),  &PTE_CHG,  &FALSE)));
	    }' unless defined(&pmap_is_modified);
	    eval 'sub pmap_is_referenced {
	        local($page) = @_;
    		eval q(( &pteclrbits( &VM_PAGE_TO_PHYS($page),  &PTE_REF,  &FALSE)));
	    }' unless defined(&pmap_is_referenced);
	    eval 'sub pmap_unwire {
	        local($pm, $va) = @_;
    		eval q();
	    }' unless defined(&pmap_unwire);
	    eval 'sub pmap_phys_address {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&pmap_phys_address);
	    eval 'sub pmap_update {
	        local($pmap) = @_;
    		eval q();
	    }' unless defined(&pmap_update);
	    eval 'sub pmap_resident_count {
	        local($pmap) = @_;
    		eval q((($pmap)-> ($pm_stats->{resident_count})));
	    }' unless defined(&pmap_resident_count);
	    eval 'sub PMAP_MAP_POOLPAGE {
	        local($pg) = @_;
    		eval q(( &VM_PAGE_TO_PHYS($pg)));
	    }' unless defined(&PMAP_MAP_POOLPAGE);
	    eval 'sub PMAP_UNMAP_POOLPAGE {
	        local($va) = @_;
    		eval q( &PHYS_TO_VM_PAGE($va));
	    }' unless defined(&PMAP_UNMAP_POOLPAGE);
	    eval 'sub pmap_copy {
	        local($dst_pmap, $src_pmap, $dst_addr, $len, $src_addr) = @_;
    		eval q(;);
	    }' unless defined(&pmap_copy);
	}
    }
}
1;
