require '_h2ph_pre.ph';

unless(defined(&_POWERPC_PARAM_H_)) {
    eval 'sub _POWERPC_PARAM_H_ () {1;}' unless defined(&_POWERPC_PARAM_H_);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub MACHINE_ARCH () {"powerpc";}' unless defined(&MACHINE_ARCH);
    eval 'sub _MACHINE_ARCH () { &powerpc;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MID_MACHINE () {0;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {($sizeof{ &double} - 1);}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        local($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
    eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () { &NBPG;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub UPAGES () {4;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    unless(defined(&NMBCLUSTERS)) {
	if(defined(&GATEWAY)) {
	    eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
	} else {
	    eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
	}
    }
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub powerpc_btop {
        local($x) = @_;
	    eval q((($x) >>  &PGSHIFT));
    }' unless defined(&powerpc_btop);
    eval 'sub powerpc_ptob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&powerpc_ptob);
    eval 'sub SEGMENT_LENGTH () {0x10000000;}' unless defined(&SEGMENT_LENGTH);
    eval 'sub SEGMENT_MASK () {0xf0000000;}' unless defined(&SEGMENT_MASK);
    eval 'sub USER_SR () {13;}' unless defined(&USER_SR);
    eval 'sub KERNEL_SR () {14;}' unless defined(&KERNEL_SR);
    eval 'sub KERNEL_SEG0 () {0xfffff0;}' unless defined(&KERNEL_SEG0);
    eval 'sub KERNEL_SEGMENT () {( &KERNEL_SEG0 +  &KERNEL_SR);}' unless defined(&KERNEL_SEGMENT);
    eval 'sub USER_ADDR () {(( &USER_SR <<  &ADDR_SR_SHIFT));}' unless defined(&USER_ADDR);
    unless(defined(&NPMAPS)) {
	eval 'sub NPMAPS () {32768;}' unless defined(&NPMAPS);
    }
    eval 'sub ovbcopy () { &bcopy;}' unless defined(&ovbcopy);
}
1;
