require '_h2ph_pre.ph';

unless(defined(&_ISPMBOX_H)) {
    eval 'sub _ISPMBOX_H () {1;}' unless defined(&_ISPMBOX_H);
    eval 'sub MBOX_NO_OP () {0x0000;}' unless defined(&MBOX_NO_OP);
    eval 'sub MBOX_LOAD_RAM () {0x0001;}' unless defined(&MBOX_LOAD_RAM);
    eval 'sub MBOX_EXEC_FIRMWARE () {0x0002;}' unless defined(&MBOX_EXEC_FIRMWARE);
    eval 'sub MBOX_DUMP_RAM () {0x0003;}' unless defined(&MBOX_DUMP_RAM);
    eval 'sub MBOX_WRITE_RAM_WORD () {0x0004;}' unless defined(&MBOX_WRITE_RAM_WORD);
    eval 'sub MBOX_READ_RAM_WORD () {0x0005;}' unless defined(&MBOX_READ_RAM_WORD);
    eval 'sub MBOX_MAILBOX_REG_TEST () {0x0006;}' unless defined(&MBOX_MAILBOX_REG_TEST);
    eval 'sub MBOX_VERIFY_CHECKSUM () {0x0007;}' unless defined(&MBOX_VERIFY_CHECKSUM);
    eval 'sub MBOX_ABOUT_FIRMWARE () {0x0008;}' unless defined(&MBOX_ABOUT_FIRMWARE);
    eval 'sub MBOX_CHECK_FIRMWARE () {0x000e;}' unless defined(&MBOX_CHECK_FIRMWARE);
    eval 'sub MBOX_READ_RAM_WORD_EXTENDED () {0x000f;}' unless defined(&MBOX_READ_RAM_WORD_EXTENDED);
    eval 'sub MBOX_INIT_REQ_QUEUE () {0x0010;}' unless defined(&MBOX_INIT_REQ_QUEUE);
    eval 'sub MBOX_INIT_RES_QUEUE () {0x0011;}' unless defined(&MBOX_INIT_RES_QUEUE);
    eval 'sub MBOX_EXECUTE_IOCB () {0x0012;}' unless defined(&MBOX_EXECUTE_IOCB);
    eval 'sub MBOX_WAKE_UP () {0x0013;}' unless defined(&MBOX_WAKE_UP);
    eval 'sub MBOX_STOP_FIRMWARE () {0x0014;}' unless defined(&MBOX_STOP_FIRMWARE);
    eval 'sub MBOX_ABORT () {0x0015;}' unless defined(&MBOX_ABORT);
    eval 'sub MBOX_ABORT_DEVICE () {0x0016;}' unless defined(&MBOX_ABORT_DEVICE);
    eval 'sub MBOX_ABORT_TARGET () {0x0017;}' unless defined(&MBOX_ABORT_TARGET);
    eval 'sub MBOX_BUS_RESET () {0x0018;}' unless defined(&MBOX_BUS_RESET);
    eval 'sub MBOX_STOP_QUEUE () {0x0019;}' unless defined(&MBOX_STOP_QUEUE);
    eval 'sub MBOX_START_QUEUE () {0x001a;}' unless defined(&MBOX_START_QUEUE);
    eval 'sub MBOX_SINGLE_STEP_QUEUE () {0x001b;}' unless defined(&MBOX_SINGLE_STEP_QUEUE);
    eval 'sub MBOX_ABORT_QUEUE () {0x001c;}' unless defined(&MBOX_ABORT_QUEUE);
    eval 'sub MBOX_GET_DEV_QUEUE_STATUS () {0x001d;}' unless defined(&MBOX_GET_DEV_QUEUE_STATUS);
    eval 'sub MBOX_GET_FIRMWARE_STATUS () {0x001f;}' unless defined(&MBOX_GET_FIRMWARE_STATUS);
    eval 'sub MBOX_GET_INIT_SCSI_ID () {0x0020;}' unless defined(&MBOX_GET_INIT_SCSI_ID);
    eval 'sub MBOX_GET_SELECT_TIMEOUT () {0x0021;}' unless defined(&MBOX_GET_SELECT_TIMEOUT);
    eval 'sub MBOX_GET_RETRY_COUNT () {0x0022;}' unless defined(&MBOX_GET_RETRY_COUNT);
    eval 'sub MBOX_GET_TAG_AGE_LIMIT () {0x0023;}' unless defined(&MBOX_GET_TAG_AGE_LIMIT);
    eval 'sub MBOX_GET_CLOCK_RATE () {0x0024;}' unless defined(&MBOX_GET_CLOCK_RATE);
    eval 'sub MBOX_GET_ACT_NEG_STATE () {0x0025;}' unless defined(&MBOX_GET_ACT_NEG_STATE);
    eval 'sub MBOX_GET_ASYNC_DATA_SETUP_TIME () {0x0026;}' unless defined(&MBOX_GET_ASYNC_DATA_SETUP_TIME);
    eval 'sub MBOX_GET_SBUS_PARAMS () {0x0027;}' unless defined(&MBOX_GET_SBUS_PARAMS);
    eval 'sub MBOX_GET_PCI_PARAMS () { &MBOX_GET_SBUS_PARAMS;}' unless defined(&MBOX_GET_PCI_PARAMS);
    eval 'sub MBOX_GET_TARGET_PARAMS () {0x0028;}' unless defined(&MBOX_GET_TARGET_PARAMS);
    eval 'sub MBOX_GET_DEV_QUEUE_PARAMS () {0x0029;}' unless defined(&MBOX_GET_DEV_QUEUE_PARAMS);
    eval 'sub MBOX_GET_RESET_DELAY_PARAMS () {0x002a;}' unless defined(&MBOX_GET_RESET_DELAY_PARAMS);
    eval 'sub MBOX_SET_INIT_SCSI_ID () {0x0030;}' unless defined(&MBOX_SET_INIT_SCSI_ID);
    eval 'sub MBOX_SET_SELECT_TIMEOUT () {0x0031;}' unless defined(&MBOX_SET_SELECT_TIMEOUT);
    eval 'sub MBOX_SET_RETRY_COUNT () {0x0032;}' unless defined(&MBOX_SET_RETRY_COUNT);
    eval 'sub MBOX_SET_TAG_AGE_LIMIT () {0x0033;}' unless defined(&MBOX_SET_TAG_AGE_LIMIT);
    eval 'sub MBOX_SET_CLOCK_RATE () {0x0034;}' unless defined(&MBOX_SET_CLOCK_RATE);
    eval 'sub MBOX_SET_ACT_NEG_STATE () {0x0035;}' unless defined(&MBOX_SET_ACT_NEG_STATE);
    eval 'sub MBOX_SET_ASYNC_DATA_SETUP_TIME () {0x0036;}' unless defined(&MBOX_SET_ASYNC_DATA_SETUP_TIME);
    eval 'sub MBOX_SET_SBUS_CONTROL_PARAMS () {0x0037;}' unless defined(&MBOX_SET_SBUS_CONTROL_PARAMS);
    eval 'sub MBOX_SET_PCI_PARAMETERS () {0x0037;}' unless defined(&MBOX_SET_PCI_PARAMETERS);
    eval 'sub MBOX_SET_TARGET_PARAMS () {0x0038;}' unless defined(&MBOX_SET_TARGET_PARAMS);
    eval 'sub MBOX_SET_DEV_QUEUE_PARAMS () {0x0039;}' unless defined(&MBOX_SET_DEV_QUEUE_PARAMS);
    eval 'sub MBOX_SET_RESET_DELAY_PARAMS () {0x003a;}' unless defined(&MBOX_SET_RESET_DELAY_PARAMS);
    eval 'sub MBOX_RETURN_BIOS_BLOCK_ADDR () {0x0040;}' unless defined(&MBOX_RETURN_BIOS_BLOCK_ADDR);
    eval 'sub MBOX_WRITE_FOUR_RAM_WORDS () {0x0041;}' unless defined(&MBOX_WRITE_FOUR_RAM_WORDS);
    eval 'sub MBOX_EXEC_BIOS_IOCB () {0x0042;}' unless defined(&MBOX_EXEC_BIOS_IOCB);
    eval 'sub MBOX_SET_FW_FEATURES () {0x004a;}' unless defined(&MBOX_SET_FW_FEATURES);
    eval 'sub MBOX_GET_FW_FEATURES () {0x004b;}' unless defined(&MBOX_GET_FW_FEATURES);
    eval 'sub FW_FEATURE_FAST_POST () {0x1;}' unless defined(&FW_FEATURE_FAST_POST);
    eval 'sub FW_FEATURE_LVD_NOTIFY () {0x2;}' unless defined(&FW_FEATURE_LVD_NOTIFY);
    eval 'sub FW_FEATURE_RIO_32BIT () {0x4;}' unless defined(&FW_FEATURE_RIO_32BIT);
    eval 'sub FW_FEATURE_RIO_16BIT () {0x8;}' unless defined(&FW_FEATURE_RIO_16BIT);
    eval 'sub MBOX_ENABLE_TARGET_MODE () {0x0055;}' unless defined(&MBOX_ENABLE_TARGET_MODE);
    eval 'sub ENABLE_TARGET_FLAG () {0x8000;}' unless defined(&ENABLE_TARGET_FLAG);
    eval 'sub ENABLE_TQING_FLAG () {0x0004;}' unless defined(&ENABLE_TQING_FLAG);
    eval 'sub ENABLE_MANDATORY_DISC () {0x0002;}' unless defined(&ENABLE_MANDATORY_DISC);
    eval 'sub MBOX_GET_TARGET_STATUS () {0x0056;}' unless defined(&MBOX_GET_TARGET_STATUS);
    eval 'sub MBOX_GET_LOOP_ID () {0x0020;}' unless defined(&MBOX_GET_LOOP_ID);
    eval 'sub MBOX_GET_FIRMWARE_OPTIONS () {0x0028;}' unless defined(&MBOX_GET_FIRMWARE_OPTIONS);
    eval 'sub MBOX_SET_FIRMWARE_OPTIONS () {0x0038;}' unless defined(&MBOX_SET_FIRMWARE_OPTIONS);
    eval 'sub MBOX_GET_RESOURCE_COUNT () {0x0042;}' unless defined(&MBOX_GET_RESOURCE_COUNT);
    eval 'sub MBOX_ENHANCED_GET_PDB () {0x0047;}' unless defined(&MBOX_ENHANCED_GET_PDB);
    eval 'sub MBOX_EXEC_COMMAND_IOCB_A64 () {0x0054;}' unless defined(&MBOX_EXEC_COMMAND_IOCB_A64);
    eval 'sub MBOX_INIT_FIRMWARE () {0x0060;}' unless defined(&MBOX_INIT_FIRMWARE);
    eval 'sub MBOX_GET_INIT_CONTROL_BLOCK () {0x0061;}' unless defined(&MBOX_GET_INIT_CONTROL_BLOCK);
    eval 'sub MBOX_INIT_LIP () {0x0062;}' unless defined(&MBOX_INIT_LIP);
    eval 'sub MBOX_GET_FC_AL_POSITION_MAP () {0x0063;}' unless defined(&MBOX_GET_FC_AL_POSITION_MAP);
    eval 'sub MBOX_GET_PORT_DB () {0x0064;}' unless defined(&MBOX_GET_PORT_DB);
    eval 'sub MBOX_CLEAR_ACA () {0x0065;}' unless defined(&MBOX_CLEAR_ACA);
    eval 'sub MBOX_TARGET_RESET () {0x0066;}' unless defined(&MBOX_TARGET_RESET);
    eval 'sub MBOX_CLEAR_TASK_SET () {0x0067;}' unless defined(&MBOX_CLEAR_TASK_SET);
    eval 'sub MBOX_ABORT_TASK_SET () {0x0068;}' unless defined(&MBOX_ABORT_TASK_SET);
    eval 'sub MBOX_GET_FW_STATE () {0x0069;}' unless defined(&MBOX_GET_FW_STATE);
    eval 'sub MBOX_GET_PORT_NAME () {0x006a;}' unless defined(&MBOX_GET_PORT_NAME);
    eval 'sub MBOX_GET_LINK_STATUS () {0x006b;}' unless defined(&MBOX_GET_LINK_STATUS);
    eval 'sub MBOX_INIT_LIP_RESET () {0x006c;}' unless defined(&MBOX_INIT_LIP_RESET);
    eval 'sub MBOX_SEND_SNS () {0x006e;}' unless defined(&MBOX_SEND_SNS);
    eval 'sub MBOX_FABRIC_LOGIN () {0x006f;}' unless defined(&MBOX_FABRIC_LOGIN);
    eval 'sub MBOX_SEND_CHANGE_REQUEST () {0x0070;}' unless defined(&MBOX_SEND_CHANGE_REQUEST);
    eval 'sub MBOX_FABRIC_LOGOUT () {0x0071;}' unless defined(&MBOX_FABRIC_LOGOUT);
    eval 'sub MBOX_INIT_LIP_LOGIN () {0x0072;}' unless defined(&MBOX_INIT_LIP_LOGIN);
    eval 'sub MBOX_DRIVER_HEARTBEAT () {0x005b;}' unless defined(&MBOX_DRIVER_HEARTBEAT);
    eval 'sub MBOX_FW_HEARTBEAT () {0x005c;}' unless defined(&MBOX_FW_HEARTBEAT);
    eval 'sub MBOX_GET_SET_DATA_RATE () {0x005d;}' unless defined(&MBOX_GET_SET_DATA_RATE);
    eval 'sub MBGSD_GET_RATE () {0;}' unless defined(&MBGSD_GET_RATE);
    eval 'sub MBGSD_SET_RATE () {1;}' unless defined(&MBGSD_SET_RATE);
    eval 'sub MBGSD_ONEGB () {0;}' unless defined(&MBGSD_ONEGB);
    eval 'sub MBGSD_TWOGB () {1;}' unless defined(&MBGSD_TWOGB);
    eval 'sub MBGSD_AUTO () {2;}' unless defined(&MBGSD_AUTO);
    eval 'sub ISP2100_SET_PCI_PARAM () {0x00ff;}' unless defined(&ISP2100_SET_PCI_PARAM);
    eval 'sub MBOX_BUSY () {0x04;}' unless defined(&MBOX_BUSY);
    eval 'sub MBOX_COMMAND_COMPLETE () {0x4000;}' unless defined(&MBOX_COMMAND_COMPLETE);
    eval 'sub MBOX_INVALID_COMMAND () {0x4001;}' unless defined(&MBOX_INVALID_COMMAND);
    eval 'sub MBOX_HOST_INTERFACE_ERROR () {0x4002;}' unless defined(&MBOX_HOST_INTERFACE_ERROR);
    eval 'sub MBOX_TEST_FAILED () {0x4003;}' unless defined(&MBOX_TEST_FAILED);
    eval 'sub MBOX_COMMAND_ERROR () {0x4005;}' unless defined(&MBOX_COMMAND_ERROR);
    eval 'sub MBOX_COMMAND_PARAM_ERROR () {0x4006;}' unless defined(&MBOX_COMMAND_PARAM_ERROR);
    eval 'sub MBOX_PORT_ID_USED () {0x4007;}' unless defined(&MBOX_PORT_ID_USED);
    eval 'sub MBOX_LOOP_ID_USED () {0x4008;}' unless defined(&MBOX_LOOP_ID_USED);
    eval 'sub MBOX_ALL_IDS_USED () {0x4009;}' unless defined(&MBOX_ALL_IDS_USED);
    eval 'sub MBOX_NOT_LOGGED_IN () {0x400a;}' unless defined(&MBOX_NOT_LOGGED_IN);
    eval 'sub MBLOGALL () {0x000f;}' unless defined(&MBLOGALL);
    eval 'sub MBLOGNONE () {0x0000;}' unless defined(&MBLOGNONE);
    eval 'sub MBLOGMASK {
        local($x) = @_;
	    eval q((($x) & 0xf));
    }' unless defined(&MBLOGMASK);
    eval 'sub ASYNC_BUS_RESET () {0x8001;}' unless defined(&ASYNC_BUS_RESET);
    eval 'sub ASYNC_SYSTEM_ERROR () {0x8002;}' unless defined(&ASYNC_SYSTEM_ERROR);
    eval 'sub ASYNC_RQS_XFER_ERR () {0x8003;}' unless defined(&ASYNC_RQS_XFER_ERR);
    eval 'sub ASYNC_RSP_XFER_ERR () {0x8004;}' unless defined(&ASYNC_RSP_XFER_ERR);
    eval 'sub ASYNC_QWAKEUP () {0x8005;}' unless defined(&ASYNC_QWAKEUP);
    eval 'sub ASYNC_TIMEOUT_RESET () {0x8006;}' unless defined(&ASYNC_TIMEOUT_RESET);
    eval 'sub ASYNC_DEVICE_RESET () {0x8007;}' unless defined(&ASYNC_DEVICE_RESET);
    eval 'sub ASYNC_EXTMSG_UNDERRUN () {0x800a;}' unless defined(&ASYNC_EXTMSG_UNDERRUN);
    eval 'sub ASYNC_SCAM_INT () {0x800b;}' unless defined(&ASYNC_SCAM_INT);
    eval 'sub ASYNC_HUNG_SCSI () {0x800c;}' unless defined(&ASYNC_HUNG_SCSI);
    eval 'sub ASYNC_KILLED_BUS () {0x800d;}' unless defined(&ASYNC_KILLED_BUS);
    eval 'sub ASYNC_BUS_TRANSIT () {0x800e;}' unless defined(&ASYNC_BUS_TRANSIT);
    eval 'sub ASYNC_LIP_OCCURRED () {0x8010;}' unless defined(&ASYNC_LIP_OCCURRED);
    eval 'sub ASYNC_LOOP_UP () {0x8011;}' unless defined(&ASYNC_LOOP_UP);
    eval 'sub ASYNC_LOOP_DOWN () {0x8012;}' unless defined(&ASYNC_LOOP_DOWN);
    eval 'sub ASYNC_LOOP_RESET () {0x8013;}' unless defined(&ASYNC_LOOP_RESET);
    eval 'sub ASYNC_PDB_CHANGED () {0x8014;}' unless defined(&ASYNC_PDB_CHANGED);
    eval 'sub ASYNC_CHANGE_NOTIFY () {0x8015;}' unless defined(&ASYNC_CHANGE_NOTIFY);
    eval 'sub ASYNC_LIP_F8 () {0x8016;}' unless defined(&ASYNC_LIP_F8);
    eval 'sub ASYNC_CMD_CMPLT () {0x8020;}' unless defined(&ASYNC_CMD_CMPLT);
    eval 'sub ASYNC_CTIO_DONE () {0x8021;}' unless defined(&ASYNC_CTIO_DONE);
    eval 'sub ASYNC_IP_XMIT_DONE () {0x8022;}' unless defined(&ASYNC_IP_XMIT_DONE);
    eval 'sub ASYNC_IP_RECV_DONE () {0x8023;}' unless defined(&ASYNC_IP_RECV_DONE);
    eval 'sub ASYNC_IP_BROADCAST () {0x8024;}' unless defined(&ASYNC_IP_BROADCAST);
    eval 'sub ASYNC_IP_RCVQ_LOW () {0x8025;}' unless defined(&ASYNC_IP_RCVQ_LOW);
    eval 'sub ASYNC_IP_RCVQ_EMPTY () {0x8026;}' unless defined(&ASYNC_IP_RCVQ_EMPTY);
    eval 'sub ASYNC_IP_RECV_DONE_ALIGNED () {0x8027;}' unless defined(&ASYNC_IP_RECV_DONE_ALIGNED);
    eval 'sub ASYNC_PTPMODE () {0x8030;}' unless defined(&ASYNC_PTPMODE);
    eval 'sub ASYNC_RIO1 () {0x8031;}' unless defined(&ASYNC_RIO1);
    eval 'sub ASYNC_RIO2 () {0x8032;}' unless defined(&ASYNC_RIO2);
    eval 'sub ASYNC_RIO3 () {0x8033;}' unless defined(&ASYNC_RIO3);
    eval 'sub ASYNC_RIO4 () {0x8034;}' unless defined(&ASYNC_RIO4);
    eval 'sub ASYNC_RIO5 () {0x8035;}' unless defined(&ASYNC_RIO5);
    eval 'sub ASYNC_CONNMODE () {0x8036;}' unless defined(&ASYNC_CONNMODE);
    eval 'sub ISP_CONN_LOOP () {1;}' unless defined(&ISP_CONN_LOOP);
    eval 'sub ISP_CONN_PTP () {2;}' unless defined(&ISP_CONN_PTP);
    eval 'sub ISP_CONN_BADLIP () {3;}' unless defined(&ISP_CONN_BADLIP);
    eval 'sub ISP_CONN_FATAL () {4;}' unless defined(&ISP_CONN_FATAL);
    eval 'sub ISP_CONN_LOOPBACK () {5;}' unless defined(&ISP_CONN_LOOPBACK);
    eval 'sub ASYNC_RIO_RESP () {0x8040;}' unless defined(&ASYNC_RIO_RESP);
    eval 'sub ASYNC_RIO_COMP () {0x8042;}' unless defined(&ASYNC_RIO_COMP);
    eval 'sub ASYNC_QFULL_SENT () {0x8049;}' unless defined(&ASYNC_QFULL_SENT);
    eval 'sub WRITE_REQUEST_QUEUE_IN_POINTER {
        local($isp, $value) = @_;
	    eval q( &ISP_WRITE($isp,  ($isp->{isp_rqstinrp}), $value));
    }' unless defined(&WRITE_REQUEST_QUEUE_IN_POINTER);
    eval 'sub READ_REQUEST_QUEUE_OUT_POINTER {
        local($isp) = @_;
	    eval q( &ISP_READ($isp,  ($isp->{isp_rqstoutrp})));
    }' unless defined(&READ_REQUEST_QUEUE_OUT_POINTER);
    eval 'sub READ_RESPONSE_QUEUE_IN_POINTER {
        local($isp) = @_;
	    eval q( &ISP_READ($isp,  ($isp->{isp_respinrp})));
    }' unless defined(&READ_RESPONSE_QUEUE_IN_POINTER);
    eval 'sub WRITE_RESPONSE_QUEUE_OUT_POINTER {
        local($isp, $value) = @_;
	    eval q( &ISP_WRITE($isp,  ($isp->{isp_respoutrp}), $value));
    }' unless defined(&WRITE_RESPONSE_QUEUE_OUT_POINTER);
    eval 'sub DSTYPE_32BIT () {0;}' unless defined(&DSTYPE_32BIT);
    eval 'sub DSTYPE_64BIT () {1;}' unless defined(&DSTYPE_64BIT);
    eval 'sub ISP_SWAP8 {
        local($a, $b) = @_;
	    eval q({  &u_int8_t  &tmp;  &tmp = $a; $a = $b; $b =  &tmp; });
    }' unless defined(&ISP_SWAP8);
    eval 'sub RQSFLAG_CONTINUATION () {0x01;}' unless defined(&RQSFLAG_CONTINUATION);
    eval 'sub RQSFLAG_FULL () {0x02;}' unless defined(&RQSFLAG_FULL);
    eval 'sub RQSFLAG_BADHEADER () {0x04;}' unless defined(&RQSFLAG_BADHEADER);
    eval 'sub RQSFLAG_BADPACKET () {0x08;}' unless defined(&RQSFLAG_BADPACKET);
    eval 'sub RQSTYPE_REQUEST () {0x01;}' unless defined(&RQSTYPE_REQUEST);
    eval 'sub RQSTYPE_DATASEG () {0x02;}' unless defined(&RQSTYPE_DATASEG);
    eval 'sub RQSTYPE_RESPONSE () {0x03;}' unless defined(&RQSTYPE_RESPONSE);
    eval 'sub RQSTYPE_MARKER () {0x04;}' unless defined(&RQSTYPE_MARKER);
    eval 'sub RQSTYPE_CMDONLY () {0x05;}' unless defined(&RQSTYPE_CMDONLY);
    eval 'sub RQSTYPE_ATIO () {0x06;}' unless defined(&RQSTYPE_ATIO);
    eval 'sub RQSTYPE_CTIO () {0x07;}' unless defined(&RQSTYPE_CTIO);
    eval 'sub RQSTYPE_SCAM () {0x08;}' unless defined(&RQSTYPE_SCAM);
    eval 'sub RQSTYPE_A64 () {0x09;}' unless defined(&RQSTYPE_A64);
    eval 'sub RQSTYPE_A64_CONT () {0x0a;}' unless defined(&RQSTYPE_A64_CONT);
    eval 'sub RQSTYPE_ENABLE_LUN () {0x0b;}' unless defined(&RQSTYPE_ENABLE_LUN);
    eval 'sub RQSTYPE_MODIFY_LUN () {0x0c;}' unless defined(&RQSTYPE_MODIFY_LUN);
    eval 'sub RQSTYPE_NOTIFY () {0x0d;}' unless defined(&RQSTYPE_NOTIFY);
    eval 'sub RQSTYPE_NOTIFY_ACK () {0x0e;}' unless defined(&RQSTYPE_NOTIFY_ACK);
    eval 'sub RQSTYPE_CTIO1 () {0x0f;}' unless defined(&RQSTYPE_CTIO1);
    eval 'sub RQSTYPE_STATUS_CONT () {0x10;}' unless defined(&RQSTYPE_STATUS_CONT);
    eval 'sub RQSTYPE_T2RQS () {0x11;}' unless defined(&RQSTYPE_T2RQS);
    eval 'sub RQSTYPE_IP_XMIT () {0x13;}' unless defined(&RQSTYPE_IP_XMIT);
    eval 'sub RQSTYPE_T4RQS () {0x15;}' unless defined(&RQSTYPE_T4RQS);
    eval 'sub RQSTYPE_ATIO2 () {0x16;}' unless defined(&RQSTYPE_ATIO2);
    eval 'sub RQSTYPE_CTIO2 () {0x17;}' unless defined(&RQSTYPE_CTIO2);
    eval 'sub RQSTYPE_CSET0 () {0x18;}' unless defined(&RQSTYPE_CSET0);
    eval 'sub RQSTYPE_T3RQS () {0x19;}' unless defined(&RQSTYPE_T3RQS);
    eval 'sub RQSTYPE_IP_XMIT_64 () {0x1b;}' unless defined(&RQSTYPE_IP_XMIT_64);
    eval 'sub RQSTYPE_CTIO4 () {0x1e;}' unless defined(&RQSTYPE_CTIO4);
    eval 'sub RQSTYPE_CTIO3 () {0x1f;}' unless defined(&RQSTYPE_CTIO3);
    eval 'sub RQSTYPE_RIO1 () {0x21;}' unless defined(&RQSTYPE_RIO1);
    eval 'sub RQSTYPE_RIO2 () {0x22;}' unless defined(&RQSTYPE_RIO2);
    eval 'sub RQSTYPE_IP_RECV () {0x23;}' unless defined(&RQSTYPE_IP_RECV);
    eval 'sub RQSTYPE_IP_RECV_CONT () {0x24;}' unless defined(&RQSTYPE_IP_RECV_CONT);
    eval 'sub ISP_RQDSEG () {4;}' unless defined(&ISP_RQDSEG);
    eval 'sub req_modifier () { &req_cdblen;}' unless defined(&req_modifier);
    eval 'sub SYNC_DEVICE () {0;}' unless defined(&SYNC_DEVICE);
    eval 'sub SYNC_TARGET () {1;}' unless defined(&SYNC_TARGET);
    eval 'sub SYNC_ALL () {2;}' unless defined(&SYNC_ALL);
    eval 'sub ISP_RQDSEG_T2 () {3;}' unless defined(&ISP_RQDSEG_T2);
    eval 'sub ISP_RQDSEG_T3 () {2;}' unless defined(&ISP_RQDSEG_T3);
    eval 'sub REQFLAG_NODISCON () {0x0001;}' unless defined(&REQFLAG_NODISCON);
    eval 'sub REQFLAG_HTAG () {0x0002;}' unless defined(&REQFLAG_HTAG);
    eval 'sub REQFLAG_OTAG () {0x0004;}' unless defined(&REQFLAG_OTAG);
    eval 'sub REQFLAG_STAG () {0x0008;}' unless defined(&REQFLAG_STAG);
    eval 'sub REQFLAG_TARGET_RTN () {0x0010;}' unless defined(&REQFLAG_TARGET_RTN);
    eval 'sub REQFLAG_NODATA () {0x0000;}' unless defined(&REQFLAG_NODATA);
    eval 'sub REQFLAG_DATA_IN () {0x0020;}' unless defined(&REQFLAG_DATA_IN);
    eval 'sub REQFLAG_DATA_OUT () {0x0040;}' unless defined(&REQFLAG_DATA_OUT);
    eval 'sub REQFLAG_DATA_UNKNOWN () {0x0060;}' unless defined(&REQFLAG_DATA_UNKNOWN);
    eval 'sub REQFLAG_DISARQ () {0x0100;}' unless defined(&REQFLAG_DISARQ);
    eval 'sub REQFLAG_FRC_ASYNC () {0x0200;}' unless defined(&REQFLAG_FRC_ASYNC);
    eval 'sub REQFLAG_FRC_SYNC () {0x0400;}' unless defined(&REQFLAG_FRC_SYNC);
    eval 'sub REQFLAG_FRC_WIDE () {0x0800;}' unless defined(&REQFLAG_FRC_WIDE);
    eval 'sub REQFLAG_NOPARITY () {0x1000;}' unless defined(&REQFLAG_NOPARITY);
    eval 'sub REQFLAG_STOPQ () {0x2000;}' unless defined(&REQFLAG_STOPQ);
    eval 'sub REQFLAG_XTRASNS () {0x4000;}' unless defined(&REQFLAG_XTRASNS);
    eval 'sub REQFLAG_PRIORITY () {0x8000;}' unless defined(&REQFLAG_PRIORITY);
    eval 'sub ISP_CDSEG () {7;}' unless defined(&ISP_CDSEG);
    eval 'sub ISP_CDSEG64 () {5;}' unless defined(&ISP_CDSEG64);
    eval 'sub req_response_len () { &req_time;}' unless defined(&req_response_len);
    eval 'sub RQCS_RU () {0x800;}' unless defined(&RQCS_RU);
    eval 'sub RQCS_RO () {0x400;}' unless defined(&RQCS_RO);
    eval 'sub RQCS_RESID () {( &RQCS_RU| &RQCS_RO);}' unless defined(&RQCS_RESID);
    eval 'sub RQCS_SV () {0x200;}' unless defined(&RQCS_SV);
    eval 'sub RQCS_RV () {0x100;}' unless defined(&RQCS_RV);
    eval 'sub RQCS_COMPLETE () {0x0000;}' unless defined(&RQCS_COMPLETE);
    eval 'sub RQCS_DMA_ERROR () {0x0002;}' unless defined(&RQCS_DMA_ERROR);
    eval 'sub RQCS_RESET_OCCURRED () {0x0004;}' unless defined(&RQCS_RESET_OCCURRED);
    eval 'sub RQCS_ABORTED () {0x0005;}' unless defined(&RQCS_ABORTED);
    eval 'sub RQCS_TIMEOUT () {0x0006;}' unless defined(&RQCS_TIMEOUT);
    eval 'sub RQCS_DATA_OVERRUN () {0x0007;}' unless defined(&RQCS_DATA_OVERRUN);
    eval 'sub RQCS_DATA_UNDERRUN () {0x0015;}' unless defined(&RQCS_DATA_UNDERRUN);
    eval 'sub RQCS_QUEUE_FULL () {0x001c;}' unless defined(&RQCS_QUEUE_FULL);
    eval 'sub RQCS_INCOMPLETE () {0x0001;}' unless defined(&RQCS_INCOMPLETE);
    eval 'sub RQCS_TRANSPORT_ERROR () {0x0003;}' unless defined(&RQCS_TRANSPORT_ERROR);
    eval 'sub RQCS_COMMAND_OVERRUN () {0x0008;}' unless defined(&RQCS_COMMAND_OVERRUN);
    eval 'sub RQCS_STATUS_OVERRUN () {0x0009;}' unless defined(&RQCS_STATUS_OVERRUN);
    eval 'sub RQCS_BAD_MESSAGE () {0x000a;}' unless defined(&RQCS_BAD_MESSAGE);
    eval 'sub RQCS_NO_MESSAGE_OUT () {0x000b;}' unless defined(&RQCS_NO_MESSAGE_OUT);
    eval 'sub RQCS_EXT_ID_FAILED () {0x000c;}' unless defined(&RQCS_EXT_ID_FAILED);
    eval 'sub RQCS_IDE_MSG_FAILED () {0x000d;}' unless defined(&RQCS_IDE_MSG_FAILED);
    eval 'sub RQCS_ABORT_MSG_FAILED () {0x000e;}' unless defined(&RQCS_ABORT_MSG_FAILED);
    eval 'sub RQCS_REJECT_MSG_FAILED () {0x000f;}' unless defined(&RQCS_REJECT_MSG_FAILED);
    eval 'sub RQCS_NOP_MSG_FAILED () {0x0010;}' unless defined(&RQCS_NOP_MSG_FAILED);
    eval 'sub RQCS_PARITY_ERROR_MSG_FAILED () {0x0011;}' unless defined(&RQCS_PARITY_ERROR_MSG_FAILED);
    eval 'sub RQCS_DEVICE_RESET_MSG_FAILED () {0x0012;}' unless defined(&RQCS_DEVICE_RESET_MSG_FAILED);
    eval 'sub RQCS_ID_MSG_FAILED () {0x0013;}' unless defined(&RQCS_ID_MSG_FAILED);
    eval 'sub RQCS_UNEXP_BUS_FREE () {0x0014;}' unless defined(&RQCS_UNEXP_BUS_FREE);
    eval 'sub RQCS_XACT_ERR1 () {0x0018;}' unless defined(&RQCS_XACT_ERR1);
    eval 'sub RQCS_XACT_ERR2 () {0x0019;}' unless defined(&RQCS_XACT_ERR2);
    eval 'sub RQCS_XACT_ERR3 () {0x001a;}' unless defined(&RQCS_XACT_ERR3);
    eval 'sub RQCS_BAD_ENTRY () {0x001b;}' unless defined(&RQCS_BAD_ENTRY);
    eval 'sub RQCS_PHASE_SKIPPED () {0x001d;}' unless defined(&RQCS_PHASE_SKIPPED);
    eval 'sub RQCS_ARQS_FAILED () {0x001e;}' unless defined(&RQCS_ARQS_FAILED);
    eval 'sub RQCS_WIDE_FAILED () {0x001f;}' unless defined(&RQCS_WIDE_FAILED);
    eval 'sub RQCS_SYNCXFER_FAILED () {0x0020;}' unless defined(&RQCS_SYNCXFER_FAILED);
    eval 'sub RQCS_LVD_BUSERR () {0x0021;}' unless defined(&RQCS_LVD_BUSERR);
    eval 'sub RQCS_PORT_UNAVAILABLE () {0x0028;}' unless defined(&RQCS_PORT_UNAVAILABLE);
    eval 'sub RQCS_PORT_LOGGED_OUT () {0x0029;}' unless defined(&RQCS_PORT_LOGGED_OUT);
    eval 'sub RQCS_PORT_CHANGED () {0x002a;}' unless defined(&RQCS_PORT_CHANGED);
    eval 'sub RQCS_PORT_BUSY () {0x002b;}' unless defined(&RQCS_PORT_BUSY);
    eval 'sub RQSF_GOT_BUS () {0x0100;}' unless defined(&RQSF_GOT_BUS);
    eval 'sub RQSF_GOT_TARGET () {0x0200;}' unless defined(&RQSF_GOT_TARGET);
    eval 'sub RQSF_SENT_CDB () {0x0400;}' unless defined(&RQSF_SENT_CDB);
    eval 'sub RQSF_XFRD_DATA () {0x0800;}' unless defined(&RQSF_XFRD_DATA);
    eval 'sub RQSF_GOT_STATUS () {0x1000;}' unless defined(&RQSF_GOT_STATUS);
    eval 'sub RQSF_GOT_SENSE () {0x2000;}' unless defined(&RQSF_GOT_SENSE);
    eval 'sub RQSF_XFER_COMPLETE () {0x4000;}' unless defined(&RQSF_XFER_COMPLETE);
    eval 'sub RQSF_DATA_IN () {0x0020;}' unless defined(&RQSF_DATA_IN);
    eval 'sub RQSF_DATA_OUT () {0x0040;}' unless defined(&RQSF_DATA_OUT);
    eval 'sub RQSF_STAG () {0x0008;}' unless defined(&RQSF_STAG);
    eval 'sub RQSF_OTAG () {0x0004;}' unless defined(&RQSF_OTAG);
    eval 'sub RQSF_HTAG () {0x0002;}' unless defined(&RQSF_HTAG);
    eval 'sub RQSTF_DISCONNECT () {0x0001;}' unless defined(&RQSTF_DISCONNECT);
    eval 'sub RQSTF_SYNCHRONOUS () {0x0002;}' unless defined(&RQSTF_SYNCHRONOUS);
    eval 'sub RQSTF_PARITY_ERROR () {0x0004;}' unless defined(&RQSTF_PARITY_ERROR);
    eval 'sub RQSTF_BUS_RESET () {0x0008;}' unless defined(&RQSTF_BUS_RESET);
    eval 'sub RQSTF_DEVICE_RESET () {0x0010;}' unless defined(&RQSTF_DEVICE_RESET);
    eval 'sub RQSTF_ABORTED () {0x0020;}' unless defined(&RQSTF_ABORTED);
    eval 'sub RQSTF_TIMEOUT () {0x0040;}' unless defined(&RQSTF_TIMEOUT);
    eval 'sub RQSTF_NEGOTIATION () {0x0080;}' unless defined(&RQSTF_NEGOTIATION);
    eval 'sub RQSTF_DMA_ERROR () {0x0080;}' unless defined(&RQSTF_DMA_ERROR);
    eval 'sub RQSTF_LOGOUT () {0x2000;}' unless defined(&RQSTF_LOGOUT);
    unless(defined(&ISP_EXEC_THROTTLE)) {
	eval 'sub ISP_EXEC_THROTTLE () {16;}' unless defined(&ISP_EXEC_THROTTLE);
    }
    eval 'sub ISP_FW_ATTR_TMODE () {0x01;}' unless defined(&ISP_FW_ATTR_TMODE);
    eval 'sub ISP_FW_ATTR_SCCLUN () {0x02;}' unless defined(&ISP_FW_ATTR_SCCLUN);
    eval 'sub ISP_FW_ATTR_FABRIC () {0x04;}' unless defined(&ISP_FW_ATTR_FABRIC);
    eval 'sub ISP_FW_ATTR_CLASS2 () {0x08;}' unless defined(&ISP_FW_ATTR_CLASS2);
    eval 'sub ISP_FW_ATTR_FCTAPE () {0x10;}' unless defined(&ISP_FW_ATTR_FCTAPE);
    eval 'sub ISP_FW_ATTR_IP () {0x20;}' unless defined(&ISP_FW_ATTR_IP);
    eval 'sub ICB_VERSION1 () {1;}' unless defined(&ICB_VERSION1);
    eval 'sub ICBOPT_HARD_ADDRESS () {0x0001;}' unless defined(&ICBOPT_HARD_ADDRESS);
    eval 'sub ICBOPT_FAIRNESS () {0x0002;}' unless defined(&ICBOPT_FAIRNESS);
    eval 'sub ICBOPT_FULL_DUPLEX () {0x0004;}' unless defined(&ICBOPT_FULL_DUPLEX);
    eval 'sub ICBOPT_FAST_POST () {0x0008;}' unless defined(&ICBOPT_FAST_POST);
    eval 'sub ICBOPT_TGT_ENABLE () {0x0010;}' unless defined(&ICBOPT_TGT_ENABLE);
    eval 'sub ICBOPT_INI_DISABLE () {0x0020;}' unless defined(&ICBOPT_INI_DISABLE);
    eval 'sub ICBOPT_INI_ADISC () {0x0040;}' unless defined(&ICBOPT_INI_ADISC);
    eval 'sub ICBOPT_INI_TGTTYPE () {0x0080;}' unless defined(&ICBOPT_INI_TGTTYPE);
    eval 'sub ICBOPT_PDBCHANGE_AE () {0x0100;}' unless defined(&ICBOPT_PDBCHANGE_AE);
    eval 'sub ICBOPT_NOLIP () {0x0200;}' unless defined(&ICBOPT_NOLIP);
    eval 'sub ICBOPT_SRCHDOWN () {0x0400;}' unless defined(&ICBOPT_SRCHDOWN);
    eval 'sub ICBOPT_PREVLOOP () {0x0800;}' unless defined(&ICBOPT_PREVLOOP);
    eval 'sub ICBOPT_STOP_ON_QFULL () {0x1000;}' unless defined(&ICBOPT_STOP_ON_QFULL);
    eval 'sub ICBOPT_FULL_LOGIN () {0x2000;}' unless defined(&ICBOPT_FULL_LOGIN);
    eval 'sub ICBOPT_BOTH_WWNS () {0x4000;}' unless defined(&ICBOPT_BOTH_WWNS);
    eval 'sub ICBOPT_EXTENDED () {0x8000;}' unless defined(&ICBOPT_EXTENDED);
    eval 'sub ICBXOPT_CLASS2_ACK0 () {0x0200;}' unless defined(&ICBXOPT_CLASS2_ACK0);
    eval 'sub ICBXOPT_CLASS2 () {0x0100;}' unless defined(&ICBXOPT_CLASS2);
    eval 'sub ICBXOPT_LOOP_ONLY () {(0<< 4);}' unless defined(&ICBXOPT_LOOP_ONLY);
    eval 'sub ICBXOPT_PTP_ONLY () {(1<< 4);}' unless defined(&ICBXOPT_PTP_ONLY);
    eval 'sub ICBXOPT_LOOP_2_PTP () {(2<< 4);}' unless defined(&ICBXOPT_LOOP_2_PTP);
    eval 'sub ICBXOPT_PTP_2_LOOP () {(3<< 4);}' unless defined(&ICBXOPT_PTP_2_LOOP);
    eval 'sub ICBXOPT_RIO_OFF () {0;}' unless defined(&ICBXOPT_RIO_OFF);
    eval 'sub ICBXOPT_RIO_16BIT () {1;}' unless defined(&ICBXOPT_RIO_16BIT);
    eval 'sub ICBXOPT_RIO_32BIT () {2;}' unless defined(&ICBXOPT_RIO_32BIT);
    eval 'sub ICBXOPT_RIO_16BIT_IOCB () {3;}' unless defined(&ICBXOPT_RIO_16BIT_IOCB);
    eval 'sub ICBXOPT_RIO_32BIT_IOCB () {4;}' unless defined(&ICBXOPT_RIO_32BIT_IOCB);
    eval 'sub ICBXOPT_ZIO () {5;}' unless defined(&ICBXOPT_ZIO);
    eval 'sub ICBZOPT_ENA_RDXFR_RDY () {0x01;}' unless defined(&ICBZOPT_ENA_RDXFR_RDY);
    eval 'sub ICBZOPT_ENA_OOF () {(1<< 6);}' unless defined(&ICBZOPT_ENA_OOF);
    eval 'sub ICBZOPT_RATE_ONEGB () {( &MBGSD_ONEGB << 14);}' unless defined(&ICBZOPT_RATE_ONEGB);
    eval 'sub ICBZOPT_RATE_TWOGB () {( &MBGSD_TWOGB << 14);}' unless defined(&ICBZOPT_RATE_TWOGB);
    eval 'sub ICBZOPT_RATE_AUTO () {( &MBGSD_AUTO << 14);}' unless defined(&ICBZOPT_RATE_AUTO);
    eval 'sub ICB_MIN_FRMLEN () {256;}' unless defined(&ICB_MIN_FRMLEN);
    eval 'sub ICB_MAX_FRMLEN () {2112;}' unless defined(&ICB_MAX_FRMLEN);
    eval 'sub ICB_DFLT_FRMLEN () {1024;}' unless defined(&ICB_DFLT_FRMLEN);
    eval 'sub ICB_DFLT_ALLOC () {256;}' unless defined(&ICB_DFLT_ALLOC);
    eval 'sub ICB_DFLT_THROTTLE () {16;}' unless defined(&ICB_DFLT_THROTTLE);
    eval 'sub ICB_DFLT_RDELAY () {5;}' unless defined(&ICB_DFLT_RDELAY);
    eval 'sub ICB_DFLT_RCOUNT () {3;}' unless defined(&ICB_DFLT_RCOUNT);
    eval 'sub RQRSP_ADDR0015 () {0;}' unless defined(&RQRSP_ADDR0015);
    eval 'sub RQRSP_ADDR1631 () {1;}' unless defined(&RQRSP_ADDR1631);
    eval 'sub RQRSP_ADDR3247 () {2;}' unless defined(&RQRSP_ADDR3247);
    eval 'sub RQRSP_ADDR4863 () {3;}' unless defined(&RQRSP_ADDR4863);
    eval 'sub ICB_NNM0 () {7;}' unless defined(&ICB_NNM0);
    eval 'sub ICB_NNM1 () {6;}' unless defined(&ICB_NNM1);
    eval 'sub ICB_NNM2 () {5;}' unless defined(&ICB_NNM2);
    eval 'sub ICB_NNM3 () {4;}' unless defined(&ICB_NNM3);
    eval 'sub ICB_NNM4 () {3;}' unless defined(&ICB_NNM4);
    eval 'sub ICB_NNM5 () {2;}' unless defined(&ICB_NNM5);
    eval 'sub ICB_NNM6 () {1;}' unless defined(&ICB_NNM6);
    eval 'sub ICB_NNM7 () {0;}' unless defined(&ICB_NNM7);
    eval 'sub MAKE_NODE_NAME_FROM_WWN {
        local($array, $wwn) = @_;
	    eval q($array->[ &ICB_NNM0] = (($wwn >> 0) & 0xff), $array->[ &ICB_NNM1] = (($wwn >> 8) & 0xff), $array->[ &ICB_NNM2] = (($wwn >> 16) & 0xff), $array->[ &ICB_NNM3] = (($wwn >> 24) & 0xff), $array->[ &ICB_NNM4] = (($wwn >> 32) & 0xff), $array->[ &ICB_NNM5] = (($wwn >> 40) & 0xff), $array->[ &ICB_NNM6] = (($wwn >> 48) & 0xff), $array->[ &ICB_NNM7] = (($wwn >> 56) & 0xff));
    }' unless defined(&MAKE_NODE_NAME_FROM_WWN);
    eval 'sub BITS2WORD {
        local($x) = @_;
	    eval q((($x)[0] << 16| ($x)[3] << 8| ($x)[2]));
    }' unless defined(&BITS2WORD);
    eval 'sub PDB_OPTIONS_XMITTING () {(1<<11);}' unless defined(&PDB_OPTIONS_XMITTING);
    eval 'sub PDB_OPTIONS_LNKXMIT () {(1<<10);}' unless defined(&PDB_OPTIONS_LNKXMIT);
    eval 'sub PDB_OPTIONS_ABORTED () {(1<<9);}' unless defined(&PDB_OPTIONS_ABORTED);
    eval 'sub PDB_OPTIONS_ADISC () {(1<<1);}' unless defined(&PDB_OPTIONS_ADISC);
    eval 'sub PDB_STATE_DISCOVERY () {0;}' unless defined(&PDB_STATE_DISCOVERY);
    eval 'sub PDB_STATE_WDISC_ACK () {1;}' unless defined(&PDB_STATE_WDISC_ACK);
    eval 'sub PDB_STATE_PLOGI () {2;}' unless defined(&PDB_STATE_PLOGI);
    eval 'sub PDB_STATE_PLOGI_ACK () {3;}' unless defined(&PDB_STATE_PLOGI_ACK);
    eval 'sub PDB_STATE_PRLI () {4;}' unless defined(&PDB_STATE_PRLI);
    eval 'sub PDB_STATE_PRLI_ACK () {5;}' unless defined(&PDB_STATE_PRLI_ACK);
    eval 'sub PDB_STATE_LOGGED_IN () {6;}' unless defined(&PDB_STATE_LOGGED_IN);
    eval 'sub PDB_STATE_PORT_UNAVAIL () {7;}' unless defined(&PDB_STATE_PORT_UNAVAIL);
    eval 'sub PDB_STATE_PRLO () {8;}' unless defined(&PDB_STATE_PRLO);
    eval 'sub PDB_STATE_PRLO_ACK () {9;}' unless defined(&PDB_STATE_PRLO_ACK);
    eval 'sub PDB_STATE_PLOGO () {10;}' unless defined(&PDB_STATE_PLOGO);
    eval 'sub PDB_STATE_PLOG_ACK () {11;}' unless defined(&PDB_STATE_PLOG_ACK);
    eval 'sub SVC3_TGT_ROLE () {0x10;}' unless defined(&SVC3_TGT_ROLE);
    eval 'sub SVC3_INI_ROLE () {0x20;}' unless defined(&SVC3_INI_ROLE);
    eval 'sub SVC3_ROLE_MASK () {0x30;}' unless defined(&SVC3_ROLE_MASK);
    eval 'sub SVC3_ROLE_SHIFT () {4;}' unless defined(&SVC3_ROLE_SHIFT);
    eval 'sub FS_ACC () {0x8002;}' unless defined(&FS_ACC);
    eval 'sub FS_RJT () {0x8001;}' unless defined(&FS_RJT);
    eval 'sub FC4_IP () {5;}' unless defined(&FC4_IP);
    eval 'sub FC4_SCSI () {8;}' unless defined(&FC4_SCSI);
    eval 'sub FC4_FC_SVC () {0x20;}' unless defined(&FC4_FC_SVC);
    eval 'sub SNS_GA_NXT () {0x100;}' unless defined(&SNS_GA_NXT);
    eval 'sub SNS_GPN_ID () {0x112;}' unless defined(&SNS_GPN_ID);
    eval 'sub SNS_GNN_ID () {0x113;}' unless defined(&SNS_GNN_ID);
    eval 'sub SNS_GFF_ID () {0x11f;}' unless defined(&SNS_GFF_ID);
    eval 'sub SNS_GID_FT () {0x171;}' unless defined(&SNS_GID_FT);
    eval 'sub SNS_RFT_ID () {0x217;}' unless defined(&SNS_RFT_ID);
    eval 'sub SNS_GA_NXT_REQ_SIZE () {($sizeof{ &sns_ga_nxt_req_t});}' unless defined(&SNS_GA_NXT_REQ_SIZE);
    eval 'sub SNS_GXN_ID_REQ_SIZE () {($sizeof{ &sns_gxn_id_req_t});}' unless defined(&SNS_GXN_ID_REQ_SIZE);
    eval 'sub SNS_GID_FT_REQ_SIZE () {($sizeof{ &sns_gid_ft_req_t});}' unless defined(&SNS_GID_FT_REQ_SIZE);
    eval 'sub SNS_RFT_ID_REQ_SIZE () {($sizeof{ &sns_rft_id_req_t});}' unless defined(&SNS_RFT_ID_REQ_SIZE);
    eval 'sub SNS_GA_NXT_RESP_SIZE () {($sizeof{ &sns_ga_nxt_rsp_t});}' unless defined(&SNS_GA_NXT_RESP_SIZE);
    eval 'sub SNS_GXN_ID_RESP_SIZE () {($sizeof{ &sns_gxn_id_rsp_t});}' unless defined(&SNS_GXN_ID_RESP_SIZE);
    eval 'sub SNS_GFF_ID_RESP_SIZE () {($sizeof{ &sns_gff_id_rsp_t});}' unless defined(&SNS_GFF_ID_RESP_SIZE);
    eval 'sub SNS_GID_FT_RESP_SIZE {
        local($x) = @_;
	    eval q((($sizeof{ &sns_gid_ft_rsp_t}) + (($x - 1) << 2)));
    }' unless defined(&SNS_GID_FT_RESP_SIZE);
    eval 'sub SNS_RFT_ID_RESP_SIZE () {($sizeof{ &ct_hdr_t});}' unless defined(&SNS_RFT_ID_RESP_SIZE);
}
1;
