require '_h2ph_pre.ph';

require 'sys/select.ph';
require 'sys/queue.ph';
unless(defined(&SB_MAX)) {
    sub SB_MAX () {	(256*1024);}
}
unless(defined(&SB_LOCK)) {
    sub SB_LOCK () {	0x01;}
}
unless(defined(&SB_WANT)) {
    sub SB_WANT () {	0x02;}
}
unless(defined(&SB_WAIT)) {
    sub SB_WAIT () {	0x04;}
}
unless(defined(&SB_SEL)) {
    sub SB_SEL () {	0x08;}
}
unless(defined(&SB_ASYNC)) {
    sub SB_ASYNC () {	0x10;}
}
unless(defined(&SB_NOINTR)) {
    sub SB_NOINTR () {	0x40;}
}
unless(defined(&SB_KNOTE)) {
    sub SB_KNOTE () {	0x80;}
}
unless(defined(&SS_NOFDREF)) {
    sub SS_NOFDREF () {	0x001;}
}
unless(defined(&SS_ISCONNECTED)) {
    sub SS_ISCONNECTED () {	0x002;}
}
unless(defined(&SS_ISCONNECTING)) {
    sub SS_ISCONNECTING () {	0x004;}
}
unless(defined(&SS_ISDISCONNECTING)) {
    sub SS_ISDISCONNECTING () {	0x008;}
}
unless(defined(&SS_CANTSENDMORE)) {
    sub SS_CANTSENDMORE () {	0x010;}
}
unless(defined(&SS_CANTRCVMORE)) {
    sub SS_CANTRCVMORE () {	0x020;}
}
unless(defined(&SS_RCVATMARK)) {
    sub SS_RCVATMARK () {	0x040;}
}
unless(defined(&SS_ISDISCONNECTED)) {
    sub SS_ISDISCONNECTED () {	0x800;}
}
unless(defined(&SS_PRIV)) {
    sub SS_PRIV () {	0x080;}
}
unless(defined(&SS_NBIO)) {
    sub SS_NBIO () {	0x100;}
}
unless(defined(&SS_ASYNC)) {
    sub SS_ASYNC () {	0x200;}
}
unless(defined(&SS_ISCONFIRMING)) {
    sub SS_ISCONFIRMING () {	0x400;}
}
unless(defined(&SS_CONNECTOUT)) {
    sub SS_CONNECTOUT () {	0x1000;}
}
unless(defined(&sb_notify)) {
    sub sb_notify {
	local($sb) = @_;
	eval q(((($sb)-> &sb_flags & ( &SB_WAIT| &SB_SEL| &SB_ASYNC|  &SB_KNOTE)) != 0));
    }
}
unless(defined(&sbspace)) {
    sub sbspace {
	local($sb) = @_;
	eval q((  &imin((-> &sb_hiwat - -> &sb_cc), (($sb)-> &sb_mbmax - ($sb)-> &sb_mbcnt))));
    }
}
unless(defined(&sosendallatonce)) {
    sub sosendallatonce {
	local($so) = @_;
	eval q((($so)-> ($so_proto->{pr_flags}) &  &PR_ATOMIC));
    }
}
unless(defined(&soreadable)) {
    sub soreadable {
	local($so) = @_;
	eval q((($so)-> ($so_rcv->{sb_cc}) >= ($so)-> ($so_rcv->{sb_lowat}) || (($so)-> &so_state &  &SS_CANTRCVMORE) || ($so)-> &so_qlen || ($so)-> &so_error));
    }
}
unless(defined(&sowriteable)) {
    sub sowriteable {
	local($so) = @_;
	eval q((( &sbspace(($so)-> &so_snd) >= ($so)-> ($so_snd->{sb_lowat})  && ((($so)-> &so_state &SS_ISCONNECTED) || (($so)-> ($so_proto->{pr_flags})& &PR_CONNREQUIRED)==0)) || (($so)-> &so_state &  &SS_CANTSENDMORE) || ($so)-> &so_error));
    }
}
unless(defined(&sballoc)) {
    sub sballoc {
	local($sb, $m) = @_;
	eval q({ ($sb)-> &sb_cc += ($m)-> &m_len; ($sb)-> &sb_mbcnt +=  &MSIZE;  &if (($m)-> &m_flags &  &M_EXT) ($sb)-> &sb_mbcnt += ($m)-> ($m_ext->{ext_size}); });
    }
}
unless(defined(&sbfree)) {
    sub sbfree {
	local($sb, $m) = @_;
	eval q({ ($sb)-> &sb_cc -= ($m)-> &m_len; ($sb)-> &sb_mbcnt -=  &MSIZE;  &if (($m)-> &m_flags &  &M_EXT) ($sb)-> &sb_mbcnt -= ($m)-> ($m_ext->{ext_size}); });
    }
}
unless(defined(&sblock)) {
    sub sblock {
	local($sb, $wf) = @_;
	eval q((($sb)-> &sb_flags &  &SB_LOCK ? ((($wf) ==  &M_WAITOK) ?  &sb_lock($sb) :  &EWOULDBLOCK) : (($sb)-> &sb_flags |=  &SB_LOCK), 0));
    }
}
unless(defined(&sbunlock)) {
    sub sbunlock {
	local($sb) = @_;
	eval q({ ($sb)-> &sb_flags &= ~ &SB_LOCK;  &if (($sb)-> &sb_flags &  &SB_WANT) { ($sb)-> &sb_flags &= ~ &SB_WANT;  &wakeup(($sb)-> &sb_flags); } });
    }
}
unless(defined(&sorwakeup)) {
    sub sorwakeup {
	local($so) = @_;
	eval q({  &sowakeup(($so), ($so)-> &so_rcv);  &if (($so)-> &so_upcall) (*(($so)-> &so_upcall))(($so), ($so)-> &so_upcallarg,  &M_DONTWAIT); });
    }
}
unless(defined(&sowwakeup)) {
    sub sowwakeup {
	local($so) = @_;
	eval q( &sowakeup(($so), ($so)-> &so_snd));
    }
}
if(defined(&_KERNEL)) {
}
1;
