require '_h2ph_pre.ph';

require 'sys/param.ph';
require 'sys/systm.ph';
require 'sys/mbuf.ph';
require 'sys/protosw.ph';
require 'sys/socket.ph';
require 'sys/ioctl.ph';
require 'sys/errno.ph';
require 'sys/malloc.ph';
require 'sys/kernel.ph';
require 'sys/proc.ph';
require 'sys/device.ph';
require 'sys/timeout.ph';
require 'net/if.ph';
require 'net/if_dl.ph';
require 'net/if_types.ph';
require 'net/if_media.ph';
if(defined(&INET)) {
    require 'netinet/in.ph';
    require 'netinet/in_systm.ph';
    require 'netinet/in_var.ph';
    require 'netinet/ip.ph';
    require 'netinet/if_ether.ph';
}
if(defined(&NS)) {
    require 'netns/ns.ph';
    require 'netns/ns_if.ph';
}
require 'bpfilter.ph';
if((defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
    require 'net/bpf.ph';
    require 'net/bpfdesc.ph';
}
require 'uvm/uvm_extern.ph';
require 'machine/bus.ph';
require 'machine/intr.ph';
require 'dev/pci/pcireg.ph';
require 'dev/pci/pcivar.ph';
require 'dev/pci/pcidevs.ph';
require 'dev/pci/if_wxreg.ph';
require 'dev/mii/mii.ph';
require 'dev/mii/miivar.ph';
unless(defined(&wx_dev)) {
    sub wx_dev () {	 ($w->{dev});}
}
unless(defined(&wx_enaddr)) {
    sub wx_enaddr () {	 ($w->{arpcom}->{ac_enaddr});}
}
unless(defined(&wx_cmdw)) {
    sub wx_cmdw () {	 ($w->{cmdw});}
}
unless(defined(&wx_media)) {
    sub wx_media () {	 ($w->{ifm});}
}
unless(defined(&wx_tmo)) {
    sub wx_tmo () {	 ($w->{tmo});}
}
unless(defined(&wx_if)) {
    sub wx_if () {	 ($w->{arpcom}->{ac_if});}
}
unless(defined(&wx_name)) {
    sub wx_name () {	 ($w->{dev}->{dv_xname});}
}
unless(defined(&IOCTL_CMD_TYPE)) {
    sub IOCTL_CMD_TYPE () {	'u_long';}
}
unless(defined(&WXMALLOC)) {
    sub WXMALLOC {
	local($len) = @_;
	eval q( &malloc($len,  &M_DEVBUF,  &M_NOWAIT));
    }
}
unless(defined(&WXFREE)) {
    sub WXFREE {
	local($ptr) = @_;
	eval q( &free($ptr,  &M_DEVBUF));
    }
}
unless(defined(&SOFTC_IFP)) {
    sub SOFTC_IFP {
	local($ifp) = @_;
	eval q( ($ifp->{if_softc}));
    }
}
unless(defined(&WX_BPFTAP_ARG)) {
    sub WX_BPFTAP_ARG {
	local($ifp) = @_;
	eval q(($ifp)-> &if_bpf);
    }
}
unless(defined(&TIMEOUT)) {
    sub TIMEOUT {
	local($sc, $func, $arg, $time) = @_;
	eval q( &VTIMEOUT($sc, $func, $arg, $time));
    }
}
unless(defined(&VTIMEOUT)) {
    sub VTIMEOUT {
	local($sc, $func, $arg, $time) = @_;
	eval q({ &timeout_set(($sc)-> &wx_tmo, $func, $arg);  &timeout_add(($sc)-> &wx_tmo, $time);});
    }
}
unless(defined(&UNTIMEOUT)) {
    sub UNTIMEOUT {
	local($f, $arg, $sc) = @_;
	eval q( &timeout_del(($sc)-> &wx_tmo));
    }
}
unless(defined(&INLINE)) {
    sub INLINE () {	 &inline;}
}
unless(defined(&WX_LOCK)) {
    sub WX_LOCK {
	local($wx) = @_;
	eval q( &if ( ($wx->{w}->{locked})++ == 0)  ($wx->{w}->{spl}) =  &splimp());
    }
}
unless(defined(&WX_UNLOCK)) {
    sub WX_UNLOCK {
	local($wx) = @_;
	eval q( &if ( ($wx->{w}->{locked})) {  &if (-- ($wx->{w}->{locked}) == 0)  &splx( ($wx->{w}->{spl})); });
    }
}
unless(defined(&WX_ILOCK)) {
    sub WX_ILOCK {
	local($_sc) = @_;
	eval q();
    }
}
unless(defined(&WX_IUNLK)) {
    sub WX_IUNLK {
	local($_sc) = @_;
	eval q();
    }
}
unless(defined(&WX_SOFTC_FROM_MII_ARG)) {
    sub WX_SOFTC_FROM_MII_ARG {
	local($x) = @_;
	eval q( $x);
    }
}
unless(defined(&WX_MII_FROM_SOFTC)) {
    sub WX_MII_FROM_SOFTC {
	local($x) = @_;
	eval q(( ($x->{w}->{mii_data})));
    }
}
unless(defined(&vm_offset_t)) {
    sub vm_offset_t () {	 &vaddr_t;}
}
unless(defined(&READ_CSR)) {
    sub READ_CSR () {	 &_read_csr;}
}
unless(defined(&WRITE_CSR)) {
    sub WRITE_CSR () {	 &_write_csr;}
}
unless(defined(&WX_RX_OFFSET_VALUE)) {
    sub WX_RX_OFFSET_VALUE () {	2;}
}
unless(defined(&WX_MAX_TDESC)) {
    sub WX_MAX_TDESC () {	256;}
}
unless(defined(&T_NXT_IDX)) {
    sub T_NXT_IDX {
	local($x) = @_;
	eval q((($x + 1) & ( &WX_MAX_TDESC - 1)));
    }
}
unless(defined(&T_PREV_IDX)) {
    sub T_PREV_IDX {
	local($x) = @_;
	eval q((($x - 1) & ( &WX_MAX_TDESC - 1)));
    }
}
unless(defined(&WX_MAX_RDESC)) {
    sub WX_MAX_RDESC () {	256;}
}
if(defined(&PADDED_CELL)) {
    eval 'sub RXINCR () {2;}' unless defined(&RXINCR);
} else {
    eval 'sub RXINCR () {1;}' unless defined(&RXINCR);
}
unless(defined(&R_NXT_IDX)) {
    sub R_NXT_IDX {
	local($x) = @_;
	eval q((($x +  &RXINCR) & ( &WX_MAX_RDESC - 1)));
    }
}
unless(defined(&R_PREV_IDX)) {
    sub R_PREV_IDX {
	local($x) = @_;
	eval q((($x -  &RXINCR) & ( &WX_MAX_RDESC - 1)));
    }
}
unless(defined(&WX_LINK_UP_TIMEOUT)) {
    sub WX_LINK_UP_TIMEOUT () {	500;}
}
1;
