#!/usr/bin/perl
#  txn-list.pl - Graphs running balance.
#
#  Modified by Arlindo L. Oliveira (aml@inesc.pt)
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: txn-list.pl,v 2.6 1997/05/06 02:33:52 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;    # don't take no guff

my($tmp, $temp, $cbb_incl_dir);
my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my($credit_total, $debit_total, $amt, $lkey, $lcat, $subtotal);
my($tcom, $tamt, $tcat, $trans, $remaining, $gtotal);
my(@keys, %ALLTRANS, @splits);
my($graphpath, $account, $name, $result);


# return the directory of a file name (this is duplicated in common.pl
# but we need this to find the include directory for common.pl :-(
sub my_file_dirname {
    my($file) = @_;
    my($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
	return substr($file, 0, ($pos + 1));
    } else { 
	return "./"; 
    }
}

# specify the installed location of the necessary pieces.
$temp = &my_file_dirname($0); chop($temp);
$cbb_incl_dir = &my_file_dirname($temp);
# print "$cbb_incl_dir\n";
unshift(@INC, $cbb_incl_dir);

$graphpath = "/usr/ports/misc/cbb/work/fake-sparc/usr/local/share/cbb/graphs";

require "flush.pl";

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

my($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";


%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $trans) = split(/\t/, $result, 2);
	($date, $remaining) = split(/\t/, $trans, 2);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {
            $ALLTRANS{"$key$name"} = $trans;
        }

        $result = &next_trans();
    }
}


# sort and print

if ( ! -x "$graphpath/graphbal") {
    die "Cannot launch $graphpath/graphbal\n";
}

open(DATA, "| $graphpath/graphbal") || die "Cannot launch graph\n";

$gtotal = 0.00;

foreach $key (sort (keys %ALLTRANS) ) {
    # print $ALLTRANS{$key} . "\n";
    ($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total) =
	split(/\t/, $ALLTRANS{$key});

#    $gtotal += $credit - $debit;

    print DATA "$date $total\n";
}

close(DATA);


# ----------------------------------------------------------------------------
# $Log: txn-list.pl,v $
# Revision 2.6  1997/05/06 02:33:52  curt
# Added "require memorized".
#
# Revision 2.5  1997/05/06 02:06:20  curt
# Added patches by Ken Latta <ken@kdl.sc.scruznet.comt> to fix problems
# with the running balance graph.
#
# Revision 2.4  1997/01/28 03:25:42  curt
# Force strict scoping in all perl scripts.
#
# Revision 2.3  1996/12/13 01:25:21  curt
# Updated paths, modified to work with reports.tcl
#
# Revision 2.2  1996/07/13 02:58:37  curt
# Misc. changes.
#
# Revision 2.1  1996/02/27  05:36:16  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:25  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
