plot.ts                 package:base                 R Documentation

_P_l_o_t_t_i_n_g _T_i_m_e-_S_e_r_i_e_s _O_b_j_e_c_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plotting methods for objects of class `"ts"' or `"mts"'
     (multivariate time-series).

_U_s_a_g_e:

     plot(x, y = NULL, type = "l", xlim = NULL, ylim = NULL,
          xlab = "Time", ylab, log = "",
          col = par("col"), bg = NA, pch = par("pch"), cex = par("cex"),
          lty = par("lty"), lwd = par("lwd"),
          axes = TRUE, frame.plot = axes, ann = par("ann"),
          main = NULL, plot.type = c("multiple", "single"),
          xy.labels = n <= 150, xy.lines = do.lab, ...)

     lines(x, ...)

_A_r_g_u_m_e_n_t_s:

     x,y: time series objects, usually of class `"ts"'.

    type: the type of plot, see `plot'.  When `y' is present, the
          default will depend on `xy.labels', see below.

plot.type: for multivariate time series, should the series by plotted
          separately (with a common time axis) or on a single plot?

xy.labels: logical, indicating if `text()' labels should be used for an
          x-y plot.

xy.lines: logical, indicating if `lines' should be drawn for an x-y
          plot.  Default is true, when labels are drawn as well.

     ...: additional graphical arguments, see `plot', `plot.default'
          and `par'.

_D_e_t_a_i_l_s:

     With one prinicipal argument, these functions create time series
     plots, for multivariate series of two kinds depending on
     `plot.type',

     If `y' is present, both `x' and `y' must be univariate, and a
     ``scatter'' plot `y ~ x' will be drawn, enhanced by using `text'
     if `xy.labels' is `TRUE' or `character', and `lines' if `xy.lines'
     is `TRUE'.

_S_e_e _A_l_s_o:

     `ts' for basic time series construction and access functionality.

_E_x_a_m_p_l_e_s:

     ## Multivariate
     z <- ts(matrix(rt(300, df = 3), 100, 3), start=c(1961, 1), frequency=12)
     plot(z)# multiple
     plot(z, plot.type="single", lty=1:3)

     ## A phase plot:
     data(nhtemp)
     plot(nhtemp, c(nhtemp[-1], NA), cex = .8, col="blue",
          main = "Lag plot of New Haven temperatures")
     ## a clearer way to do this would be
     library(ts)
     plot(nhtemp, lag(nhtemp, 1), cex = .8, col="blue",
          main = "Lag plot of New Haven temperatures")


     library(ts)

     data(sunspots)
     ## xy.lines and xy.labels are FALSE for large series:
     plot(lag(sunspots, 1), sunspots, pch = ".")

     data(EuStockMarkets)
     SMI <- EuStockMarkets[, "SMI"]
     plot(lag(SMI,  1), SMI, pch = ".")
     plot(lag(SMI, 20), SMI, pch = ".", log = "xy",
          main = "4 weeks lagged SMI stocks -- log scale", xy.lines= TRUE)

     detach("package:ts") 

