.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_DATABASE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
DROP DATABASE \- Removes an existing database
.SH SYNOPSIS
.sp
.nf
DROP DATABASE \fIname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing database to remove.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP DATABASE\fR
This message is returned if the command is successful.
.TP
\fBERROR: user '\fIusername\fB' is not allowed to create/drop databases\fR
You must have the special CREATEDB privilege to drop databases.
See \fBcreate_user\fR(l).
.TP
\fBERROR: dropdb: cannot be executed on the template database\fR
The template1 database cannot be removed. It's not in
your interest.
.TP
\fBERROR: dropdb: cannot be executed on an open database\fR
You cannot be connected to the the database your are about to remove.
Instead, you could connect to template1 or any other
database and run this command again.
.TP
\fBERROR: dropdb: database '\fIname\fB' does not exist\fR
This message occurs if the specified database does not exist.
.TP
\fBERROR: dropdb: database '\fIname\fB' is not owned by you\fR
You must be the owner of the database. Being the owner usually means that
you created it as well.
.TP
\fBERROR: dropdb: May not be called in a transaction block.\fR
You must finish the transaction in progress before you can call this command.
.TP
\fBNOTICE: The database directory 'xxx' could not be removed.\fR
The database was dropped (unless other error messages came up), but the
directory where the data is stored could not be removed. You must delete
it manually.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP DATABASE\fR removes the catalog entries for an existing
database and deletes the directory containing the data.
It can only be executed by the database owner (usually the user that created
it).
.SS "NOTES"
.PP
This command cannot be executed while connected to the target
database. Thus, it might be more convenient to use the shell
script \fBdropdb\fR(1),
which is a wrapper around this command, instead.
.PP
Refer to
\fBcreate_database\fR(l)
for information on how to create a database.
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBDROP DATABASE\fR statement is a
Postgres language extension;
there is no such command in SQL92.
