.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "COMMENT" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
COMMENT \- Add comment to an object
.SH SYNOPSIS
.sp
.nf
COMMENT ON
[
  [ DATABASE | INDEX | RULE | SEQUENCE | TABLE | TYPE | VIEW ]
  \fIobject_name\fR |
  COLUMN \fItable_name\fR.\fIcolumn_name\fR|
  AGGREGATE \fIagg_name\fR \fIagg_type\fR|
  FUNCTION \fIfunc_name\fR (\fIarg1\fR, \fIarg2\fR, ...)|
  OPERATOR \fIop\fR (\fIleftoperand_type\fR \fIrightoperand_type\fR) |
  TRIGGER \fItrigger_name\fR ON \fItable_name\fR
] IS \fI'text'\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIobject_name, table_name,\fR
The name of the object to be be commented.
.TP
\fB\fItext\fB\fR
The comment to add.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCOMMENT\fR
Message returned if the table is successfully commented.
.PP
.SH "DESCRIPTION"
.PP
\fBCOMMENT\fR adds a comment to an object that can be 
easily retrieved with \fBpsql's\fR
\fB\\dd\fR command.
To remove a comment, use NULL.
Comments are automatically dropped when the object is dropped.
.SH "USAGE"
.PP
Comment the table mytable:
.sp
.nf
COMMENT ON mytable IS 'This is my table.';
   
.sp
.fi
.PP
Some more examples:
.sp
.nf
COMMENT ON DATABASE my_database IS 'Development Database';
COMMENT ON INDEX my_index IS 'Enforces uniqueness on employee id';
COMMENT ON RULE my_rule IS 'Logs UPDATES of employee records';
COMMENT ON SEQUENCE my_sequence IS 'Used to generate primary keys';
COMMENT ON TABLE my_table IS 'Employee Information';
COMMENT ON TYPE my_type IS 'Complex Number support';
COMMENT ON VIEW my_view IS 'View of departmental costs';
COMMENT ON COLUMN my_table.my_field IS 'Employee ID number';
COMMENT ON AGGREGATE my_aggregate float8 IS 'Computes sample variance';
COMMENT ON FUNCTION my_function (datetime) IS 'Returns Roman Numeral';
COMMENT ON OPERATOR ^ (text, text) IS 'Performs intersection of two text';
COMMENT ON TRIGGER my_trigger ON my_table IS 'Used for R.I.';
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCOMMENT\fR in SQL92.
