/* src/rep.h.  Generated automatically by configure.  */
/* rep.h.in -- Public include file, brings in all the rest
   Copyright (C) 1993, 1994 John Harper <john@dcs.warwick.ac.uk>
   $Id: rep.h.in,v 1.7 2000/05/18 17:21:12 john Exp $

   This file is part of Jade.

   Jade is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Jade is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jade; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef REP_H
#define REP_H

#include <sys/types.h>
#include <limits.h>

typedef int rep_bool;
#define rep_TRUE 1
#define rep_FALSE 0

#ifndef NULL
#define NULL 0
#endif


/* configure defs needed by library callers */

/* Version number */
#define rep_VERSION "0.12.4"

/* libtool interface revision number */
#define rep_INTERFACE 9

/* Define if you have some flavour of Unix */
#define rep_HAVE_UNIX 1

/* An implicitly signed integer type, that a pointer can be cast to and
   from without dropping bits */
#define rep_PTR_SIZED_INT int

/* This is either L or LL -- the suffix to append to integer constants
   of the above type */
#define rep_PTR_SIZED_INT_SUFFIX L

/* A string, the printf integer conversion of the above integer type,
   i.e. "" for int, "l" for long, "ll" for long long */
#define rep_PTR_SIZED_INT_CONV ""

/* The number of bytes in the above type. */
#define rep_PTR_SIZED_INT_SIZEOF 4
#define rep_PTR_SIZED_INT_BITS (rep_PTR_SIZED_INT_SIZEOF * CHAR_BIT)

/* The minimum alignment of memory allocated by malloc(). The default of
   four should be ok for most systems? */
#define rep_MALLOC_ALIGNMENT 4

/* Defined if `long long int' is available */
#define rep_HAVE_LONG_LONG 1

#ifdef rep_HAVE_LONG_LONG
# define rep_long_long long long
#else
# define rep_long_long long
#endif


/* Other public includes */

#include "rep_lisp.h"
#include "rep_regexp.h"
#include "rep_subrs.h"

#endif /* REP_H */
