// -*- c++ -*-
//  Generated by gtkmmproc from ./../text.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_TEXT_H
#define _GTKMM_TEXT_H

/* $Id: text.gen_h,v 1.58 2000/03/02 19:34:08 kenelson Exp $ */

/* text.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/editable.h>
#include <gtk--/adjustment.h>
#include <gtk/gtktext.h>

namespace Gtk {
class Text;
class Text_Class;
}
namespace Gtk { Gtk::Text *wrap (GtkText *o); }
extern "C" void gtk_text_set_scroll_adjustments(GtkText*,GtkAdjustment* p1,GtkAdjustment* p2);
namespace Gtk
{

namespace Text_Helpers {
class Context
  {
      bool is_fore_;
      bool is_back_;
      bool is_font_;
      Gdk_Color fore_;
      Gdk_Color back_;
      Gdk_Font  font_;
    public:
      GdkColor* gtkfore() const
        { return (is_fore_)?const_cast<GdkColor*>(fore_.gdkobj()):0; }
      GdkColor* gtkback() const
        { return (is_back_)?const_cast<GdkColor*>(back_.gdkobj()):0; }
      GdkFont* gtkfont()  const
        { return (is_font_)?font_.gdkobj():0; }

      void set_foreground() {is_fore_=false;}
      void set_background() {is_back_=false;}
      void set_font()       {is_font_=false; font_=0;}
      void set_foreground(const Gdk_Color& color)
        { is_fore_=true;  fore_=color; }
      void set_background(const Gdk_Color& color)
        { is_back_=true;  back_=color; }
      void set_font(const Gdk_Font& color)
        { is_font_=true;  font_=color; }

      Context() : is_fore_(0),is_back_(0),is_font_(0) {}
      Context(const Gdk_Font& font) : is_fore_(0),is_back_(0),is_font_(1)
        { font_=font; }
  };
};

class Text : public Editable {

public:
  typedef Text          CppObjectType;
  typedef Text_Class    CppClassType;
  typedef GtkText           BaseObjectType;
  typedef GtkTextClass      BaseClassType;

private:
  friend CppClassType;
  static CppClassType text_class;

  Text(const Text&);
  Text& operator=(const Text&); // not implemented

protected:
  void   initialize_class();
  explicit Text(GtkText *castitem);

public:
  static GtkType get_type();
  GtkText* gtkobj()             { return (GtkText*)(gtkobject); }
  const GtkText* gtkobj() const { return (GtkText*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Text();

private:

public:

  Text( Adjustment &hadj, Adjustment &vadj);


  Text();

  // gtk_text_set_editable inherited from editable



  void set_word_wrap(bool word_wrap);



  void set_line_wrap(bool line_wrap);




  void set_adjustments(Gtk::Adjustment* hadj=0,Gtk::Adjustment* vadj=0);



  void set_adjustments(Gtk::Adjustment& hadj,Gtk::Adjustment& vadj);


  Gtk::Adjustment* get_hadjustment() const;

  Gtk::Adjustment* get_vadjustment() const;

  void set_point(guint index);



  guint get_point() const;



  guint get_length() const;


  void freeze();


  void thaw();

  // depreciated

  void insert(const Gdk_Font& font,const Gdk_Color& fore,const Gdk_Color& back,const nstring& chars,gint length);

  typedef Gtk::Text_Helpers::Context Context;
  void insert(const Context& gc, const string &text);
  void insert(const string &text);


  gint backward_delete(guint nchars);

  gint forward_delete(guint nchars);

  // use this only if you are changing in a local spot.  Global
  // changes should be done at the style level.
  void set_context();
  void set_context(const Context& gc);
  Context get_context() const;

private:
  Context gc_;

public:

    class Proxy_set_scroll_adjustments
      : public Gtk::EmitProxySignal2<void,GtkAdjustment*,GtkAdjustment*,CppObjectType,BaseObjectType,0,&gtk_text_set_scroll_adjustments>
      {
          typedef Gtk::EmitProxySignal2<void,GtkAdjustment*,GtkAdjustment*,CppObjectType,BaseObjectType,0,&gtk_text_set_scroll_adjustments> BaseType;
        public:
          void operator ()(Gtk::Adjustment*,Gtk::Adjustment*);
          void emit(Gtk::Adjustment*,Gtk::Adjustment*);
          Connection connect(const SigC::Slot2<void,Gtk::Adjustment*,Gtk::Adjustment*> &s);
      };
  union
    {
      CppObjectType * text_self;
      Proxy_set_scroll_adjustments set_scroll_adjustments;
    };

protected:
  // impl functions
    virtual void set_scroll_adjustments_impl(Gtk::Adjustment* p0,Gtk::Adjustment* p1);

};

}


//+ PROPERTIES(Gtk_Text)
//. name: text_area
//. type: GdkWindow*
//. get:
//. set:
//. desc:

//. name: hadj
//. type: GtkAdjustment*
//. get:
//. set:
//. desc:

//. name: vadj
//. type: GtkAdjustment*
//. get:
//. set:
//. desc:

//. name: gc
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: line_wrap_bitmap
//. type: GdkPixmap*
//. get:
//. set:
//. desc:

//. name: line_arrow_bitmap
//. type: GdkPixmap*
//. get:
//. set:
//. desc:

#endif
