// -*- c++ -*-
//  Generated by gtkmmproc from ./../notebook.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_NOTEBOOK_H
#define _GTKMM_NOTEBOOK_H

/* $Id: notebook.gen_h,v 1.84 2000/03/03 01:38:48 kenelson Exp $ */

/* notebook.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/container.h>
#include <gtk--/label.h>
#include <gtk/gtknotebook.h>

namespace Gtk {
class Notebook;
class Notebook_Class;
}
namespace Gtk { Gtk::Notebook *wrap (GtkNotebook *o); }
extern "C" void gtkmm_notebook_switch_page(GtkNotebook*,GtkNotebookPage* p1,guint p2);
namespace Gtk
{

class Notebook;



namespace Notebook_Helpers
{
/*********************************************************************
***** Page Properties
*********************************************************************/
  // we will have to muck a good bit to get this to work.
  // output type
  class Page : protected GtkNotebookPage
    {
      private:
        Page& operator=(const Page&);
        Page(const Page&);
      protected:
        Page(void* do_not_derive_this);

        // This is the key to wrapping this type
        GtkNotebook* parent()
          {return GTK_NOTEBOOK(gtkobj()->child->parent);}

      public:
        GtkNotebookPage* gtkobj() {return (this);}

        Widget* get_child();
        Widget* get_tab();
        Widget* get_menu();

        void set_tab (Widget* tab=0);
        void set_tab (Widget& tab);
        void set_tab_text(const nstring& str=0);
        void set_menu(Widget* menu=0);
        void set_menu(Widget& menu);

        bool get_expand();
        bool get_fill();
        GtkPackType get_pack();
        void set_tab_packing(bool expand,bool fill,GtkPackType pack_type);
    };

  // input type (Factory)
  class PageList;
  class Element
    {
        friend PageList;
        Widget   *child_;
        Widget   *tab_;
        Widget   *menu_;
     public:
        Element(Widget* child,Widget* tab,Widget* menu)
            : child_(child),tab_(tab),menu_(menu)
          {}
        Element(Widget& child,Widget& tab,Widget& menu)
            : child_(&child),tab_(&tab),menu_(&menu)
          {}
        Element(Widget& child)
            : child_(&child),tab_(0),menu_(0)
          {}
    };

  // Just a widget without a tab
  typedef Element WidgetElem;

  struct TabElem : public Element
    {
        TabElem(Widget& child,Widget& tab)
            : Element(&child,&tab,0)
          {}
        TabElem(Widget& child,const string& s)
            : Element(&child,manage( new Label(s)),0)
          {}
    };

  struct MenuElem : public Element
    {
        MenuElem(Widget& child,Widget& menu)
            : Element(&child,0,&menu)
          {}
    };

/*********************************************************************
***** List properties
*********************************************************************/

  // This still needs some work.

  class PageList
    {
      public:
        typedef Page*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Iterator<value_type>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend Notebook;
        Notebook *parent_;
        explicit PageList(Notebook* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~PageList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

        iterator insert(iterator position, const Element& e);
        template <class InputIterator>
        inline void insert(iterator position, InputIterator first, InputIterator last)
          { for (;first!=last;++first) position=insert(position,*first); }

        inline void push_front(const Element& e) { insert(begin(), e); }
        inline void push_back(const Element& e)  { insert(end(), e); }
        inline void pop_front()                  { erase(begin()); }
        inline void pop_back()                   { erase(--end()); }

        void clear();

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);

        void remove(Widget& w);

        // Non-standard
        void reorder(iterator loc,iterator page);

        iterator find(const_reference c);
        iterator find(Widget&);

        value_type front() const     { return *begin(); }
        value_type back() const      { return *(--end()); }

        // This is order n. (use at own risk)
        value_type operator[](size_type l) const;

     };
};

//: container which shows one of it's children a time, normally subwindows
class Notebook : public Container {

public:
  typedef Notebook          CppObjectType;
  typedef Notebook_Class    CppClassType;
  typedef GtkNotebook           BaseObjectType;
  typedef GtkNotebookClass      BaseClassType;

private:
  friend CppClassType;
  static CppClassType notebook_class;

  Notebook(const Notebook&);
  Notebook& operator=(const Notebook&); // not implemented

protected:
  void   initialize_class();
  explicit Notebook(GtkNotebook *castitem);

public:
  static GtkType get_type();
  GtkNotebook* gtkobj()             { return (GtkNotebook*)(gtkobject); }
  const GtkNotebook* gtkobj() const { return (GtkNotebook*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Notebook();

private:

public:

  typedef Notebook_Helpers::Page     Page;
  typedef Notebook_Helpers::Element  Element;
  typedef Notebook_Helpers::PageList PageList;

  Notebook();

//  WRAP_METHOD(
//    void gtk_notebook_remove_page(GtkNotepad*,gint page_number),
//    void remove_page       (gint page_num));

/* Page controls */




  gint get_current_page_num() const;



  Gtk::Widget* get_nth_page(gint page_number);



  gint page_num(const Gtk::Widget& child);



  void set_page(gint page_number);



  void next_page();



  void prev_page();


  Page* get_current() const;
  // deprecated (use notebook.get_current().child()
  Gtk::Widget* get_current_child();


/* Style */
  GtkPositionType get_tab_pos() const;

  bool get_show_tabs() const;

  bool get_show_border() const;

  void set_show_border(bool show_border);



  void set_show_tabs(bool show_tabs);

  //: pos is one of GTK_POS_LEFT, GTK_POS_RIGHT, GTK_POS_TOP, GTK_POS_BOTTOM


  void set_tab_pos(GtkPositionType pos);



  void set_homogeneous_tabs(bool homogeneous);



  void set_tab_border(gint border_width);



  void set_tab_hborder(guint tab_hborder);



  void set_tab_vborder(guint tab_vborder);



  void set_scrollable(bool scrollable);



/* Popup */

  void popup_enable();



  void popup_disable();

  //: (deprecated)


  void prepend_page(Gtk::Widget& p0,Gtk::Widget& p1);

  //: (deprecated)


  void append_page(Gtk::Widget& p0,Gtk::Widget& p1);

  PageList& pages()
    {return reinterpret_cast<PageList&>(widget_self); }
  const PageList& pages() const
    {return reinterpret_cast<const PageList&>(widget_self); }

public:

    class Proxy_switch_page
      : public Gtk::EmitProxySignal2<void,GtkNotebookPage*,guint,CppObjectType,BaseObjectType,0,&gtkmm_notebook_switch_page>
      {
          typedef Gtk::EmitProxySignal2<void,GtkNotebookPage*,guint,CppObjectType,BaseObjectType,0,&gtkmm_notebook_switch_page> BaseType;
        public:
          void operator ()(Gtk::Notebook_Helpers::Page*,guint);
          void emit(Gtk::Notebook_Helpers::Page*,guint);
          Connection connect(const SigC::Slot2<void,Gtk::Notebook_Helpers::Page*,guint> &s);
          void operator ()(Gtk::Notebook_Helpers::Page* p) {emit(p,-1);}
          void emit(Gtk::Notebook_Helpers::Page* p) {emit(p,-1);}

      };
  union
    {
      CppObjectType * notebook_self;
      Proxy_switch_page switch_page;
    };

protected:
  // impl functions
    virtual void switch_page_impl(Gtk::Notebook_Helpers::Page* p0,guint p1);

};

}


//+ PROPERTIES(Gtk_NoteBook)
//. name: cur_page
//. type: GtkNotebookPage*
//. get:
//. set:
//. desc:

//. name: children
//. type: GList*
//. get:
//. set:
//. desc:

//. name: first_tab
//. type: GList*
//. get:
//. set:
//. desc:

//. name: focus_tab
//. type: GList*
//. get:
//. set:
//. desc:

//. name: menu
//. type: Gtk_Widget*
//. get:
//. set:
//. desc:

//. name: panel
//. type: GdkWindow*
//. get:
//. set:
//. desc:

//. name: timer
//. type: guint32
//. get:
//. set:
//. desc:

//. name: tab_hborder
//. type: guint16
//. get:
//. set:
//. desc:

//. name: tab_vborder
//. type: guint16
//. get:
//. set:
//. desc:

//. name: show_tabs
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: homogeneous
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: show_border
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: tab_pos
//. type: guint:2
//. get:
//. set:
//. desc:

//. name: scrollable
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: in_child
//. type: guint:2
//. get:
//. set:
//. desc:

//. name: click_child
//. type: guint:2
//. get:
//. set:
//. desc:

//. name: button
//. type: guint:2
//. get:
//. set:
//. desc:

//. name: need_timer
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: child_has_focus
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: have_visible_child
//. type: guint:1
//. get:
//. set:
//. desc:

#endif
