%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%%%----------------------------------------------------------------------
%%% File    : code_aux.erl
%%% Author  : Peter Olin <olin@smaug>
%%% Purpose : 
%%% Created :  4 Feb 1998 by Peter Olin <olin@smaug>
%%%----------------------------------------------------------------------

-module(code_aux).
-author('olin@smaug').

%%-compile(export_all).
-export([
	 to_atom/1,
	 to_list/1,
	 objfile_extension/0,
	 sticky/2,
	 do_purge/1]).



objfile_extension() ->
    case erlang:info(machine) of
	"JAM" -> ".jam";
	"VEE" -> ".vee";
	"BEAM" -> ".beam"
    end.


to_list(X) when list(X) -> X;
to_list(X) when atom(X) -> atom_to_list(X).


to_atom(X) when atom(X) -> X;
to_atom(X) when list(X) -> list_to_atom(X).



%% The idea here is that we shall sucseed in loading 
%% a lib module the first time and then never be able reload it !!!!!
sticky(Mod, Db) ->
    case erlang:module_loaded(Mod) of
	true ->
	    case ets:lookup(Db, {sticky, Mod}) of
		[] -> false;
		_  -> true
	    end;
	_ -> false
    end.




%% do_purge(Module)
%%  Kill all processes running code from *old* Module, and then purge the
%%  module. Return true if any processes killed, else false.

do_purge(Mod) ->
    M = code_aux:to_atom(Mod),
    do_purge(processes(), M, false).

do_purge([P|Ps], Mod, Purged) ->
    case erlang:check_process_code(P, Mod) of
	true ->
	    exit(P, kill),
	    do_purge(Ps, Mod, true);
	false ->
	    do_purge(Ps, Mod, Purged)
    end;
do_purge([], Mod, Purged) ->
    catch erlang:purge_module(Mod),
    Purged.
