'\"
'\" Copyright (c) 1992-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) canvas.n 1.44 95/08/12 17:35:03
'\"
.so STk-man.macros
.TH canvas n 3.1 STk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
canvas \- Create and manipulate canvas widgets
.SH SYNOPSIS
(\fBcanvas\fI \fIwidget\-name \fR?\fIoptions\fR?)
.SO
:background	:highlightthickness	:insertwidth	:takefocus
:borderwidth	:insertbackground	:relief	:xscrollcommand
:cursor	:insertborderwidth	:selectbackground	:yscrollcommand
:highlightbackground	:insertofftime	:selectborderwidth
:highlightcolor	:insertontime	:selectforeground
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP :closeenough closeEnough CloseEnough close-enough
Specifies a floating-point value indicating how close the mouse cursor
must be to an item before it is considered to be ``inside'' the item.
Defaults to 1.0.
.OP :confine confine Confine confine
Specifies a boolean value that indicates whether or not it should be
allowable to set the canvas's view outside the region defined by the
\fBscrollRegion\fR argument.
Defaults to true, which means that the view will
be constrained within the scroll region.
.OP :height height Height height
Specifies a desired window height that the canvas widget should request from
its geometry manager.  The value may be specified in any
of the forms described in the COORDINATES section below.
.OP :scrollregion scrollRegion ScrollRegion scroll-region
Specifies a list with four coordinates describing the left, top, right, and
bottom coordinates of a rectangular region.
This region is used for scrolling purposes and is considered to be
the boundary of the information in the canvas.
Each of the coordinates may be specified
in any of the forms given in the COORDINATES section below.
.OP :width width width width
Specifies a desired window width that the canvas widget should request from
its geometry manager.  The value may be specified in any
of the forms described in the COORDINATES section below.
.br
.OP :xscrollincrement xScrollIncrement ScrollIncrement x-scroll-indent
Specifies an increment for horizontal scrolling, in any of the usual forms
permitted for screen distances.  If the value of this option is greater
than zero, the horizontal view in the window will be constrained so that
the canvas x coordinate at the left edge of the window is always an even
multiple of \fBxScrollIncrement\fR;  furthermore, the units for scrolling
(e.g., the change in view when the left and right arrows of a scrollbar
are selected) will also be \fBxScrollIncrement\fR.  If the value of
this option is less than or equal to zero, then horizontal scrolling
is unconstrained.
.OP :yscrollincrement yScrollIncrement ScrollIncrement y-scroll-indent
Specifies an increment for vertical scrolling, in any of the usual forms
permitted for screen distances.  If the value of this option is greater
than zero, the vertical view in the window will be constrained so that
the canvas y coordinate at the top edge of the window is always an even
multiple of \fByScrollIncrement\fR;  furthermore, the units for scrolling
(e.g., the change in view when the top and bottom arrows of a scrollbar
are selected) will also be \fByScrollIncrement\fR.  If the value of
this option is less than or equal to zero, then vertical scrolling
is unconstrained.
.BE

.SH INTRODUCTION
.PP
The \fBcanvas\fR procedure creates a new window (given
by the \fIwidget\-name\fR argument) and makes it into a canvas widget.
Additional options, described above, may be specified on the
procedure line or in the option database
to configure aspects of the canvas such as its colors and 3-D relief.
The \fBcanvas\fR procedure returns its
\fIwidget\-name\fR argument.  At the time this procedure is invoked,
there must not exist a window named \fIwidget\-name\fR, but
\fIwidget\-name\fR's parent must exist.
.PP
Canvas widgets implement structured graphics.
A canvas displays any number of \fIitems\fR, which may be things like
rectangles, circles, lines, and text.
Items may be manipulated (e.g. moved or re-colored) and procedures may
be associated with items in much the same way that the \fBbind\fR
procedure allows procedures to be bound to widgets.  For example,
a particular procedure may be associated with the <Button-1> event
so that the procedure is invoked whenever button 1 is pressed with
the mouse cursor over an item.
This means that items in a canvas can have behaviors defined by
the STk scripts bound to them.

.SH "DISPLAY LIST"
.PP
The items in a canvas are ordered for purposes of display,
with the first item in the display list being displayed
first, followed by the next item in the list, and so on.
Items later in the display list obscure those that are
earlier in the display list and are sometimes referred to
as being ``on top'' of earlier items.
When a new item is created it is placed at the end of the
display list, on top of everything else.
Widget procedures may be used to re-arrange the order of the
display list.

.SH "ITEM IDS AND TAGS"
.PP
Items in a canvas widget may be named in either of two ways:
by id or by tag.
Each item has a unique identifying number which is assigned to
that item when it is created.  The id of an item never changes
and id numbers are never re-used within the lifetime of a
canvas widget.
.PP
Each item may also have any number of \fItags\fR associated
with it.  A tag is just a string of characters, and it may
take any form except that of an integer.
For example, ``x123'' is OK but ``123'' isn't.
The same tag may be associated with many different items.
This is commonly done to group items in various interesting
ways;  for example, all selected items might be given the
tag ``selected''.
.PP
The tag \fBall\fR is implicitly associated with every item
in the canvas;  it may be used to invoke operations on
all the items in the canvas.
.PP
The tag \fBcurrent\fR is managed automatically by Tk;
it applies to the \fIcurrent item\fR, which is the
topmost item whose drawn area covers the position of
the mouse cursor.
If the mouse is not in the canvas widget or is not over
an item, then no item has the \fBcurrent\fR tag.
.PP
When specifying items in canvas widget procedures, if the
specifier is an integer then it is assumed to refer to
the single item with that id.
If the specifier is not an integer, then it is assumed to
refer to all of the items in the canvas that have a tag
matching the specifier.
The symbol \fItagOrId\fR is used below to indicate that
an argument specifies either an id that selects a single
item or a tag that selects zero or more items.
Some widget procedures only operate on a single item at a
time;  if \fItagOrId\fR is specified in a way that
names multiple items, then the normal behavior is for
the procedure to use the first (lowest) of these items in
the display list that is suitable for the procedure.
Exceptions are noted in the widget procedure descriptions
below.

.SH "COORDINATES"
.PP
All coordinates related to canvases are stored as floating-point
numbers.
Coordinates and distances are specified in screen units,
which are floating-point numbers optionally followed
by one of several letters.
If no letter is supplied then the distance is in pixels.
If the letter is \fBm\fR then the distance is in millimeters on
the screen;  if it is \fBc\fR then the distance is in centimeters;
\fBi\fR means inches, and \fBp\fR means printers points (1/72 inch).
Larger y-coordinates refer to points lower on the screen;  larger
x-coordinates refer to points farther to the right.

.SH TRANSFORMATIONS
.PP
Normally the origin of the canvas coordinate system is at the
upper-left corner of the window containing the canvas.
It is possible to adjust the origin of the canvas
coordinate system relative to the origin of the window using the
\fBxview\fR and \fByview\fR widget procedures;  this is typically used
for scrolling.
Canvases do not support scaling or rotation of the canvas coordinate
system relative to the window coordinate system.
.PP
Individual items may be moved or scaled using widget procedures
described below, but they may not be rotated.

.SH "INDICES"
.PP
Text items support the notion of an \fIindex\fR for identifying
particular positions within the item.
Indices are used for procedures such as inserting text, deleting
a range of characters, and setting the insertion cursor position.
An index may be specified in any of a number of ways, and
different types of items may support different forms for
specifying indices.
Text items support the following forms for an index;  if you
define new types of text-like items, it would be advisable to
support as many of these forms as practical.
Note that it is possible to refer to the character just after
the last one in the text item;  this is necessary for such
tasks as inserting new text at the end of the item.
.TP 10
\fInumber\fR
A decimal number giving the position of the desired character
within the text item.
0 refers to the first character, 1 to the next character, and
so on.
A number less than 0 is treated as if it were zero, and a
number greater than the length of the text item is treated
as if it were equal to the length of the text item.
.TP 10
\fBend\fR
Refers to the character just after the last one in the item
(same as the number of characters in the item).
.TP 10
\fBinsert\fR
Refers to the character just before which the insertion cursor
is drawn in this item.
.TP 10
\fBsel.first\fR
Refers to the first selected character in the item.
If the selection isn't in this item then this form is illegal.
.TP 10
\fBsel.last\fR
Refers to the last selected character in the item.
If the selection isn't in this item then this form is illegal.
.TP 10
\fB@\fIx,y\fR
Refers to the character at the point given by \fIx\fR and
\fIy\fR, where \fIx\fR and \fIy\fR are specified in the coordinate
system of the canvas.
If \fIx\fR and \fIy\fR lie outside the coordinates covered by the
text item, then they refer to the first or last character in the
line that is closest to the given point.

.SH "WIDGET PROCEDURE"
.PP
The \fBcanvas\fR procedure creates a new STk procedure whose
name is \fIwidget\-name\fR.  This
procedure may be used to invoke various
operations on the widget.  It has the following general form:
.CS
(\fIwidget\-name option \fR?\fIarg arg ...\fR?)
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the procedure.
The following widget procedures are possible for canvas widgets:
.TP
(\fIwidget\-name '\fBaddtag \fItag searchSpec \fR?\fIarg arg ...\fR?)
For each item that meets the constraints specified by
\fIsearchSpec\fR and the \fIarg\fRs, add
\fItag\fR to the list of tags associated with the item if it
isn't already present on that list.
It is possible that no items will satisfy the constraints
given by \fIsearchSpec and \fIarg\fRs, in which case the
procedure has no effect.
This procedure returns an empty list as result.
\fISearchSpec\fR and \fIarg\fR's may take any of the following
forms:
.RS
.TP
\fBabove \fItagOrId\fR
Selects the item just after (above) the one given by \fItagOrId\fR
in the display list.
If \fItagOrId\fR denotes more than one item, then the last (topmost)
of these items in the display list is used.
.TP
\fBall\fR
Selects all the items in the canvas.
.TP
\fBbelow \fItagOrId\fR
Selects the item just before (below) the one given by \fItagOrId\fR
in the display list.
If \fItagOrId\fR denotes more than one item, then the first (lowest)
of these items in the display list is used.
.TP
\fBclosest \fIx y \fR?\fIhalo\fR? ?\fIstart\fR?
Selects the item closest to the point given by \fIx\fR and \fIy\fR.
If more than one item is at the same closest distance (e.g. two
items overlap the point), then the top-most of these items (the
last one in the display list) is used.
If \fIhalo\fR is specified, then it must be a non-negative
value.
Any item closer than \fIhalo\fR to the point is considered to
overlap it.
The \fIstart\fR argument may be used to step circularly through
all the closest items.
If \fIstart\fR is specified, it names an item using a tag or id
(if by tag, it selects the first item in the display list with
the given tag).
Instead of selecting the topmost closest item, this form will
select the topmost closest item that is below \fIstart\fR in
the display list;  if no such item exists, then the selection
behaves as if the \fIstart\fR argument had not been specified.
.TP
\fBenclosed\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
Selects all the items completely enclosed within the rectangular
region given by \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR.
\fIX1\fR must be no greater then \fIx2\fR and \fIy1\fR must be
no greater than \fIy2\fR.
.TP
\fBoverlapping\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
Selects all the items that overlap or are enclosed within the
rectangular region given by \fIx1\fR, \fIy1\fR, \fIx2\fR,
and \fIy2\fR.
\fIX1\fR must be no greater then \fIx2\fR and \fIy1\fR must be
no greater than \fIy2\fR.
.TP
\fBwithtag \fItagOrId\fR
Selects all the items given by \fItagOrId\fR.
.RE
.TP
(\fIwidget\-name '\fBbbox \fItagOrId\fR ?\fItagOrId tagOrId ...\fR?)
Returns a list with four elements giving an approximate bounding box
for all the items named by the \fItagOrId\fR arguments.
The list has the form \fI(x1 y1 x2 y2)\fR such that the drawn
areas of all the named elements are within the region bounded by
\fIx1\fR on the left, \fIx2\fR on the right, \fIy1\fR on the top,
and \fIy2\fR on the bottom.
The return value may overestimate the actual bounding box by
a few pixels.
If no items match any of the \fItagOrId\fR arguments or if the
matching items have empty bounding boxes (i.e. they have nothing
to display) then an empty list is returned.
.TP
(\fIwidget\-name '\fBbind \fItagOrId\fR ?\fIsequence\fR? ?\fIprocedure\fR?)
This procedure associates \fIprocedure\fR with all the items given by
\fItagOrId\fR such that whenever the event sequence given by
\fIsequence\fR occurs for one of the items the procedure will
be invoked.
This widget procedure is similar to the \fBbind\fR procedure except that
it operates on items in a canvas rather than entire widgets.
See the \fBbind\fR manual entry for complete details
on the syntax of \fIsequence\fR and the substitutions performed
on \fIprocedure\fR before invoking it.
If all arguments are specified then a new binding is created, replacing
any existing binding for the same \fIsequence\fR and \fItagOrId\fR
(if the first character of \fIprocedure\fR is ``+'' then \fIprocedure\fR
augments an existing binding rather than replacing it).
In this case the return value is an empty list.
If \fIprocedure\fR is omitted then the procedure returns the \fIprocedure\fR
associated with \fItagOrId\fR and \fIsequence\fR (an error occurs
if there is no such binding).
If both \fIprocedure\fR and \fIsequence\fR are omitted then the procedure
returns a list of all the sequences for which bindings have been
defined for \fItagOrId\fR.
.RS
.LP
Example:
.DS
(pack (canvas '.c))
            (define item (.c 'create 'rectangle 0 0 10 10))
            (.c 'bind item "<Enter>" (lambda() (display "You enter\n")))

.DE
.RE
.RS
.PP
The only events for which bindings may be specified are those related
to the mouse and keyboard, such as \fBEnter\fR, \fBLeave\fR,
\fBButtonPress\fR, \fBMotion\fR, and \fBKeyPress\fR.
The handling of events in canvases uses the current item defined
in ITEM IDS AND TAGS above.
\fBEnter\fR and \fBLeave\fR events trigger for an item when it
becomes the current item or ceases to be the current item;  note
that these events are different than \fBEnter\fR and \fBLeave\fR
events for windows.
Mouse-related events are directed to the current item, if any.
Keyboard-related events are directed to the focus item, if any
(see the \fBfocus\fR widget procedure below for more on this).
.PP
It is possible for multiple bindings to match a particular event.
This could occur, for example, if one binding is associated with the
item's id and another is associated with one of the item's tags.
When this occurs, all of the matching bindings are invoked.
A binding associated with the \fBall\fR tag is invoked first,
followed by one binding for each of the item's tags (in order),
followed by a binding associated with the item's id.
If there are multiple matching bindings for a single tag,
then only the most specific binding is invoked.
If a binding script returns the symbol \fBbreak\fR, remaining scripts 
for the event are skipped, just as for the \fBbind\fR procedure.

.PP
If bindings have been created for a canvas window using the \fBbind\fR
procedure, then they are invoked in addition to bindings created for
the canvas's items using the \fBbind\fR widget procedure.
The bindings for items will be invoked before any of the bindings
for the window as a whole.
.RE
.LP
.TP
(\fIwidget\-name '\fBcanvasx \fIscreenx\fR)
.TP
(\fIwidget\-name '\fBcanvasx \fIscreenx\fR \fIgridspacing\fR)
Given a screen x-coordinate \fIscreenx\fR this procedure returns
the canvas x-coordinate that is displayed at that location.
If \fIgridspacing\fR is specified, then the canvas coordinate is
rounded to the nearest multiple of \fIgridspacing\fR units.
.TP
(\fIwidget\-name '\fBcanvasy \fIscreeny\fR)
.TP
(\fIwidget\-name '\fBcanvasy \fIscreeny\fR \fIgridspacing\fR)
Given a screen y-coordinate \fIscreeny\fR this procedure returns
the canvas y-coordinate that is displayed at that location.
If \fIgridspacing\fR is specified, then the canvas coordinate is
rounded to the nearest multiple of \fIgridspacing\fR units.
.TP
(\fIwidget\-name '\fBcget\fR \fIoption\fR)
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBcanvas\fR
procedure.
.TP
(\fIwidget\-name '\fBconfigure \fR?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?)
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIwidget\-name\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the procedure returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the procedure
modifies the given widget option(s) to have the given value(s);  in
this case the procedure returns an empty list.
\fIOption\fR may have any of the values accepted by the \fBcanvas\fR
procedure.
.TP
(\fIwidget\-name\fR '\fBcoords \fItagOrId \fR?\fIx0 y0 ...\fR?)
Query or modify the coordinates that define an item.
If no coordinates are specified, this procedure returns a list
whose elements are the coordinates of the item named by
\fItagOrId\fR.
If coordinates are specified, then they replace the current
coordinates for the named item.
If \fItagOrId\fR refers to multiple items, then
the first one in the display list is used.
.TP
(\fIwidget\-name '\fBcreate \fItype x y \fR?\fIx y ...\fR? ?\fIoption value ...\fR?)
Create a new item in \fIwidget\-name\fR of type \fItype\fR.
The exact format of the arguments after \fBtype\fR depends
on \fBtype\fR, but usually they consist of the coordinates for
one or more points, followed by specifications for zero or
more item options.
See the subsections on individual item types below for more
on the syntax of this procedure.
This procedure returns the id for the new item.
.TP
(\fIwidget\-name '\fBdchars \fItagOrId first \fR)
.TP
(\fIwidget\-name '\fBdchars \fItagOrId first \fR\fIlast\fR)
For each item given by \fItagOrId\fR, delete the characters
in the range given by \fIfirst\fR and \fIlast\fR,
inclusive.
If some of the items given by \fItagOrId\fR don't support
text operations, then they are ignored.
\fIFirst\fR and \fIlast\fR are indices of characters
within the item(s) as described in INDICES above.
If \fIlast\fR is omitted, it defaults to \fIfirst\fR.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBdelete \fR?\fItagOrId tagOrId ...\fR?)
Delete each of the items given by each \fItagOrId\fR, and return
an empty list.
.TP
(\fIwidget\-name '\fBdtag \fItagOrId \fR)
.TP
(\fIwidget\-name '\fBdtag \fItagOrId \fR\fItagToDelete\fR)
For each of the items given by \fItagOrId\fR, delete the
tag given by \fItagToDelete\fR from the list of those
associated with the item.
If an item doesn't have the tag \fItagToDelete\fR then
the item is unaffected by the procedure.
If \fItagToDelete\fR is omitted then it defaults to \fItagOrId\fR.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBfind \fIsearchProcedure \fR?\fIarg arg ...\fR?)
This procedure returns a list consisting of all the items that
meet the constraints specified by \fIsearchProcedure\fR and
\fIarg\fR's.
\fISearchProcedure\fR and \fIargs\fR have any of the forms
accepted by the \fBaddtag\fR procedure.
.TP
(\fIwidget\-name '\fBfocus \fR)
.TP
(\fIwidget\-name '\fBfocus \fR\fItagOrId\fR)
Set the keyboard focus for the canvas widget to the item given by
\fItagOrId\fR.
If \fItagOrId\fR refers to several items, then the focus is set
to the first such item in the display list that supports the
insertion cursor.
If \fItagOrId\fR doesn't refer to any items, or if none of them
support the insertion cursor, then the focus isn't changed.
If \fItagOrId\fR is an empty
string, then the focus item is reset so that no item has the focus.
If \fItagOrId\fR is not specified then the procedure returns the
id for the item that currently has the focus, or an empty list
if no item has the focus.
.RS
.PP
Once the focus has been set to an item, the item will display
the insertion cursor and all keyboard events will be directed
to that item.
The focus item within a canvas and the focus window on the
screen (set with the \fBfocus\fR procedure) are totally independent:
a given item doesn't actually have the input focus unless (a)
its canvas is the focus window and (b) the item is the focus item
within the canvas.
In most cases it is advisable to follow the \fBfocus\fR widget
procedure with the \fIfocus\fR option to set the focus window to
the canvas (if it wasn't there already).
.RE
.LP
.TP
(\fIwidget\-name '\fBgettags\fR \fItagOrId\fR)
Return a list whose elements are the tags associated with the
item given by \fItagOrId\fR.
If \fItagOrId\fR refers to more than one item, then the tags
are returned from the first such item in the display list.
If \fItagOrId\fR doesn't refer to any items, or if the item
contains no tags, then an empty list is returned.
.TP
(\fIwidget\-name '\fBicursor \fItagOrId index\fR)
Set the position of the insertion cursor for the item(s)
given by \fItagOrId\fR
to just before the character whose position is given by \fIindex\fR.
If some or all of the items given by \fItagOrId\fR don't support
an insertion cursor then this procedure has no effect on them.
See INDICES above for a description of the
legal forms for \fIindex\fR.
Note:  the insertion cursor is only displayed in an item if
that item currently has the keyboard focus (see the widget
procedure \fBfocus\fR, below), but the cursor position may
be set even when the item doesn't have the focus.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBindex \fItagOrId index\fR)
This procedure returns a decimal string giving the numerical index
within \fItagOrId\fR corresponding to \fIindex\fR.
\fIIndex\fR gives a textual description of the desired position
as described in INDICES above.
The return value is guaranteed to lie between 0 and the number
of characters within the item, inclusive.
If \fItagOrId\fR refers to multiple items, then the index
is processed in the first of these items that supports indexing
operations (in display list order).
.TP
(\fIwidget\-name '\fBinsert \fItagOrId beforeThis string\fR)
For each of the items given by \fItagOrId\fR, if the item supports
text insertion then \fIstring\fR is inserted into the item's
text just before the character whose index is \fIbeforeThis\fR.
See INDICES above for information about the forms allowed
for \fIbeforeThis\fR.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBitemcget\fR \fItagOrId\fR \fIoption\fR)
Returns the current value of the configuration option for the
item given by \fItagOrId\fR whose name is \fIoption\fR.
This procedure is similar to the \fBcget\fR widget procedure except that
it applies to a particular item rather than the widget as a whole.
\fIOption\fR may have any of the values accepted by the \fBcreate\fR
widget procedure when the item was created.
If \fItagOrId\fR is a tag that refers to more than one item,
the first (lowest) such item is used.
.TP
(\fIwidget\-name '\fBitemconfigure \fItagOrId\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?)
This procedure is similar to the \fBconfigure\fR widget procedure except
that it modifies item-specific options for the items given by
\fItagOrId\fR instead of modifying options for the overall
canvas widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for the first item given by \fItagOrId\fR
(see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the procedure returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the procedure
modifies the given widget option(s) to have the given value(s) in
each of the items given by \fItagOrId\fR;  in
this case the procedure returns an empty list.
The \fIoption\fRs and \fIvalue\fRs are the same as those permissible
in the \fBcreate\fR widget procedure when the item(s) were created;
see the sections describing individual item types below for details
on the legal options.
.TP
(\fIwidget\-name '\fBlower \fItagOrId \fR)
.TP
(\fIwidget\-name '\fBlower \fItagOrId \fR\fIbelowThis\fR)
Move all of the items given by \fItagOrId\fR to a new position
in the display list just before the item given by \fIbelowThis\fR.
If \fItagOrId\fR refers to more than one item then all are moved
but the relative order of the moved items will not be changed.
\fIBelowThis\fR is a tag or id;  if it refers to more than one
item then the first (lowest) of these items in the display list is used
as the destination location for the moved items.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBmove \fItagOrId xAmount yAmount\fR)
Move each of the items given by \fItagOrId\fR in the canvas coordinate
space by adding \fIxAmount\fR to the x-coordinate of each point
associated with the item and \fIyAmount\fR to the y-coordinate of
each point associated with the item.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBpostscript \fR?\fIoption value option value ...\fR?)
Generate a Postscript representation for part or all of the canvas.
If the \fB:file\fR option is specified then the Postscript is written
to a file and an empty list is returned;  otherwise the Postscript
is returned as the result of the procedure.
The Postscript is created in Encapsulated Postscript form using
version 3.0 of the Document Structuring Conventions.
Note: by default Postscript is only generated for information that
appears in the canvas's window on the screen.  If the canvas is
freshly created it may still have its initial size of 1x1 pixel
so nothing will appear in the Postscript.  To get around this problem
either invoke the "update" procedure to wait for the canvas window
to reach its final size, or else use the \fB:width\fR and \fB:height\fR
options to specify the area of the canvas to print.
The \fIoption\fR\-\fIvalue\fR argument pairs provide additional
information to control the generation of Postscript.  The following
options are supported:
.RS
.TP
\fB:colormap \fIvarName\fR
\fBNOT IMPLEMENTED IN STk\fR
.TP
\fB:colormode \fImode\fR
Specifies how to output color information.  \fIMode\fR must be either
\fBcolor\fR (for full color output), \fBgray\fR (convert all colors
to their gray-scale equivalents) or \fBmono\fR (convert all colors
to black or white).
.TP
\fB:file \fIfileName\fR
Specifies the name of the file in which to write the Postscript.
If this option isn't specified then the Postscript is returned as the
result of the procedure instead of being written to a file.
.TP
\fB:fontmap \fIvarName\fR
\fBNOT IMPLEMENTED IN STk\fR
.TP
\fB:height \fIsize\fR
Specifies the height of the area of the canvas to print.
Defaults to the height of the canvas window.
.TP
\fB:pageanchor \fIanchor\fR
Specifies which point of the printed area of the canvas should appear over
the positioning point on the page (which is given by the \fB:pagex\fR
and \fB:pagey\fR options).
For example, \fB:pageanchor n\fR means that the top center of the
area of the canvas being printed (as it appears in the canvas window)
should be over the positioning point. Defaults to \fBcenter\fR.
.TP
\fB:pageheight \fIsize\fR
Specifies that the Postscript should be scaled in both x and y so
that the printed area is \fIsize\fR high on the Postscript page.
\fISize\fR consists of a floating-point number followed by
\fBc\fR for centimeters, \fBi\fR for inches, \fBm\fR for millimeters,
or \fBp\fR or nothing for printer's points (1/72 inch).
Defaults to the height of the printed area on the screen.
If both \fB:pageheight\fR and \fB:pagewidth\fR are specified then
the scale factor from \fB:pagewidth\fR  is used (non-uniform scaling
is not implemented).
.TP
\fB:pagewidth \fIsize\fR
Specifies that the Postscript should be scaled in both x and y so
that the printed area is \fIsize\fR wide on the Postscript page.
\fISize\fR has the same form as for \fB:pageheight\fR.
Defaults to the width of the printed area on the screen.
If both \fB:pageheight\fR and \fB:pagewidth\fR are specified then
the scale factor from  \fB:pagewidth\fR is used (non-uniform scaling
is not implemented).
.TP
\fB:pagex \fIposition\fR
\fIPosition\fR gives the x-coordinate of the positioning point on
the Postscript page, using any of the forms allowed for \fB:pageheight\fR.
Used in conjunction with the \fB:pagey\fR and \fB:pageanchor\fR options
to determine where the printed area appears on the Postscript page.
Defaults to the center of the page.
.TP
\fB:pagey \fIposition\fR
\fIPosition\fR gives the y-coordinate of the positioning point on
the Postscript page, using any of the forms allowed for \fB:pageheight\fR.
Used in conjunction with the \fB:pagex\fR and \fB:pageanchor\fR options
to determine where the printed area appears on the Postscript page.
Defaults to the center of the page.
.TP
\fB:rotate \fIboolean\fR
\fIBoolean\fR specifies whether the printed area is to be rotated 90
degrees.
In non-rotated output the x-axis of the printed area runs along
the short dimension of the page (``portrait'' orientation);
in rotated output the x-axis runs along the long dimension of the
page (``landscape'' orientation).
Defaults to non-rotated.
.TP
\fB:width \fIsize\fR
Specifies the width of the area of the canvas to print.
Defaults to the width of the canvas window.
.TP
\fB:x \fIposition\fR
Specifies the x-coordinate of the left edge of the area of the
canvas that is to be printed, in canvas coordinates, not window
coordinates.
Defaults to the coordinate of the left edge of the window.
.TP
\fB:y \fIposition\fR
Specifies the y-coordinate of the top edge of the area of the
canvas that is to be printed, in canvas coordinates, not window
coordinates.
Defaults to the coordinate of the top edge of the window.
.RE
.TP
(\fIwidget\-name '\fBraise \fItagOrId \fR)
.TP
(\fIwidget\-name '\fBraise \fItagOrId \fR\fIaboveThis\fR)
Move all of the items given by \fItagOrId\fR to a new position
in the display list just after the item given by \fIaboveThis\fR.
If \fItagOrId\fR refers to more than one item then all are moved
but the relative order of the moved items will not be changed.
\fIAboveThis\fR is a tag or id;  if it refers to more than one
item then the last (topmost) of these items in the display list is used
as the destination location for the moved items.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBscale \fItagOrId xOrigin yOrigin xScale yScale\fR)
Rescale all of the items given by \fItagOrId\fR in canvas coordinate
space.
\fIXOrigin\fR and \fIyOrigin\fR identify the origin for the scaling
operation and \fIxScale\fR and \fIyScale\fR identify the scale
factors for x- and y-coordinates, respectively (a scale factor of
1.0 implies no change to that coordinate).
For each of the points defining each item, the x-coordinate is
adjusted to change the distance from \fIxOrigin\fR by a factor
of \fIxScale\fR.
Similarly, each y-coordinate is adjusted to change the distance
from \fIyOrigin\fR by a factor of \fIyScale\fR.
This procedure returns an empty list.
.TP
(\fIwidget\-name '\fBscan\fR \fIoption args\fR)
This procedure is used to implement scanning on canvases.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
(\fIwidget\-name '\fBscan 'mark \fIx y\fR)
Records \fIx\fR and \fIy\fR and the canvas's current view;  used
in conjunction with later \fBscan dragto\fR procedures.
Typically this procedure is associated with a mouse button press in
the widget and \fIx\fR and \fIy\fR are the coordinates of the
mouse.  It returns an empty list.
.TP
(\fIwidget\-name '\fBscan 'dragto \fIx y\fR)
This procedure computes the difference between its \fIx\fR and \fIy\fR
arguments (which are typically mouse coordinates) and the \fIx\fR and
\fIy\fR arguments to the last \fBscan mark\fR procedure for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This procedure is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the canvas at high speed through its window.  The return
value is an empty list.
.RE
.TP
(\fIwidget\-name '\fBselect \fIoption\fR ?\fItagOrId arg\fR?)
Manipulates the selection in one of several ways, depending on
\fIoption\fR.
The procedure may take any of the forms described below.
In all of the descriptions below, \fItagOrId\fR must refer to
an item that supports indexing and selection;  if it refers to
multiple items then the first of
these that supports indexing and the selection is used.
\fIIndex\fR gives a textual description of a position
within \fItagOrId\fR, as described in INDICES above.
.RS
.TP
(\fIwidget\-name '\fBselect adjust \fItagOrId index\fR)
Locate the end of the selection in \fItagOrId\fR nearest
to the character given by \fIindex\fR, and adjust that
end of the selection to be at \fIindex\fR (i.e. including
but not going beyond \fIindex\fR).
The other end of the selection is made the anchor point
for future \fBselect to\fR procedures.
If the selection isn't currently in \fItagOrId\fR then
this procedure behaves the same as the \fBselect to\fR widget
procedure.
Returns an empty list.
.TP
(\fIwidget\-name '\fBselect 'clear\fR)
Clear the selection if it is in this widget.
If the selection isn't in this widget then the procedure
has no effect.
Returns an empty list.
.TP
(\fIwidget\-name '\fBselect 'from \fItagOrId index\fR)
Set the selection anchor point for the widget to be just
before the character
given by \fIindex\fR in the item given by \fItagOrId\fR.
This procedure doesn't change the selection;  it just sets
the fixed end of the selection for future \fBselect to\fR
procedures.
Returns an empty list.
.TP
(\fIwidget\-name '\fBselect 'item\fR)
Returns the id of the selected item, if the selection is in an
item in this canvas.
If the selection is not in this canvas then an empty list
is returned.
.TP
(\fIwidget\-name '\fBselect 'to \fItagOrId index\fR)
Set the selection to consist of those characters of \fItagOrId\fR
between the selection anchor point and
\fIindex\fR.
The new selection will include the character given by \fIindex\fR;
it will include the character given by the anchor point only if
\fIindex\fR is greater than or equal to the anchor point.
The anchor point is determined by the most recent \fBselect adjust\fR
or \fBselect from\fR procedure for this widget.
If the selection anchor point for the widget isn't currently in
\fItagOrId\fR, then it is set to the same character given
by \fIindex\fR.
Returns an empty list.
.RE
.TP
(\fIwidget\-name '\fBtype\fI tagOrId\fR)
Returns the type of the item given by \fItagOrId\fR, such as
\fBrectangle\fR or \fBtext\fR.
If \fItagOrId\fR refers to more than one item, then the type
of the first item in the display list is returned.
If \fItagOrId\fR doesn't refer to any items at all then
an empty list is returned.
.TP
(\fIwidget\-name '\fBxview  \fR?\fIargs\fR?)
This procedure is used to query and change the horizontal position of the
information displayed in the canvas's window.
It can take any of the following forms:
.RS
.TP
(\fIwidget\-name '\fBxview\fR)
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the canvas's area (as defined by the \fB:scrollregion\fR option)
is off-screen to the left, the middle 40% is visible
in the window, and 40% of the canvas is off-screen to the right.
These are the same values passed to scrollbars via the \fB:xscrollcommand\fR
option.
.TP
(\fIwidget\-name '\fBxview 'moveto\fI fraction\fR)
Adjusts the view in the window so that \fIfraction\fR of the
total width of the canvas is off-screen to the left.
\fIFraction\fR must be a fraction between 0 and 1.
.TP
(\fIwidget\-name '\fBxview 'scroll \fInumber what\fR)
This procedure shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right in units
of the \fBxScrollIncrement\fR option, if it is greater than zero,
or in units of one-tenth the window's width otherwise.
If \fIwhat is \fBpages\fR then the view
adjusts in units of nine-tenths the window's width.
If \fInumber\fR is negative then information farther to the left
becomes visible;  if it is positive then information farther to the right
becomes visible.
.RE
.TP
(\fIwidget\-name '\fByview \fI?args\fR?)
This procedure is used to query and change the vertical position of the
information displayed in the canvas's window.
It can take any of the following forms:
.RS
.TP
(\fIwidget\-name '\fByview\fR)
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the vertical span that is visible in the window.
For example, if the first element is .6 and the second element is 1.0,
the lowest 40% of the canvas's area (as defined by the \fB:scrollregion\fR
option) is visible in the window.
These are the same values passed to scrollbars via the \fB:yscrollcommand\fR
option.
.TP
(\fIwidget\-name '\fByview 'moveto\fI fraction\fR)
Adjusts the view in the window so that \fIfraction\fR of the canvas's
area is off-screen to the top.
\fIFraction\fR is a fraction between 0 and 1.
.TP
(\fIwidget\-name '\fByview 'scroll \fInumber what\fR)
This procedure adjusts the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.
If \fIwhat\fR is \fBunits\fR, the view adjusts up or down in units
of the \fByScrollIncrement\fR option, if it is greater than zero,
or in units of one-tenth the window's height otherwise.
If \fIwhat\fR is \fBpages\fR then
the view adjusts in units of nine-tenths the window's height.
If \fInumber\fR is negative then higher information becomes
visible;  if it is positive then lower information
becomes visible.
.RE

.SH "OVERVIEW OF ITEM TYPES"
.PP
The sections below describe the various types of items supported
by canvas widgets.  Each item type is characterized by two things:
first, the form of the \fBcreate\fR procedure used to create
instances of the type;  and second, a set of configuration options
for items of that type, which may be used in the
\fBcreate\fR and \fBitemconfigure\fR widget procedures.
Most items don't support indexing or selection or the procedures
related to them, such as \fBindex\fR and \fBinsert\fR.
Where items do support these facilities, it is noted explicitly
in the descriptions below (at present, only text items provide
this support).

.SH "ARC ITEMS"
.PP
Items of type \fBarc\fR appear on the display as arc-shaped regions.
An arc is a section of an oval delimited by two angles (specified
by the \fB:start\fR and \fB:extent\fR options) and displayed in
one of several ways (specified by the \fB:style\fR option).
Arcs are created with widget procedures of the following form:
.CS
(\fIwidget\-name '\fBcreate 'arc \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of a
rectangular region enclosing the oval that defines the arc.
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for arcs:
.TP
\fB:extent \fIdegrees\fR
Specifies the size of the angular range occupied by the arc.
The arc's range extends for \fIdegrees\fR degrees counter-clockwise
from the starting angle given by the \fB:start\fR option.
\fIDegrees\fR may be negative.
If it is greater than 360 or less than -360, then \fIdegrees\fR
modulo 360 is used as the extent.
.TP
\fB:fill \fIcolor\fR
Fill the region of the arc with \fIcolor\fR.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string (the default), then
then the arc will not be filled.
.TP
\fB:outline \fIcolor\fR
\fIColor\fR specifies a color to use for drawing the arc's
outline;  it may have any of the forms accepted by \fBTk_GetColor\fR.
This option defaults to \fBblack\fR.  If \fIcolor\fR is specified
as an empty string then no outline is drawn for the arc.
.TP
\fB:outlinestipple \fIbitmap\fR
Indicates that the outline for the arc should be drawn with a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If the \fB:outline\fR option hasn't been specified then this option
has no effect.
If \fIbitmap\fR is an empty string (the default), then the outline is drawn
in a solid fashion.
.TP
\fB:start \fIdegrees\fR
Specifies the beginning of the angular range occupied by the
arc.
\fIDegrees\fR is given in units of degrees measured counter-clockwise
from the 3-o'clock position;  it may be either positive or negative.
.TP
\fB:stipple \fIbitmap\fR
Indicates that the arc should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If the \fB:fill\fR option hasn't been specified then this option
has no effect.
If \fIbitmap\fR is an empty string (the default), then filling is done
in a solid fashion.
.TP
\fB:style \fItype\fR
Specifies how to draw the arc.  If \fItype\fR is \fBpieslice\fR
(the default) then the arc's region is defined by a section
of the oval's perimeter plus two line segments, one between the center
of the oval and each end of the perimeter section.
If \fItype\fR is \fBchord\fR then the arc's region is defined
by a section of the oval's perimeter plus a single line segment
connecting the two end points of the perimeter section.
If \fItype\fR is \fBarc\fR then the arc's region consists of
a section of the perimeter alone.
In this last case the \fB:fill\fR option is ignored.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB:width \fIoutlineWidth\fR
Specifies the width of the outline to be drawn around
the arc's region, in any of the forms described in the COORDINATES
section above.
If the \fB:outline\fR option has been specified as an empty string
then this option has no effect.
Wide outlines will be drawn centered on the edges of the arc's region.
This option defaults to 1.0.

.SH "BITMAP ITEMS"
.PP
Items of type \fBbitmap\fR appear on the display as images with
two colors, foreground and background.
Bitmaps are created with widget procedures of the following form:
.CS
(\fIwidget\-name '\fBcreate 'bitmap \fIx y \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx\fR and \fIy\fR specify the coordinates of a
point used to position the bitmap on the display (see the \fB:anchor\fR
option below for more information on how bitmaps are displayed).
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for bitmaps:
.TP
\fB:anchor \fIanchorPos\fR
\fIAnchorPos\fR tells how to position the bitmap relative to the
positioning point for the item;  it may have any of the forms
accepted by \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR
is \fBcenter\fR then the bitmap is centered on the point;  if
\fIanchorPos\fR is \fBn\fR then the bitmap will be drawn so that
its top center point is at the positioning point.
This option defaults to \fBcenter\fR.
.TP
\fB:background \fIcolor\fR
Specifies a color to use for each of the bitmap pixels
whose value is 0.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
If this option isn't specified, or if it is specified as an empty
string, then nothing is displayed where the bitmap pixels are 0;  this
produces a transparent effect.
.TP
\fB:bitmap \fIbitmap\fR
Specifies the bitmap to display in the item.
\fIBitmap\fR may have any of the forms accepted by \fBTk_GetBitmap\fR.
.TP
\fB:foreground \fIcolor\fR
Specifies a color to use for each of the bitmap pixels
whose value is 1.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR and
defaults to \fBblack\fR.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.

.SH "IMAGE ITEMS"
.PP
Items of type \fBimage\fR are used to display images on a
canvas.
Images are created with widget procedures of the following form:
.CS
(\fIwidget\-name '\fBcreate 'image \fIx y \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx\fR and \fIy\fR specify the coordinates of a
point used to position the image on the display (see the \fB:anchor\fR
option below for more information).
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for images:
.TP
\fB:anchor \fIanchorPos\fR
\fIAnchorPos\fR tells how to position the image relative to the
positioning point for the item;  it may have any of the forms
accepted by \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR
is \fBcenter\fR then the image is centered on the point;  if
\fIanchorPos\fR is \fBn\fR then the image will be drawn so that
its top center point is at the positioning point.
This option defaults to \fBcenter\fR.
.TP
\fB:image \fIname\fR
Specifies the name of the image to display in the item.
This image must have been created previously with the
\fBimage create\fR procedure.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item;  it may be an empty list.

.SH "LINE ITEMS"
.PP
Items of type \fBline\fR appear on the display as one or more connected
line segments or curves.
Lines are created with widget procedures of the following form:
.CS
(\fIwidget\-name '\fBcreate 'line \fIx1 y1... xn yn \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx1\fR through \fIyn\fR give
the coordinates for a series of two or more points that describe
a series of connected line segments.
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for lines:
.TP
\fB:arrow \fIwhere\fR
Indicates whether or not arrowheads are to be drawn at one or both
ends of the line.
\fIWhere\fR must have one of the values \fBnone\fR (for no arrowheads),
\fBfirst\fR (for an arrowhead at the first point of the line),
\fBlast\fR (for an arrowhead at the last point of the line), or
\fBboth\fR (for arrowheads at both ends).
This option defaults to \fBnone\fR.
.TP
\fB:arrowshape \fIshape\fR
This option indicates how to draw arrowheads.
The \fIshape\fR argument must be a list with three elements, each
specifying a distance in any of the forms described in
the COORDINATES section above.
The first element of the list gives the distance along the line
from the neck of the arrowhead to its tip.
The second element gives the distance along the line from the
trailing points of the arrowhead to the tip, and the third
element gives the distance from the outside edge of the line to the
trailing points.
If this option isn't specified then Tk picks a ``reasonable'' shape.
.TP
\fB:capstyle \fIstyle\fR
Specifies the ways in which caps are to be drawn at the endpoints
of the line.
\fIStyle\fR may have any of the forms accepted by \fBTk_GetCapStyle\fR
(\fBbutt\fR, \fBprojecting\fR, or \fBround\fR).
If this option isn't specified then it defaults to \fBbutt\fR.
Where arrowheads are drawn the cap style is ignored.
.TP
\fB:fill \fIcolor\fR
\fIColor\fR specifies a color to use for drawing the line; it may have
any of the forms acceptable to \fBTk_GetColor\fR.  It may also be an
empty string, in which case the line will be transparent.
This option defaults to \fBblack\fR.
.TP
\fB:joinstyle \fIstyle\fR
Specifies the ways in which joints are to be drawn at the vertices
of the line.
\fIStyle\fR may have any of the forms accepted by \fBTk_GetCapStyle\fR
(\fBbevel\fR, \fBmiter\fR, or \fBround\fR).
If this option isn't specified then it defaults to \fBmiter\fR.
If the line only contains two points then this option is
irrelevant.
.TP
\fB:smooth \fIboolean\fR
\fIBoolean\fR must have one of the forms accepted by \fBTk_GetBoolean\fR.
It indicates whether or not the line should be drawn as a curve.
If so, the line is rendered as a set of Bezier splines: one spline
is drawn for the first and second line segments, one for the second
and third, and so on.  Straight-line segments can be generated within
a curve by duplicating the end-points of the desired line segment.
.TP
\fB:splinesteps \fInumber\fR
Specifies the degree of smoothness desired for curves:  each spline
will be approximated with \fInumber\fR line segments.  This
option is ignored unless the \fB:smooth\fR option is true.
.TP
\fB:stipple \fIbitmap\fR
Indicates that the line should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR is an empty string (the default), then filling is
done in a solid fashion.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB:width \fIlineWidth\fR
\fILineWidth\fR specifies the width of the line, in any of the forms
described in the COORDINATES section above.
Wide lines will be drawn centered on the path specified by the
points.
If this option isn't specified then it defaults to 1.0.

.SH "OVAL ITEMS"
.PP
Items of type \fBoval\fR appear as circular or oval regions on
the display.  Each oval may have an outline, a fill, or
both.  Ovals are created with widget procedures of the
following form:
.CS
(\fIwidget\-name '\fBcreate 'oval \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of a
rectangular region enclosing the oval.
The oval will include the top and left edges of the rectangle
not the lower or right edges.
If the region is square then the resulting oval is circular;
otherwise it is elongated in shape.
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for ovals:
.TP
\fB:fill \fIcolor\fR
Fill the area of the oval with \fIcolor\fR.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string (the default), then
then the oval will not be filled.
.TP
\fB:outline \fIcolor\fR
\fIColor\fR specifies a color to use for drawing the oval's
outline;  it may have any of the forms accepted by \fBTk_GetColor\fR.
This option defaults to \fBblack\fR.
If \fIcolor\fR is an empty string then no outline will be
drawn for the oval.
.TP
\fB:stipple \fIbitmap\fR
Indicates that the oval should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If the \fB:fill\fR option hasn't been specified then this option
has no effect.
If \fIbitmap\fR is an empty string (the default), then filling is done
in a solid fashion.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB:width \fIoutlineWidth\fR
\fIoutlineWidth\fR specifies the width of the outline to be drawn around
the oval, in any of the forms described in the COORDINATES section above.
If the \fB:outline\fR option hasn't been specified then this option
has no effect.
Wide outlines are drawn centered on the oval path defined by
\fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR.
This option defaults to 1.0.

.SH "POLYGON ITEMS"
.PP
Items of type \fBpolygon\fR appear as polygonal or curved filled regions
on the display.
Polygons are created with widget procedures of the following form:
.CS
(\fIwidget\-name '\fBcreate 'polygon \fIx1 y1 ... xn yn \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx1\fR through \fIyn\fR specify the coordinates for
three or more points that define a closed polygon.
The first and last points may be the same;  whether they are or not,
Tk will draw the polygon as a closed polygon.
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for polygons:
.TP
\fB:fill \fIcolor\fR
\fIColor\fR specifies a color to use for filling the area of the
polygon; it may have any of the forms acceptable to \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string then the polygon will be
transparent.
This option defaults to \fBblack\fR.
.TP
\fB:outline \fIcolor\fR
\fIColor\fR specifies a color to use for drawing the polygon's
outline;  it may have any of the forms accepted by \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string then no outline will be
drawn for the polygon.
This option defaults to empty (no outline).
.TP
\fB:smooth \fIboolean\fR
\fIBoolean\fR must have one of the forms accepted by \fBTk_GetBoolean\fR
It indicates whether or not the polygon should be drawn with a
curved perimeter.
If so, the outline of the polygon becomes a set of Bezier splines,
one spline for the first and second line segments, one for the second
and third, and so on.  Straight-line segments can be generated in a
smoothed polygon by duplicating the end-points of the desired line segment.
.TP
\fB:splinesteps \fInumber\fR
Specifies the degree of smoothness desired for curves:  each spline
will be approximated with \fInumber\fR line segments.  This
option is ignored unless the \fB:smooth\fR option is true.
.TP
\fB:stipple \fIbitmap\fR
Indicates that the polygon should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR is an empty string (the default), then filling is
done in a solid fashion.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB:width \fIoutlineWidth\fR
\fIOutlineWidth\fR specifies the width of the outline to be drawn around
the polygon, in any of the forms described in the COORDINATES section above.
If the \fB:outline\fR option hasn't been specified then this option
has no effect.  This option defaults to 1.0.
.PP
Polygon items are different from other items such as rectangles, ovals
and arcs in that interior points are considered to be ``inside'' a
polygon (e.g. for purposes of the \fBfind closest\fR and
\fBfind overlapping\fR widget commands) even if it is not filled.
For most other item types, an
interior point is considered to be inside the item only if the item
is filled or if it has neither a fill nor an outline.  If you would
like an unfilled polygon whose interior points are not considered
to be inside the polygon, use a line item instead.

.SH "RECTANGLE ITEMS"
.PP
Items of type \fBrectangle\fR appear as rectangular regions on
the display.  Each rectangle may have an outline, a fill, or
both.  Rectangles are created with widget procedures of the
following form:
.CS
(\fIwidget\-name '\fBcreate 'rectangle \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of the rectangle
(the rectangle will include its upper and left edges but not
its lower or right edges).
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for rectangles:
.TP
\fB:fill \fIcolor\fR
Fill the area of the rectangle with \fIcolor\fR, which may be
specified in any of the forms accepted by \fBTk_GetColor\fR.
If \fIcolor\fR is an empty string (the default),
then the rectangle will not be filled.
.TP
\fB:outline \fIcolor\fR
Draw an outline around the edge of the rectangle in \fIcolor\fR.
\fIColor\fR may have any of the forms accepted by \fBTk_GetColor\fR.
This option defaults to \fBblack\fR.
If \fIcolor\fR is an empty string then no outline will be
drawn for the rectangle.
.TP
\fB:stipple \fIbitmap\fR
Indicates that the rectangle should be filled in a stipple pattern;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If the \fB:fill\fR option hasn't been specified then this option
has no effect.
If \fIbitmap\fR is an empty string (the default), then filling
is done in a solid fashion.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB:width \fIoutlineWidth\fR
\fIOutlineWidth\fR specifies the width of the outline to be drawn around
the rectangle, in any of the forms described in the COORDINATES section above.
If the \fB:outline\fR option hasn't been specified then this option
has no effect.
Wide outlines are drawn centered on the rectangular path
defined by \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR.
This option defaults to 1.0.

.SH "TEXT ITEMS"
.PP
A text item displays a string of characters on the screen in one
or more lines.
Text items support indexing and selection, along with the
following text-related canvas widget procedures:  \fBdchars\fR,
\fBfocus\fR, \fBicursor\fR, \fBindex\fR, \fBinsert\fR,
\fBselect\fR.
Text items are created with widget procedures of the following
form:
.CS
(\fIwidget\-name '\fBcreate 'text \fIx y \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx\fR and \fIy\fR specify the coordinates of a
point used to position the text on the display (see the options
below for more information on how text is displayed).
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for text items:
.TP
\fB:anchor \fIanchorPos\fR
\fIAnchorPos\fR tells how to position the text relative to the
positioning point for the text;  it may have any of the forms
accepted by \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR
is \fBcenter\fR then the text is centered on the point;  if
\fIanchorPos\fR is \fBn\fR then the text will be drawn such that
the top center point of the rectangular region occupied by the
text will be at the positioning point.
This option defaults to \fBcenter\fR.
.TP
\fB:fill \fIcolor\fR
\fIColor\fR specifies a color to use for filling the text characters;
it may have any of the forms accepted by \fBTk_GetColor\fR.
If this option isn't specified then it defaults to \fBblack\fR.
.TP
\fB:font \fIfontName\fR
Specifies the font to use for the text item.
\fIFontName\fR may be any string acceptable to \fBTk_GetFontStruct\fR.
If this option isn't specified, it defaults to a system-dependent
font.
.TP
\fB:justify \fIhow\fR
Specifies how to justify the text within its bounding region.
\fIHow\fR must be one of the values \fBleft\fR, \fBright\fR,
or \fBcenter\fR.
This option will only matter if the text is displayed as multiple
lines.
If the option is omitted, it defaults to \fBleft\fR.
.TP
\fB:stipple \fIbitmap\fR
Indicates that the text should be drawn in a stippled pattern
rather than solid;
\fIbitmap\fR specifies the stipple pattern to use, in any of the
forms accepted by \fBTk_GetBitmap\fR.
If \fIbitmap\fR is an empty string (the default) then the text
is drawn in a solid fashion.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB:text \fIstring\fR
\fIString\fR specifies the characters to be displayed in the text item.
Newline characters cause line breaks.
The characters in the item may also be changed with the
\fBinsert\fR and \fBdelete\fR widget procedures.
This option defaults to an empty string.
.TP
\fB:width \fIlineLength\fR
Specifies a maximum line length for the text, in any of the forms
described in the COORDINATES section above.
If this option is zero (the default) the text is broken into
lines only at newline characters.
However, if this option is non-zero then any line that would
be longer than \fIlineLength\fR is broken just before a space
character to make the line shorter than \fIlineLength\fR;  the
space character is treated as if it were a newline
character.

.SH "WINDOW ITEMS"
.PP
Items of type \fBwindow\fR cause a particular window to be displayed
at a given position on the canvas.
Window items are created with widget procedures of the following form:
.CS
(\fIwidget\-name '\fBcreate 'window \fIx y \fR?\fIoption value option value ...\fR?)
.CE
The arguments \fIx\fR and \fIy\fR specify the coordinates of a
point used to position the window on the display (see the \fB:anchor\fR
option below for more information on how bitmaps are displayed).
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget procedures to change the item's
configuration.
The following options are supported for window items:
.TP
\fB:anchor \fIanchorPos\fR
\fIAnchorPos\fR tells how to position the window relative to the
positioning point for the item;  it may have any of the forms
accepted by \fBTk_GetAnchor\fR.  For example, if \fIanchorPos\fR
is \fBcenter\fR then the window is centered on the point;  if
\fIanchorPos\fR is \fBn\fR then the window will be drawn so that
its top center point is at the positioning point.
This option defaults to \fBcenter\fR.
.TP
\fB:height \fIpixels\fR
Specifies the height to assign to the item's window.
\fIPixels\fR may have any of the
forms described in the COORDINATES section above.
If this option isn't specified, or if it is specified as an empty
string, then the window is given whatever height it requests internally.
.TP
\fB:tags \fItagList\fR
Specifies a set of tags to apply to the item.
\fITagList\fR consists of a list of tag names, which replace any
existing tags for the item.
\fITagList\fR may be an empty list.
.TP
\fB:width \fIpixels\fR
Specifies the width to assign to the item's window.
\fIPixels\fR may have any of the
forms described in the COORDINATES section above.
If this option isn't specified, or if it is specified as an empty
string, then the window is given whatever width it requests internally.
.TP
\fB:window \fIwidget\-name\fR
Specifies the window to associate with this item.
The window specified by \fIwidget\-name\fR must either be a child of
the canvas widget or a child of some ancestor of the canvas widget.
\fIPathName\fR may not refer to a top-level window.

.SH "APPLICATION-DEFINED ITEM TYPES"
.PP
It is possible for individual applications to define new item
types for canvas widgets using C code.
See the documentation for \fBTk_CreateItemType\fR.


.SH BINDINGS
.PP
In the current implementation, new canvases are not given any
default behavior:  you'll have to execute explicit STk procedures
to give the canvas its behavior.

.SH CREDITS
.PP
Tk's canvas widget is a blatant ripoff of ideas from Joel Bartlett's
\fIezd\fR program.  \fIEzd\fR provides structured graphics in a Scheme
environment and preceded canvases by a year or two.  Its simple
mechanisms for placing and animating graphical objects inspired the
functions of canvases.

