#!/usr/bin/perl
#  cat2-col.pl - Graphs expenses by category
#
#  Modified by Arlindo L. Oliveira (aml@inesc.pt)
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: cat2-col.pl,v 2.5 1997/05/06 02:33:51 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;    # don't take no guff

my($tmp, $temp, $cbb_incl_dir);
my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my($credit_total, $debit_total, $amt, $lkey, $lcat, $subtotal);
my($tcom, $tamt, $tcat);
my(@keys, %ALLTRANS, @splits);
my($graphpath, $account, $name, $result);


# return the directory of a file name (this is duplicated in common.pl
# but we need this to find the include directory for common.pl :-(
sub my_file_dirname {
    my($file) = @_;
    my($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
	return substr($file, 0, ($pos + 1));
    } else { 
	return "./"; 
    }
}

# specify the installed location of the necessary pieces.
$temp = &my_file_dirname($0); chop($temp);
$cbb_incl_dir = &my_file_dirname($temp);
unshift(@INC, $cbb_incl_dir);

$graphpath = "/usr/ports/misc/cbb/work/fake-amiga/usr/local/share/cbb/graphs";

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || die "Usage: report [ -from date ] [ -to date] accounts";


# process arguments

my($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

my(%tmp_cat) = ();

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $amt = $credit - $debit;

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

            $ALLTRANS{"$key$name"} = $result;

            if ( substr($cat, 0, 1) ne "|" ) {
                $tmp_cat{$cat} .= "$key$name" . "," . $amt . ",";
            } else {
                # process split

                @splits = split(/\|/, $cat);
                shift(@splits);

                $tmp = 0;
                while ( $#splits >= 0 ) {
                    $tcat = shift(@splits);
                    $tcom = shift(@splits);
                    $tamt = shift(@splits);

                    $tmp += $tamt;

                    # print "processing $tcat $tamt\n";
                    $tmp_cat{$tcat} .= "$key$name" . "," . $tamt . ",";
                }
                if ( sprintf("%.2f", $tmp) ne sprintf("%.2f", $amt) ) {
                    printf("WARNING:  Incorrect splits in $date: $desc\n");
                    printf("    %.2f != %.2f\n\n", $tmp, $amt);
                }
            }
        }

        $result = &next_trans();
    }
}


$credit_total = 0.00;
$debit_total = 0.00;

if ( ! -x "$graphpath/graphcolpos") {
    die "Cannot launch $graphpath/graphcolpos\n";
}

open(DATA,"| $graphpath/graphcolpos") || die "Cannot launch graph\n";

foreach $lcat (sort keys(%tmp_cat)) {
    
    chop($tmp_cat{$lcat});  # Delete final comma

    @keys = split(/,/, $tmp_cat{$lcat});

    $subtotal = 0.00;

    while ( $#keys >= 0 ) {
        $lkey = shift(@keys);
        $amt  = shift(@keys);

        $result = $ALLTRANS{$lkey};

        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/\t/, $result);

        $subtotal = $subtotal + $amt;
        if ( $amt > 0 ) {
            $credit_total = $credit_total + $amt;
        } else {
            $debit_total = $debit_total + $amt;
        }

    }

    $lcat =~ s/ /-/g;
    print DATA "$lcat $subtotal\n";
    # printf(" = %9.2f\n", $subtotal);
}

close(DATA);


# ----------------------------------------------------------------------------
# $Log: cat2-col.pl,v $
# Revision 2.5  1997/05/06 02:33:51  curt
# Added "require memorized".
#
# Revision 2.4  1997/01/28 03:25:41  curt
# Force strict scoping in all perl scripts.
#
# Revision 2.3  1996/12/13 01:25:18  curt
# Updated paths, modified to work with reports.tcl
#
# Revision 2.2  1996/07/13 02:58:33  curt
# Misc. changes.
#
# Revision 2.1  1996/02/27  05:36:12  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:21  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
