; Copyright (c) 1993, 1994 Richard Kelsey and Jonathan Rees.  See file COPYING.

; Added really-ensure-loaded proc, which gives you noise control.
; 	-Olin 6/95.

(define (ensure-loaded . structs)		; S48 default is noisily.
  (apply really-ensure-loaded
	 (current-output-port)	; Should this be error port?
	 structs))

(define (really-ensure-loaded noise . structs)
  (really-scan-structures structs noise
			  (lambda (p) (not (package-loaded? p)))
    (lambda (stuff p)  ;stuff = pair (file . (node1 node2 ...))
      (really-noting-undefined-variables p noise
        (lambda ()
	  (with-interaction-environment p
	    (lambda ()
	      (for-each (lambda (filename+scanned-forms)
			  (really-eval-scanned-forms
			      (cdr filename+scanned-forms)
			      p
			      (car filename+scanned-forms)
			      noise))
			stuff)
	      (set-package-loaded?! p #t))))))))
