#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10478);

 name["english"] = "Tomcat's snoop servlet gives too much information";
 name["francais"] = "Le servlet snoop de Tomcat donne trop d'informations";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The 'snoop' tomcat's servlet is installed.
(/examples/jsp/snp/anything.snp)

This servlet gives too much information about 
the remote host, such as the PATHs in use,
the host kernel version and so on...

This allows an attacker to gain more knowledge
about this host, and make more precise attacks
thanks to this.

Solution : delete this servlet

Risk factor : Low";


 desc["francais"] = "
Le servlet 'snoop' est install
(/examples/jsp/snp/anything.snp)

Ce servlet donne trop d'informations
sur l'hote distant, comme les PATHs
utiliss, la version du kernel, etc, etc...

Ces informations donnent  un pirate plus
de connaissances vis  vis de cette machine,
lui permettant ainsi de mener des attaques
plus prcises.

Solution : effacez ce servlet
Facteur de risque : Faible";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /examples/jsp/snp/anything.snp";
 summary["francais"] = "Vrifie la prsence de /examples/jsp/snp/anything.snp";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 8080);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 8080;

soc = open_sock_tcp(port);
if(soc)
{
 req = string("GET /examples/jsp/snp/anything.snp HTTP/1.0\r\n\r\n");
 send(socket:soc, data:req);
 r = recv(socket:soc, length:8192);
 close(soc);
 if("HTTP/1.0 200 OK" >< r)
 {
  if("Server Info: Tomcat" >< r)
  {
   security_warning(port);
  }
 }
}
