#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10503);

 name["english"] = "Reading CGIs sources using /cgi-bin-sdb";
 name["francais"] = "Lecture des sources des CGIs grace  /cgi-bin-sdb";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The directory /cgi-bin-sdb is an Alias to
/cgi-bin - most SuSE systems are configured that
way.

This setting allows an attacker to obtain the source
code of the installed CGIs of this server. This is 
dangerous as it gives more knowledge about the setup
of this host or even to gain more access if your CGIs 
contain hardcoded usernames and passwords.


Solution : Change, in httpd.conf, the directive 
Alias /cgi-bin-sdb/ /usr/local/httpd/cgi-bin/
to
ScriptAlias /cgi-bin-sdb/ /usr/local/httpd/cgi-bin/
Risk factor : Serious";



 desc["francais"] = "
Le dossier /cgi-bin/sdb est un Alias vers
/cgi-bin - ce qui est la configuration de la 
plupart des SuSE.

Ce paramtre permet a un pirate d'obtenir
le code source des CGIs installs sur ce
serveur. C'est dangereux dans le sens o 
cela lui donne plus d'informations sur
l'organisation de cette machine, ou meme
d'obtenir un accs plus privilgi sur
ce serveur si le CGI contient des
noms d'utilisateurs ou mots de passe cods
en dur.

Solution : Changez, dans httpd.conf, la directive
Alias /cgi-bin-sdb/ /usr/local/httpd/cgi-bin/
en
ScriptAlias /cgi-bin-sdb/ /usr/local/httpd/cgi-bin/
Facteur de risque : Srieux";




 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin-sdb/";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/sdb/";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port) port = 80;

if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  # First try : attempt to get printenv
  req = string("GET /cgi-bin-sdb/printenv HTTP/1.0\r\n\r\n");
  send(socket:soc, data:req);
  r = recv(socket:soc, length:2048);
  close(soc);
  if("/usr/bin/perl" >< r)
  {
  	security_hole(port);
	exit(0);
  }
  
  soc = open_sock_tcp(port);
  req = string("GET /cgi-bin/sdb/sdbsearch.cgi HTTP/1.0\r\n\r\n");
  send(socket:soc, data:req);
  r = recv_line(socket:soc, length:2048);
  close(soc);
  if("HTTP/1.1 403 " >< r){
  	security_hole(port);
	exit(0);
	}
 }
}
