#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
  script_id(10514);
  
  name["english"] = "Directory listing through Sambar's search.dll";
  name["francais"] = "Listing du contenu d'un repertoire avec search.dll de Sambar";

  script_name(english:name["english"], francais:name["francais"]);
  desc["english"] = "
It is possible to retrieve the listing of the remote 
directories accessible via HTTP, rather than their index.html, 
using the search.dll CGI that comes with the Sambar server.

This problem allows an attacker to gain more knowledge
about the remote host, and may make him aware of hidden
HTML files.

Solution : disable the search.dll CGI, or upgrade to Sambar 4.4b4
Risk factor : Low";

  desc["francais"] = "
Il est possible d'obtenir la liste du contenu des repertoires
distants accessibles par HTTP, plutot que leur fichier index.html,
en utilisant le module search.dll de Sambar.

 Ce problme permet  un pirate d'obtenir plus d'informations
sur la machine attaque, ainsi que de dcouvrir la prsence de
fichiers HTML cachs.

Solution : dsactivez ce CGI ou mettez Sambar  jour en 4.4b4";

 script_description(english:desc["english"], francais:desc["francais"]);

 summary["english"] = "Checks the presence of search.dll";
 summary["francais"] = "Vrifie la prsence de search.dll";
 script_summary(english:summary["english"], francais:summary["francais"]);
 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
     	 	  francais:"Ce script est Copyright (C) 2000 Renaud Deraison");

 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";

 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}
port = get_kb_item("Services/www");
if(!port) port = 80;

if(get_port_state(port))
{
  soc = open_sock_tcp(port);
  if(soc)
  {

  req = string("GET /search.dll?query=%00&logic=AND HTTP/1.0\r\n\r\n");
  send(socket:soc, data:req);
  result = recv_line(socket:soc, length:2048);
  r = recv(socket:soc, length:10496);
  close(soc);
  if("HTTP/1.1 200 " >< result)
   {
    quote = raw_string(0x22);
    expect = string("A HREF=", quote, "/");
    if(expect >< r)security_warning(port);
   }
  }
}
