#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10156);
 script_cve_id("CVE-1999-0239");
 name["english"] = "Netscape FastTrack 'get'";
 name["francais"] = "Netscape FastTrack 'get'";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The remote web server returns
a directory listing, rather than the index.html
file content, when it is issued a lower-cased 'get'
command.
Exemple :

		get / HTTP/1.0
		
Will return the listing of the root directory.

This problem allows an intruder to find hidden
files on your web server.

Solution : Upgrade your server to the latest version.

Risk factor : Medium";


 desc["francais"] = "Le serveur web distant
renvoie le listing du contenu d'un dossier
plutot que le contenu du fichier index.html
situ dans ce dossier lorsqu'on lui envoie
une commande 'get' en minuscules.
Exemple :
		get / HTTP/1.0

Renverra la liste des fichiers contenus dans
le repertoire racine distant.

Ce problme permet  un pirate de dcouvrir
des fichiers cachs sur votre serveur.

Solution : Mettez  jour votre serveur web.

Facteur de risque : Moyen";
 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "'get / ' gives a directory listing";
 summary["francais"] = "'get / ' donne un listing du dossier";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
soc = open_sock_tcp(port);
if(soc)
{
  d = string("GET / HTTP/1.0\r\n\r\n");
  send(socket:soc, data:d);
  r = recv(socket:soc, length:1024);
  close(soc);
  r2 = tolower(r);
  bad = "<title>index of /</title>";
  if(bad >< r2)exit(0);
  soc = open_sock_tcp(port);
  d = string("get / HTTP/1.0\r\n\r\n");
  send(socket:soc, data:d);
  r = recv(socket:soc, data:d);
  close(soc);
  r2 = tolower(r2);
  if(bad >< r2)security_hole(port);
}
