/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontMetrics;
import java.awt.Graphics;

class TextBuffer {
    static int defLen = 128;
    char[] buf;
    int len;
    int tabWidth;
    FontMetrics fm;

    public void append(String string) {
        this.insert(this.len, string);
    }

    public void append(TextBuffer textBuffer) {
        this.checkCapacity(this.len + textBuffer.len);
        int n = 0;
        while (n < textBuffer.len) {
            this.buf[this.len++] = textBuffer.buf[n];
            ++n;
        }
    }

    public void append(char c) {
        this.insert(this.len, c);
    }

    void checkCapacity(int n) {
        if (n <= this.buf.length) {
            return;
        }
        int n2 = this.buf.length + defLen;
        if (n > n2) {
            n2 = n;
        }
        char[] cArray = this.buf;
        this.buf = new char[n2];
        System.arraycopy(cArray, 0, this.buf, 0, cArray.length);
    }

    public void copyLevelFrom(TextBuffer textBuffer) {
        int n = textBuffer.getLevel();
        int n2 = this.getLevel();
        int n3 = 0;
        while (n3 < n - n2) {
            this.insert(0, '\t');
            ++n3;
        }
    }

    public int getIdx(int n) {
        return this.getIdxFrom(0, n);
    }

    /*
     * Unable to fully structure code
     */
    public int getIdxFrom(int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = 0;
            if (var2_2 >= 0) ** GOTO lbl18
            if (var3_3 == 0) {
                return 0;
            }
            --var3_3;
            while (var3_3 >= 0) {
                var4_4 = this.buf[var3_3] == '\t' ? (var4_4 + this.tabWidth) / this.tabWidth * this.tabWidth : (var4_4 += this.fm.charWidth(this.buf[var3_3]));
                if (-var4_4 < var2_2) {
                    return var3_3;
                }
                --var3_3;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                var4_4 = this.buf[var3_3] == '\t' ? (var4_4 + this.tabWidth) / this.tabWidth * this.tabWidth : (var4_4 += this.fm.charWidth(this.buf[var3_3]));
                if (var4_4 > var2_2) {
                    return var3_3;
                }
                ++var3_3;
lbl18:
                // 2 sources

                ** while (var3_3 < this.len)
            }
        }
        return var3_3;
    }

    public int getLevel() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.len) {
            if (this.buf[n2] != '\t') break;
            ++n;
            ++n2;
        }
        return n;
    }

    public int getPos(int n) {
        int n2 = 0;
        if (n > this.len) {
            n = this.len;
        }
        int n3 = 0;
        while (n3 < n) {
            n2 = this.buf[n3] == '\t' ? (n2 + this.tabWidth) / this.tabWidth * this.tabWidth : (n2 += this.fm.charWidth(this.buf[n3]));
            ++n3;
        }
        return n2;
    }

    public String getString(int n, int n2) {
        if (this.len < n + n2) {
            n2 = this.len - n;
        }
        if (n2 > 0) {
            return new String(this.buf, n, n2);
        }
        return null;
    }

    public int getWidth() {
        int n = this.getPos(0);
        int n2 = this.getPos(this.len);
        return n2 - n;
    }

    public int getWidth(int n, int n2) {
        int n3 = this.getPos(n);
        int n4 = this.getPos(n2);
        return n4 - n3;
    }

    public void insert(int n, String string) {
        this.replace(n, 0, string);
    }

    public void insert(int n, char c) {
        this.replace(n, 0, c);
    }

    public static void main(String[] stringArray) {
        TextBuffer textBuffer = new TextBuffer();
        textBuffer.append("12356789");
        System.out.println(textBuffer);
        textBuffer.insert(3, '4');
        System.out.println(textBuffer);
        textBuffer.replace(3, 2, "xxxxxxxx");
        System.out.println(textBuffer);
        textBuffer.replace(3, 8, "45");
        System.out.println(textBuffer);
        textBuffer.remove(0, 2);
        System.out.println(textBuffer);
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        this.paint(graphics, n, n2, n3, 0, this.len);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        this.paint(graphics, n, n2, n3, n4, this.len - n4);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getPos(n4);
        int n7 = n4;
        int n8 = n4;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics();
            this.tabWidth = 4 * this.fm.charWidth('x');
        }
        int n9 = n2 + n3 - (n3 - this.fm.getHeight()) / 2 - this.fm.getDescent();
        if (this.len < n4 + n5) {
            n5 = this.len - n4;
        }
        while (n8 < n4 + n5) {
            if (this.buf[n8] == '\t') {
                if (n8 > n7) {
                    graphics.drawChars(this.buf, n7, n8 - n7, n + n6, n9);
                    n6 += this.fm.charsWidth(this.buf, n7, n8 - n7);
                }
                n7 = n8 + 1;
                n6 = (n6 + this.tabWidth) / this.tabWidth * this.tabWidth;
            }
            ++n8;
        }
        if (n7 < n8) {
            graphics.drawChars(this.buf, n7, n8 - n7, n + n6, n9);
        }
    }

    public void paintFrom(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n5;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics();
            this.tabWidth = 4 * this.fm.charWidth('x');
        }
        int n9 = this.getWidth(n4, n5);
        int n10 = n2 + n3 - (n3 - this.fm.getHeight()) / 2 - this.fm.getDescent();
        if (this.len < n5 + n6) {
            n6 = this.len - n5;
        }
        while (n8 < n5 + n6) {
            if (this.buf[n8] == '\t') {
                if (n8 > n7) {
                    graphics.drawChars(this.buf, n7, n8 - n7, n + n9, n10);
                    n9 += this.fm.charsWidth(this.buf, n7, n8 - n7);
                }
                n7 = n8 + 1;
                n9 = (n9 + this.tabWidth) / this.tabWidth * this.tabWidth;
            }
            ++n8;
        }
        if (n7 < n8) {
            graphics.drawChars(this.buf, n7, n8 - n7, n + n9, n10);
        }
    }

    public void remove(int n, int n2) {
        if (n > this.len || n2 <= 0) {
            return;
        }
        int n3 = this.len - n - n2;
        if (n3 > 0) {
            System.arraycopy(this.buf, n + n2, this.buf, n, n3);
        }
        this.len -= n2;
    }

    public void replace(int n, int n2, String string) {
        int n3 = string != null ? string.length() : 0;
        int n4 = n3 - n2;
        this.checkCapacity(this.len + n4);
        int n5 = n + n2;
        System.arraycopy(this.buf, n5, this.buf, n5 + n4, this.len - n5);
        if (string != null) {
            string.getChars(0, n3, this.buf, n);
        }
        this.len += n4;
    }

    public void replace(int n, int n2, char c) {
        int n3 = 1 - n2;
        this.checkCapacity(this.len + n3);
        int n4 = n + n2;
        System.arraycopy(this.buf, n4, this.buf, n4 + n3, this.len - n4);
        this.buf[n] = c;
        this.len += n3;
    }

    public void set(String string) {
        if (string == null || string.length() == 0) {
            this.len = 0;
        } else {
            int n = string.length();
            this.checkCapacity(n);
            string.getChars(0, n, this.buf, 0);
            this.len = n;
        }
    }

    public void set(char c, int n) {
        this.checkCapacity(n);
        this.len = 0;
        while (this.len < n) {
            this.buf[this.len] = c;
            ++this.len;
        }
    }

    public void setMetrics(FontMetrics fontMetrics, int n) {
        this.fm = fontMetrics;
        this.tabWidth = n;
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public TextBuffer() {
        this(defLen);
    }

    public TextBuffer(String string) {
        this(defLen);
        this.append(string);
    }

    public TextBuffer(int n) {
        this.buf = new char[n];
    }
}

