// -*- c++ -*-
//  Generated by gtkmmproc from ./../pixmap.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_PIXMAP_H
#define _GTKMM_PIXMAP_H

/* $Id: pixmap.gen_h,v 1.66 2000/04/06 16:41:15 kenelson Exp $ */


/* pixmap.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/misc.h>
#include <gtk/gtkpixmap.h>
#include <gtk--/base.h>

namespace Gtk {
class Pixmap;
class Pixmap_Class;
}
namespace Gtk { Gtk::Pixmap *wrap (GtkPixmap *o); }
namespace Gtk
{
class Pixmap : public Misc {

public:
  typedef Pixmap          CppObjectType;
  typedef Pixmap_Class    CppClassType;
  typedef GtkPixmap           BaseObjectType;
  typedef GtkPixmapClass      BaseClassType;

private:
  friend CppClassType;
  static CppClassType pixmap_class;

  Pixmap(const Pixmap&);
  Pixmap& operator=(const Pixmap&); // not implemented

protected:
  void   initialize_class();
  explicit Pixmap(GtkPixmap *castitem);

public:
  static GtkType get_type();
  GtkPixmap* gtkobj()             { return (GtkPixmap*)(gtkobject); }
  const GtkPixmap* gtkobj() const { return (GtkPixmap*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Pixmap();

private:

public:

  //: Construct an empty pixmap.
  //- Note that default constructor puts Pixmap objects to invalid
  //- state and you should not show it or add it to containers
  //- before you've set() the pixmap and mask for it.
  Pixmap();

  //: Load a pixmap form file.
  Pixmap(const nstring &xpmfilename);

  //: Create a pixmap from data.
  //- data must live until Pixmap is realized
  Pixmap(const gchar * const *data);

  //: Create using specified {pixmap} and {mask}.
  Pixmap(const Gdk_Pixmap &pixmap,
	     const Gdk_Bitmap &mask);



  //: Set the {pixmap} and border {mask}.



  void set(const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask);

  void set(const gchar * const *data);
  void set(const string &xpmfilename);

  //: Get the {pixmap} and border {mask}.
  //- works only following realization.
  void get(Gdk_Pixmap &pixmap,
	   Gdk_Bitmap &mask) const;

  //: (Gtk 1.1) Build an special pixmap for insensitive states.
  //- Setting this switch will cause Gtk to build a greyed out
  //- version on the specified {pixmap}.

  void set_build_insensitive(bool build);


protected:
  virtual void realize_impl();
  void load_xpm();
  void unset();

  // These are not caches.
  nstring xpm_file_name_;
  const gchar * const *data_;

public:

protected:
  // impl functions

};

}


//+ PROPERTIES(Gtk_Pixmap)
//. name: pixmap
//. type: Gdk_Pixmap
//. get: {get()}
//. set: {set()}
//. desc: Pixmap to be displayed normally.

//. name: mask
//. type: Gdk_Bitmap
//. get: {get()}
//. set: {set()}
//. desc: Mask defining outlines of pixmap.

//. name: pixmap_insensitive
//. type: Gdk_Pixmap
//. get:
//. set:
//. desc: (Gtk 1.1) The pixmap used when the widget is in the insensitive
//.  state.  This is a cache and is not directly setable.

//. name: build_insensitive
//. type: bool
//. get:
//. set: {build_insensitive()}
//. desc: (Gtk 1.1) Specifies that Gtk is to create a greyed out version
//. of {pixmap} to use in insensitive states.

#endif
