// -*- c++ -*-
//  Generated by gtkmmproc from ./../box.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_BOX_H
#define _GTKMM_BOX_H

/* $Id: box.gen_h,v 1.70 2000/05/14 18:48:19 kenelson Exp $ */


/* box.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/container.h>
#include <gtk/gtkbox.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>

namespace Gtk {
class Box;
class Box_Class;
}
namespace Gtk { Gtk::Box *wrap (GtkBox *o); }
namespace Gtk {
class VBox;
class VBox_Class;
}
namespace Gtk { Gtk::VBox *wrap (GtkVBox *o); }
namespace Gtk {
class HBox;
class HBox_Class;
}
namespace Gtk { Gtk::HBox *wrap (GtkHBox *o); }
namespace Gtk
{

namespace Box_Helpers
{
  class Child : protected _GtkBoxChild
    {
      public:
        inline _GtkBoxChild* gtkobj() {return (this);}
        inline const _GtkBoxChild* gtkobj() const {return (this);}

      private:
        Child& operator=(const Child&);
        Child(const Child&);

      protected:
        Child(void* do_not_derive_this);

        inline GtkBox* parent()
          {return GTK_BOX(gtkobj()->widget->parent);}
        void redraw();

      public:
        Widget* get_widget() const;

        inline guint16 get_padding() const   { return (gtkobj()->padding); }
        inline bool get_expand() const       { return (gtkobj()->expand); }
        inline bool get_fill() const         { return (gtkobj()->fill); }
        inline bool get_pack() const         { return (gtkobj()->pack); }

        void set_options(bool expand,bool fill,guint padding);
        void set_pack(GtkPackType pack);
    };

  struct Element
    {
      Widget* widget_;
      bool expand_;
      bool fill_;
      guint padding_;
      GtkPackType pack_;

      Element(Widget& widget,
              bool expand=true,
              bool fill=true,
              guint padding=0,
              GtkPackType pack=GTK_PACK_START)
          : widget_(&widget),expand_(expand),fill_(fill),
            padding_(padding),pack_(pack)
        {}
    };

  typedef Element StartElem;

  struct EndElem : public Element
    {
      EndElem(Widget& widget,
              bool expand=true,
              bool fill=true,
              guint padding=0)
          : Element (widget,expand,fill,padding,GTK_PACK_END)
        {}
    };

  class BoxList
    {
      public:
        typedef Child*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Iterator<value_type>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend Box;
        Box *parent_;
        explicit BoxList(Box* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~BoxList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

        iterator insert(iterator position, const Element& e);
        template <class InputIterator>
        inline void insert(iterator position, InputIterator first, InputIterator last)
          { for (;first!=last;++first) position=insert(position,*first); }

        inline void push_front(const Element& e) { insert(begin(), e); }
        inline void push_back(const Element& e)  { insert(end(), e); }
        inline void pop_front()                  { erase(begin()); }
        inline void pop_back()                   { erase(--end()); }

        void clear();

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);

        iterator find(const_reference c);
        iterator find(Widget&);

        void remove(Widget& w);

        // Non-standard
        void reorder(iterator loc,iterator pos);
     };
};

//: Abstract base class for horizontal and vertical boxes
//- {Gtk::Box::} is an abstract class and it defers choice of which
//- way the widgets are packed to the screen to the derived classes.
//- {Gtk::Box::} provides common interface for inserting widgets
//- to a box indepenently of how it is shown in the screen.
//-
//- The most common use of {Gtk::Box::} is like this:
//- {\example
//-
//- class mywindow : public Gtk_Window {
//-    Gtk_Label label1,label2;
//-    Gtk_VBox vbox;
//- public:
//-    mywindow();
//- };
//- mywindow::mywindow()
//- {
//-    add(vbox);
//-    vbox.pack_end(label1, true, true, 0);
//-    vbox.pack_end(label2, true, true, 0);
//- }
//-
//- }
class Box : public Container {

public:
  typedef Box          CppObjectType;
  typedef Box_Class    CppClassType;
  typedef GtkBox           BaseObjectType;
  typedef GtkBoxClass      BaseClassType;

private:
  friend CppClassType;
  static CppClassType box_class;

  Box(const Box&);
  Box& operator=(const Box&); // not implemented

protected:
  void   initialize_class();
  explicit Box(GtkBox *castitem);

public:
  static GtkType get_type();
  GtkBox* gtkobj()             { return (GtkBox*)(gtkobject); }
  const GtkBox* gtkobj() const { return (GtkBox*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Box();

private:

public:

  typedef Box_Helpers::BoxList BoxList;




  //: left side insert a widget to a box.
  //- The expand argument to {pack_start()} or {pack_end()}
  //- controls whether the widgets are laid out in the box to {fill} in all
  //- the extra space in the box so the box is expanded to fill the area
  //- alloted to it ({\key true}). Or the box is shrunk to just fit the widgets
  //- ({\key false}).  Setting {expand} to {\key false} will allow you
  //- to do right and left
  //- justifying of your widgets.  Otherwise, they will all expand to fit in
  //- the box, and the same effect could be achieved by using only one of
  //- {pack_start()} or {pack_end()} functions.
  //-
  //- The fill argument to the {pack_start()}/{pack_end()} functions control whether the
  //- extra space is allocated to the objects themselves ({\key true}), or as extra
  //- padding in the box around these objects ({\key false}). It only has an effect
  //- if the {expand} argument is also {\key true}.
  //-
  //- The difference between spacing (set when the box is created)
  //- and {padding} (set when elements are packed), spacing is added between
  //- objects, and {padding} is added on either side of an object.





  void pack_start(Gtk::Widget& child,bool expand=true,bool fill=true,guint padding=0);

  //: right side insert a widget to a box.





  void pack_end(Gtk::Widget& child,bool expand=true,bool fill=true,guint padding=0);

  //: Change box child sizing policy.
  //- allows setting homongeneous afterwards. This is usually given on
  //- {Gtk::VBox::VBox()} or {Gtk::HBox::HBox()}


  void set_homogeneous(bool homogeneous);

  //: Change spacing between children.


  void set_spacing(gint spacing);

  //: Reorder children by integer index.


  void reorder_child(Gtk::Widget& child,gint pos);


// Horrible interface use new one
// void query_child_packing             (Gtk_Widget &child,
//					bool         *expand,
//					bool         *fill,
//					guint        *padding,
//					GtkPackType  *pack_type) const;
// void set_child_packing               (Gtk_Widget &child,
//					bool         expand,
//					bool         fill,
//					guint        padding,
//					GtkPackType  pack_type);
  BoxList& children()
    {return reinterpret_cast<BoxList&>(widget_self); }
  const BoxList& children() const
    {return reinterpret_cast<const BoxList&>(widget_self); }

protected:
  Box();

public:

protected:
  // impl functions

};


//: Vertical Box for laying widgets in a vertical row.
//- You should create these objects, but it is more confortable to
//- pass around pointers of {Gtk::Box::}. All the methods that do anything
//- are in {Gtk::Box::} class and this allows you to later change
//- the direction of the box, when there's no dependencies to hbox and
//- vbox classes.
//-
//- See {Gtk::Box::}.
class VBox : public Box
{

public:
  typedef VBox          CppObjectType;
  typedef VBox_Class    CppClassType;
  typedef GtkVBox           BaseObjectType;
  typedef GtkVBoxClass      BaseClassType;

private:
  friend CppClassType;
  static CppClassType vbox_class;

  VBox(const VBox&);
  VBox& operator=(const VBox&); // not implemented

protected:
  void   initialize_class();
  explicit VBox(GtkVBox *castitem);

public:
  static GtkType get_type();
  GtkVBox* gtkobj()             { return (GtkVBox*)(gtkobject); }
  const GtkVBox* gtkobj() const { return (GtkVBox*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~VBox();

private:

public:

  //: Create a vertical packing box.
  //- See {Gtk::HBox::HBox()}.
  VBox(bool homogeneous=false, gint spacing=0);

public:

protected:
  // impl functions

};

//: Horizontal Box for laying widgets in a horizontal row.
//- You should create these objects, but it is more confortable to
//- pass around pointers of {Gtk::Box::}. All the methods that do anything
//- are in {Gtk::Box::} class and this allows you to later change
//- the direction of the box, when there's no dependencies to hbox and
//- vbox classes.
//-
//- Use the {\class GtkBox} packing interface to determine the arrangement,
//- spacing, width, and alignment of GtkHBox children.
//-
//- All children are allocated the same height.
//-
//- See {Gtk::Box::}.
class HBox : public Box
{

public:
  typedef HBox          CppObjectType;
  typedef HBox_Class    CppClassType;
  typedef GtkHBox           BaseObjectType;
  typedef GtkHBoxClass      BaseClassType;

private:
  friend CppClassType;
  static CppClassType hbox_class;

  HBox(const HBox&);
  HBox& operator=(const HBox&); // not implemented

protected:
  void   initialize_class();
  explicit HBox(GtkHBox *castitem);

public:
  static GtkType get_type();
  GtkHBox* gtkobj()             { return (GtkHBox*)(gtkobject); }
  const GtkHBox* gtkobj() const { return (GtkHBox*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~HBox();

private:

public:

  //: Creates a new horizontal box
  //- The {homogeneous} argument to  controls whether each object
  //- in the box has the same
  //- size (i.e. the same width in an hbox, or the same height in a
  //- vbox). If it is set, the expand argument to the gtk_box_pack routines
  //- is always turned on.
  //-
  //- {spacing} determines width between children.
  HBox(bool homogeneous=false, gint spacing=0);

  //- See {page docs/castitem}

public:

protected:
  // impl functions

};


}


//+ PROPERTIES(Gtk_Box)
//. name: children
//. type: GList*
//. get:
//. set:
//. desc:

//. name: spacing
//. type: gint16
//. get:
//. set:
//. desc:

//. name: homogeneous
//. type: guint:1
//. get:
//. set:
//. desc:

#endif
