require '_h2ph_pre.ph';

require 'sys/termios.ph';
require 'sys/select.ph';
require 'sys/queue.ph';
require 'sys/timeout.ph';
unless(defined(&REAL_CLISTS)) {
} else {
}
unless(defined(&t_cc)) {
    sub t_cc () {	 ($t_termios->{c_cc});}
}
unless(defined(&t_cflag)) {
    sub t_cflag () {	 ($t_termios->{c_cflag});}
}
unless(defined(&t_iflag)) {
    sub t_iflag () {	 ($t_termios->{c_iflag});}
}
unless(defined(&t_ispeed)) {
    sub t_ispeed () {	 ($t_termios->{c_ispeed});}
}
unless(defined(&t_lflag)) {
    sub t_lflag () {	 ($t_termios->{c_lflag});}
}
unless(defined(&t_min)) {
    sub t_min () {	 ($t_termios->{c_min});}
}
unless(defined(&t_oflag)) {
    sub t_oflag () {	 ($t_termios->{c_oflag});}
}
unless(defined(&t_ospeed)) {
    sub t_ospeed () {	 ($t_termios->{c_ospeed});}
}
unless(defined(&t_time)) {
    sub t_time () {	 ($t_termios->{c_time});}
}
unless(defined(&TTIPRI)) {
    sub TTIPRI () {	25;}
}
unless(defined(&TTOPRI)) {
    sub TTOPRI () {	26;}
}
unless(defined(&TTMASK)) {
    sub TTMASK () {	15;}
}
unless(defined(&OBUFSIZ)) {
    sub OBUFSIZ () {	100;}
}
unless(defined(&TTYHOG)) {
    sub TTYHOG () {	1024;}
}
if(defined(&_KERNEL)) {
    eval 'sub TTMAXHIWAT () { &roundup(2048,  &CBSIZE);}' unless defined(&TTMAXHIWAT);
    eval 'sub TTMINHIWAT () { &roundup(100,  &CBSIZE);}' unless defined(&TTMINHIWAT);
    eval 'sub TTMAXLOWAT () {256;}' unless defined(&TTMAXLOWAT);
    eval 'sub TTMINLOWAT () {32;}' unless defined(&TTMINLOWAT);
}
unless(defined(&TS_ASLEEP)) {
    sub TS_ASLEEP () {	0x00001;}
}
unless(defined(&TS_ASYNC)) {
    sub TS_ASYNC () {	0x00002;}
}
unless(defined(&TS_BUSY)) {
    sub TS_BUSY () {	0x00004;}
}
unless(defined(&TS_CARR_ON)) {
    sub TS_CARR_ON () {	0x00008;}
}
unless(defined(&TS_FLUSH)) {
    sub TS_FLUSH () {	0x00010;}
}
unless(defined(&TS_ISOPEN)) {
    sub TS_ISOPEN () {	0x00020;}
}
unless(defined(&TS_TBLOCK)) {
    sub TS_TBLOCK () {	0x00040;}
}
unless(defined(&TS_TIMEOUT)) {
    sub TS_TIMEOUT () {	0x00080;}
}
unless(defined(&TS_TTSTOP)) {
    sub TS_TTSTOP () {	0x00100;}
}
unless(defined(&TS_WOPEN)) {
    sub TS_WOPEN () {	0x00200;}
}
unless(defined(&TS_XCLUDE)) {
    sub TS_XCLUDE () {	0x00400;}
}
unless(defined(&TS_BKSL)) {
    sub TS_BKSL () {	0x00800;}
}
unless(defined(&TS_CNTTB)) {
    sub TS_CNTTB () {	0x01000;}
}
unless(defined(&TS_ERASE)) {
    sub TS_ERASE () {	0x02000;}
}
unless(defined(&TS_LNCH)) {
    sub TS_LNCH () {	0x04000;}
}
unless(defined(&TS_TYPEN)) {
    sub TS_TYPEN () {	0x08000;}
}
unless(defined(&TS_LOCAL)) {
    sub TS_LOCAL () {	( &TS_BKSL |  &TS_CNTTB |  &TS_ERASE |  &TS_LNCH |  &TS_TYPEN);}
}
unless(defined(&ORDINARY)) {
    sub ORDINARY () {	0;}
}
unless(defined(&CONTROL)) {
    sub CONTROL () {	1;}
}
unless(defined(&BACKSPACE)) {
    sub BACKSPACE () {	2;}
}
unless(defined(&NEWLINE)) {
    sub NEWLINE () {	3;}
}
unless(defined(&TAB)) {
    sub TAB () {	4;}
}
unless(defined(&VTAB)) {
    sub VTAB () {	5;}
}
unless(defined(&RETURN)) {
    sub RETURN () {	6;}
}
unless(defined(&DMSET)) {
    sub DMSET () {	0;}
}
unless(defined(&DMBIS)) {
    sub DMBIS () {	1;}
}
unless(defined(&DMBIC)) {
    sub DMBIC () {	2;}
}
unless(defined(&DMGET)) {
    sub DMGET () {	3;}
}
unless(defined(&TTY_CHARMASK)) {
    sub TTY_CHARMASK () {	0x000000ff;}
}
unless(defined(&TTY_QUOTE)) {
    sub TTY_QUOTE () {	0x00000100;}
}
unless(defined(&TTY_ERRORMASK)) {
    sub TTY_ERRORMASK () {	0xff000000;}
}
unless(defined(&TTY_FE)) {
    sub TTY_FE () {	0x01000000;}
}
unless(defined(&TTY_PE)) {
    sub TTY_PE () {	0x02000000;}
}
unless(defined(&isctty)) {
    sub isctty {
	local($p, $tp) = @_;
	eval q((($p)-> &p_session == ($tp)-> &t_session  && ($p)-> &p_flag &  &P_CONTROLT));
    }
}
unless(defined(&isbackground)) {
    sub isbackground {
	local($p, $tp) = @_;
	eval q(( &isctty(($p), ($tp))  && ($p)-> &p_pgrp != ($tp)-> &t_pgrp));
    }
}
if(defined(&_KERNEL)) {
    if(defined( &COMPAT_43) || defined( &COMPAT_SUNOS) || defined( &COMPAT_SVR4) || defined( &COMPAT_FREEBSD) || defined( &COMPAT_OSF1)) {
	eval 'sub COMPAT_OLDTTY () {1;}' unless defined(&COMPAT_OLDTTY);
    }
}
1;
