require '_h2ph_pre.ph';

unless(defined(&_USB_H_)) {
    eval 'sub _USB_H_ () {1;}' unless defined(&_USB_H_);
    require 'sys/types.ph';
    require 'sys/time.ph';
    if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	require 'sys/ioctl.ph';
	if(defined( &_KERNEL)) {
	    require 'dev/usb/usb_port.ph';
	}
    }
 elsif(defined( &__FreeBSD__)) {
	if(defined( &KERNEL)) {
	    require 'sys/malloc.ph';
	    require 'dev/usb/usb_port.ph';
	}
    }
    eval 'sub USB_MAX_DEVICES () {128;}' unless defined(&USB_MAX_DEVICES);
    eval 'sub USB_START_ADDR () {0;}' unless defined(&USB_START_ADDR);
    eval 'sub USB_CONTROL_ENDPOINT () {0;}' unless defined(&USB_CONTROL_ENDPOINT);
    eval 'sub USB_MAX_ENDPOINTS () {16;}' unless defined(&USB_MAX_ENDPOINTS);
    eval 'sub USB_FRAMES_PER_SECOND () {1000;}' unless defined(&USB_FRAMES_PER_SECOND);
    eval 'sub USETW2 {
        local($w,$h,$l) = @_;
	    eval q(([0] = , [1] = ($h)));
    }' unless defined(&USETW2);
    if(1) {
	eval 'sub UGETW {
	    local($w) = @_;
    	    eval q((($w)[0] | (($w)[1] << 8)));
	}' unless defined(&UGETW);
	eval 'sub USETW {
	    local($w,$v) = @_;
    	    eval q(([0] = , [1] = (($v) >> 8)));
	}' unless defined(&USETW);
	eval 'sub UGETDW {
	    local($w) = @_;
    	    eval q((($w)[0] | (($w)[1] << 8) | (($w)[2] << 16) | (($w)[3] << 24)));
	}' unless defined(&UGETDW);
	eval 'sub USETDW {
	    local($w,$v) = @_;
    	    eval q(([0] = , [1] = ( >> 8), [2] = ( >> 16), [3] = (($v) >> 24)));
	}' unless defined(&USETDW);
    } else {
	eval 'sub UGETW {
	    local($w) = @_;
    	    eval q((*($w)));
	}' unless defined(&UGETW);
	eval 'sub USETW {
	    local($w,$v) = @_;
    	    eval q((*($w) = ($v)));
	}' unless defined(&USETW);
	eval 'sub UGETDW {
	    local($w) = @_;
    	    eval q((*($w)));
	}' unless defined(&UGETDW);
	eval 'sub USETDW {
	    local($w,$v) = @_;
    	    eval q((*($w) = ($v)));
	}' unless defined(&USETDW);
    }
    eval 'sub UPACKED () { &__attribute__(( &__packed__));}' unless defined(&UPACKED);
    eval 'sub UT_WRITE () {0x00;}' unless defined(&UT_WRITE);
    eval 'sub UT_READ () {0x80;}' unless defined(&UT_READ);
    eval 'sub UT_STANDARD () {0x00;}' unless defined(&UT_STANDARD);
    eval 'sub UT_CLASS () {0x20;}' unless defined(&UT_CLASS);
    eval 'sub UT_VENDOR () {0x40;}' unless defined(&UT_VENDOR);
    eval 'sub UT_DEVICE () {0x00;}' unless defined(&UT_DEVICE);
    eval 'sub UT_INTERFACE () {0x01;}' unless defined(&UT_INTERFACE);
    eval 'sub UT_ENDPOINT () {0x02;}' unless defined(&UT_ENDPOINT);
    eval 'sub UT_OTHER () {0x03;}' unless defined(&UT_OTHER);
    eval 'sub UT_READ_DEVICE () {( &UT_READ |  &UT_STANDARD |  &UT_DEVICE);}' unless defined(&UT_READ_DEVICE);
    eval 'sub UT_READ_INTERFACE () {( &UT_READ |  &UT_STANDARD |  &UT_INTERFACE);}' unless defined(&UT_READ_INTERFACE);
    eval 'sub UT_READ_ENDPOINT () {( &UT_READ |  &UT_STANDARD |  &UT_ENDPOINT);}' unless defined(&UT_READ_ENDPOINT);
    eval 'sub UT_WRITE_DEVICE () {( &UT_WRITE |  &UT_STANDARD |  &UT_DEVICE);}' unless defined(&UT_WRITE_DEVICE);
    eval 'sub UT_WRITE_INTERFACE () {( &UT_WRITE |  &UT_STANDARD |  &UT_INTERFACE);}' unless defined(&UT_WRITE_INTERFACE);
    eval 'sub UT_WRITE_ENDPOINT () {( &UT_WRITE |  &UT_STANDARD |  &UT_ENDPOINT);}' unless defined(&UT_WRITE_ENDPOINT);
    eval 'sub UT_READ_CLASS_DEVICE () {( &UT_READ |  &UT_CLASS |  &UT_DEVICE);}' unless defined(&UT_READ_CLASS_DEVICE);
    eval 'sub UT_READ_CLASS_INTERFACE () {( &UT_READ |  &UT_CLASS |  &UT_INTERFACE);}' unless defined(&UT_READ_CLASS_INTERFACE);
    eval 'sub UT_READ_CLASS_OTHER () {( &UT_READ |  &UT_CLASS |  &UT_OTHER);}' unless defined(&UT_READ_CLASS_OTHER);
    eval 'sub UT_READ_CLASS_ENDPOINT () {( &UT_READ |  &UT_CLASS |  &UT_ENDPOINT);}' unless defined(&UT_READ_CLASS_ENDPOINT);
    eval 'sub UT_WRITE_CLASS_DEVICE () {( &UT_WRITE |  &UT_CLASS |  &UT_DEVICE);}' unless defined(&UT_WRITE_CLASS_DEVICE);
    eval 'sub UT_WRITE_CLASS_INTERFACE () {( &UT_WRITE |  &UT_CLASS |  &UT_INTERFACE);}' unless defined(&UT_WRITE_CLASS_INTERFACE);
    eval 'sub UT_WRITE_CLASS_OTHER () {( &UT_WRITE |  &UT_CLASS |  &UT_OTHER);}' unless defined(&UT_WRITE_CLASS_OTHER);
    eval 'sub UT_WRITE_CLASS_ENDPOINT () {( &UT_WRITE |  &UT_CLASS |  &UT_ENDPOINT);}' unless defined(&UT_WRITE_CLASS_ENDPOINT);
    eval 'sub UT_READ_VENDOR_DEVICE () {( &UT_READ |  &UT_VENDOR |  &UT_DEVICE);}' unless defined(&UT_READ_VENDOR_DEVICE);
    eval 'sub UT_READ_VENDOR_INTERFACE () {( &UT_READ |  &UT_VENDOR |  &UT_INTERFACE);}' unless defined(&UT_READ_VENDOR_INTERFACE);
    eval 'sub UT_READ_VENDOR_OTHER () {( &UT_READ |  &UT_VENDOR |  &UT_OTHER);}' unless defined(&UT_READ_VENDOR_OTHER);
    eval 'sub UT_READ_VENDOR_ENDPOINT () {( &UT_READ |  &UT_VENDOR |  &UT_ENDPOINT);}' unless defined(&UT_READ_VENDOR_ENDPOINT);
    eval 'sub UT_WRITE_VENDOR_DEVICE () {( &UT_WRITE |  &UT_VENDOR |  &UT_DEVICE);}' unless defined(&UT_WRITE_VENDOR_DEVICE);
    eval 'sub UT_WRITE_VENDOR_INTERFACE () {( &UT_WRITE |  &UT_VENDOR |  &UT_INTERFACE);}' unless defined(&UT_WRITE_VENDOR_INTERFACE);
    eval 'sub UT_WRITE_VENDOR_OTHER () {( &UT_WRITE |  &UT_VENDOR |  &UT_OTHER);}' unless defined(&UT_WRITE_VENDOR_OTHER);
    eval 'sub UT_WRITE_VENDOR_ENDPOINT () {( &UT_WRITE |  &UT_VENDOR |  &UT_ENDPOINT);}' unless defined(&UT_WRITE_VENDOR_ENDPOINT);
    eval 'sub UR_GET_STATUS () {0x00;}' unless defined(&UR_GET_STATUS);
    eval 'sub UR_CLEAR_FEATURE () {0x01;}' unless defined(&UR_CLEAR_FEATURE);
    eval 'sub UR_SET_FEATURE () {0x03;}' unless defined(&UR_SET_FEATURE);
    eval 'sub UR_SET_ADDRESS () {0x05;}' unless defined(&UR_SET_ADDRESS);
    eval 'sub UR_GET_DESCRIPTOR () {0x06;}' unless defined(&UR_GET_DESCRIPTOR);
    eval 'sub UDESC_DEVICE () {0x01;}' unless defined(&UDESC_DEVICE);
    eval 'sub UDESC_CONFIG () {0x02;}' unless defined(&UDESC_CONFIG);
    eval 'sub UDESC_STRING () {0x03;}' unless defined(&UDESC_STRING);
    eval 'sub UDESC_INTERFACE () {0x04;}' unless defined(&UDESC_INTERFACE);
    eval 'sub UDESC_ENDPOINT () {0x05;}' unless defined(&UDESC_ENDPOINT);
    eval 'sub UDESC_CS_DEVICE () {0x21;}' unless defined(&UDESC_CS_DEVICE);
    eval 'sub UDESC_CS_CONFIG () {0x22;}' unless defined(&UDESC_CS_CONFIG);
    eval 'sub UDESC_CS_STRING () {0x23;}' unless defined(&UDESC_CS_STRING);
    eval 'sub UDESC_CS_INTERFACE () {0x24;}' unless defined(&UDESC_CS_INTERFACE);
    eval 'sub UDESC_CS_ENDPOINT () {0x25;}' unless defined(&UDESC_CS_ENDPOINT);
    eval 'sub UDESC_HUB () {0x29;}' unless defined(&UDESC_HUB);
    eval 'sub UR_SET_DESCRIPTOR () {0x07;}' unless defined(&UR_SET_DESCRIPTOR);
    eval 'sub UR_GET_CONFIG () {0x08;}' unless defined(&UR_GET_CONFIG);
    eval 'sub UR_SET_CONFIG () {0x09;}' unless defined(&UR_SET_CONFIG);
    eval 'sub UR_GET_INTERFACE () {0x0a;}' unless defined(&UR_GET_INTERFACE);
    eval 'sub UR_SET_INTERFACE () {0x0b;}' unless defined(&UR_SET_INTERFACE);
    eval 'sub UR_SYNCH_FRAME () {0x0c;}' unless defined(&UR_SYNCH_FRAME);
    eval 'sub UF_ENDPOINT_HALT () {0;}' unless defined(&UF_ENDPOINT_HALT);
    eval 'sub UF_DEVICE_REMOTE_WAKEUP () {1;}' unless defined(&UF_DEVICE_REMOTE_WAKEUP);
    eval 'sub USB_MAX_IPACKET () {8;}' unless defined(&USB_MAX_IPACKET);
    eval 'sub USB_DEVICE_DESCRIPTOR_SIZE () {18;}' unless defined(&USB_DEVICE_DESCRIPTOR_SIZE);
    eval 'sub UC_BUS_POWERED () {0x80;}' unless defined(&UC_BUS_POWERED);
    eval 'sub UC_SELF_POWERED () {0x40;}' unless defined(&UC_SELF_POWERED);
    eval 'sub UC_REMOTE_WAKEUP () {0x20;}' unless defined(&UC_REMOTE_WAKEUP);
    eval 'sub UC_POWER_FACTOR () {2;}' unless defined(&UC_POWER_FACTOR);
    eval 'sub USB_CONFIG_DESCRIPTOR_SIZE () {9;}' unless defined(&USB_CONFIG_DESCRIPTOR_SIZE);
    eval 'sub USB_INTERFACE_DESCRIPTOR_SIZE () {9;}' unless defined(&USB_INTERFACE_DESCRIPTOR_SIZE);
    eval 'sub UE_GET_DIR {
        local($a) = @_;
	    eval q((($a) & 0x80));
    }' unless defined(&UE_GET_DIR);
    eval 'sub UE_SET_DIR {
        local($a,$d) = @_;
	    eval q((($a) | ((($d)&1) << 7)));
    }' unless defined(&UE_SET_DIR);
    eval 'sub UE_DIR_IN () {0x80;}' unless defined(&UE_DIR_IN);
    eval 'sub UE_DIR_OUT () {0x00;}' unless defined(&UE_DIR_OUT);
    eval 'sub UE_ADDR () {0x0f;}' unless defined(&UE_ADDR);
    eval 'sub UE_GET_ADDR {
        local($a) = @_;
	    eval q((($a) &  &UE_ADDR));
    }' unless defined(&UE_GET_ADDR);
    eval 'sub UE_XFERTYPE () {0x03;}' unless defined(&UE_XFERTYPE);
    eval 'sub UE_CONTROL () {0x00;}' unless defined(&UE_CONTROL);
    eval 'sub UE_ISOCHRONOUS () {0x01;}' unless defined(&UE_ISOCHRONOUS);
    eval 'sub UE_BULK () {0x02;}' unless defined(&UE_BULK);
    eval 'sub UE_INTERRUPT () {0x03;}' unless defined(&UE_INTERRUPT);
    eval 'sub UE_GET_XFERTYPE {
        local($a) = @_;
	    eval q((($a) &  &UE_XFERTYPE));
    }' unless defined(&UE_GET_XFERTYPE);
    eval 'sub UE_ISO_TYPE () {0x0c;}' unless defined(&UE_ISO_TYPE);
    eval 'sub UE_ISO_ASYNC () {0x04;}' unless defined(&UE_ISO_ASYNC);
    eval 'sub UE_ISO_ADAPT () {0x08;}' unless defined(&UE_ISO_ADAPT);
    eval 'sub UE_ISO_SYNC () {0x0c;}' unless defined(&UE_ISO_SYNC);
    eval 'sub UE_GET_ISO_TYPE {
        local($a) = @_;
	    eval q((($a) &  &UE_ISO_TYPE));
    }' unless defined(&UE_GET_ISO_TYPE);
    eval 'sub USB_ENDPOINT_DESCRIPTOR_SIZE () {7;}' unless defined(&USB_ENDPOINT_DESCRIPTOR_SIZE);
    eval 'sub USB_MAX_STRING_LEN () {128;}' unless defined(&USB_MAX_STRING_LEN);
    eval 'sub USB_LANGUAGE_TABLE () {0;}' unless defined(&USB_LANGUAGE_TABLE);
    eval 'sub UR_GET_BUS_STATE () {0x02;}' unless defined(&UR_GET_BUS_STATE);
    eval 'sub UHF_C_HUB_LOCAL_POWER () {0;}' unless defined(&UHF_C_HUB_LOCAL_POWER);
    eval 'sub UHF_C_HUB_OVER_CURRENT () {1;}' unless defined(&UHF_C_HUB_OVER_CURRENT);
    eval 'sub UHF_PORT_CONNECTION () {0;}' unless defined(&UHF_PORT_CONNECTION);
    eval 'sub UHF_PORT_ENABLE () {1;}' unless defined(&UHF_PORT_ENABLE);
    eval 'sub UHF_PORT_SUSPEND () {2;}' unless defined(&UHF_PORT_SUSPEND);
    eval 'sub UHF_PORT_OVER_CURRENT () {3;}' unless defined(&UHF_PORT_OVER_CURRENT);
    eval 'sub UHF_PORT_RESET () {4;}' unless defined(&UHF_PORT_RESET);
    eval 'sub UHF_PORT_POWER () {8;}' unless defined(&UHF_PORT_POWER);
    eval 'sub UHF_PORT_LOW_SPEED () {9;}' unless defined(&UHF_PORT_LOW_SPEED);
    eval 'sub UHF_C_PORT_CONNECTION () {16;}' unless defined(&UHF_C_PORT_CONNECTION);
    eval 'sub UHF_C_PORT_ENABLE () {17;}' unless defined(&UHF_C_PORT_ENABLE);
    eval 'sub UHF_C_PORT_SUSPEND () {18;}' unless defined(&UHF_C_PORT_SUSPEND);
    eval 'sub UHF_C_PORT_OVER_CURRENT () {19;}' unless defined(&UHF_C_PORT_OVER_CURRENT);
    eval 'sub UHF_C_PORT_RESET () {20;}' unless defined(&UHF_C_PORT_RESET);
    eval 'sub UHD_PWR () {0x03;}' unless defined(&UHD_PWR);
    eval 'sub UHD_PWR_GANGED () {0x00;}' unless defined(&UHD_PWR_GANGED);
    eval 'sub UHD_PWR_INDIVIDUAL () {0x01;}' unless defined(&UHD_PWR_INDIVIDUAL);
    eval 'sub UHD_PWR_NO_SWITCH () {0x02;}' unless defined(&UHD_PWR_NO_SWITCH);
    eval 'sub UHD_COMPOUND () {0x04;}' unless defined(&UHD_COMPOUND);
    eval 'sub UHD_OC () {0x18;}' unless defined(&UHD_OC);
    eval 'sub UHD_OC_GLOBAL () {0x00;}' unless defined(&UHD_OC_GLOBAL);
    eval 'sub UHD_OC_INDIVIDUAL () {0x08;}' unless defined(&UHD_OC_INDIVIDUAL);
    eval 'sub UHD_OC_NONE () {0x10;}' unless defined(&UHD_OC_NONE);
    eval 'sub UHD_PWRON_FACTOR () {2;}' unless defined(&UHD_PWRON_FACTOR);
    eval 'sub UHD_NOT_REMOV {
        local($desc, $i) = @_;
	    eval q(((($desc)-> $DeviceRemovable[($i)/8] >> (($i) % 8)) & 1));
    }' unless defined(&UHD_NOT_REMOV);
    eval 'sub USB_HUB_DESCRIPTOR_SIZE () {9;}' unless defined(&USB_HUB_DESCRIPTOR_SIZE);
    eval 'sub UDS_SELF_POWERED () {0x0001;}' unless defined(&UDS_SELF_POWERED);
    eval 'sub UDS_REMOTE_WAKEUP () {0x0002;}' unless defined(&UDS_REMOTE_WAKEUP);
    eval 'sub UES_HALT () {0x0001;}' unless defined(&UES_HALT);
    eval 'sub UHS_LOCAL_POWER () {0x0001;}' unless defined(&UHS_LOCAL_POWER);
    eval 'sub UHS_OVER_CURRENT () {0x0002;}' unless defined(&UHS_OVER_CURRENT);
    eval 'sub UPS_CURRENT_CONNECT_STATUS () {0x0001;}' unless defined(&UPS_CURRENT_CONNECT_STATUS);
    eval 'sub UPS_PORT_ENABLED () {0x0002;}' unless defined(&UPS_PORT_ENABLED);
    eval 'sub UPS_SUSPEND () {0x0004;}' unless defined(&UPS_SUSPEND);
    eval 'sub UPS_OVERCURRENT_INDICATOR () {0x0008;}' unless defined(&UPS_OVERCURRENT_INDICATOR);
    eval 'sub UPS_RESET () {0x0010;}' unless defined(&UPS_RESET);
    eval 'sub UPS_PORT_POWER () {0x0100;}' unless defined(&UPS_PORT_POWER);
    eval 'sub UPS_LOW_SPEED () {0x0200;}' unless defined(&UPS_LOW_SPEED);
    eval 'sub UPS_C_CONNECT_STATUS () {0x0001;}' unless defined(&UPS_C_CONNECT_STATUS);
    eval 'sub UPS_C_PORT_ENABLED () {0x0002;}' unless defined(&UPS_C_PORT_ENABLED);
    eval 'sub UPS_C_SUSPEND () {0x0004;}' unless defined(&UPS_C_SUSPEND);
    eval 'sub UPS_C_OVERCURRENT_INDICATOR () {0x0008;}' unless defined(&UPS_C_OVERCURRENT_INDICATOR);
    eval 'sub UPS_C_PORT_RESET () {0x0010;}' unless defined(&UPS_C_PORT_RESET);
    eval 'sub UDCLASS_AUDIO () {0x00;}' unless defined(&UDCLASS_AUDIO);
    eval 'sub UDCLASS_COMM () {0x02;}' unless defined(&UDCLASS_COMM);
    eval 'sub UDCLASS_HID () {0x00;}' unless defined(&UDCLASS_HID);
    eval 'sub UDCLASS_HUB () {0x09;}' unless defined(&UDCLASS_HUB);
    eval 'sub UDSUBCLASS_HUB () {0;}' unless defined(&UDSUBCLASS_HUB);
    eval 'sub UDCLASS_MASS () {0x00;}' unless defined(&UDCLASS_MASS);
    eval 'sub UICLASS_UNSPEC () {0x00;}' unless defined(&UICLASS_UNSPEC);
    eval 'sub UICLASS_AUDIO () {0x01;}' unless defined(&UICLASS_AUDIO);
    eval 'sub UISUBCLASS_AUDIOCONTROL () {1;}' unless defined(&UISUBCLASS_AUDIOCONTROL);
    eval 'sub UISUBCLASS_AUDIOSTREAM () {2;}' unless defined(&UISUBCLASS_AUDIOSTREAM);
    eval 'sub UISUBCLASS_MIDISTREAM () {3;}' unless defined(&UISUBCLASS_MIDISTREAM);
    eval 'sub UICLASS_CDC () {0x02;}' unless defined(&UICLASS_CDC);
    eval 'sub UISUBCLASS_DIRECT_LINE_CONTROL_MODEL () {1;}' unless defined(&UISUBCLASS_DIRECT_LINE_CONTROL_MODEL);
    eval 'sub UISUBCLASS_ABSTRACT_CONTROL_MODEL () {2;}' unless defined(&UISUBCLASS_ABSTRACT_CONTROL_MODEL);
    eval 'sub UISUBCLASS_TELEPHONE_CONTROL_MODEL () {3;}' unless defined(&UISUBCLASS_TELEPHONE_CONTROL_MODEL);
    eval 'sub UISUBCLASS_MULTICHANNEL_CONTROL_MODEL () {4;}' unless defined(&UISUBCLASS_MULTICHANNEL_CONTROL_MODEL);
    eval 'sub UISUBCLASS_CAPI_CONTROLMODEL () {5;}' unless defined(&UISUBCLASS_CAPI_CONTROLMODEL);
    eval 'sub UISUBCLASS_ETHERNET_NETWORKING_CONTROL_MODEL () {6;}' unless defined(&UISUBCLASS_ETHERNET_NETWORKING_CONTROL_MODEL);
    eval 'sub UISUBCLASS_ATM_NETWORKING_CONTROL_MODEL () {7;}' unless defined(&UISUBCLASS_ATM_NETWORKING_CONTROL_MODEL);
    eval 'sub UIPROTO_CDC_AT () {1;}' unless defined(&UIPROTO_CDC_AT);
    eval 'sub UICLASS_HID () {0x03;}' unless defined(&UICLASS_HID);
    eval 'sub UISUBCLASS_BOOT () {1;}' unless defined(&UISUBCLASS_BOOT);
    eval 'sub UIPROTO_BOOT_KEYBOARD () {1;}' unless defined(&UIPROTO_BOOT_KEYBOARD);
    eval 'sub UICLASS_PHYSICAL () {0x05;}' unless defined(&UICLASS_PHYSICAL);
    eval 'sub UICLASS_PRINTER () {0x07;}' unless defined(&UICLASS_PRINTER);
    eval 'sub UISUBCLASS_PRINTER () {1;}' unless defined(&UISUBCLASS_PRINTER);
    eval 'sub UIPROTO_PRINTER_UNI () {1;}' unless defined(&UIPROTO_PRINTER_UNI);
    eval 'sub UIPROTO_PRINTER_BI () {2;}' unless defined(&UIPROTO_PRINTER_BI);
    eval 'sub UICLASS_MASS () {0x08;}' unless defined(&UICLASS_MASS);
    eval 'sub UISUBCLASS_RBC () {1;}' unless defined(&UISUBCLASS_RBC);
    eval 'sub UISUBCLASS_SFF8020I () {2;}' unless defined(&UISUBCLASS_SFF8020I);
    eval 'sub UISUBCLASS_QIC157 () {3;}' unless defined(&UISUBCLASS_QIC157);
    eval 'sub UISUBCLASS_UFI () {4;}' unless defined(&UISUBCLASS_UFI);
    eval 'sub UISUBCLASS_SFF8070I () {5;}' unless defined(&UISUBCLASS_SFF8070I);
    eval 'sub UISUBCLASS_SCSI () {6;}' unless defined(&UISUBCLASS_SCSI);
    eval 'sub UIPROTO_MASS_CBI_I () {0;}' unless defined(&UIPROTO_MASS_CBI_I);
    eval 'sub UIPROTO_MASS_CBI () {1;}' unless defined(&UIPROTO_MASS_CBI);
    eval 'sub UIPROTO_MASS_BBB () {2;}' unless defined(&UIPROTO_MASS_BBB);
    eval 'sub UIPROTO_MASS_BBB_P () {80;}' unless defined(&UIPROTO_MASS_BBB_P);
    eval 'sub UICLASS_HUB () {0x09;}' unless defined(&UICLASS_HUB);
    eval 'sub UISUBCLASS_HUB () {0;}' unless defined(&UISUBCLASS_HUB);
    eval 'sub UICLASS_CDC_DATA () {0x0a;}' unless defined(&UICLASS_CDC_DATA);
    eval 'sub UISUBCLASS_DATA () {0;}' unless defined(&UISUBCLASS_DATA);
    eval 'sub UIPROTO_DATA_ISDNBRI () {0x30;}' unless defined(&UIPROTO_DATA_ISDNBRI);
    eval 'sub UIPROTO_DATA_HDLC () {0x31;}' unless defined(&UIPROTO_DATA_HDLC);
    eval 'sub UIPROTO_DATA_TRANSPARENT () {0x32;}' unless defined(&UIPROTO_DATA_TRANSPARENT);
    eval 'sub UIPROTO_DATA_Q921M () {0x50;}' unless defined(&UIPROTO_DATA_Q921M);
    eval 'sub UIPROTO_DATA_Q921 () {0x51;}' unless defined(&UIPROTO_DATA_Q921);
    eval 'sub UIPROTO_DATA_Q921TM () {0x52;}' unless defined(&UIPROTO_DATA_Q921TM);
    eval 'sub UIPROTO_DATA_V42BIS () {0x90;}' unless defined(&UIPROTO_DATA_V42BIS);
    eval 'sub UIPROTO_DATA_Q931 () {0x91;}' unless defined(&UIPROTO_DATA_Q931);
    eval 'sub UIPROTO_DATA_V120 () {0x92;}' unless defined(&UIPROTO_DATA_V120);
    eval 'sub UIPROTO_DATA_CAPI () {0x93;}' unless defined(&UIPROTO_DATA_CAPI);
    eval 'sub UIPROTO_DATA_HOST_BASED () {0xfd;}' unless defined(&UIPROTO_DATA_HOST_BASED);
    eval 'sub UIPROTO_DATA_PUF () {0xfe;}' unless defined(&UIPROTO_DATA_PUF);
    eval 'sub UIPROTO_DATA_VENDOR () {0xff;}' unless defined(&UIPROTO_DATA_VENDOR);
    eval 'sub UICLASS_FIRM_UPD () {0x0c;}' unless defined(&UICLASS_FIRM_UPD);
    eval 'sub UICLASS_APPL_SPEC () {0xfe;}' unless defined(&UICLASS_APPL_SPEC);
    eval 'sub UICLASS_VENDOR () {0xff;}' unless defined(&UICLASS_VENDOR);
    eval 'sub USB_HUB_MAX_DEPTH () {5;}' unless defined(&USB_HUB_MAX_DEPTH);
    eval 'sub USB_POWER_DOWN_TIME () {200;}' unless defined(&USB_POWER_DOWN_TIME);
    eval 'sub USB_PORT_POWER_DOWN_TIME () {100;}' unless defined(&USB_PORT_POWER_DOWN_TIME);
    if(0) {
	eval 'sub USB_PORT_RESET_DELAY () {10;}' unless defined(&USB_PORT_RESET_DELAY);
	eval 'sub USB_PORT_RESET_SETTLE () {10;}' unless defined(&USB_PORT_RESET_SETTLE);
	eval 'sub USB_PORT_POWERUP_DELAY () {100;}' unless defined(&USB_PORT_POWERUP_DELAY);
	eval 'sub USB_SET_ADDRESS_SETTLE () {2;}' unless defined(&USB_SET_ADDRESS_SETTLE);
	eval 'sub USB_RESUME_DELAY () {(20*5);}' unless defined(&USB_RESUME_DELAY);
	eval 'sub USB_RESUME_WAIT () {10;}' unless defined(&USB_RESUME_WAIT);
	eval 'sub USB_RESUME_RECOVERY () {10;}' unless defined(&USB_RESUME_RECOVERY);
	eval 'sub USB_EXTRA_POWER_UP_TIME () {0;}' unless defined(&USB_EXTRA_POWER_UP_TIME);
    } else {
	eval 'sub USB_PORT_RESET_DELAY () {50;}' unless defined(&USB_PORT_RESET_DELAY);
	eval 'sub USB_PORT_RESET_RECOVERY () {50;}' unless defined(&USB_PORT_RESET_RECOVERY);
	eval 'sub USB_PORT_POWERUP_DELAY () {200;}' unless defined(&USB_PORT_POWERUP_DELAY);
	eval 'sub USB_SET_ADDRESS_SETTLE () {10;}' unless defined(&USB_SET_ADDRESS_SETTLE);
	eval 'sub USB_RESUME_DELAY () {(50*5);}' unless defined(&USB_RESUME_DELAY);
	eval 'sub USB_RESUME_WAIT () {50;}' unless defined(&USB_RESUME_WAIT);
	eval 'sub USB_RESUME_RECOVERY () {50;}' unless defined(&USB_RESUME_RECOVERY);
	eval 'sub USB_EXTRA_POWER_UP_TIME () {20;}' unless defined(&USB_EXTRA_POWER_UP_TIME);
    }
    eval 'sub USB_MIN_POWER () {100;}' unless defined(&USB_MIN_POWER);
    eval 'sub USB_MAX_POWER () {500;}' unless defined(&USB_MAX_POWER);
    eval 'sub USB_BUS_RESET_DELAY () {100;}' unless defined(&USB_BUS_RESET_DELAY);
    eval 'sub USB_UNCONFIG_NO () {0;}' unless defined(&USB_UNCONFIG_NO);
    eval 'sub USB_UNCONFIG_INDEX () {(-1);}' unless defined(&USB_UNCONFIG_INDEX);
    eval 'sub USBD_SHORT_XFER_OK () {0x04;}' unless defined(&USBD_SHORT_XFER_OK);
    eval 'sub USB_CURRENT_CONFIG_INDEX () {(-1);}' unless defined(&USB_CURRENT_CONFIG_INDEX);
    eval 'sub USB_CURRENT_ALT_INDEX () {(-1);}' unless defined(&USB_CURRENT_ALT_INDEX);
    eval 'sub USB_MAX_DEVNAMES () {4;}' unless defined(&USB_MAX_DEVNAMES);
    eval 'sub USB_MAX_DEVNAMELEN () {16;}' unless defined(&USB_MAX_DEVNAMELEN);
    eval 'sub USB_PORT_ENABLED () {0xff;}' unless defined(&USB_PORT_ENABLED);
    eval 'sub USB_PORT_SUSPENDED () {0xfe;}' unless defined(&USB_PORT_SUSPENDED);
    eval 'sub USB_PORT_POWERED () {0xfd;}' unless defined(&USB_PORT_POWERED);
    eval 'sub USB_PORT_DISABLED () {0xfc;}' unless defined(&USB_PORT_DISABLED);
    eval 'sub USB_EVENT_CTRLR_ATTACH () {1;}' unless defined(&USB_EVENT_CTRLR_ATTACH);
    eval 'sub USB_EVENT_CTRLR_DETACH () {2;}' unless defined(&USB_EVENT_CTRLR_DETACH);
    eval 'sub USB_EVENT_DEVICE_ATTACH () {3;}' unless defined(&USB_EVENT_DEVICE_ATTACH);
    eval 'sub USB_EVENT_DEVICE_DETACH () {4;}' unless defined(&USB_EVENT_DEVICE_DETACH);
    eval 'sub USB_EVENT_DRIVER_ATTACH () {5;}' unless defined(&USB_EVENT_DRIVER_ATTACH);
    eval 'sub USB_EVENT_DRIVER_DETACH () {6;}' unless defined(&USB_EVENT_DRIVER_DETACH);
    eval 'sub USB_REQUEST () { &_IOWR(ord(\'U\'), 1, \'struct usb_ctl_request\');}' unless defined(&USB_REQUEST);
    eval 'sub USB_SETDEBUG () { &_IOW (ord(\'U\'), 2, \'int\');}' unless defined(&USB_SETDEBUG);
    eval 'sub USB_DISCOVER () { &_IO (ord(\'U\'), 3);}' unless defined(&USB_DISCOVER);
    eval 'sub USB_DEVICEINFO () { &_IOWR(ord(\'U\'), 4, \'struct usb_device_info\');}' unless defined(&USB_DEVICEINFO);
    eval 'sub USB_DEVICESTATS () { &_IOR (ord(\'U\'), 5, \'struct usb_device_stats\');}' unless defined(&USB_DEVICESTATS);
    eval 'sub USB_GET_REPORT_DESC () { &_IOR (ord(\'U\'), 21, \'struct usb_ctl_report_desc\');}' unless defined(&USB_GET_REPORT_DESC);
    eval 'sub USB_SET_IMMED () { &_IOW (ord(\'U\'), 22, \'int\');}' unless defined(&USB_SET_IMMED);
    eval 'sub USB_GET_REPORT () { &_IOWR(ord(\'U\'), 23, \'struct usb_ctl_report\');}' unless defined(&USB_GET_REPORT);
    eval 'sub USB_SET_REPORT () { &_IOW (ord(\'U\'), 24, \'struct usb_ctl_report\');}' unless defined(&USB_SET_REPORT);
    eval 'sub USB_GET_CONFIG () { &_IOR (ord(\'U\'), 100, \'int\');}' unless defined(&USB_GET_CONFIG);
    eval 'sub USB_SET_CONFIG () { &_IOW (ord(\'U\'), 101, \'int\');}' unless defined(&USB_SET_CONFIG);
    eval 'sub USB_GET_ALTINTERFACE () { &_IOWR(ord(\'U\'), 102, \'struct usb_alt_interface\');}' unless defined(&USB_GET_ALTINTERFACE);
    eval 'sub USB_SET_ALTINTERFACE () { &_IOWR(ord(\'U\'), 103, \'struct usb_alt_interface\');}' unless defined(&USB_SET_ALTINTERFACE);
    eval 'sub USB_GET_NO_ALT () { &_IOWR(ord(\'U\'), 104, \'struct usb_alt_interface\');}' unless defined(&USB_GET_NO_ALT);
    eval 'sub USB_GET_DEVICE_DESC () { &_IOR (ord(\'U\'), 105,  &usb_device_descriptor_t);}' unless defined(&USB_GET_DEVICE_DESC);
    eval 'sub USB_GET_CONFIG_DESC () { &_IOWR(ord(\'U\'), 106, \'struct usb_config_desc\');}' unless defined(&USB_GET_CONFIG_DESC);
    eval 'sub USB_GET_INTERFACE_DESC () { &_IOWR(ord(\'U\'), 107, \'struct usb_interface_desc\');}' unless defined(&USB_GET_INTERFACE_DESC);
    eval 'sub USB_GET_ENDPOINT_DESC () { &_IOWR(ord(\'U\'), 108, \'struct usb_endpoint_desc\');}' unless defined(&USB_GET_ENDPOINT_DESC);
    eval 'sub USB_GET_FULL_DESC () { &_IOWR(ord(\'U\'), 109, \'struct usb_full_desc\');}' unless defined(&USB_GET_FULL_DESC);
    eval 'sub USB_GET_STRING_DESC () { &_IOWR(ord(\'U\'), 110, \'struct usb_string_desc\');}' unless defined(&USB_GET_STRING_DESC);
    eval 'sub USB_DO_REQUEST () { &_IOWR(ord(\'U\'), 111, \'struct usb_ctl_request\');}' unless defined(&USB_DO_REQUEST);
    eval 'sub USB_GET_DEVICEINFO () { &_IOR (ord(\'U\'), 112, \'struct usb_device_info\');}' unless defined(&USB_GET_DEVICEINFO);
    eval 'sub USB_SET_SHORT_XFER () { &_IOW (ord(\'U\'), 113, \'int\');}' unless defined(&USB_SET_SHORT_XFER);
    eval 'sub USB_SET_TIMEOUT () { &_IOW (ord(\'U\'), 114, \'int\');}' unless defined(&USB_SET_TIMEOUT);
    eval 'sub USB_GET_CM_OVER_DATA () { &_IOR (ord(\'U\'), 130, \'int\');}' unless defined(&USB_GET_CM_OVER_DATA);
    eval 'sub USB_SET_CM_OVER_DATA () { &_IOW (ord(\'U\'), 131, \'int\');}' unless defined(&USB_SET_CM_OVER_DATA);
}
1;
