require '_h2ph_pre.ph';

unless(defined(&_IC_DPTREG_H_)) {
    eval 'sub _IC_DPTREG_H_ () {1;}' unless defined(&_IC_DPTREG_H_);
    eval 'sub DPT_MAX_TARGETS () {16;}' unless defined(&DPT_MAX_TARGETS);
    eval 'sub DPT_MAX_LUNS () {8;}' unless defined(&DPT_MAX_LUNS);
    eval 'sub DPT_MAX_CHANNELS () {3;}' unless defined(&DPT_MAX_CHANNELS);
    eval 'sub DPT_MAX_XFER () {(( &DPT_SG_SIZE - 1) <<  &PGSHIFT);}' unless defined(&DPT_MAX_XFER);
    eval 'sub DPT_MAX_CCBS () {256;}' unless defined(&DPT_MAX_CCBS);
    eval 'sub DPT_SG_SIZE () {64;}' unless defined(&DPT_SG_SIZE);
    eval 'sub DPT_ABORT_TIMEOUT () {2000;}' unless defined(&DPT_ABORT_TIMEOUT);
    eval 'sub DPT_MORE_TIMEOUT () {1000;}' unless defined(&DPT_MORE_TIMEOUT);
    if(defined(&_KERNEL)) {
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : 0)) {
	    eval 'sub SWAP32 {
	        local($x) = @_;
    		eval q( &bswap32(($x)));
	    }' unless defined(&SWAP32);
	    eval 'sub SWAP16 {
	        local($x) = @_;
    		eval q( &bswap16(($x)));
	    }' unless defined(&SWAP16);
	    eval 'sub RSWAP32 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&RSWAP32);
	    eval 'sub RSWAP16 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&RSWAP16);
	} else {
	    eval 'sub SWAP32 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&SWAP32);
	    eval 'sub SWAP16 {
	        local($x) = @_;
    		eval q(($x));
	    }' unless defined(&SWAP16);
	    eval 'sub RSWAP32 {
	        local($x) = @_;
    		eval q( &bswap32(($x)));
	    }' unless defined(&RSWAP32);
	    eval 'sub RSWAP16 {
	        local($x) = @_;
    		eval q( &bswap16(($x)));
	    }' unless defined(&RSWAP16);
	}
	eval 'sub dpt_inb {
	    local($x, $o) = @_;
    	    eval q( &bus_space_read_1(($x)-> &sc_iot, ($x)-> &sc_ioh, ($o)));
	}' unless defined(&dpt_inb);
	eval 'sub dpt_inw {
	    local($x, $o) = @_;
    	    eval q( &RSWAP16( &bus_space_read_2(($x)-> &sc_iot, ($x)-> &sc_ioh, ($o))));
	}' unless defined(&dpt_inw);
	eval 'sub dpt_inl {
	    local($x, $o) = @_;
    	    eval q( &RSWAP32( &bus_space_read_4(($x)-> &sc_iot, ($x)-> &sc_ioh, ($o))));
	}' unless defined(&dpt_inl);
	eval 'sub dpt_outb {
	    local($x, $o, $d) = @_;
    	    eval q( &bus_space_write_1(($x)-> &sc_iot, ($x)-> &sc_ioh, ($o), ($d)));
	}' unless defined(&dpt_outb);
	eval 'sub dpt_outw {
	    local($x, $o, $d) = @_;
    	    eval q( &bus_space_write_2(($x)-> &sc_iot, ($x)-> &sc_ioh, ($o),  &RSWAP16($d)));
	}' unless defined(&dpt_outw);
	eval 'sub dpt_outl {
	    local($x, $o, $d) = @_;
    	    eval q( &bus_space_write_4(($x)-> &sc_iot, ($x)-> &sc_ioh, ($o),  &RSWAP32($d)));
	}' unless defined(&dpt_outl);
    }
    eval 'sub HA_BASE () {0x10;}' unless defined(&HA_BASE);
    eval 'sub HA_DATA () {( &HA_BASE + 0);}' unless defined(&HA_DATA);
    eval 'sub HA_ERROR () {( &HA_BASE + 1);}' unless defined(&HA_ERROR);
    eval 'sub HA_DMA_BASE () {( &HA_BASE + 2);}' unless defined(&HA_DMA_BASE);
    eval 'sub HA_ICMD_CODE2 () {( &HA_BASE + 4);}' unless defined(&HA_ICMD_CODE2);
    eval 'sub HA_ICMD_CODE1 () {( &HA_BASE + 5);}' unless defined(&HA_ICMD_CODE1);
    eval 'sub HA_ICMD () {( &HA_BASE + 6);}' unless defined(&HA_ICMD);
    eval 'sub HA_COMMAND () {( &HA_BASE + 7);}' unless defined(&HA_COMMAND);
    eval 'sub CP_PIO_GETCFG () {0xf0;}' unless defined(&CP_PIO_GETCFG);
    eval 'sub CP_PIO_CMD () {0xf2;}' unless defined(&CP_PIO_CMD);
    eval 'sub CP_DMA_GETCFG () {0xfd;}' unless defined(&CP_DMA_GETCFG);
    eval 'sub CP_DMA_CMD () {0xff;}' unless defined(&CP_DMA_CMD);
    eval 'sub CP_PIO_TRUNCATE () {0xf4;}' unless defined(&CP_PIO_TRUNCATE);
    eval 'sub CP_RESET () {0xf9;}' unless defined(&CP_RESET);
    eval 'sub CP_REBOOT () {0x06;}' unless defined(&CP_REBOOT);
    eval 'sub CP_IMMEDIATE () {0xfa;}' unless defined(&CP_IMMEDIATE);
    eval 'sub CPI_GEN_ABORT () {0x00;}' unless defined(&CPI_GEN_ABORT);
    eval 'sub CPI_SPEC_RESET () {0x01;}' unless defined(&CPI_SPEC_RESET);
    eval 'sub CPI_BUS_RESET () {0x02;}' unless defined(&CPI_BUS_RESET);
    eval 'sub CPI_SPEC_ABORT () {0x03;}' unless defined(&CPI_SPEC_ABORT);
    eval 'sub CPI_QUIET_INTR () {0x04;}' unless defined(&CPI_QUIET_INTR);
    eval 'sub CPI_ROM_DL_EN () {0x05;}' unless defined(&CPI_ROM_DL_EN);
    eval 'sub CPI_COLD_BOOT () {0x06;}' unless defined(&CPI_COLD_BOOT);
    eval 'sub CPI_FORCE_IO () {0x07;}' unless defined(&CPI_FORCE_IO);
    eval 'sub CPI_BUS_OFFLINE () {0x08;}' unless defined(&CPI_BUS_OFFLINE);
    eval 'sub CPI_RESET_MSKD_BUS () {0x09;}' unless defined(&CPI_RESET_MSKD_BUS);
    eval 'sub CPI_POWEROFF_WARN () {0x0a;}' unless defined(&CPI_POWEROFF_WARN);
    eval 'sub HA_STATUS () {( &HA_BASE + 7);}' unless defined(&HA_STATUS);
    eval 'sub HA_ST_ERROR () {0x01;}' unless defined(&HA_ST_ERROR);
    eval 'sub HA_ST_MORE () {0x02;}' unless defined(&HA_ST_MORE);
    eval 'sub HA_ST_CORRECTD () {0x04;}' unless defined(&HA_ST_CORRECTD);
    eval 'sub HA_ST_DRQ () {0x08;}' unless defined(&HA_ST_DRQ);
    eval 'sub HA_ST_SEEK_COMPLETE () {0x10;}' unless defined(&HA_ST_SEEK_COMPLETE);
    eval 'sub HA_ST_WRT_FLT () {0x20;}' unless defined(&HA_ST_WRT_FLT);
    eval 'sub HA_ST_READY () {0x40;}' unless defined(&HA_ST_READY);
    eval 'sub HA_ST_BUSY () {0x80;}' unless defined(&HA_ST_BUSY);
    eval 'sub HA_ST_DATA_RDY () {( &HA_ST_SEEK_COMPLETE| &HA_ST_READY| &HA_ST_DRQ);}' unless defined(&HA_ST_DATA_RDY);
    eval 'sub HA_AUX_STATUS () {( &HA_BASE + 8);}' unless defined(&HA_AUX_STATUS);
    eval 'sub HA_AUX_BUSY () {0x01;}' unless defined(&HA_AUX_BUSY);
    eval 'sub HA_AUX_INTR () {0x02;}' unless defined(&HA_AUX_INTR);
    eval 'sub HA_NO_ERROR () {0x00;}' unless defined(&HA_NO_ERROR);
    eval 'sub HA_ERROR_SEL_TO () {0x01;}' unless defined(&HA_ERROR_SEL_TO);
    eval 'sub HA_ERROR_CMD_TO () {0x02;}' unless defined(&HA_ERROR_CMD_TO);
    eval 'sub HA_ERROR_RESET () {0x03;}' unless defined(&HA_ERROR_RESET);
    eval 'sub HA_INIT_POWERUP () {0x04;}' unless defined(&HA_INIT_POWERUP);
    eval 'sub HA_UNX_BUSPHASE () {0x05;}' unless defined(&HA_UNX_BUSPHASE);
    eval 'sub HA_UNX_BUS_FREE () {0x06;}' unless defined(&HA_UNX_BUS_FREE);
    eval 'sub HA_BUS_PARITY () {0x07;}' unless defined(&HA_BUS_PARITY);
    eval 'sub HA_SCSI_HUNG () {0x08;}' unless defined(&HA_SCSI_HUNG);
    eval 'sub HA_UNX_MSGRJCT () {0x09;}' unless defined(&HA_UNX_MSGRJCT);
    eval 'sub HA_RESET_STUCK () {0x0a;}' unless defined(&HA_RESET_STUCK);
    eval 'sub HA_RSENSE_FAIL () {0x0b;}' unless defined(&HA_RSENSE_FAIL);
    eval 'sub HA_PARITY () {0x0c;}' unless defined(&HA_PARITY);
    eval 'sub HA_ABORT_NA () {0x0d;}' unless defined(&HA_ABORT_NA);
    eval 'sub HA_ABORTED () {0x0e;}' unless defined(&HA_ABORTED);
    eval 'sub HA_RESET_NA () {0x0f;}' unless defined(&HA_RESET_NA);
    eval 'sub HA_RESET () {0x10;}' unless defined(&HA_RESET);
    eval 'sub HA_ECC () {0x11;}' unless defined(&HA_ECC);
    eval 'sub HA_PCI_PARITY () {0x12;}' unless defined(&HA_PCI_PARITY);
    eval 'sub HA_PCI_MASTER () {0x13;}' unless defined(&HA_PCI_MASTER);
    eval 'sub HA_PCI_TARGET () {0x14;}' unless defined(&HA_PCI_TARGET);
    eval 'sub HA_PCI_SIGNAL_TARGET () {0x15;}' unless defined(&HA_PCI_SIGNAL_TARGET);
    eval 'sub HA_ABORT () {0x20;}' unless defined(&HA_ABORT);
}
1;
