require '_h2ph_pre.ph';

unless(defined(&DC_BUSCTL)) {
    sub DC_BUSCTL () {	0x00;}
}
unless(defined(&DC_TXSTART)) {
    sub DC_TXSTART () {	0x08;}
}
unless(defined(&DC_RXSTART)) {
    sub DC_RXSTART () {	0x10;}
}
unless(defined(&DC_RXADDR)) {
    sub DC_RXADDR () {	0x18;}
}
unless(defined(&DC_TXADDR)) {
    sub DC_TXADDR () {	0x20;}
}
unless(defined(&DC_ISR)) {
    sub DC_ISR () {	0x28;}
}
unless(defined(&DC_NETCFG)) {
    sub DC_NETCFG () {	0x30;}
}
unless(defined(&DC_IMR)) {
    sub DC_IMR () {	0x38;}
}
unless(defined(&DC_FRAMESDISCARDED)) {
    sub DC_FRAMESDISCARDED () {	0x40;}
}
unless(defined(&DC_SIO)) {
    sub DC_SIO () {	0x48;}
}
unless(defined(&DC_ROM)) {
    sub DC_ROM () {	0x50;}
}
unless(defined(&DC_TIMER)) {
    sub DC_TIMER () {	0x58;}
}
unless(defined(&DC_10BTSTAT)) {
    sub DC_10BTSTAT () {	0x60;}
}
unless(defined(&DC_SIARESET)) {
    sub DC_SIARESET () {	0x68;}
}
unless(defined(&DC_10BTCTRL)) {
    sub DC_10BTCTRL () {	0x70;}
}
unless(defined(&DC_WATCHDOG)) {
    sub DC_WATCHDOG () {	0x78;}
}
unless(defined(&DC_SIAGP)) {
    sub DC_SIAGP () {	0x78;}
}
unless(defined(&DC_TYPE_98713)) {
    sub DC_TYPE_98713 () {	0x1;}
}
unless(defined(&DC_TYPE_98713A)) {
    sub DC_TYPE_98713A () {	0x2;}
}
unless(defined(&DC_TYPE_987x5)) {
    sub DC_TYPE_987x5 () {	0x3;}
}
unless(defined(&DC_TYPE_21143)) {
    sub DC_TYPE_21143 () {	0x4;}
}
unless(defined(&DC_TYPE_ASIX)) {
    sub DC_TYPE_ASIX () {	0x5;}
}
unless(defined(&DC_TYPE_AL981)) {
    sub DC_TYPE_AL981 () {	0x6;}
}
unless(defined(&DC_TYPE_AN983)) {
    sub DC_TYPE_AN983 () {	0x7;}
}
unless(defined(&DC_TYPE_DM9102)) {
    sub DC_TYPE_DM9102 () {	0x8;}
}
unless(defined(&DC_TYPE_PNICII)) {
    sub DC_TYPE_PNICII () {	0x9;}
}
unless(defined(&DC_TYPE_PNIC)) {
    sub DC_TYPE_PNIC () {	0xa;}
}
unless(defined(&DC_TYPE_XIRCOM)) {
    sub DC_TYPE_XIRCOM () {	0xb;}
}
unless(defined(&DC_IS_MACRONIX)) {
    sub DC_IS_MACRONIX {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_98713 ||  ($x->{dc_type}) ==  &DC_TYPE_98713A ||  ($x->{dc_type}) ==  &DC_TYPE_987x5));
    }
}
unless(defined(&DC_IS_ADMTEK)) {
    sub DC_IS_ADMTEK {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_AL981 ||  ($x->{dc_type}) ==  &DC_TYPE_AN983));
    }
}
unless(defined(&DC_IS_INTEL)) {
    sub DC_IS_INTEL {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_21143));
    }
}
unless(defined(&DC_IS_ASIX)) {
    sub DC_IS_ASIX {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_ASIX));
    }
}
unless(defined(&DC_IS_COMET)) {
    sub DC_IS_COMET {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_AL981));
    }
}
unless(defined(&DC_IS_CENTAUR)) {
    sub DC_IS_CENTAUR {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_AN983));
    }
}
unless(defined(&DC_IS_DAVICOM)) {
    sub DC_IS_DAVICOM {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_DM9102));
    }
}
unless(defined(&DC_IS_PNICII)) {
    sub DC_IS_PNICII {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_PNICII));
    }
}
unless(defined(&DC_IS_PNIC)) {
    sub DC_IS_PNIC {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_PNIC));
    }
}
unless(defined(&DC_IS_XIRCOM)) {
    sub DC_IS_XIRCOM {
	local($x) = @_;
	eval q(( ($x->{dc_type}) ==  &DC_TYPE_XIRCOM));
    }
}
unless(defined(&DC_PMODE_MII)) {
    sub DC_PMODE_MII () {	0x1;}
}
unless(defined(&DC_PMODE_SYM)) {
    sub DC_PMODE_SYM () {	0x2;}
}
unless(defined(&DC_BUSCTL_RESET)) {
    sub DC_BUSCTL_RESET () {	0x00000001;}
}
unless(defined(&DC_BUSCTL_ARBITRATION)) {
    sub DC_BUSCTL_ARBITRATION () {	0x00000002;}
}
unless(defined(&DC_BUSCTL_SKIPLEN)) {
    sub DC_BUSCTL_SKIPLEN () {	0x0000007c;}
}
unless(defined(&DC_BUSCTL_BUF_BIGENDIAN)) {
    sub DC_BUSCTL_BUF_BIGENDIAN () {	0x00000080;}
}
unless(defined(&DC_BUSCTL_BURSTLEN)) {
    sub DC_BUSCTL_BURSTLEN () {	0x00003f00;}
}
unless(defined(&DC_BUSCTL_CACHEALIGN)) {
    sub DC_BUSCTL_CACHEALIGN () {	0x0000c000;}
}
unless(defined(&DC_BUSCTL_TXPOLL)) {
    sub DC_BUSCTL_TXPOLL () {	0x000e0000;}
}
unless(defined(&DC_BUSCTL_DBO)) {
    sub DC_BUSCTL_DBO () {	0x00100000;}
}
unless(defined(&DC_BUSCTL_MRME)) {
    sub DC_BUSCTL_MRME () {	0x00200000;}
}
unless(defined(&DC_BUSCTL_MRLE)) {
    sub DC_BUSCTL_MRLE () {	0x00800000;}
}
unless(defined(&DC_BUSCTL_MWIE)) {
    sub DC_BUSCTL_MWIE () {	0x01000000;}
}
unless(defined(&DC_BUSCTL_ONNOW_ENB)) {
    sub DC_BUSCTL_ONNOW_ENB () {	0x04000000;}
}
unless(defined(&DC_SKIPLEN_1LONG)) {
    sub DC_SKIPLEN_1LONG () {	0x00000004;}
}
unless(defined(&DC_SKIPLEN_2LONG)) {
    sub DC_SKIPLEN_2LONG () {	0x00000008;}
}
unless(defined(&DC_SKIPLEN_3LONG)) {
    sub DC_SKIPLEN_3LONG () {	0x00000010;}
}
unless(defined(&DC_SKIPLEN_4LONG)) {
    sub DC_SKIPLEN_4LONG () {	0x00000020;}
}
unless(defined(&DC_SKIPLEN_5LONG)) {
    sub DC_SKIPLEN_5LONG () {	0x00000040;}
}
unless(defined(&DC_CACHEALIGN_NONE)) {
    sub DC_CACHEALIGN_NONE () {	0x00000000;}
}
unless(defined(&DC_CACHEALIGN_8LONG)) {
    sub DC_CACHEALIGN_8LONG () {	0x00004000;}
}
unless(defined(&DC_CACHEALIGN_16LONG)) {
    sub DC_CACHEALIGN_16LONG () {	0x00008000;}
}
unless(defined(&DC_CACHEALIGN_32LONG)) {
    sub DC_CACHEALIGN_32LONG () {	0x0000c000;}
}
unless(defined(&DC_BURSTLEN_USECA)) {
    sub DC_BURSTLEN_USECA () {	0x00000000;}
}
unless(defined(&DC_BURSTLEN_1LONG)) {
    sub DC_BURSTLEN_1LONG () {	0x00000100;}
}
unless(defined(&DC_BURSTLEN_2LONG)) {
    sub DC_BURSTLEN_2LONG () {	0x00000200;}
}
unless(defined(&DC_BURSTLEN_4LONG)) {
    sub DC_BURSTLEN_4LONG () {	0x00000400;}
}
unless(defined(&DC_BURSTLEN_8LONG)) {
    sub DC_BURSTLEN_8LONG () {	0x00000800;}
}
unless(defined(&DC_BURSTLEN_16LONG)) {
    sub DC_BURSTLEN_16LONG () {	0x00001000;}
}
unless(defined(&DC_BURSTLEN_32LONG)) {
    sub DC_BURSTLEN_32LONG () {	0x00002000;}
}
unless(defined(&DC_TXPOLL_OFF)) {
    sub DC_TXPOLL_OFF () {	0x00000000;}
}
unless(defined(&DC_TXPOLL_1)) {
    sub DC_TXPOLL_1 () {	0x00020000;}
}
unless(defined(&DC_TXPOLL_2)) {
    sub DC_TXPOLL_2 () {	0x00040000;}
}
unless(defined(&DC_TXPOLL_3)) {
    sub DC_TXPOLL_3 () {	0x00060000;}
}
unless(defined(&DC_TXPOLL_4)) {
    sub DC_TXPOLL_4 () {	0x00080000;}
}
unless(defined(&DC_TXPOLL_5)) {
    sub DC_TXPOLL_5 () {	0x000a0000;}
}
unless(defined(&DC_TXPOLL_6)) {
    sub DC_TXPOLL_6 () {	0x000c0000;}
}
unless(defined(&DC_TXPOLL_7)) {
    sub DC_TXPOLL_7 () {	0x000e0000;}
}
unless(defined(&DC_ISR_TX_OK)) {
    sub DC_ISR_TX_OK () {	0x00000001;}
}
unless(defined(&DC_ISR_TX_IDLE)) {
    sub DC_ISR_TX_IDLE () {	0x00000002;}
}
unless(defined(&DC_ISR_TX_NOBUF)) {
    sub DC_ISR_TX_NOBUF () {	0x00000004;}
}
unless(defined(&DC_ISR_TX_JABBERTIMEO)) {
    sub DC_ISR_TX_JABBERTIMEO () {	0x00000008;}
}
unless(defined(&DC_ISR_LINKGOOD)) {
    sub DC_ISR_LINKGOOD () {	0x00000010;}
}
unless(defined(&DC_ISR_TX_UNDERRUN)) {
    sub DC_ISR_TX_UNDERRUN () {	0x00000020;}
}
unless(defined(&DC_ISR_RX_OK)) {
    sub DC_ISR_RX_OK () {	0x00000040;}
}
unless(defined(&DC_ISR_RX_NOBUF)) {
    sub DC_ISR_RX_NOBUF () {	0x00000080;}
}
unless(defined(&DC_ISR_RX_READ)) {
    sub DC_ISR_RX_READ () {	0x00000100;}
}
unless(defined(&DC_ISR_RX_WATDOGTIMEO)) {
    sub DC_ISR_RX_WATDOGTIMEO () {	0x00000200;}
}
unless(defined(&DC_ISR_TX_EARLY)) {
    sub DC_ISR_TX_EARLY () {	0x00000400;}
}
unless(defined(&DC_ISR_TIMER_EXPIRED)) {
    sub DC_ISR_TIMER_EXPIRED () {	0x00000800;}
}
unless(defined(&DC_ISR_LINKFAIL)) {
    sub DC_ISR_LINKFAIL () {	0x00001000;}
}
unless(defined(&DC_ISR_BUS_ERR)) {
    sub DC_ISR_BUS_ERR () {	0x00002000;}
}
unless(defined(&DC_ISR_RX_EARLY)) {
    sub DC_ISR_RX_EARLY () {	0x00004000;}
}
unless(defined(&DC_ISR_ABNORMAL)) {
    sub DC_ISR_ABNORMAL () {	0x00008000;}
}
unless(defined(&DC_ISR_NORMAL)) {
    sub DC_ISR_NORMAL () {	0x00010000;}
}
unless(defined(&DC_ISR_RX_STATE)) {
    sub DC_ISR_RX_STATE () {	0x000e0000;}
}
unless(defined(&DC_ISR_TX_STATE)) {
    sub DC_ISR_TX_STATE () {	0x00700000;}
}
unless(defined(&DC_ISR_BUSERRTYPE)) {
    sub DC_ISR_BUSERRTYPE () {	0x03800000;}
}
unless(defined(&DC_ISR_100MBPSLINK)) {
    sub DC_ISR_100MBPSLINK () {	0x08000000;}
}
unless(defined(&DC_ISR_MAGICKPACK)) {
    sub DC_ISR_MAGICKPACK () {	0x10000000;}
}
unless(defined(&DC_RXSTATE_STOPPED)) {
    sub DC_RXSTATE_STOPPED () {	0x00000000;}
}
unless(defined(&DC_RXSTATE_FETCH)) {
    sub DC_RXSTATE_FETCH () {	0x00020000;}
}
unless(defined(&DC_RXSTATE_ENDCHECK)) {
    sub DC_RXSTATE_ENDCHECK () {	0x00040000;}
}
unless(defined(&DC_RXSTATE_WAIT)) {
    sub DC_RXSTATE_WAIT () {	0x00060000;}
}
unless(defined(&DC_RXSTATE_SUSPEND)) {
    sub DC_RXSTATE_SUSPEND () {	0x00080000;}
}
unless(defined(&DC_RXSTATE_CLOSE)) {
    sub DC_RXSTATE_CLOSE () {	0x000a0000;}
}
unless(defined(&DC_RXSTATE_FLUSH)) {
    sub DC_RXSTATE_FLUSH () {	0x000c0000;}
}
unless(defined(&DC_RXSTATE_DEQUEUE)) {
    sub DC_RXSTATE_DEQUEUE () {	0x000e0000;}
}
unless(defined(&DC_TXSTATE_RESET)) {
    sub DC_TXSTATE_RESET () {	0x00000000;}
}
unless(defined(&DC_TXSTATE_FETCH)) {
    sub DC_TXSTATE_FETCH () {	0x00100000;}
}
unless(defined(&DC_TXSTATE_WAITEND)) {
    sub DC_TXSTATE_WAITEND () {	0x00200000;}
}
unless(defined(&DC_TXSTATE_READING)) {
    sub DC_TXSTATE_READING () {	0x00300000;}
}
unless(defined(&DC_TXSTATE_RSVD)) {
    sub DC_TXSTATE_RSVD () {	0x00400000;}
}
unless(defined(&DC_TXSTATE_SETUP)) {
    sub DC_TXSTATE_SETUP () {	0x00500000;}
}
unless(defined(&DC_TXSTATE_SUSPEND)) {
    sub DC_TXSTATE_SUSPEND () {	0x00600000;}
}
unless(defined(&DC_TXSTATE_CLOSE)) {
    sub DC_TXSTATE_CLOSE () {	0x00700000;}
}
unless(defined(&DC_NETCFG_RX_HASHPERF)) {
    sub DC_NETCFG_RX_HASHPERF () {	0x00000001;}
}
unless(defined(&DC_NETCFG_RX_ON)) {
    sub DC_NETCFG_RX_ON () {	0x00000002;}
}
unless(defined(&DC_NETCFG_RX_HASHONLY)) {
    sub DC_NETCFG_RX_HASHONLY () {	0x00000004;}
}
unless(defined(&DC_NETCFG_RX_BADFRAMES)) {
    sub DC_NETCFG_RX_BADFRAMES () {	0x00000008;}
}
unless(defined(&DC_NETCFG_RX_INVFILT)) {
    sub DC_NETCFG_RX_INVFILT () {	0x00000010;}
}
unless(defined(&DC_NETCFG_BACKOFFCNT)) {
    sub DC_NETCFG_BACKOFFCNT () {	0x00000020;}
}
unless(defined(&DC_NETCFG_RX_PROMISC)) {
    sub DC_NETCFG_RX_PROMISC () {	0x00000040;}
}
unless(defined(&DC_NETCFG_RX_ALLMULTI)) {
    sub DC_NETCFG_RX_ALLMULTI () {	0x00000080;}
}
unless(defined(&DC_NETCFG_FULLDUPLEX)) {
    sub DC_NETCFG_FULLDUPLEX () {	0x00000200;}
}
unless(defined(&DC_NETCFG_LOOPBACK)) {
    sub DC_NETCFG_LOOPBACK () {	0x00000c00;}
}
unless(defined(&DC_NETCFG_FORCECOLL)) {
    sub DC_NETCFG_FORCECOLL () {	0x00001000;}
}
unless(defined(&DC_NETCFG_TX_ON)) {
    sub DC_NETCFG_TX_ON () {	0x00002000;}
}
unless(defined(&DC_NETCFG_TX_THRESH)) {
    sub DC_NETCFG_TX_THRESH () {	0x0000c000;}
}
unless(defined(&DC_NETCFG_TX_BACKOFF)) {
    sub DC_NETCFG_TX_BACKOFF () {	0x00020000;}
}
unless(defined(&DC_NETCFG_PORTSEL)) {
    sub DC_NETCFG_PORTSEL () {	0x00040000;}
}
unless(defined(&DC_NETCFG_HEARTBEAT)) {
    sub DC_NETCFG_HEARTBEAT () {	0x00080000;}
}
unless(defined(&DC_NETCFG_STORENFWD)) {
    sub DC_NETCFG_STORENFWD () {	0x00200000;}
}
unless(defined(&DC_NETCFG_SPEEDSEL)) {
    sub DC_NETCFG_SPEEDSEL () {	0x00400000;}
}
unless(defined(&DC_NETCFG_PCS)) {
    sub DC_NETCFG_PCS () {	0x00800000;}
}
unless(defined(&DC_NETCFG_SCRAMBLER)) {
    sub DC_NETCFG_SCRAMBLER () {	0x01000000;}
}
unless(defined(&DC_NETCFG_NO_RXCRC)) {
    sub DC_NETCFG_NO_RXCRC () {	0x02000000;}
}
unless(defined(&DC_NETCFG_RX_ALL)) {
    sub DC_NETCFG_RX_ALL () {	0x40000000;}
}
unless(defined(&DC_NETCFG_CAPEFFECT)) {
    sub DC_NETCFG_CAPEFFECT () {	0x80000000;}
}
unless(defined(&DC_OPMODE_NORM)) {
    sub DC_OPMODE_NORM () {	0x00000000;}
}
unless(defined(&DC_OPMODE_INTLOOP)) {
    sub DC_OPMODE_INTLOOP () {	0x00000400;}
}
unless(defined(&DC_OPMODE_EXTLOOP)) {
    sub DC_OPMODE_EXTLOOP () {	0x00000800;}
}
unless(defined(&DC_TXTHRESH_72BYTES)) {
    sub DC_TXTHRESH_72BYTES () {	0x00000000;}
}
unless(defined(&DC_TXTHRESH_96BYTES)) {
    sub DC_TXTHRESH_96BYTES () {	0x00004000;}
}
unless(defined(&DC_TXTHRESH_128BYTES)) {
    sub DC_TXTHRESH_128BYTES () {	0x00008000;}
}
unless(defined(&DC_TXTHRESH_160BYTES)) {
    sub DC_TXTHRESH_160BYTES () {	0x0000c000;}
}
unless(defined(&DC_IMR_TX_OK)) {
    sub DC_IMR_TX_OK () {	0x00000001;}
}
unless(defined(&DC_IMR_TX_IDLE)) {
    sub DC_IMR_TX_IDLE () {	0x00000002;}
}
unless(defined(&DC_IMR_TX_NOBUF)) {
    sub DC_IMR_TX_NOBUF () {	0x00000004;}
}
unless(defined(&DC_IMR_TX_JABBERTIMEO)) {
    sub DC_IMR_TX_JABBERTIMEO () {	0x00000008;}
}
unless(defined(&DC_IMR_LINKGOOD)) {
    sub DC_IMR_LINKGOOD () {	0x00000010;}
}
unless(defined(&DC_IMR_TX_UNDERRUN)) {
    sub DC_IMR_TX_UNDERRUN () {	0x00000020;}
}
unless(defined(&DC_IMR_RX_OK)) {
    sub DC_IMR_RX_OK () {	0x00000040;}
}
unless(defined(&DC_IMR_RX_NOBUF)) {
    sub DC_IMR_RX_NOBUF () {	0x00000080;}
}
unless(defined(&DC_IMR_RX_READ)) {
    sub DC_IMR_RX_READ () {	0x00000100;}
}
unless(defined(&DC_IMR_RX_WATDOGTIMEO)) {
    sub DC_IMR_RX_WATDOGTIMEO () {	0x00000200;}
}
unless(defined(&DC_IMR_TX_EARLY)) {
    sub DC_IMR_TX_EARLY () {	0x00000400;}
}
unless(defined(&DC_IMR_TIMER_EXPIRED)) {
    sub DC_IMR_TIMER_EXPIRED () {	0x00000800;}
}
unless(defined(&DC_IMR_LINKFAIL)) {
    sub DC_IMR_LINKFAIL () {	0x00001000;}
}
unless(defined(&DC_IMR_BUS_ERR)) {
    sub DC_IMR_BUS_ERR () {	0x00002000;}
}
unless(defined(&DC_IMR_RX_EARLY)) {
    sub DC_IMR_RX_EARLY () {	0x00004000;}
}
unless(defined(&DC_IMR_ABNORMAL)) {
    sub DC_IMR_ABNORMAL () {	0x00008000;}
}
unless(defined(&DC_IMR_NORMAL)) {
    sub DC_IMR_NORMAL () {	0x00010000;}
}
unless(defined(&DC_IMR_100MBPSLINK)) {
    sub DC_IMR_100MBPSLINK () {	0x08000000;}
}
unless(defined(&DC_IMR_MAGICKPACK)) {
    sub DC_IMR_MAGICKPACK () {	0x10000000;}
}
unless(defined(&DC_INTRS)) {
    sub DC_INTRS () {	( &DC_IMR_RX_OK| &DC_IMR_TX_OK| &DC_IMR_RX_NOBUF| &DC_IMR_RX_WATDOGTIMEO|  &DC_IMR_TX_NOBUF| &DC_IMR_TX_UNDERRUN| &DC_IMR_BUS_ERR|  &DC_IMR_ABNORMAL| &DC_IMR_NORMAL);}
}
unless(defined(&DC_SIO_EE_CS)) {
    sub DC_SIO_EE_CS () {	0x00000001;}
}
unless(defined(&DC_SIO_EE_CLK)) {
    sub DC_SIO_EE_CLK () {	0x00000002;}
}
unless(defined(&DC_SIO_EE_DATAIN)) {
    sub DC_SIO_EE_DATAIN () {	0x00000004;}
}
unless(defined(&DC_SIO_EE_DATAOUT)) {
    sub DC_SIO_EE_DATAOUT () {	0x00000008;}
}
unless(defined(&DC_SIO_ROMDATA4)) {
    sub DC_SIO_ROMDATA4 () {	0x00000010;}
}
unless(defined(&DC_SIO_ROMDATA5)) {
    sub DC_SIO_ROMDATA5 () {	0x00000020;}
}
unless(defined(&DC_SIO_ROMDATA6)) {
    sub DC_SIO_ROMDATA6 () {	0x00000040;}
}
unless(defined(&DC_SIO_ROMDATA7)) {
    sub DC_SIO_ROMDATA7 () {	0x00000080;}
}
unless(defined(&DC_SIO_EESEL)) {
    sub DC_SIO_EESEL () {	0x00000800;}
}
unless(defined(&DC_SIO_ROMSEL)) {
    sub DC_SIO_ROMSEL () {	0x00001000;}
}
unless(defined(&DC_SIO_ROMCTL_WRITE)) {
    sub DC_SIO_ROMCTL_WRITE () {	0x00002000;}
}
unless(defined(&DC_SIO_ROMCTL_READ)) {
    sub DC_SIO_ROMCTL_READ () {	0x00004000;}
}
unless(defined(&DC_SIO_MII_CLK)) {
    sub DC_SIO_MII_CLK () {	0x00010000;}
}
unless(defined(&DC_SIO_MII_DATAOUT)) {
    sub DC_SIO_MII_DATAOUT () {	0x00020000;}
}
unless(defined(&DC_SIO_MII_DIR)) {
    sub DC_SIO_MII_DIR () {	0x00040000;}
}
unless(defined(&DC_SIO_MII_DATAIN)) {
    sub DC_SIO_MII_DATAIN () {	0x00080000;}
}
unless(defined(&DC_EECMD_WRITE)) {
    sub DC_EECMD_WRITE () {	0x140;}
}
unless(defined(&DC_EECMD_READ)) {
    sub DC_EECMD_READ () {	0x180;}
}
unless(defined(&DC_EECMD_ERASE)) {
    sub DC_EECMD_ERASE () {	0x1c0;}
}
unless(defined(&DC_EE_NODEADDR_OFFSET)) {
    sub DC_EE_NODEADDR_OFFSET () {	0x70;}
}
unless(defined(&DC_EE_NODEADDR)) {
    sub DC_EE_NODEADDR () {	10;}
}
unless(defined(&DC_TIMER_VALUE)) {
    sub DC_TIMER_VALUE () {	0x0000ffff;}
}
unless(defined(&DC_TIMER_CONTINUOUS)) {
    sub DC_TIMER_CONTINUOUS () {	0x00010000;}
}
unless(defined(&DC_TSTAT_MIIACT)) {
    sub DC_TSTAT_MIIACT () {	0x00000001;}
}
unless(defined(&DC_TSTAT_LS100)) {
    sub DC_TSTAT_LS100 () {	0x00000002;}
}
unless(defined(&DC_TSTAT_LS10)) {
    sub DC_TSTAT_LS10 () {	0x00000004;}
}
unless(defined(&DC_TSTAT_AUTOPOLARITY)) {
    sub DC_TSTAT_AUTOPOLARITY () {	0x00000008;}
}
unless(defined(&DC_TSTAT_AUIACT)) {
    sub DC_TSTAT_AUIACT () {	0x00000100;}
}
unless(defined(&DC_TSTAT_10BTACT)) {
    sub DC_TSTAT_10BTACT () {	0x00000200;}
}
unless(defined(&DC_TSTAT_NSN)) {
    sub DC_TSTAT_NSN () {	0x00000400;}
}
unless(defined(&DC_TSTAT_REMFAULT)) {
    sub DC_TSTAT_REMFAULT () {	0x00000800;}
}
unless(defined(&DC_TSTAT_ANEGSTAT)) {
    sub DC_TSTAT_ANEGSTAT () {	0x00007000;}
}
unless(defined(&DC_TSTAT_LP_CAN_NWAY)) {
    sub DC_TSTAT_LP_CAN_NWAY () {	0x00008000;}
}
unless(defined(&DC_TSTAT_LPCODEWORD)) {
    sub DC_TSTAT_LPCODEWORD () {	0xffff0000;}
}
unless(defined(&DC_ASTAT_DISABLE)) {
    sub DC_ASTAT_DISABLE () {	0x00000000;}
}
unless(defined(&DC_ASTAT_TXDISABLE)) {
    sub DC_ASTAT_TXDISABLE () {	0x00001000;}
}
unless(defined(&DC_ASTAT_ABDETECT)) {
    sub DC_ASTAT_ABDETECT () {	0x00002000;}
}
unless(defined(&DC_ASTAT_ACKDETECT)) {
    sub DC_ASTAT_ACKDETECT () {	0x00003000;}
}
unless(defined(&DC_ASTAT_CMPACKDETECT)) {
    sub DC_ASTAT_CMPACKDETECT () {	0x00004000;}
}
unless(defined(&DC_ASTAT_AUTONEGCMP)) {
    sub DC_ASTAT_AUTONEGCMP () {	0x00005000;}
}
unless(defined(&DC_ASTAT_LINKCHECK)) {
    sub DC_ASTAT_LINKCHECK () {	0x00006000;}
}
unless(defined(&DC_SIA_RESET)) {
    sub DC_SIA_RESET () {	0x00000001;}
}
unless(defined(&DC_SIA_AUI)) {
    sub DC_SIA_AUI () {	0x00000008;}
}
unless(defined(&DC_TCTL_ENCODER_ENB)) {
    sub DC_TCTL_ENCODER_ENB () {	0x00000001;}
}
unless(defined(&DC_TCTL_LOOPBACK)) {
    sub DC_TCTL_LOOPBACK () {	0x00000002;}
}
unless(defined(&DC_TCTL_DRIVER_ENB)) {
    sub DC_TCTL_DRIVER_ENB () {	0x00000004;}
}
unless(defined(&DC_TCTL_LNKPULSE_ENB)) {
    sub DC_TCTL_LNKPULSE_ENB () {	0x00000008;}
}
unless(defined(&DC_TCTL_HALFDUPLEX)) {
    sub DC_TCTL_HALFDUPLEX () {	0x00000040;}
}
unless(defined(&DC_TCTL_AUTONEGENBL)) {
    sub DC_TCTL_AUTONEGENBL () {	0x00000080;}
}
unless(defined(&DC_TCTL_RX_SQUELCH)) {
    sub DC_TCTL_RX_SQUELCH () {	0x00000100;}
}
unless(defined(&DC_TCTL_COLL_SQUELCH)) {
    sub DC_TCTL_COLL_SQUELCH () {	0x00000200;}
}
unless(defined(&DC_TCTL_COLL_DETECT)) {
    sub DC_TCTL_COLL_DETECT () {	0x00000400;}
}
unless(defined(&DC_TCTL_SQE_ENB)) {
    sub DC_TCTL_SQE_ENB () {	0x00000800;}
}
unless(defined(&DC_TCTL_LINKTEST)) {
    sub DC_TCTL_LINKTEST () {	0x00001000;}
}
unless(defined(&DC_TCTL_AUTOPOLARITY)) {
    sub DC_TCTL_AUTOPOLARITY () {	0x00002000;}
}
unless(defined(&DC_TCTL_SET_POL_PLUS)) {
    sub DC_TCTL_SET_POL_PLUS () {	0x00004000;}
}
unless(defined(&DC_TCTL_AUTOSENSE)) {
    sub DC_TCTL_AUTOSENSE () {	0x00008000;}
}
unless(defined(&DC_TCTL_100BTXHALF)) {
    sub DC_TCTL_100BTXHALF () {	0x00010000;}
}
unless(defined(&DC_TCTL_100BTXFULL)) {
    sub DC_TCTL_100BTXFULL () {	0x00020000;}
}
unless(defined(&DC_TCTL_100BT4)) {
    sub DC_TCTL_100BT4 () {	0x00040000;}
}
unless(defined(&DC_WDOG_JABBERDIS)) {
    sub DC_WDOG_JABBERDIS () {	0x00000001;}
}
unless(defined(&DC_WDOG_HOSTUNJAB)) {
    sub DC_WDOG_HOSTUNJAB () {	0x00000002;}
}
unless(defined(&DC_WDOG_JABBERCLK)) {
    sub DC_WDOG_JABBERCLK () {	0x00000004;}
}
unless(defined(&DC_WDOG_RXWDOGDIS)) {
    sub DC_WDOG_RXWDOGDIS () {	0x00000010;}
}
unless(defined(&DC_WDOG_RXWDOGCLK)) {
    sub DC_WDOG_RXWDOGCLK () {	0x00000020;}
}
unless(defined(&DC_WDOG_MUSTBEZERO)) {
    sub DC_WDOG_MUSTBEZERO () {	0x00000100;}
}
unless(defined(&DC_WDOG_AUIBNC)) {
    sub DC_WDOG_AUIBNC () {	0x00100000;}
}
unless(defined(&DC_WDOG_ACTIVITY)) {
    sub DC_WDOG_ACTIVITY () {	0x00200000;}
}
unless(defined(&DC_WDOG_LINK)) {
    sub DC_WDOG_LINK () {	0x00800000;}
}
unless(defined(&DC_WDOG_CTLWREN)) {
    sub DC_WDOG_CTLWREN () {	0x08000000;}
}
unless(defined(&DC_SIAGP_RXMATCH)) {
    sub DC_SIAGP_RXMATCH () {	0x40000000;}
}
unless(defined(&DC_SIAGP_INT1)) {
    sub DC_SIAGP_INT1 () {	0x20000000;}
}
unless(defined(&DC_SIAGP_INT0)) {
    sub DC_SIAGP_INT0 () {	0x10000000;}
}
unless(defined(&DC_SIAGP_WRITE_EN)) {
    sub DC_SIAGP_WRITE_EN () {	0x08000000;}
}
unless(defined(&DC_SIAGP_RXMATCH_EN)) {
    sub DC_SIAGP_RXMATCH_EN () {	0x04000000;}
}
unless(defined(&DC_SIAGP_INT1_EN)) {
    sub DC_SIAGP_INT1_EN () {	0x02000000;}
}
unless(defined(&DC_SIAGP_INT0_EN)) {
    sub DC_SIAGP_INT0_EN () {	0x01000000;}
}
unless(defined(&DC_SIAGP_LED3)) {
    sub DC_SIAGP_LED3 () {	0x00800000;}
}
unless(defined(&DC_SIAGP_LED2)) {
    sub DC_SIAGP_LED2 () {	0x00400000;}
}
unless(defined(&DC_SIAGP_LED1)) {
    sub DC_SIAGP_LED1 () {	0x00200000;}
}
unless(defined(&DC_SIAGP_LED0)) {
    sub DC_SIAGP_LED0 () {	0x00100000;}
}
unless(defined(&DC_SIAGP_MD_GP3_OUTPUT)) {
    sub DC_SIAGP_MD_GP3_OUTPUT () {	0x00080000;}
}
unless(defined(&DC_SIAGP_MD_GP2_OUTPUT)) {
    sub DC_SIAGP_MD_GP2_OUTPUT () {	0x00040000;}
}
unless(defined(&DC_SIAGP_MD_GP1_OUTPUT)) {
    sub DC_SIAGP_MD_GP1_OUTPUT () {	0x00020000;}
}
unless(defined(&DC_SIAGP_MD_GP0_OUTPUT)) {
    sub DC_SIAGP_MD_GP0_OUTPUT () {	0x00010000;}
}
unless(defined(&DC_SFRAME_LEN)) {
    sub DC_SFRAME_LEN () {	192;}
}
unless(defined(&dc_data)) {
    sub dc_data () {	 &dc_ptr1;}
}
unless(defined(&dc_next)) {
    sub dc_next () {	 &dc_ptr2;}
}
unless(defined(&DC_RXSTAT_FIFOOFLOW)) {
    sub DC_RXSTAT_FIFOOFLOW () {	0x00000001;}
}
unless(defined(&DC_RXSTAT_CRCERR)) {
    sub DC_RXSTAT_CRCERR () {	0x00000002;}
}
unless(defined(&DC_RXSTAT_DRIBBLE)) {
    sub DC_RXSTAT_DRIBBLE () {	0x00000004;}
}
unless(defined(&DC_RXSTAT_WATCHDOG)) {
    sub DC_RXSTAT_WATCHDOG () {	0x00000010;}
}
unless(defined(&DC_RXSTAT_FRAMETYPE)) {
    sub DC_RXSTAT_FRAMETYPE () {	0x00000020;}
}
unless(defined(&DC_RXSTAT_COLLSEEN)) {
    sub DC_RXSTAT_COLLSEEN () {	0x00000040;}
}
unless(defined(&DC_RXSTAT_GIANT)) {
    sub DC_RXSTAT_GIANT () {	0x00000080;}
}
unless(defined(&DC_RXSTAT_LASTFRAG)) {
    sub DC_RXSTAT_LASTFRAG () {	0x00000100;}
}
unless(defined(&DC_RXSTAT_FIRSTFRAG)) {
    sub DC_RXSTAT_FIRSTFRAG () {	0x00000200;}
}
unless(defined(&DC_RXSTAT_MULTICAST)) {
    sub DC_RXSTAT_MULTICAST () {	0x00000400;}
}
unless(defined(&DC_RXSTAT_RUNT)) {
    sub DC_RXSTAT_RUNT () {	0x00000800;}
}
unless(defined(&DC_RXSTAT_RXTYPE)) {
    sub DC_RXSTAT_RXTYPE () {	0x00003000;}
}
unless(defined(&DC_RXSTAT_RXERR)) {
    sub DC_RXSTAT_RXERR () {	0x00008000;}
}
unless(defined(&DC_RXSTAT_RXLEN)) {
    sub DC_RXSTAT_RXLEN () {	0x3fff0000;}
}
unless(defined(&DC_RXSTAT_OWN)) {
    sub DC_RXSTAT_OWN () {	0x80000000;}
}
unless(defined(&DC_RXBYTES)) {
    sub DC_RXBYTES {
	local($x) = @_;
	eval q((($x &  &DC_RXSTAT_RXLEN) >> 16));
    }
}
unless(defined(&DC_RXSTAT)) {
    sub DC_RXSTAT () {	( &DC_RXSTAT_FIRSTFRAG| &DC_RXSTAT_LASTFRAG| &DC_RXSTAT_OWN);}
}
unless(defined(&DC_RXCTL_BUFLEN1)) {
    sub DC_RXCTL_BUFLEN1 () {	0x00000fff;}
}
unless(defined(&DC_RXCTL_BUFLEN2)) {
    sub DC_RXCTL_BUFLEN2 () {	0x00fff000;}
}
unless(defined(&DC_RXCTL_RLINK)) {
    sub DC_RXCTL_RLINK () {	0x01000000;}
}
unless(defined(&DC_RXCTL_RLAST)) {
    sub DC_RXCTL_RLAST () {	0x02000000;}
}
unless(defined(&DC_TXSTAT_DEFER)) {
    sub DC_TXSTAT_DEFER () {	0x00000001;}
}
unless(defined(&DC_TXSTAT_UNDERRUN)) {
    sub DC_TXSTAT_UNDERRUN () {	0x00000002;}
}
unless(defined(&DC_TXSTAT_LINKFAIL)) {
    sub DC_TXSTAT_LINKFAIL () {	0x00000003;}
}
unless(defined(&DC_TXSTAT_COLLCNT)) {
    sub DC_TXSTAT_COLLCNT () {	0x00000078;}
}
unless(defined(&DC_TXSTAT_SQE)) {
    sub DC_TXSTAT_SQE () {	0x00000080;}
}
unless(defined(&DC_TXSTAT_EXCESSCOLL)) {
    sub DC_TXSTAT_EXCESSCOLL () {	0x00000100;}
}
unless(defined(&DC_TXSTAT_LATECOLL)) {
    sub DC_TXSTAT_LATECOLL () {	0x00000200;}
}
unless(defined(&DC_TXSTAT_NOCARRIER)) {
    sub DC_TXSTAT_NOCARRIER () {	0x00000400;}
}
unless(defined(&DC_TXSTAT_CARRLOST)) {
    sub DC_TXSTAT_CARRLOST () {	0x00000800;}
}
unless(defined(&DC_TXSTAT_JABTIMEO)) {
    sub DC_TXSTAT_JABTIMEO () {	0x00004000;}
}
unless(defined(&DC_TXSTAT_ERRSUM)) {
    sub DC_TXSTAT_ERRSUM () {	0x00008000;}
}
unless(defined(&DC_TXSTAT_OWN)) {
    sub DC_TXSTAT_OWN () {	0x80000000;}
}
unless(defined(&DC_TXCTL_BUFLEN1)) {
    sub DC_TXCTL_BUFLEN1 () {	0x000007ff;}
}
unless(defined(&DC_TXCTL_BUFLEN2)) {
    sub DC_TXCTL_BUFLEN2 () {	0x003ff800;}
}
unless(defined(&DC_TXCTL_FILTTYPE0)) {
    sub DC_TXCTL_FILTTYPE0 () {	0x00400000;}
}
unless(defined(&DC_TXCTL_PAD)) {
    sub DC_TXCTL_PAD () {	0x00800000;}
}
unless(defined(&DC_TXCTL_TLINK)) {
    sub DC_TXCTL_TLINK () {	0x01000000;}
}
unless(defined(&DC_TXCTL_TLAST)) {
    sub DC_TXCTL_TLAST () {	0x02000000;}
}
unless(defined(&DC_TXCTL_NOCRC)) {
    sub DC_TXCTL_NOCRC () {	0x04000000;}
}
unless(defined(&DC_TXCTL_SETUP)) {
    sub DC_TXCTL_SETUP () {	0x08000000;}
}
unless(defined(&DC_TXCTL_FILTTYPE1)) {
    sub DC_TXCTL_FILTTYPE1 () {	0x10000000;}
}
unless(defined(&DC_TXCTL_FIRSTFRAG)) {
    sub DC_TXCTL_FIRSTFRAG () {	0x20000000;}
}
unless(defined(&DC_TXCTL_LASTFRAG)) {
    sub DC_TXCTL_LASTFRAG () {	0x40000000;}
}
unless(defined(&DC_TXCTL_FINT)) {
    sub DC_TXCTL_FINT () {	0x80000000;}
}
unless(defined(&DC_FILTER_PERFECT)) {
    sub DC_FILTER_PERFECT () {	0x00000000;}
}
unless(defined(&DC_FILTER_HASHPERF)) {
    sub DC_FILTER_HASHPERF () {	0x00400000;}
}
unless(defined(&DC_FILTER_INVERSE)) {
    sub DC_FILTER_INVERSE () {	0x10000000;}
}
unless(defined(&DC_FILTER_HASHONLY)) {
    sub DC_FILTER_HASHONLY () {	0x10400000;}
}
unless(defined(&DC_MAXFRAGS)) {
    sub DC_MAXFRAGS () {	16;}
}
unless(defined(&DC_RX_LIST_CNT)) {
    sub DC_RX_LIST_CNT () {	64;}
}
unless(defined(&DC_TX_LIST_CNT)) {
    sub DC_TX_LIST_CNT () {	256;}
}
unless(defined(&DC_MIN_FRAMELEN)) {
    sub DC_MIN_FRAMELEN () {	60;}
}
unless(defined(&DC_RXLEN)) {
    sub DC_RXLEN () {	1536;}
}
unless(defined(&DC_INC)) {
    sub DC_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&DC_MII_STARTDELIM)) {
    sub DC_MII_STARTDELIM () {	0x01;}
}
unless(defined(&DC_MII_READOP)) {
    sub DC_MII_READOP () {	0x02;}
}
unless(defined(&DC_MII_WRITEOP)) {
    sub DC_MII_WRITEOP () {	0x01;}
}
unless(defined(&DC_MII_TURNAROUND)) {
    sub DC_MII_TURNAROUND () {	0x02;}
}
unless(defined(&DC_AL_PAR0)) {
    sub DC_AL_PAR0 () {	0xa4;}
}
unless(defined(&DC_AL_PAR1)) {
    sub DC_AL_PAR1 () {	0xa8;}
}
unless(defined(&DC_AL_MAR0)) {
    sub DC_AL_MAR0 () {	0xac;}
}
unless(defined(&DC_AL_MAR1)) {
    sub DC_AL_MAR1 () {	0xb0;}
}
unless(defined(&DC_AL_BMCR)) {
    sub DC_AL_BMCR () {	0xb4;}
}
unless(defined(&DC_AL_BMSR)) {
    sub DC_AL_BMSR () {	0xb8;}
}
unless(defined(&DC_AL_VENID)) {
    sub DC_AL_VENID () {	0xbc;}
}
unless(defined(&DC_AL_DEVID)) {
    sub DC_AL_DEVID () {	0xc0;}
}
unless(defined(&DC_AL_ANAR)) {
    sub DC_AL_ANAR () {	0xc4;}
}
unless(defined(&DC_AL_LPAR)) {
    sub DC_AL_LPAR () {	0xc8;}
}
unless(defined(&DC_AL_ANER)) {
    sub DC_AL_ANER () {	0xcc;}
}
unless(defined(&DC_ADMTEK_PHYADDR)) {
    sub DC_ADMTEK_PHYADDR () {	0x1;}
}
unless(defined(&DC_AL_EE_NODEADDR)) {
    sub DC_AL_EE_NODEADDR () {	4;}
}
unless(defined(&DC_AX_FILTIDX)) {
    sub DC_AX_FILTIDX () {	0x68;}
}
unless(defined(&DC_AX_FILTDATA)) {
    sub DC_AX_FILTDATA () {	0x70;}
}
unless(defined(&DC_AX_NETCFG_RX_BROAD)) {
    sub DC_AX_NETCFG_RX_BROAD () {	0x00000100;}
}
unless(defined(&DC_AX_FILTIDX_PAR0)) {
    sub DC_AX_FILTIDX_PAR0 () {	0x00000000;}
}
unless(defined(&DC_AX_FILTIDX_PAR1)) {
    sub DC_AX_FILTIDX_PAR1 () {	0x00000001;}
}
unless(defined(&DC_AX_FILTIDX_MAR0)) {
    sub DC_AX_FILTIDX_MAR0 () {	0x00000002;}
}
unless(defined(&DC_AX_FILTIDX_MAR1)) {
    sub DC_AX_FILTIDX_MAR1 () {	0x00000003;}
}
unless(defined(&DC_MX_MAGICPACKET)) {
    sub DC_MX_MAGICPACKET () {	0x80;}
}
unless(defined(&DC_MX_NWAYSTAT)) {
    sub DC_MX_NWAYSTAT () {	0xa0;}
}
unless(defined(&DC_MX_MPACK_DISABLE)) {
    sub DC_MX_MPACK_DISABLE () {	0x00400000;}
}
unless(defined(&DC_MX_NWAY_10BTHALF)) {
    sub DC_MX_NWAY_10BTHALF () {	0x08000000;}
}
unless(defined(&DC_MX_NWAY_10BTFULL)) {
    sub DC_MX_NWAY_10BTFULL () {	0x10000000;}
}
unless(defined(&DC_MX_NWAY_100BTHALF)) {
    sub DC_MX_NWAY_100BTHALF () {	0x20000000;}
}
unless(defined(&DC_MX_NWAY_100BTFULL)) {
    sub DC_MX_NWAY_100BTFULL () {	0x40000000;}
}
unless(defined(&DC_MX_NWAY_100BT4)) {
    sub DC_MX_NWAY_100BT4 () {	0x80000000;}
}
unless(defined(&DC_MX_MAGIC_98713)) {
    sub DC_MX_MAGIC_98713 () {	0x0f370000;}
}
unless(defined(&DC_MX_MAGIC_98713A)) {
    sub DC_MX_MAGIC_98713A () {	0x0b3c0000;}
}
unless(defined(&DC_MX_MAGIC_98715)) {
    sub DC_MX_MAGIC_98715 () {	0x0b3c0000;}
}
unless(defined(&DC_MX_MAGIC_98725)) {
    sub DC_MX_MAGIC_98725 () {	0x0b3c0000;}
}
unless(defined(&DC_PN_GPIO)) {
    sub DC_PN_GPIO () {	0x60;}
}
unless(defined(&DC_PN_PWRUP_CFG)) {
    sub DC_PN_PWRUP_CFG () {	0x90;}
}
unless(defined(&DC_PN_SIOCTL)) {
    sub DC_PN_SIOCTL () {	0x98;}
}
unless(defined(&DC_PN_MII)) {
    sub DC_PN_MII () {	0xa0;}
}
unless(defined(&DC_PN_NWAY)) {
    sub DC_PN_NWAY () {	0xb8;}
}
unless(defined(&DC_PN_SIOCTL_DATA)) {
    sub DC_PN_SIOCTL_DATA () {	0x0000003f;}
}
unless(defined(&DC_PN_SIOCTL_OPCODE)) {
    sub DC_PN_SIOCTL_OPCODE () {	0x00000300;}
}
unless(defined(&DC_PN_SIOCTL_BUSY)) {
    sub DC_PN_SIOCTL_BUSY () {	0x80000000;}
}
unless(defined(&DC_PN_EEOPCODE_ERASE)) {
    sub DC_PN_EEOPCODE_ERASE () {	0x00000300;}
}
unless(defined(&DC_PN_EEOPCODE_READ)) {
    sub DC_PN_EEOPCODE_READ () {	0x00000600;}
}
unless(defined(&DC_PN_EEOPCODE_WRITE)) {
    sub DC_PN_EEOPCODE_WRITE () {	0x00000100;}
}
unless(defined(&DC_PN_GPIO_DATA0)) {
    sub DC_PN_GPIO_DATA0 () {	0x000000001;}
}
unless(defined(&DC_PN_GPIO_DATA1)) {
    sub DC_PN_GPIO_DATA1 () {	0x000000002;}
}
unless(defined(&DC_PN_GPIO_DATA2)) {
    sub DC_PN_GPIO_DATA2 () {	0x000000004;}
}
unless(defined(&DC_PN_GPIO_DATA3)) {
    sub DC_PN_GPIO_DATA3 () {	0x000000008;}
}
unless(defined(&DC_PN_GPIO_CTL0)) {
    sub DC_PN_GPIO_CTL0 () {	0x000000010;}
}
unless(defined(&DC_PN_GPIO_CTL1)) {
    sub DC_PN_GPIO_CTL1 () {	0x000000020;}
}
unless(defined(&DC_PN_GPIO_CTL2)) {
    sub DC_PN_GPIO_CTL2 () {	0x000000040;}
}
unless(defined(&DC_PN_GPIO_CTL3)) {
    sub DC_PN_GPIO_CTL3 () {	0x000000080;}
}
unless(defined(&DC_PN_GPIO_SPEEDSEL)) {
    sub DC_PN_GPIO_SPEEDSEL () {	 &DC_PN_GPIO_DATA0;}
}
unless(defined(&DC_PN_GPIO_100TX_LOOP)) {
    sub DC_PN_GPIO_100TX_LOOP () {	 &DC_PN_GPIO_DATA1;}
}
unless(defined(&DC_PN_GPIO_BNC_ENB)) {
    sub DC_PN_GPIO_BNC_ENB () {	 &DC_PN_GPIO_DATA2;}
}
unless(defined(&DC_PN_GPIO_100TX_LNK)) {
    sub DC_PN_GPIO_100TX_LNK () {	 &DC_PN_GPIO_DATA3;}
}
unless(defined(&DC_PN_GPIO_SETBIT)) {
    sub DC_PN_GPIO_SETBIT {
	local($sc, $r) = @_;
	eval q( &DC_SETBIT($sc,  &DC_PN_GPIO, (($r) | ($r << 4))));
    }
}
unless(defined(&DC_PN_GPIO_CLRBIT)) {
    sub DC_PN_GPIO_CLRBIT {
	local($sc, $r) = @_;
	eval q({  &DC_SETBIT($sc,  &DC_PN_GPIO, (($r) << 4));  &DC_CLRBIT($sc,  &DC_PN_GPIO, ($r)); });
    }
}
unless(defined(&DC_PN_MII_DATA)) {
    sub DC_PN_MII_DATA () {	0x0000ffff;}
}
unless(defined(&DC_PN_MII_RESERVER)) {
    sub DC_PN_MII_RESERVER () {	0x00020000;}
}
unless(defined(&DC_PN_MII_REGADDR)) {
    sub DC_PN_MII_REGADDR () {	0x007c0000;}
}
unless(defined(&DC_PN_MII_PHYADDR)) {
    sub DC_PN_MII_PHYADDR () {	0x0f800000;}
}
unless(defined(&DC_PN_MII_OPCODE)) {
    sub DC_PN_MII_OPCODE () {	0x30000000;}
}
unless(defined(&DC_PN_MII_BUSY)) {
    sub DC_PN_MII_BUSY () {	0x80000000;}
}
unless(defined(&DC_PN_MIIOPCODE_READ)) {
    sub DC_PN_MIIOPCODE_READ () {	0x60020000;}
}
unless(defined(&DC_PN_MIIOPCODE_WRITE)) {
    sub DC_PN_MIIOPCODE_WRITE () {	0x50020000;}
}
unless(defined(&DC_PN_NWAY_RESET)) {
    sub DC_PN_NWAY_RESET () {	0x00000001;}
}
unless(defined(&DC_PN_NWAY_PDOWN)) {
    sub DC_PN_NWAY_PDOWN () {	0x00000002;}
}
unless(defined(&DC_PN_NWAY_BYPASS)) {
    sub DC_PN_NWAY_BYPASS () {	0x00000004;}
}
unless(defined(&DC_PN_NWAY_AUILOWCUR)) {
    sub DC_PN_NWAY_AUILOWCUR () {	0x00000008;}
}
unless(defined(&DC_PN_NWAY_TPEXTEND)) {
    sub DC_PN_NWAY_TPEXTEND () {	0x00000010;}
}
unless(defined(&DC_PN_NWAY_POLARITY)) {
    sub DC_PN_NWAY_POLARITY () {	0x00000020;}
}
unless(defined(&DC_PN_NWAY_TP)) {
    sub DC_PN_NWAY_TP () {	0x00000040;}
}
unless(defined(&DC_PN_NWAY_AUIVOLT)) {
    sub DC_PN_NWAY_AUIVOLT () {	0x00000080;}
}
unless(defined(&DC_PN_NWAY_DUPLEX)) {
    sub DC_PN_NWAY_DUPLEX () {	0x00000100;}
}
unless(defined(&DC_PN_NWAY_LINKTEST)) {
    sub DC_PN_NWAY_LINKTEST () {	0x00000200;}
}
unless(defined(&DC_PN_NWAY_AUTODETECT)) {
    sub DC_PN_NWAY_AUTODETECT () {	0x00000400;}
}
unless(defined(&DC_PN_NWAY_SPEEDSEL)) {
    sub DC_PN_NWAY_SPEEDSEL () {	0x00000800;}
}
unless(defined(&DC_PN_NWAY_NWAY_ENB)) {
    sub DC_PN_NWAY_NWAY_ENB () {	0x00001000;}
}
unless(defined(&DC_PN_NWAY_CAP10HDX)) {
    sub DC_PN_NWAY_CAP10HDX () {	0x00002000;}
}
unless(defined(&DC_PN_NWAY_CAP10FDX)) {
    sub DC_PN_NWAY_CAP10FDX () {	0x00004000;}
}
unless(defined(&DC_PN_NWAY_CAP100FDX)) {
    sub DC_PN_NWAY_CAP100FDX () {	0x00008000;}
}
unless(defined(&DC_PN_NWAY_CAP100HDX)) {
    sub DC_PN_NWAY_CAP100HDX () {	0x00010000;}
}
unless(defined(&DC_PN_NWAY_CAP100T4)) {
    sub DC_PN_NWAY_CAP100T4 () {	0x00020000;}
}
unless(defined(&DC_PN_NWAY_ANEGRESTART)) {
    sub DC_PN_NWAY_ANEGRESTART () {	0x02000000;}
}
unless(defined(&DC_PN_NWAY_REMFAULT)) {
    sub DC_PN_NWAY_REMFAULT () {	0x04000000;}
}
unless(defined(&DC_PN_NWAY_LPAR10HDX)) {
    sub DC_PN_NWAY_LPAR10HDX () {	0x08000000;}
}
unless(defined(&DC_PN_NWAY_LPAR10FDX)) {
    sub DC_PN_NWAY_LPAR10FDX () {	0x10000000;}
}
unless(defined(&DC_PN_NWAY_LPAR100FDX)) {
    sub DC_PN_NWAY_LPAR100FDX () {	0x20000000;}
}
unless(defined(&DC_PN_NWAY_LPAR100HDX)) {
    sub DC_PN_NWAY_LPAR100HDX () {	0x40000000;}
}
unless(defined(&DC_PN_NWAY_LPAR100T4)) {
    sub DC_PN_NWAY_LPAR100T4 () {	0x80000000;}
}
unless(defined(&DC_TX_POLL)) {
    sub DC_TX_POLL () {	0x00000001;}
}
unless(defined(&DC_TX_COALESCE)) {
    sub DC_TX_COALESCE () {	0x00000002;}
}
unless(defined(&DC_TX_ADMTEK_WAR)) {
    sub DC_TX_ADMTEK_WAR () {	0x00000004;}
}
unless(defined(&DC_TX_USE_TX_INTR)) {
    sub DC_TX_USE_TX_INTR () {	0x00000008;}
}
unless(defined(&DC_RX_FILTER_TULIP)) {
    sub DC_RX_FILTER_TULIP () {	0x00000010;}
}
unless(defined(&DC_TX_INTR_FIRSTFRAG)) {
    sub DC_TX_INTR_FIRSTFRAG () {	0x00000020;}
}
unless(defined(&DC_PNIC_RX_BUG_WAR)) {
    sub DC_PNIC_RX_BUG_WAR () {	0x00000040;}
}
unless(defined(&DC_TX_FIXED_RING)) {
    sub DC_TX_FIXED_RING () {	0x00000080;}
}
unless(defined(&DC_TX_STORENFWD)) {
    sub DC_TX_STORENFWD () {	0x00000100;}
}
unless(defined(&DC_REDUCED_MII_POLL)) {
    sub DC_REDUCED_MII_POLL () {	0x00000200;}
}
unless(defined(&DC_TX_INTR_ALWAYS)) {
    sub DC_TX_INTR_ALWAYS () {	0x00000400;}
}
unless(defined(&DC_21143_NWAY)) {
    sub DC_21143_NWAY () {	0x00000800;}
}
unless(defined(&DC_128BIT_HASH)) {
    sub DC_128BIT_HASH () {	0x00001000;}
}
unless(defined(&DC_64BIT_HASH)) {
    sub DC_64BIT_HASH () {	0x00002000;}
}
unless(defined(&DC_TULIP_LEDS)) {
    sub DC_TULIP_LEDS () {	0x00004000;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{dc_btag}),  ($sc->{dc_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{dc_btag}),  ($sc->{dc_bhandle}), $reg));
    }
}
unless(defined(&DC_TIMEOUT)) {
    sub DC_TIMEOUT () {	1000;}
}
unless(defined(&ETHER_ALIGN)) {
    sub ETHER_ALIGN () {	2;}
}
unless(defined(&DC_REVISION_98713)) {
    sub DC_REVISION_98713 () {	0x00;}
}
unless(defined(&DC_REVISION_98713A)) {
    sub DC_REVISION_98713A () {	0x10;}
}
unless(defined(&DC_REVISION_98715)) {
    sub DC_REVISION_98715 () {	0x20;}
}
unless(defined(&DC_REVISION_98715AEC_C)) {
    sub DC_REVISION_98715AEC_C () {	0x25;}
}
unless(defined(&DC_REVISION_98725)) {
    sub DC_REVISION_98725 () {	0x30;}
}
unless(defined(&DC_REVISION_82C168)) {
    sub DC_REVISION_82C168 () {	0x10;}
}
unless(defined(&DC_REVISION_82C169)) {
    sub DC_REVISION_82C169 () {	0x20;}
}
unless(defined(&DC_REVISION_88140)) {
    sub DC_REVISION_88140 () {	0x00;}
}
unless(defined(&DC_REVISION_88141)) {
    sub DC_REVISION_88141 () {	0x10;}
}
unless(defined(&DC_REVISION_DM9102)) {
    sub DC_REVISION_DM9102 () {	0x10;}
}
unless(defined(&DC_REVISION_DM9102A)) {
    sub DC_REVISION_DM9102A () {	0x30;}
}
unless(defined(&DC_PCI_CFID)) {
    sub DC_PCI_CFID () {	0x00;}
}
unless(defined(&DC_PCI_CFCS)) {
    sub DC_PCI_CFCS () {	0x04;}
}
unless(defined(&DC_PCI_CFRV)) {
    sub DC_PCI_CFRV () {	0x08;}
}
unless(defined(&DC_PCI_CFLT)) {
    sub DC_PCI_CFLT () {	0x0c;}
}
unless(defined(&DC_PCI_CFBIO)) {
    sub DC_PCI_CFBIO () {	0x10;}
}
unless(defined(&DC_PCI_CFBMA)) {
    sub DC_PCI_CFBMA () {	0x14;}
}
unless(defined(&DC_PCI_CCIS)) {
    sub DC_PCI_CCIS () {	0x28;}
}
unless(defined(&DC_PCI_CSID)) {
    sub DC_PCI_CSID () {	0x2c;}
}
unless(defined(&DC_PCI_CBER)) {
    sub DC_PCI_CBER () {	0x30;}
}
unless(defined(&DC_PCI_CCAP)) {
    sub DC_PCI_CCAP () {	0x34;}
}
unless(defined(&DC_PCI_CFIT)) {
    sub DC_PCI_CFIT () {	0x3c;}
}
unless(defined(&DC_PCI_CFDD)) {
    sub DC_PCI_CFDD () {	0x40;}
}
unless(defined(&DC_PCI_CWUA0)) {
    sub DC_PCI_CWUA0 () {	0x44;}
}
unless(defined(&DC_PCI_CWUA1)) {
    sub DC_PCI_CWUA1 () {	0x48;}
}
unless(defined(&DC_PCI_SOP0)) {
    sub DC_PCI_SOP0 () {	0x4c;}
}
unless(defined(&DC_PCI_SOP1)) {
    sub DC_PCI_SOP1 () {	0x50;}
}
unless(defined(&DC_PCI_CWUC)) {
    sub DC_PCI_CWUC () {	0x54;}
}
unless(defined(&DC_PCI_CCID)) {
    sub DC_PCI_CCID () {	0xdc;}
}
unless(defined(&DC_PCI_CPMC)) {
    sub DC_PCI_CPMC () {	0xe0;}
}
unless(defined(&DC_CFID_VENDOR)) {
    sub DC_CFID_VENDOR () {	0x0000ffff;}
}
unless(defined(&DC_CFID_DEVICE)) {
    sub DC_CFID_DEVICE () {	0xffff0000;}
}
unless(defined(&DC_CFCS_IOSPACE)) {
    sub DC_CFCS_IOSPACE () {	0x00000001;}
}
unless(defined(&DC_CFCS_MEMSPACE)) {
    sub DC_CFCS_MEMSPACE () {	0x00000002;}
}
unless(defined(&DC_CFCS_BUSMASTER)) {
    sub DC_CFCS_BUSMASTER () {	0x00000004;}
}
unless(defined(&DC_CFCS_MWI_ENB)) {
    sub DC_CFCS_MWI_ENB () {	0x00000008;}
}
unless(defined(&DC_CFCS_PARITYERR_ENB)) {
    sub DC_CFCS_PARITYERR_ENB () {	0x00000020;}
}
unless(defined(&DC_CFCS_SYSERR_ENB)) {
    sub DC_CFCS_SYSERR_ENB () {	0x00000080;}
}
unless(defined(&DC_CFCS_NEWCAPS)) {
    sub DC_CFCS_NEWCAPS () {	0x00100000;}
}
unless(defined(&DC_CFCS_FAST_B2B)) {
    sub DC_CFCS_FAST_B2B () {	0x00800000;}
}
unless(defined(&DC_CFCS_DATAPARITY)) {
    sub DC_CFCS_DATAPARITY () {	0x01000000;}
}
unless(defined(&DC_CFCS_DEVSELTIM)) {
    sub DC_CFCS_DEVSELTIM () {	0x06000000;}
}
unless(defined(&DC_CFCS_TGTABRT)) {
    sub DC_CFCS_TGTABRT () {	0x10000000;}
}
unless(defined(&DC_CFCS_MASTERABRT)) {
    sub DC_CFCS_MASTERABRT () {	0x20000000;}
}
unless(defined(&DC_CFCS_SYSERR)) {
    sub DC_CFCS_SYSERR () {	0x40000000;}
}
unless(defined(&DC_CFCS_PARITYERR)) {
    sub DC_CFCS_PARITYERR () {	0x80000000;}
}
unless(defined(&DC_CFRV_STEPPING)) {
    sub DC_CFRV_STEPPING () {	0x0000000f;}
}
unless(defined(&DC_CFRV_REVISION)) {
    sub DC_CFRV_REVISION () {	0x000000f0;}
}
unless(defined(&DC_CFRV_SUBCLASS)) {
    sub DC_CFRV_SUBCLASS () {	0x00ff0000;}
}
unless(defined(&DC_CFRV_BASECLASS)) {
    sub DC_CFRV_BASECLASS () {	0xff000000;}
}
unless(defined(&DC_21143_PB_REV)) {
    sub DC_21143_PB_REV () {	0x00000030;}
}
unless(defined(&DC_21143_TB_REV)) {
    sub DC_21143_TB_REV () {	0x00000030;}
}
unless(defined(&DC_21143_PC_REV)) {
    sub DC_21143_PC_REV () {	0x00000030;}
}
unless(defined(&DC_21143_TC_REV)) {
    sub DC_21143_TC_REV () {	0x00000030;}
}
unless(defined(&DC_21143_PD_REV)) {
    sub DC_21143_PD_REV () {	0x00000041;}
}
unless(defined(&DC_21143_TD_REV)) {
    sub DC_21143_TD_REV () {	0x00000041;}
}
unless(defined(&DC_CFLT_CACHELINESIZE)) {
    sub DC_CFLT_CACHELINESIZE () {	0x000000ff;}
}
unless(defined(&DC_CFLT_LATENCYTIMER)) {
    sub DC_CFLT_LATENCYTIMER () {	0x0000ff00;}
}
unless(defined(&DC_CSID_VENDOR)) {
    sub DC_CSID_VENDOR () {	0x0000ffff;}
}
unless(defined(&DC_CSID_DEVICE)) {
    sub DC_CSID_DEVICE () {	0xffff0000;}
}
unless(defined(&DC_CCAP_OFFSET)) {
    sub DC_CCAP_OFFSET () {	0x000000ff;}
}
unless(defined(&DC_CFIT_INTLINE)) {
    sub DC_CFIT_INTLINE () {	0x000000ff;}
}
unless(defined(&DC_CFIT_INTPIN)) {
    sub DC_CFIT_INTPIN () {	0x0000ff00;}
}
unless(defined(&DC_CFIT_MIN_GNT)) {
    sub DC_CFIT_MIN_GNT () {	0x00ff0000;}
}
unless(defined(&DC_CFIT_MAX_LAT)) {
    sub DC_CFIT_MAX_LAT () {	0xff000000;}
}
unless(defined(&DC_CCID_CAPID)) {
    sub DC_CCID_CAPID () {	0x000000ff;}
}
unless(defined(&DC_CCID_NEXTPTR)) {
    sub DC_CCID_NEXTPTR () {	0x0000ff00;}
}
unless(defined(&DC_CCID_PM_VERS)) {
    sub DC_CCID_PM_VERS () {	0x00070000;}
}
unless(defined(&DC_CCID_PME_CLK)) {
    sub DC_CCID_PME_CLK () {	0x00080000;}
}
unless(defined(&DC_CCID_DVSPEC_INT)) {
    sub DC_CCID_DVSPEC_INT () {	0x00200000;}
}
unless(defined(&DC_CCID_STATE_D1)) {
    sub DC_CCID_STATE_D1 () {	0x02000000;}
}
unless(defined(&DC_CCID_STATE_D2)) {
    sub DC_CCID_STATE_D2 () {	0x04000000;}
}
unless(defined(&DC_CCID_PME_D0)) {
    sub DC_CCID_PME_D0 () {	0x08000000;}
}
unless(defined(&DC_CCID_PME_D1)) {
    sub DC_CCID_PME_D1 () {	0x10000000;}
}
unless(defined(&DC_CCID_PME_D2)) {
    sub DC_CCID_PME_D2 () {	0x20000000;}
}
unless(defined(&DC_CCID_PME_D3HOT)) {
    sub DC_CCID_PME_D3HOT () {	0x40000000;}
}
unless(defined(&DC_CCID_PME_D3COLD)) {
    sub DC_CCID_PME_D3COLD () {	0x80000000;}
}
unless(defined(&DC_CPMC_STATE)) {
    sub DC_CPMC_STATE () {	0x00000003;}
}
unless(defined(&DC_CPMC_PME_ENB)) {
    sub DC_CPMC_PME_ENB () {	0x00000100;}
}
unless(defined(&DC_CPMC_PME_STS)) {
    sub DC_CPMC_PME_STS () {	0x00008000;}
}
unless(defined(&DC_PSTATE_D0)) {
    sub DC_PSTATE_D0 () {	0x0;}
}
unless(defined(&DC_PSTATE_D1)) {
    sub DC_PSTATE_D1 () {	0x1;}
}
unless(defined(&DC_PSTATE_D2)) {
    sub DC_PSTATE_D2 () {	0x2;}
}
unless(defined(&DC_PSTATE_D3)) {
    sub DC_PSTATE_D3 () {	0x3;}
}
unless(defined(&DC_CFDD_DRVUSE)) {
    sub DC_CFDD_DRVUSE () {	0x0000ffff;}
}
unless(defined(&DC_CFDD_SNOOZE_MODE)) {
    sub DC_CFDD_SNOOZE_MODE () {	0x40000000;}
}
unless(defined(&DC_CFDD_SLEEP_MODE)) {
    sub DC_CFDD_SLEEP_MODE () {	0x80000000;}
}
unless(defined(&DC_CWUC_MUST_BE_ZERO)) {
    sub DC_CWUC_MUST_BE_ZERO () {	0x00000001;}
}
unless(defined(&DC_CWUC_SECUREON_ENB)) {
    sub DC_CWUC_SECUREON_ENB () {	0x00000002;}
}
unless(defined(&DC_CWUC_FORCE_WUL)) {
    sub DC_CWUC_FORCE_WUL () {	0x00000004;}
}
unless(defined(&DC_CWUC_BNC_ABILITY)) {
    sub DC_CWUC_BNC_ABILITY () {	0x00000008;}
}
unless(defined(&DC_CWUC_AUI_ABILITY)) {
    sub DC_CWUC_AUI_ABILITY () {	0x00000010;}
}
unless(defined(&DC_CWUC_TP10_ABILITY)) {
    sub DC_CWUC_TP10_ABILITY () {	0x00000020;}
}
unless(defined(&DC_CWUC_MII_ABILITY)) {
    sub DC_CWUC_MII_ABILITY () {	0x00000040;}
}
unless(defined(&DC_CWUC_SYM_ABILITY)) {
    sub DC_CWUC_SYM_ABILITY () {	0x00000080;}
}
unless(defined(&DC_CWUC_LOCK)) {
    sub DC_CWUC_LOCK () {	0x00000100;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap($va));
    }' unless defined(&vtophys);
}
unless(defined(&ETHER_CRC_LEN)) {
    eval 'sub ETHER_CRC_LEN () {4;}' unless defined(&ETHER_CRC_LEN);
}
1;
