;;; finder-inf.el --- keyword-to-package mapping
;; Keywords: help
;;; Commentary:
;; Don't edit this file.  It's generated by finder.el

;;; Code:

(setq finder-package-info '(
    ("default.el"
        "Site-wide file run after User's init file is run."
        nil
        "lisp/")
    ("paths.el"
        "define pathnames for use by various Emacs commands."
        (internal)
        "lisp/")
    ("site-load.el"
        "Template file for site-wide XEmacs customization"
        (internal)
        "lisp/")
    ("site-start.el"
        "Site wide run time initialization"
        nil
        "lisp/")
    ("alist.el"
        "utility functions about assoc-list"
        (alist)
        "lisp/apel/")
    ("atype.el"
        "atype functions"
        (atype)
        "lisp/apel/")
    ("emu-18.el"
        "emu API implementation for Emacs 18.*"
        (emulation  compatibility)
        "lisp/apel/")
    ("emu-19.el"
        "emu API implementation for Emacs 19.*"
        (emulation  compatibility)
        "lisp/apel/")
    ("emu-20.el"
        "emu API implementation for Emacs 20 and XEmacs/mule"
        (emulation  compatibility  mule)
        "lisp/apel/")
    ("emu-e19.el"
        "emu module for Emacs 19 and XEmacs 19"
        (emulation  compatibility  mule  latin-1)
        "lisp/apel/")
    ("emu-e20.el"
        "emu API implementation for Emacs 20"
        (emulation  compatibility  mule)
        "lisp/apel/")
    ("emu-mule.el"
        "emu module for Mule 1.* and Mule 2.*"
        (emulation  compatibility  mule)
        "lisp/apel/")
    ("emu-nemacs.el"
        "emu API implementation for NEmacs"
        (emulation  compatibility  nemacs  mule)
        "lisp/apel/")
    ("emu-x20.el"
        "emu API implementation for XEmacs with mule"
        (emulation  compatibility  mule  xemacs)
        "lisp/apel/")
    ("emu-xemacs.el"
        "emu API implementation for XEmacs"
        (emulation  compatibility  xemacs)
        "lisp/apel/")
    ("emu.el"
        "Emulation module for each Emacs variants"
        (emulation  compatibility  nemacs  mule  emacs/mule  xemacs)
        "lisp/apel/")
    ("file-detect.el"
        "Path management or file detection utility"
        (file detection  install  module)
        "lisp/apel/")
    ("filename.el"
        "file name filter"
        (file name  string)
        "lisp/apel/")
    ("install.el"
        "Emacs Lisp package install utility"
        (install  byte-compile  directory detection)
        "lisp/apel/")
    ("mule-caesar.el"
        "ROT 13-47 Caesar rotation utility"
        (rot 13-47  caesar  mail  news  text/x-rot13-47)
        "lisp/apel/")
    ("path-util.el"
        "Emacs Lisp file detection utility"
        (file detection  install  module)
        "lisp/apel/")
    ("richtext.el"
        "read and save files in text/richtext format"
        (wp  faces  mime  multimedia)
        "lisp/apel/")
    ("std11-parse.el"
        "STD 11 parser for GNU Emacs"
        (mail  news  rfc 822  std 11)
        "lisp/apel/")
    ("std11.el"
        "STD 11 functions for GNU Emacs"
        (mail  news  rfc 822  std 11)
        "lisp/apel/")
    ("custom-load.el"
        "automatically extracted custom dependencies"
        nil
        "lisp/auctex/")
    ("font-latex.el"
        "LaTeX fontification for Font Lock mode."
        (latex faces)
        "lisp/auctex/")
    ("latex.el"
        "Support for LaTeX documents."
        (wp)
        "lisp/auctex/")
    ("multi-prompt.el"
        "completing read of multiple strings."
        (extensions)
        "lisp/auctex/")
    ("tex.el"
        "Support for TeX documents."
        (wp)
        "lisp/auctex/")
    ("byte-optimize.el"
        "the optimization passes of the emacs-lisp byte compiler."
        (internal)
        "lisp/bytecomp/")
    ("bytecomp-runtime.el"
        "byte-compiler support for inlining"
        (internal)
        "lisp/bytecomp/")
    ("bytecomp.el"
        "compilation of Lisp code into byte code."
        (internal)
        "lisp/bytecomp/")
    ("disass.el"
        "disassembler for compiled Emacs Lisp code"
        (internal)
        "lisp/bytecomp/")
    ("appt.el"
        "appointment notification functions."
        (calendar)
        "lisp/calendar/")
    ("cal-dst.el"
        "calendar functions for daylight savings rules."
        (calendar)
        "lisp/calendar/")
    ("cal-french.el"
        "calendar functions for the French Revolutionary calendar."
        (calendar)
        "lisp/calendar/")
    ("cal-mayan.el"
        "calendar functions for the Mayan calendars."
        (calendar)
        "lisp/calendar/")
    ("cal-x.el"
        "calendar windows in dedicated frames in x-windows"
        (calendar)
        "lisp/calendar/")
    ("cal-xemacs.el"
        "calendar functions for menu bar and popup menu support"
        (calendar)
        "lisp/calendar/")
    ("calendar.el"
        "Calendar functions.  -*-byte-compile-dynamic: t;-*-"
        (calendar)
        "lisp/calendar/")
    ("diary-ins.el"
        "calendar functions for adding diary entries."
        (diary  calendar)
        "lisp/calendar/")
    ("diary-lib.el"
        "diary functions."
        (calendar)
        "lisp/calendar/")
    ("holidays.el"
        "holiday functions for the calendar package"
        (holidays  calendar)
        "lisp/calendar/")
    ("lunar.el"
        "calendar functions for phases of the moon."
        (calendar)
        "lisp/calendar/")
    ("solar.el"
        "calendar functions for solar events."
        (calendar)
        "lisp/calendar/")
    ("cc-align.el"
        "custom indentation functions for CC Mode"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-cmds.el"
        "user level commands for CC Mode "
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-compat.el"
        "cc-mode compatibility with c-mode.el confusion"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-defs.el"
        "definitions for CC Mode"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-engine.el"
        "core syntax guessing engine for CC mode"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-langs.el"
        "specific language support for CC Mode"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-menus.el"
        "imenu support for CC Mode"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-mode.el"
        "major mode for editing C, C++, Objective-C, and Java code"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-styles.el"
        "support for styles in CC Mode"
        (c languages oop)
        "lisp/cc-mode/")
    ("cc-vars.el"
        "user customization variables for CC Mode"
        (c languages oop)
        "lisp/cc-mode/")
    ("cl-compat.el"
        "Common Lisp extensions for GNU Emacs Lisp (compatibility)"
        (extensions)
        "lisp/cl/")
    ("cl-extra.el"
        "Common Lisp extensions for GNU Emacs Lisp (part two)"
        (extensions)
        "lisp/cl/")
    ("cl-macs.el"
        "Common Lisp extensions for GNU Emacs Lisp (part four)"
        (extensions)
        "lisp/cl/")
    ("cl-seq.el"
        "Common Lisp extensions for GNU Emacs Lisp (part three)"
        (extensions)
        "lisp/cl/")
    ("cl.el"
        "Common Lisp extensions for GNU Emacs Lisp"
        (extensions  lisp)
        "lisp/cl/")
    ("background.el"
        "fun with background jobs"
        (processes)
        "lisp/comint/")
    ("comint-xemacs.el"
        "Face customizations for comint"
        (help  faces)
        "lisp/comint/")
    ("comint.el"
        "general command interpreter in a window stuff"
        (processes)
        "lisp/comint/")
    ("dbx.el"
        "run dbx under Emacs"
        (c  unix  tools  debugging)
        "lisp/comint/")
    ("gdb.el"
        "run gdb under Emacs"
        (c  unix  tools  debugging)
        "lisp/comint/")
    ("gdbsrc.el"
        "Source-based (as opposed to comint-based) debugger"
        (c  unix  tools  debugging)
        "lisp/comint/")
    ("gud.el"
        "Grand Unified Debugger mode for gdb, sdb, dbx, or xdb"
        (c  unix  tools  debugging)
        "lisp/comint/")
    ("history.el"
        "Generic history stuff"
        nil
        "lisp/comint/")
    ("inf-lisp.el"
        "an inferior-lisp mode"
        (processes  lisp)
        "lisp/comint/")
    ("kermit.el"
        "additions to shell mode for use with kermit, etc."
        (comm)
        "lisp/comint/")
    ("rlogin.el"
        "remote login interface"
        (unix  comm)
        "lisp/comint/")
    ("shell.el"
        "specialized comint.el for running the shell."
        (processes)
        "lisp/comint/")
    ("ssh.el"
        "remote login interface"
        (unix  comm)
        "lisp/comint/")
    ("telnet.el"
        "run a telnet session from within an Emacs buffer"
        (comm  unix)
        "lisp/comint/")
    ("cus-dep.el"
        "Find customization dependencies."
        (internal)
        "lisp/custom/")
    ("cus-edit.el"
        "Tools for customizating Emacs and Lisp packages."
        (help  faces)
        "lisp/custom/")
    ("cus-face.el"
        "Support for Custom faces."
        (help  faces)
        "lisp/custom/")
    ("cus-load.el"
        "Batch load all available cus-load files"
        (internal  help  faces)
        "lisp/custom/")
    ("cus-start.el"
        "define customization properties of builtins."
        (internal)
        "lisp/custom/")
    ("custom.el"
        "Tools for declaring and initializing options."
        (help  faces)
        "lisp/custom/")
    ("wid-browse.el"
        "Functions for browsing widgets."
        (extensions)
        "lisp/custom/")
    ("wid-edit.el"
        "Functions for creating and using widgets."
        (extensions)
        "lisp/custom/")
    ("widget.el"
        "a library of user interface components."
        (help  extensions  faces  hypermedia)
        "lisp/custom/")
    ("advise-eval-region.el"
        "Wrap advice around eval-region"
        (extensions lisp)
        "lisp/edebug/")
    ("cust-print.el"
        "handles print-level and print-circle."
        (extensions)
        "lisp/edebug/")
    ("edebug-cl-read.el"
        "Edebug reader macros for use with cl-read."
        (lisp  tools  maint)
        "lisp/edebug/")
    ("edebug.el"
        "a source-level debugger for Emacs Lisp"
        (lisp  tools  maint)
        "lisp/edebug/")
    ("eval-reg.el"
        "Redefine eval-region, and subrs that use it, in Lisp"
        (lisp)
        "lisp/edebug/")
    ("ediff-diff.el"
        "diff-related utilities"
        nil
        "lisp/ediff/")
    ("ediff-help.el"
        "Code related to the contents of Ediff help buffers"
        nil
        "lisp/ediff/")
    ("ediff-hook.el"
        "setup for Ediff's menus and autoloads"
        nil
        "lisp/ediff/")
    ("ediff-init.el"
        "Macros, variables, and defsubsts used by Ediff"
        nil
        "lisp/ediff/")
    ("ediff-merg.el"
        "merging utilities"
        nil
        "lisp/ediff/")
    ("ediff-mult.el"
        "support for multi-file/multi-buffer processing in Ediff"
        nil
        "lisp/ediff/")
    ("ediff-ptch.el"
        "Ediff's  patch support"
        nil
        "lisp/ediff/")
    ("ediff-tbar.el"
        "A toolbar for Ediff control buffer"
        nil
        "lisp/ediff/")
    ("ediff-util.el"
        "the core commands and utilities of ediff"
        nil
        "lisp/ediff/")
    ("ediff-vers.el"
        "version control interface to Ediff"
        nil
        "lisp/ediff/")
    ("ediff-wind.el"
        "window manipulation utilities"
        nil
        "lisp/ediff/")
    ("ediff.el"
        "a comprehensive visual interface to diff & patch"
        (comparing  merging  patching  version control.)
        "lisp/ediff/")
    ("egg-leim.el"
        "Egg/Wnn-related code for LEIM"
        (japanese  input method  leim)
        "lisp/egg/")
    ("egg-sj3-leim.el"
        "Egg/SJ3-related code for LEIM"
        (japanese  input method  leim)
        "lisp/egg/")
    ("egg-wnn.el"
        "a inputting method communicating with [jck]server"
        (inputting method)
        "lisp/egg/")
    ("ebuff-menu.el"
        "electric-buffer-list mode"
        (frames)
        "lisp/electric/")
    ("echistory.el"
        "Electric Command History Mode"
        (extensions)
        "lisp/electric/")
    ("ehelp.el"
        "bindings for electric-help mode"
        (help  extensions)
        "lisp/electric/")
    ("electric.el"
        "window maker and Command loop for `electric' modes."
        (extensions)
        "lisp/electric/")
    ("helper.el"
        "utility help package supporting help in electric modes"
        (help)
        "lisp/electric/")
    ("crisp.el"
        "CRiSP/Brief Emacs emulator"
        (emulations brief crisp)
        "lisp/emulators/")
    ("edt-lk201.el"
        "Enhanced EDT Keypad Mode Emulation for LK-201 Keyboards"
        (emulations)
        "lisp/emulators/")
    ("edt-mapper.el"
        "Create an EDT LK-201 Map File for X-Windows Emacs"
        (emulations)
        "lisp/emulators/")
    ("edt-pc.el"
        "Enhanced EDT Keypad Mode Emulation for PC 101 Keyboards"
        (emulations)
        "lisp/emulators/")
    ("edt-vt100.el"
        "Enhanced EDT Keypad Mode Emulation for VT Series Terminals"
        (emulations)
        "lisp/emulators/")
    ("edt.el"
        "Enhanced EDT Keypad Mode Emulation for GNU Emacs 19"
        (emulations)
        "lisp/emulators/")
    ("scroll-lock.el"
        "scroll-locking minor mode"
        (scroll crisp brief lock)
        "lisp/emulators/")
    ("teco.el"
        "Teco interpreter for Gnu Emacs, version 1."
        (emulators)
        "lisp/emulators/")
    ("tpu-doc.el"
        "Documentation for TPU-edt"
        (emulations)
        "lisp/emulators/")
    ("tpu-edt.el"
        "Emacs emulating TPU emulating EDT"
        (emulations)
        "lisp/emulators/")
    ("tpu-extras.el"
        "Scroll margins and free cursor mode for TPU-edt"
        (emulations)
        "lisp/emulators/")
    ("tpu-mapper.el"
        "Create a TPU-edt X-windows keymap file"
        (emulations)
        "lisp/emulators/")
    ("ws-mode.el"
        "WordStar emulation mode for GNU Emacs"
        (emulations)
        "lisp/emulators/")
    ("eos.el"
        "Intereactively loads the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks load)
        "lisp/eos/")
    ("sun-eos-browser.el"
        "Implements the XEmacs/SPARCworks SourceBrowser interface"
        (sparcworks eos era on sparcworks sbrowser source browser)
        "lisp/eos/")
    ("sun-eos-debugger-extra.el"
        "Implements the XEmacs/SPARCworks Debugger interface"
        (sparcworks eos era on sparcworks debugger dbx)
        "lisp/eos/")
    ("sun-eos-debugger.el"
        "Implements the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks debugger dbx)
        "lisp/eos/")
    ("sun-eos-editor.el"
        "Implements the XEmacs/SPARCworks editor protocol"
        (sparcworks eos era on sparcworks editor)
        "lisp/eos/")
    ("sun-eos-init.el"
        "Initializes the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks initialize)
        "lisp/eos/")
    ("sun-eos-load.el"
        "Loads the XEmacs/SPARCworks interface code"
        (sparcworks eos era on sparcworks debugger dbx)
        "lisp/eos/")
    ("sun-eos-menubar.el"
        "Implements the XEmacs/SPARCworks menubar"
        (sparcworks eos era on sparcworks menubar)
        "lisp/eos/")
    ("sun-eos-toolbar.el"
        "Implements the EOS toolbar interface"
        (sparcworks eos era on sparcworks toolbar)
        "lisp/eos/")
    ("sun-eos.el"
        "Intereactively loads the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks load)
        "lisp/eos/")
    ("term.el"
        "general command interpreter in a window stuff"
        nil
        "lisp/eterm/")
    ("tshell.el"
        "specialized term.el for running the shell."
        (processes)
        "lisp/eterm/")
    ("NeXTify.el"
        "Character insertion variation"
        (games)
        "lisp/games/")
    ("blackbox.el"
        "blackbox game in Emacs Lisp"
        (games)
        "lisp/games/")
    ("conx.el"
        "Yet another dissociater"
        (games)
        "lisp/games/")
    ("cookie1.el"
        "retrieve random phrases from fortune cookie files"
        (games)
        "lisp/games/")
    ("decipher.el"
        "Cryptanalyze monoalphabetic substitution ciphers"
        (games)
        "lisp/games/")
    ("dissociate.el"
        "scramble text amusingly for Emacs."
        (games)
        "lisp/games/")
    ("doctor.el"
        "psychological help for frustrated users."
        (games)
        "lisp/games/")
    ("dunnet.el"
        "Text adventure for Emacs"
        (games)
        "lisp/games/")
    ("flame.el"
        "Automated insults"
        (games)
        "lisp/games/")
    ("gomoku.el"
        "Gomoku game between you and Emacs"
        (games)
        "lisp/games/")
    ("hanoi.el"
        "towers of hanoi in GNUmacs"
        (games)
        "lisp/games/")
    ("life.el"
        "John Horton Conway's `Life' game for GNU Emacs"
        (games)
        "lisp/games/")
    ("mpuz.el"
        "multiplication puzzle for XEmacs"
        (games)
        "lisp/games/")
    ("spook.el"
        "spook phrase utility for overloading the NSA line eater"
        (games)
        "lisp/games/")
    ("studly.el"
        "StudlyCaps (tm)(r)(c)(xxx)"
        (games)
        "lisp/games/")
    ("tetris.el"
        "Implementation of Tetris for Emacs."
        (games)
        "lisp/games/")
    ("xmine.el"
        "Mine game for XEmacs"
        (games)
        "lisp/games/")
    ("yow.el"
        "quote random zippyisms"
        (games)
        "lisp/games/")
    ("dgnushack.el"
        "a hack to set the load path for byte-compiling"
        (news  path)
        "lisp/gnus/")
    ("earcon.el"
        "Sound effects for messages"
        (news fun sound)
        "lisp/gnus/")
    ("gnus-art.el"
        "article mode commands for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-async.el"
        "asynchronous support for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-audio.el"
        "Sound effects for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-bcklg.el"
        "backlog functions for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-cache.el"
        "cache interface for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-cite.el"
        "parse citations in articles for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("gnus-cus.el"
        "customization commands for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-demon.el"
        "daemonic Gnus behaviour"
        (news)
        "lisp/gnus/")
    ("gnus-dup.el"
        "suppression of duplicate articles in Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-eform.el"
        "a mode for editing forms for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-ems.el"
        "functions for making Gnus work under different Emacsen"
        (news)
        "lisp/gnus/")
    ("gnus-gl.el"
        "an interface to GroupLens for Gnus"
        (news  score)
        "lisp/gnus/")
    ("gnus-group.el"
        "group mode commands for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-int.el"
        "backend interface functions for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-kill.el"
        "kill commands for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-load.el"
        "automatically extracted custom dependencies"
        nil
        "lisp/gnus/")
    ("gnus-logic.el"
        "advanced scoring code for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-mh.el"
        "mh-e interface for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-move.el"
        "commands for moving Gnus from one server to another"
        (news)
        "lisp/gnus/")
    ("gnus-msg.el"
        "mail and post interface for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-nocem.el"
        "NoCeM pseudo-cancellation treatment"
        (news)
        "lisp/gnus/")
    ("gnus-picon.el"
        "displaying pretty icons in Gnus"
        (news xpm annotation glyph faces)
        "lisp/gnus/")
    ("gnus-range.el"
        "range and sequence functions for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-salt.el"
        "alternate summary mode interfaces for Gnus"
        nil
        "lisp/gnus/")
    ("gnus-setup.el"
        "Initialization & Setup for Gnus 5"
        (news)
        "lisp/gnus/")
    ("gnus-soup.el"
        "SOUP packet writing support for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("gnus-spec.el"
        "format spec functions for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-srvr.el"
        "virtual server support for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-start.el"
        "startup functions for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-sum.el"
        "summary mode commands for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-topic.el"
        "a folding minor mode for Gnus group buffers"
        (news)
        "lisp/gnus/")
    ("gnus-undo.el"
        "minor mode for undoing in Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-util.el"
        "utility functions for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-uu.el"
        "extract (uu)encoded files in Gnus"
        nil
        "lisp/gnus/")
    ("gnus-vm.el"
        "vm interface for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("gnus-win.el"
        "window configuration functions for Gnus"
        (news)
        "lisp/gnus/")
    ("gnus-xmas.el"
        "Gnus functions for XEmacs"
        (news)
        "lisp/gnus/")
    ("gnus.el"
        "a newsreader for GNU Emacs"
        (news  mail)
        "lisp/gnus/")
    ("mailheader.el"
        "Mail header parsing, merging, formatting"
        (tools  mail  news)
        "lisp/gnus/")
    ("message.el"
        "composing mail and news messages"
        (mail  news)
        "lisp/gnus/")
    ("messagexmas.el"
        "XEmacs extensions to message"
        (mail  news)
        "lisp/gnus/")
    ("messcompat.el"
        "making message mode compatible with mail mode"
        (mail  news)
        "lisp/gnus/")
    ("nnbabyl.el"
        "rmail mbox access for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("nndb.el"
        "nndb access for Gnus"
        (news)
        "lisp/gnus/")
    ("nndir.el"
        "single directory newsgroup access for Gnus"
        (news)
        "lisp/gnus/")
    ("nndoc.el"
        "single file access for Gnus"
        (news)
        "lisp/gnus/")
    ("nndraft.el"
        "draft article access for Gnus"
        (news)
        "lisp/gnus/")
    ("nneething.el"
        "random file access for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("nnfolder.el"
        "mail folder access for Gnus"
        (mail)
        "lisp/gnus/")
    ("nngateway.el"
        "posting news via mail gateways"
        (news  mail)
        "lisp/gnus/")
    ("nnheader.el"
        "header access macros for Gnus and its backends"
        (news)
        "lisp/gnus/")
    ("nnheaderxm.el"
        "making Gnus backends work under XEmacs"
        (news)
        "lisp/gnus/")
    ("nnkiboze.el"
        "select virtual news access for Gnus"
        (news)
        "lisp/gnus/")
    ("nnmail.el"
        "mail support functions for the Gnus mail backends"
        (news  mail)
        "lisp/gnus/")
    ("nnmbox.el"
        "mail mbox access for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("nnmh.el"
        "mhspool access for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("nnml.el"
        "mail spool access for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("nnoo.el"
        "OO Gnus Backends"
        (news)
        "lisp/gnus/")
    ("nnsoup.el"
        "SOUP access for Gnus"
        (news  mail)
        "lisp/gnus/")
    ("nnspool.el"
        "spool access for GNU Emacs"
        (news)
        "lisp/gnus/")
    ("nntp.el"
        "nntp access for Gnus"
        (news)
        "lisp/gnus/")
    ("nnvirtual.el"
        "virtual newsgroups access for Gnus"
        (news)
        "lisp/gnus/")
    ("nnweb.el"
        "retrieving articles via web search engines"
        (news)
        "lisp/gnus/")
    ("parse-time.el"
        "Parsing time strings"
        (util)
        "lisp/gnus/")
    ("pop3.el"
        "Post Office Protocol (RFC 1460) interface"
        (mail  pop3)
        "lisp/gnus/")
    ("score-mode.el"
        "mode for editing Gnus score files"
        (news  mail)
        "lisp/gnus/")
    ("smiley.el"
        "displaying smiley faces"
        (fun)
        "lisp/gnus/")
    ("hm--html-menu.el"
        "A menu for the hm--html-mode."
        nil
        "lisp/hm--html-menus/")
    ("hm--html-mode.el"
        "Major mode for editing HTML documents for the WWW"
        (hypermedia languages help docs wp)
        "lisp/hm--html-menus/")
    ("html-view.el"
        "routines for communicating with a NCSA Mosaic process"
        (comm unix wp help)
        "lisp/hm--html-menus/")
    ("internal-drag-and-drop.el"
        "Internal drag and drop interface"
        (mouse)
        "lisp/hm--html-menus/")
    ("tmpl-minor-mode.el"
        "Template Minor Mode"
        (data tools)
        "lisp/hm--html-menus/")
    ("iso-acc.el"
        "minor mode providing electric accent keys"
        (i18n)
        "lisp/iso/")
    ("iso-ascii.el"
        "set up char tables for ISO 8859/1 on ASCII terminals."
        (i18n)
        "lisp/iso/")
    ("iso-cvt.el"
        "translate to ISO 8859-1 from/to net/TeX conventions"
        (tex  iso  latin  i18n)
        "lisp/iso/")
    ("iso-insert.el"
        "insert functions for ISO 8859/1."
        (i18n)
        "lisp/iso/")
    ("iso-swed.el"
        "set up char tables for ISO 8859/1 for Swedish/Finnish ttys"
        (i18n)
        "lisp/iso/")
    ("iso-syntax.el"
        "set up case-conversion and syntax tables for ISO 8859/1"
        (i18n)
        "lisp/iso/")
    ("swedish.el"
        "miscellaneous functions for dealing with Swedish."
        (i18n)
        "lisp/iso/")
    ("arabic.el"
        "pre-loaded support for Arabic."
        nil
        "lisp/language/")
    ("china-util.el"
        "utilities for Chinese"
        (mule  multilingual  chinese)
        "lisp/language/")
    ("chinese.el"
        "Support for Chinese"
        (multilingual  chinese)
        "lisp/language/")
    ("cyril-util.el"
        "utilities for Cyrillic scripts"
        (mule  multilingual  cyrillic)
        "lisp/language/")
    ("cyrillic.el"
        "Support for languages which use Cyrillic characters"
        (multilingual  cyrillic)
        "lisp/language/")
    ("english.el"
        "English support"
        (multibyte character  character set  syntax  category)
        "lisp/language/")
    ("european.el"
        "Support for European languages"
        (multilingual  european)
        "lisp/language/")
    ("greek.el"
        "Support for Greek"
        (multilingual  greek)
        "lisp/language/")
    ("hebrew.el"
        "Support for Hebrew"
        (multilingual  hebrew)
        "lisp/language/")
    ("japan-util.el"
        "utilities for Japanese"
        (mule  multilingual  japanese)
        "lisp/language/")
    ("japanese.el"
        "Japanese support"
        (multilingual  japanese)
        "lisp/language/")
    ("korean.el"
        "Support for Korean"
        (multilingual  korean)
        "lisp/language/")
    ("misc-lang.el"
        "support for miscellaneous languages (characters)"
        (multilingual  character set  coding system)
        "lisp/language/")
    ("viet-chars.el"
        "pre-loaded support for Vietnamese, part 1."
        nil
        "lisp/language/")
    ("vietnamese.el"
        "Support for Vietnamese"
        (multilingual  vietnamese)
        "lisp/language/")
    ("leim-list.el"
        "list of LEIM (Library of Emacs Input Method)"
        nil
        "lisp/leim/")
    ("quail.el"
        "Provides simple input method for multilingual text"
        (mule  multilingual  input method)
        "lisp/leim/")
    ("mc-remail.el"
        "Remailer support for Mailcrypt"
        nil
        "lisp/mailcrypt/")
    ("mh-comp.el"
        "mh-e functions for composing messages"
        nil
        "lisp/mh-e/")
    ("mh-e.el"
        "GNU Emacs interface to the MH mail system"
        (mail)
        "lisp/mh-e/")
    ("mh-funcs.el"
        "mh-e functions not everyone will use right away"
        nil
        "lisp/mh-e/")
    ("mh-mime.el"
        "mh-e support for composing MIME messages"
        nil
        "lisp/mh-e/")
    ("mh-pick.el"
        "make a search pattern and search for a message in mh-e"
        nil
        "lisp/mh-e/")
    ("mh-seq.el"
        "mh-e sequences support"
        nil
        "lisp/mh-e/")
    ("mh-utils.el"
        "mh-e code needed for both sending and reading"
        nil
        "lisp/mh-e/")
    ("abbrev.el"
        "abbrev mode commands for Emacs"
        (abbrev)
        "lisp/modes/")
    ("ada-mode.el"
        "An Emacs major-mode for editing Ada source."
        (languages oop ada)
        "lisp/modes/")
    ("arc-mode.el"
        "simple editing of archives"
        (archives msdog editing major-mode)
        "lisp/modes/")
    ("asm-mode.el"
        "mode for editing assembler code"
        (tools  languages)
        "lisp/modes/")
    ("auto-show.el"
        "perform automatic horizontal scrolling as point moves"
        (extensions  internal)
        "lisp/modes/")
    ("autoconf-mode.el"
        "autoconf code editing commands for Emacs"
        (languages  faces  m4  configure)
        "lisp/modes/")
    ("awk-mode.el"
        "AWK code editing commands for Emacs"
        (unix  languages)
        "lisp/modes/")
    ("bib-mode.el"
        "bib-mode, major mode for editing bib files."
        (bib)
        "lisp/modes/")
    ("bibtex.el"
        "BibTeX mode for GNU Emacs"
        (bibtex  latex  tex)
        "lisp/modes/")
    ("c-comment.el"
        "edit C comments"
        (languages)
        "lisp/modes/")
    ("c-style.el"
        "sets c-style control variables."
        nil
        "lisp/modes/")
    ("cl-indent.el"
        "enhanced lisp-indent mode"
        (lisp  tools)
        "lisp/modes/")
    ("cmacexp.el"
        "expand C macros in a region"
        (c)
        "lisp/modes/")
    ("cperl-mode.el"
        "Perl code editing commands for XEmacs"
        (languages)
        "lisp/modes/")
    ("enriched.el"
        "read and save files in text/enriched format"
        (wp  faces)
        "lisp/modes/")
    ("executable.el"
        "base functionality for executable interpreter scripts"
        (languages  unix)
        "lisp/modes/")
    ("f90.el"
        "Fortran-90 mode (free format)"
        (fortran  f90  languages)
        "lisp/modes/")
    ("fortran-misc.el"
        "Routines than can be used with fortran mode."
        (languages)
        "lisp/modes/")
    ("fortran.el"
        "Fortran mode for GNU Emacs"
        (languages)
        "lisp/modes/")
    ("hideif.el"
        "hides selected code within ifdef."
        (c  outlines)
        "lisp/modes/")
    ("hideshow.el"
        "minor mode cmds to selectively display blocks of code"
        (c c++ lisp tools editing)
        "lisp/modes/")
    ("icon.el"
        "mode for editing Icon code"
        (languages)
        "lisp/modes/")
    ("image-mode.el"
        "Major mode for navigate images"
        (image  graphics)
        "lisp/modes/")
    ("ksh-mode.el"
        "sh (ksh, bash) script editing mode for GNU Emacs."
        (shell  korn  bourne  sh  ksh  bash)
        "lisp/modes/")
    ("lazy-shot.el"
        "Lazy font locking for XEmacs"
        (languages  faces)
        "lisp/modes/")
    ("linuxdoc-sgml.el"
        "sgml-mode enhancements for linuxdoc"
        (docs  languages)
        "lisp/modes/")
    ("lisp-mnt.el"
        "minor mode for Emacs Lisp maintainers"
        (docs)
        "lisp/modes/")
    ("lisp-mode.el"
        "Lisp mode, and its idiosyncratic commands."
        (lisp  languages)
        "lisp/modes/")
    ("m4-mode.el"
        "m4 code editing commands for Emacs"
        (languages  faces)
        "lisp/modes/")
    ("make-mode.el"
        "makefile editing commands for Emacs"
        (unix  tools)
        "lisp/modes/")
    ("modula2.el"
        "Modula-2 editing support package"
        (languages)
        "lisp/modes/")
    ("nroff-mode.el"
        "GNU Emacs major mode for editing nroff source"
        (wp)
        "lisp/modes/")
    ("outl-mouse.el"
        "outline mode mouse commands for Emacs"
        (outlines  mouse)
        "lisp/modes/")
    ("outline.el"
        "outline mode commands for Emacs"
        (outlines)
        "lisp/modes/")
    ("pascal.el"
        "major mode for editing pascal source in Emacs"
        (languages)
        "lisp/modes/")
    ("perl-mode.el"
        "Perl code editing commands for GNU Emacs"
        (languages)
        "lisp/modes/")
    ("picture.el"
        "\"Picture mode\" -- editing using quarter-plane screen model."
        nil
        "lisp/modes/")
    ("postscript.el"
        "major mode for editing PostScript programs"
        (langauges)
        "lisp/modes/")
    ("prolog.el"
        "major mode for editing and running Prolog under Emacs"
        (languages)
        "lisp/modes/")
    ("python-mode.el"
        "Major mode for editing Python programs"
        (python languages oop)
        "lisp/modes/")
    ("reftex.el"
        "Minor mode for doing \\label, \\ref and \\cite in LaTeX"
        (tex)
        "lisp/modes/")
    ("rexx-mode.el"
        "major mode for editing REXX program files"
        (languages)
        "lisp/modes/")
    ("rsz-minibuf.el"
        "dynamically resize minibuffer to display entire contents"
        (minibuffer  window  frames  display)
        "lisp/modes/")
    ("scheme.el"
        "Scheme mode, and its idiosyncratic commands."
        (languages  lisp)
        "lisp/modes/")
    ("scribe.el"
        "scribe mode, and its idiosyncratic commands."
        (wp)
        "lisp/modes/")
    ("sendmail.el"
        "mail sending commands for Emacs."
        (mail)
        "lisp/modes/")
    ("sgml-mode.el"
        "SGML- and HTML-editing modes"
        (wp  hypermedia  comm  languages)
        "lisp/modes/")
    ("sh-script.el"
        "shell-script editing commands for Emacs"
        (languages  unix)
        "lisp/modes/")
    ("simula.el"
        "SIMULA 87 code editing commands for Emacs"
        (languages)
        "lisp/modes/")
    ("strokes.el"
        "Control XEmacs through mouse strokes --"
        (lisp  mouse  extensions)
        "lisp/modes/")
    ("tcl.el"
        "Tcl code editing commands for Emacs"
        (languages tcl modes)
        "lisp/modes/")
    ("tex-mode.el"
        "TeX, LaTeX, and SliTeX mode commands."
        nil
        "lisp/modes/")
    ("texinfo.el"
        "major mode for editing Texinfo files"
        (tex wp)
        "lisp/modes/")
    ("text-mode.el"
        "text mode, and its idiosyncratic commands."
        nil
        "lisp/modes/")
    ("verilog-mode.el"
        "major mode for editing verilog source in Emacs"
        (languages)
        "lisp/modes/")
    ("vhdl-mode.el"
        "major mode for editing VHDL code"
        (languages vhdl)
        "lisp/modes/")
    ("view-less.el"
        "Minor mode for browsing files with keybindings like `less'"
        (wp unix)
        "lisp/modes/")
    ("view-process-mode.el"
        "Display current running processes"
        (processes)
        "lisp/modes/")
    ("view-process-system-specific.el"
        "System specific stuff for view-process"
        (processes)
        "lisp/modes/")
    ("view-process-xemacs.el"
        "XEmacs specific code for view-process"
        (processes)
        "lisp/modes/")
    ("view.el"
        "peruse file or buffer without editing."
        (wp unix)
        "lisp/modes/")
    ("vrml-mode.el"
        "major mode for editing VRML (.wrl) files"
        (languages vrml modes)
        "lisp/modes/")
    ("whitespace-mode.el"
        "minor mode for making whitespace visible"
        (modes  extensions)
        "lisp/modes/")
    ("winmgr-mode.el"
        "generic window manager mode"
        (languages)
        "lisp/modes/")
    ("xpm-mode.el"
        "minor mode for editing XPM files"
        (data tools)
        "lisp/modes/")
    ("xrdb-mode.el"
        "mode for editing X resource database files"
        (data languages)
        "lisp/modes/")
    ("latex-math-symbol.el"
        "LaTeX math symbol decoder"
        (latex  math  mule)
        "lisp/mu/")
    ("mu-bbdb.el"
        "`attribution' function for mu-cite with BBDB."
        nil
        "lisp/mu/")
    ("mu-cite.el"
        "yet another citation tool for GNU Emacs"
        (mail  news  citation)
        "lisp/mu/")
    ("canna-leim.el"
        "Canna-related code for LEIM"
        (japanese  input method  leim)
        "lisp/mule/")
    ("canna.el"
        "Interface to the Canna input method."
        (canna  japanese  input method  mule  multilingual)
        "lisp/mule/")
    ("isearch-mule.el"
        "incremental search with front-end inputting method"
        (search)
        "lisp/mule/")
    ("kinsoku.el"
        "Kinsoku (line wrap) processing for XEmacs/Mule"
        nil
        "lisp/mule/")
    ("mule-category.el"
        "category functions for XEmacs/Mule."
        nil
        "lisp/mule/")
    ("mule-ccl.el"
        "Code Conversion Language functions."
        nil
        "lisp/mule/")
    ("mule-charset.el"
        "Charset functions for Mule."
        nil
        "lisp/mule/")
    ("mule-cmds.el"
        "Commands for multilingual environment"
        (mule  multilingual)
        "lisp/mule/")
    ("mule-cne.el"
        "interface between input methods Canna and EGG."
        nil
        "lisp/mule/")
    ("mule-coding.el"
        "Coding-system functions for Mule."
        nil
        "lisp/mule/")
    ("mule-debug.el"
        "debugging functions for Mule."
        nil
        "lisp/mule/")
    ("mule-diag.el"
        "Show diagnosis of multilingual environment (MULE)"
        (multilingual  charset  coding system  fontset  diagnosis)
        "lisp/mule/")
    ("mule-files.el"
        "File I/O functions for XEmacs/Mule."
        nil
        "lisp/mule/")
    ("mule-help.el"
        "Mule-ized Help functions "
        (help  internal)
        "lisp/mule/")
    ("mule-keyboard.el"
        "Direct input of multilingual chars from keyboard."
        nil
        "lisp/mule/")
    ("mule-misc.el"
        "Miscellaneous Mule functions."
        nil
        "lisp/mule/")
    ("mule-process.el"
        "Process functions for XEmacs/mule."
        (mule  multilingual  coding system  process)
        "lisp/mule/")
    ("mule-util.el"
        "Utility functions for multilingual environment (mule)"
        (mule  multilingual)
        "lisp/mule/")
    ("mule-x-init.el"
        "initialization code for X Windows under MULE"
        (mule x11)
        "lisp/mule/")
    ("add-log.el"
        "change log maintenance commands for Emacs"
        (maint)
        "lisp/packages/")
    ("apropos.el"
        "apropos commands for users and programmers."
        (help)
        "lisp/packages/")
    ("array.el"
        "array editing commands for XEmacs"
        (extensions)
        "lisp/packages/")
    ("autoinsert.el"
        "automatic mode-dependent insertion of text into new files"
        nil
        "lisp/packages/")
    ("avoid.el"
        "make mouse pointer stay out of the way of editing"
        (mouse)
        "lisp/packages/")
    ("big-menubar.el"
        "an alternate menubar"
        (mouse menubar)
        "lisp/packages/")
    ("blink-cursor.el"
        "Blink the cursor on or off"
        (display)
        "lisp/packages/")
    ("blink-paren.el"
        "blink the matching paren, just like Zmacs"
        (faces)
        "lisp/packages/")
    ("bookmark.el"
        "set bookmarks, maybe annotate them, jump to them later."
        (bookmarks  placeholders  annotations)
        "lisp/packages/")
    ("buff-menu.el"
        "buffer menu main function and support functions."
        (extensions)
        "lisp/packages/")
    ("chistory.el"
        "list command history"
        nil
        "lisp/packages/")
    ("cmuscheme.el"
        "Scheme process in a buffer. Adapted from tea.el."
        (processes  lisp)
        "lisp/packages/")
    ("compare-w.el"
        "compare text between windows for Emacs."
        nil
        "lisp/packages/")
    ("compile.el"
        "run compiler as inferior of Emacs, parse error messages."
        (tools  processes)
        "lisp/packages/")
    ("completion.el"
        "dynamic word-completion code"
        (abbrev)
        "lisp/packages/")
    ("crypt.el"
        "code for handling all sorts of compressed and encrypted files"
        (extensions)
        "lisp/packages/")
    ("dabbrev.el"
        "dynamic abbreviation package"
        (abbrev expand completion)
        "lisp/packages/")
    ("desktop.el"
        "save partial status of Emacs when killed"
        (customization)
        "lisp/packages/")
    ("detexinfo.el"
        "remove Texinfo commands from a Texinfo source file"
        (tex  docs)
        "lisp/packages/")
    ("doctex.el"
        "grind GNU Emacs DOC file into LaTeX input"
        (tex  docs)
        "lisp/packages/")
    ("edit-faces.el"
        "interactive face editing mode"
        nil
        "lisp/packages/")
    ("emacsbug.el"
        "command to report Emacs bugs to appropriate mailing list."
        (maint)
        "lisp/packages/")
    ("emerge.el"
        "merge diffs under Emacs control"
        (unix  tools)
        "lisp/packages/")
    ("etags.el"
        "etags facility for Emacs"
        (tools)
        "lisp/packages/")
    ("fast-lock.el"
        "Automagic text properties caching for fast Font Lock mode."
        (faces files)
        "lisp/packages/")
    ("feedmail.el"
        "outbound mail handling"
        (mail)
        "lisp/packages/")
    ("file-part.el"
        "treat a section of a buffer as a separate file"
        (extensions  tools)
        "lisp/packages/")
    ("font-lock.el"
        "decorating source files with fonts/colors based on syntax"
        (languages  faces)
        "lisp/packages/")
    ("fontl-hooks.el"
        "pre-loaded stuff for font-lock."
        nil
        "lisp/packages/")
    ("func-menu.el"
        "Jump to a function within a buffer."
        (tools  c  lisp)
        "lisp/packages/")
    ("generic-sc.el"
        "generic interface to source control systems"
        (tools  unix)
        "lisp/packages/")
    ("gnuserv.el"
        "Lisp interface code between Emacs and gnuserv"
        (environment  processes  terminals)
        "lisp/packages/")
    ("gopher.el"
        "an emacs gopher client"
        (gopher  comm)
        "lisp/packages/")
    ("hexl.el"
        "edit a file in a hex dump format using the hexl filter."
        (data)
        "lisp/packages/")
    ("hyper-apropos.el"
        "Hypertext emacs lisp documentation interface."
        (lisp  tools  help  docs  matching)
        "lisp/packages/")
    ("igrep.el"
        "An improved interface to `grep`."
        nil
        "lisp/packages/")
    ("info.el"
        "info package for Emacs."
        (help)
        "lisp/packages/")
    ("informat.el"
        "info support functions package for Emacs"
        (help)
        "lisp/packages/")
    ("ispell.el"
        "spell checking using Ispell"
        nil
        "lisp/packages/")
    ("iswitchb.el"
        "switch between buffers using substrings"
        (extensions)
        "lisp/packages/")
    ("jka-compr.el"
        "reading/writing/loading compressed files"
        (data)
        "lisp/packages/")
    ("lazy-lock.el"
        "Lazy demand-driven fontification for fast Font Lock mode."
        (faces files)
        "lisp/packages/")
    ("ledit.el"
        "Emacs side of ledit interface"
        nil
        "lisp/packages/")
    ("lispm-fonts.el"
        "quick hack to parse LISPM-style font-shift codes"
        (faces)
        "lisp/packages/")
    ("lpr.el"
        "print Emacs buffer on line printer."
        (unix)
        "lisp/packages/")
    ("makeinfo.el"
        "run makeinfo conveniently"
        nil
        "lisp/packages/")
    ("makesum.el"
        "generate key binding summary for Emacs"
        (help)
        "lisp/packages/")
    ("man.el"
        "browse UNIX manual pages"
        (help)
        "lisp/packages/")
    ("metamail.el"
        "Metamail interface for GNU Emacs"
        (mail  news  mime  multimedia)
        "lisp/packages/")
    ("mic-paren.el"
        "highlight matching parenthesises."
        (languages  faces)
        "lisp/packages/")
    ("page-ext.el"
        "extended page handling commands"
        nil
        "lisp/packages/")
    ("paren.el"
        "highlight (un)matching parens and whole expressions"
        (languages  faces)
        "lisp/packages/")
    ("pending-del.el"
        "Making insertions replace any selected text."
        nil
        "lisp/packages/")
    ("ps-print.el"
        "Jim's Pretty-Good PostScript Generator for Emacs 19."
        (print  postscript)
        "lisp/packages/")
    ("rcompile.el"
        "run a compilation on a remote machine"
        (tools  processes)
        "lisp/packages/")
    ("recent-files.el"
        "Maintain menu of recently opened files."
        (menu  file)
        "lisp/packages/")
    ("refbib.el"
        "convert refer-style references to ones usable by Latex bib"
        (bib  tex)
        "lisp/packages/")
    ("resume.el"
        "process command line args from within a suspended Emacs job"
        (processes)
        "lisp/packages/")
    ("saveplace.el"
        "automatically save place in files."
        (bookmarks  placeholders)
        "lisp/packages/")
    ("spell.el"
        "spelling correction interface for Emacs."
        (wp  unix)
        "lisp/packages/")
    ("supercite.el"
        "minor mode for citing mail and news replies"
        (citation attribution mail news article reply followup)
        "lisp/packages/")
    ("tar-mode.el"
        "simple editing of tar files from GNU emacs"
        (unix)
        "lisp/packages/")
    ("terminal.el"
        "terminal emulator for GNU Emacs."
        (comm  terminals)
        "lisp/packages/")
    ("texinfmt.el"
        "format Texinfo files into Info files."
        nil
        "lisp/packages/")
    ("texnfo-upd.el"
        "utilities for updating nodes and menus in Texinfo files"
        (maint  tex  docs)
        "lisp/packages/")
    ("time-stamp.el"
        "Maintain last change time stamps in files edited by Emacs"
        (tools)
        "lisp/packages/")
    ("time.el"
        "display time and load in mode line of Emacs."
        nil
        "lisp/packages/")
    ("uncompress.el"
        "auto-decompression hook for visiting .Z files"
        (unix extensions)
        "lisp/packages/")
    ("underline.el"
        "insert/remove underlining (done by overstriking) in Emacs."
        (wp)
        "lisp/packages/")
    ("upd-copyr.el"
        "update the copyright notice in a GNU Emacs Lisp file"
        (maint)
        "lisp/packages/")
    ("webjump.el"
        "programmable Web hotlist"
        (comm www)
        "lisp/packages/")
    ("webster-www.el"
        "Look up a word in WWW Merriam-Webster dictionary"
        (comm  hypermedia)
        "lisp/packages/")
    ("xscheme.el"
        "run Scheme under Emacs"
        (languages  lisp)
        "lisp/packages/")
    ("dll-debug.el"
        "A slow implementation of dll for debugging."
        (extensions  lisp)
        "lisp/pcl-cvs/")
    ("about.el"
        "the About The Authors page (shameless self promotion)."
        (extensions)
        "lisp/prim/")
    ("advocacy.el"
        "blatant XEmacs self promotion"
        nil
        "lisp/prim/")
    ("backquote.el"
        "Full backquote support for elisp.  Reverse compatible too."
        (extensions)
        "lisp/prim/")
    ("buffer.el"
        "buffer routines taken from C"
        nil
        "lisp/prim/")
    ("case-table.el"
        "code to extend the character set and support case tables."
        (i18n)
        "lisp/prim/")
    ("cleantree.el"
        "Remove out of date .elcs in lisp directories"
        (internal)
        "lisp/prim/")
    ("cmdloop.el"
        "support functions for the top-level command loop."
        nil
        "lisp/prim/")
    ("console.el"
        "miscellaneous console functions not written in C"
        (internal)
        "lisp/prim/")
    ("debug.el"
        "debuggers and related commands for XEmacs"
        nil
        "lisp/prim/")
    ("device.el"
        "miscellaneous device functions not written in C"
        (internal)
        "lisp/prim/")
    ("disp-table.el"
        "functions for dealing with char tables."
        (i18n)
        "lisp/prim/")
    ("env.el"
        "functions to manipulate environment variables."
        (processes  unix)
        "lisp/prim/")
    ("events.el"
        "event functions."
        (internal event)
        "lisp/prim/")
    ("extents.el"
        "miscellaneous extent functions not written in C"
        (internal)
        "lisp/prim/")
    ("faces.el"
        "Lisp interface to the C \"face\" structure"
        (faces internal)
        "lisp/prim/")
    ("files-nomule.el"
        "file I/O stubs when not under Mule."
        nil
        "lisp/prim/")
    ("files.el"
        "file input and output commands for XEmacs."
        nil
        "lisp/prim/")
    ("fill.el"
        "fill commands for XEmacs."
        (wp)
        "lisp/prim/")
    ("find-func.el"
        "find the definition of the Emacs Lisp function near point"
        (emacs-lisp  functions)
        "lisp/prim/")
    ("float-sup.el"
        "detect absence of floating-point support in XEmacs runtime"
        (internal)
        "lisp/prim/")
    ("format.el"
        "read and save files in multiple formats"
        (extensions  dumped)
        "lisp/prim/")
    ("frame.el"
        "multi-frame management independent of window systems."
        (internal)
        "lisp/prim/")
    ("glyphs.el"
        "Lisp interface to C glyphs"
        (extensions  internal)
        "lisp/prim/")
    ("gui.el"
        "Basic GUI functions for XEmacs."
        (internal)
        "lisp/prim/")
    ("help-nomule.el"
        "Help functions when not in Mule"
        (help  internal)
        "lisp/prim/")
    ("help.el"
        "help commands for XEmacs."
        (help  internal)
        "lisp/prim/")
    ("inc-vers.el"
        "load this to increment the recorded XEmacs version number."
        (internal)
        "lisp/prim/")
    ("indent.el"
        "indentation commands for XEmacs"
        (lisp languages tools)
        "lisp/prim/")
    ("itimer-autosave.el"
        "Autosave functions with itimers"
        nil
        "lisp/prim/")
    ("lisp.el"
        "Lisp editing commands for XEmacs"
        (lisp  languages)
        "lisp/prim/")
    ("loaddefs.el"
        "define standard autoloads of other files"
        (internal)
        "lisp/prim/")
    ("loadup.el"
        "load up standardly loaded Lisp files for XEmacs."
        (internal)
        "lisp/prim/")
    ("macros.el"
        "non-primitive commands for keyboard macros."
        (abbrev)
        "lisp/prim/")
    ("make-docfile.el"
        "Cache docstrings in external file"
        (internal)
        "lisp/prim/")
    ("minibuf.el"
        "Minibuffer functions for XEmacs"
        (internal)
        "lisp/prim/")
    ("misc.el"
        "miscellaneous functions for XEmacs"
        nil
        "lisp/prim/")
    ("modeline.el"
        "modeline hackery."
        nil
        "lisp/prim/")
    ("mouse.el"
        "window system-independent mouse support."
        (hardware)
        "lisp/prim/")
    ("novice.el"
        "handling of disabled commands (\"novice mode\") for XEmacs."
        (internal  help)
        "lisp/prim/")
    ("objects.el"
        "Lisp interface to C window-system objects"
        (faces internal)
        "lisp/prim/")
    ("obsolete.el"
        "obsoleteness support."
        (internal)
        "lisp/prim/")
    ("options.el"
        "edit Options command for XEmacs."
        nil
        "lisp/prim/")
    ("overlay.el"
        "overlay support."
        (internal)
        "lisp/prim/")
    ("package-admin.el"
        "Installation and Maintenance of XEmacs packages"
        (internal)
        "lisp/prim/")
    ("packages.el"
        "Low level support for XEmacs packages"
        (internal  lisp)
        "lisp/prim/")
    ("page.el"
        "page motion commands for emacs."
        nil
        "lisp/prim/")
    ("paragraphs.el"
        "paragraph and sentence parsing."
        (wp)
        "lisp/prim/")
    ("process.el"
        "commands for subprocesses; split out of simple.el"
        (internal  processes)
        "lisp/prim/")
    ("profile.el"
        "basic profiling commands for XEmacs"
        (internal)
        "lisp/prim/")
    ("rect.el"
        "rectangle functions for XEmacs."
        (internal)
        "lisp/prim/")
    ("register.el"
        "register commands for Emacs."
        (internal)
        "lisp/prim/")
    ("replace.el"
        "search and replace commands for XEmacs."
        nil
        "lisp/prim/")
    ("reposition.el"
        "center a Lisp function or comment on the screen"
        nil
        "lisp/prim/")
    ("simple.el"
        "basic editing commands for XEmacs"
        nil
        "lisp/prim/")
    ("sort.el"
        "commands to sort text in an XEmacs buffer."
        (unix)
        "lisp/prim/")
    ("sound.el"
        "Loading sound files in XEmacs"
        nil
        "lisp/prim/")
    ("specifier.el"
        "Lisp interface to specifiers"
        (internal)
        "lisp/prim/")
    ("startup.el"
        "process XEmacs shell arguments"
        (internal)
        "lisp/prim/")
    ("subr.el"
        "basic lisp subroutines for XEmacs"
        nil
        "lisp/prim/")
    ("symbols.el"
        "functions for working with symbols and symbol values"
        nil
        "lisp/prim/")
    ("tabify.el"
        "tab conversion commands for XEmacs"
        nil
        "lisp/prim/")
    ("toolbar.el"
        "Toolbar support for XEmacs"
        (extensions  internal)
        "lisp/prim/")
    ("undo-stack.el"
        "An \"undoable stack\" object."
        (extensions)
        "lisp/prim/")
    ("update-elc.el"
        "Bytecompile out-of-date dumped files"
        (internal)
        "lisp/prim/")
    ("userlock.el"
        "handle file access contention between multiple users"
        (internal)
        "lisp/prim/")
    ("window-xemacs.el"
        "XEmacs window commands aside from those written in C."
        (extensions)
        "lisp/prim/")
    ("window.el"
        "XEmacs window commands aside from those written in C."
        (extensions)
        "lisp/prim/")
    ("winnt.el"
        "Lisp routines for Windows NT."
        nil
        "lisp/prim/")
    ("iso-sgml.el"
        "display SGML entity references as ISO 8859-1 characters"
        (sgml  html  iso  latin  i18n)
        "lisp/psgml/")
    ("psgml-api.el"
        "Extra API functions for PSGML"
        nil
        "lisp/psgml/")
    ("psgml-dtd.el"
        "DTD parser for SGML-editing mode with parsing support"
        nil
        "lisp/psgml/")
    ("psgml-edit.el"
        "Editing commands for SGML-mode with parsing support"
        nil
        "lisp/psgml/")
    ("psgml-fs.el"
        "Format a SGML-file according to a style file"
        nil
        "lisp/psgml/")
    ("psgml-html.el"
        "HTML mode in conjunction with PSGML"
        nil
        "lisp/psgml/")
    ("psgml-other.el"
        "Part of SGML-editing mode with parsing support"
        nil
        "lisp/psgml/")
    ("psgml-parse.el"
        "Parser for SGML-editing mode with parsing support"
        nil
        "lisp/psgml/")
    ("psgml-xemacs.el"
        "Part of SGML-editing mode with parsing support"
        nil
        "lisp/psgml/")
    ("psgml.el"
        "SGML-editing mode with parsing support"
        (languages)
        "lisp/psgml/")
    ("tempo.el"
        "Flexible template insertion"
        (extensions  languages  tools)
        "lisp/psgml/")
    ("rmail-kill.el"
        "Mail filtering for rmail"
        (mail)
        "lisp/rmail/")
    ("rmail-xemacs.el"
        "Mouse and font support for RMAIL running on XEmacs"
        (mail)
        "lisp/rmail/")
    ("rmail.el"
        "main code of \"RMAIL\" mail reader for Emacs."
        (mail)
        "lisp/rmail/")
    ("rmailedit.el"
        "\"RMAIL edit mode\"  Edit the current message."
        (mail)
        "lisp/rmail/")
    ("rmailkwd.el"
        "part of the \"RMAIL\" mail reader for Emacs."
        (mail)
        "lisp/rmail/")
    ("rmailmsc.el"
        "miscellaneous support functions for the RMAIL mail reader"
        (mail)
        "lisp/rmail/")
    ("rmailout.el"
        "\"RMAIL\" mail reader for Emacs: output message to a file."
        (mail)
        "lisp/rmail/")
    ("rmailsort.el"
        "Rmail: sort messages."
        (mail)
        "lisp/rmail/")
    ("rmailsum.el"
        "make summary buffers for the mail reader"
        (mail)
        "lisp/rmail/")
    ("undigest.el"
        "digest-cracking support for the RMAIL mail reader"
        (mail)
        "lisp/rmail/")
    ("unrmail.el"
        "convert Rmail files to mailbox files."
        (mail)
        "lisp/rmail/")
    ("skk-auto.el"
        "$BAw$j2>L>$N<+F0=hM}$N$?$a$N%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-comp.el"
        "$BJd40$N$?$a$N%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-foreword.el"
        "$BA0=q$-(B"
        (japanese)
        "lisp/skk/")
    ("skk-gadget.el"
        "$B<B9TJQ49$N$?$a$N%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-kakasi.el"
        "KAKASI $B4XO"%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-kcode.el"
        "$B4A;z%3!<%I$r;H$C$?JQ49$N$?$a$N%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-leim.el"
        "SKK related code for LEIM"
        (japanese)
        "lisp/skk/")
    ("skk-menu.el"
        "SKK Menul related functions."
        (japanese)
        "lisp/skk/")
    ("skk-num.el"
        "$B?tCMJQ49$N$?$a$N%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-server.el"
        "SKK $B%5!<%P!<$N$?$a$N%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-tree.el"
        "$BLZ7A<0%G!<%?!<$r;H$C$?JQ49$N$?$a$N%W%m%0%i%`(B"
        (japanese)
        "lisp/skk/")
    ("skk-vip.el"
        "vip related functions for skk.el"
        (japanese)
        "lisp/skk/")
    ("skk-viper.el"
        "SKK related code for Viper"
        (japanese)
        "lisp/skk/")
    ("vip.el"
        "a VI Package for GNU Emacs"
        (emulations)
        "lisp/skk/")
    ("sccs.el"
        "easy-to-use SCCS control from within Emacs"
        nil
        "lisp/sunpro/")
    ("sunpro-keys.el"
        "SunPro-specific key bindings"
        nil
        "lisp/sunpro/")
    ("sunpro-menubar.el"
        "Initialize the SunPro menubar"
        (sunpro menubar initialization)
        "lisp/sunpro/")
    ("sunpro-sparcworks.el"
        "support SPARCworks manager ToolTalk messages"
        (sparcworks  tooltalk  messages)
        "lisp/sunpro/")
    ("AT386.el"
        "terminal support package for IBM AT keyboards"
        (terminals)
        "lisp/term/")
    ("bg-mouse.el"
        "GNU Emacs code for BBN Bitgraph mouse."
        (hardware)
        "lisp/term/")
    ("internal.el"
        "setup support for PC keyboards and screens, internal terminal"
        nil
        "lisp/term/")
    ("keyswap.el"
        "swap BS and DEL keys"
        (terminals)
        "lisp/term/")
    ("linux.el"
        "define function key sequences for the Linux console"
        (terminals)
        "lisp/term/")
    ("lk201.el"
        "basic editing commands for XEmacs"
        nil
        "lisp/term/")
    ("news.el"
        "keypad and function key bindings for the Sony NEWS keyboard"
        (terminals)
        "lisp/term/")
    ("pc-win.el"
        "setup support for `PC windows' (whatever that is)."
        nil
        "lisp/term/")
    ("scoansi.el"
        "set up key names for SCO ansi console"
        nil
        "lisp/term/")
    ("sun-mouse.el"
        "mouse handling for Sun windows"
        (hardware)
        "lisp/term/")
    ("sun.el"
        "keybinding for standard default sunterm keys"
        (terminals)
        "lisp/term/")
    ("sup-mouse.el"
        "supdup mouse support for lisp machines"
        (hardware)
        "lisp/term/")
    ("tty-init.el"
        "initialization code for tty's"
        (terminals)
        "lisp/term/")
    ("tvi970.el"
        "terminal support for the Televideo 970"
        (terminals)
        "lisp/term/")
    ("vt-control.el"
        "Common VTxxx control functions"
        (terminals)
        "lisp/term/")
    ("vt100-led.el"
        "functions for LED control on VT-100 terminals & clones."
        (hardware)
        "lisp/term/")
    ("vt100.el"
        "define VT100 function key sequences in function-key-map"
        (terminals)
        "lisp/term/")
    ("win32-win.el"
        "parse switches controlling interface with win32"
        (terminals)
        "lisp/term/")
    ("wyse50.el"
        "terminal support code for Wyse 50"
        (terminals)
        "lisp/term/")
    ("xterm.el"
        "define function key sequences for xterm"
        (terminals)
        "lisp/term/")
    ("char-table.el"
        "display table of charset"
        (character  mule)
        "lisp/tl/")
    ("char-util.el"
        "character utility"
        (character  emacs/mule)
        "lisp/tl/")
    ("chartblxmas.el"
        "display table of charset by pop-up menu"
        (character  xemacs/mule)
        "lisp/tl/")
    ("cless.el"
        "Common lisp and Emacs Lisp source sharing"
        (common lisp)
        "lisp/tl/")
    ("range.el"
        "range functions"
        (range)
        "lisp/tl/")
    ("texi-util.el"
        "Texinfo utility"
        (texinfo)
        "lisp/tl/")
    ("tl-atype.el"
        "atype functions"
        (atype)
        "lisp/tl/")
    ("tl-list.el"
        "utility functions about list"
        (list)
        "lisp/tl/")
    ("tl-misc.el"
        "miscellaneous utility of tl."
        (load-path  module  structure)
        "lisp/tl/")
    ("tl-seq.el"
        "sequence functions"
        (sequence)
        "lisp/tl/")
    ("tl-str.el"
        "Emacs Lisp Library module about string"
        (string)
        "lisp/tl/")
    ("tu-comment.el"
        "a comment out utility for Lisp programs."
        (comment  lisp)
        "lisp/tl/")
    ("tu-replace.el"
        "a replacing utility for GNU Emacs"
        (replace)
        "lisp/tl/")
    ("gnus-art-mime.el"
        "MIME extension for article mode of Gnus"
        (news  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("gnus-charset.el"
        "MIME charset extension for Gnus"
        (news  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("gnus-mime.el"
        "MIME extensions for Gnus"
        (news  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("gnus-sum-mime.el"
        "MIME extension for summary mode of Gnus"
        (news  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("message-mime.el"
        "MIME extensions for message.el"
        (news  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("mime-setup.el"
        "setup file for tm viewer and composer."
        (mail  news  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("signature.el"
        "a signature utility for GNU Emacs"
        (mail  news  signature)
        "lisp/tm/")
    ("tm-bbdb.el"
        "tm shared module for BBDB"
        (mail  news  mime  multimedia  multilingual  bbdb)
        "lisp/tm/")
    ("tm-def.el"
        "definition module for tm"
        (mail  news  mime  multimedia  definition)
        "lisp/tm/")
    ("tm-edit-mc.el"
        "Mailcrypt interface for tm-edit"
        (mail  news  mime  multimedia  multilingual  security  pgp)
        "lisp/tm/")
    ("tm-edit.el"
        "Simple MIME Composer for GNU Emacs"
        (mail  news  mime  multimedia  multilingual)
        "lisp/tm/")
    ("tm-ew-d.el"
        "RFC 2047 based encoded-word decoder for GNU Emacs"
        (encoded-word  mime  multilingual  header  mail  news)
        "lisp/tm/")
    ("tm-ew-e.el"
        "RFC 2047 based encoded-word encoder for GNU Emacs"
        (encoded-word  mime  multilingual  header  mail  news)
        "lisp/tm/")
    ("tm-file.el"
        "tm-view internal method for file extraction"
        (mail  news  mime  multimedia  file  extract)
        "lisp/tm/")
    ("tm-ftp.el"
        "tm-view internal method for anonymous ftp"
        (anonymous ftp  mime  multimedia  mail  news)
        "lisp/tm/")
    ("tm-image.el"
        "tm-view filter to display images in XEmacs or MULE buffers"
        (image  picture  x-face  mime  multimedia  mail  news)
        "lisp/tm/")
    ("tm-mail.el"
        "mail-mode extension."
        (mail  mime  multimedia)
        "lisp/tm/")
    ("tm-mh-e.el"
        "MIME extension for mh-e"
        (mail  mh  mime  multimedia  encoded-word  multilingual)
        "lisp/tm/")
    ("tm-parse.el"
        "MIME message parser"
        (mail  news  mime  multimedia)
        "lisp/tm/")
    ("tm-partial.el"
        "Grabbing all MIME \"message/partial\"s."
        (mail  news  mime  multimedia  message/partial)
        "lisp/tm/")
    ("tm-pgp.el"
        "tm-view internal methods for PGP."
        (mail  news  mime  multimedia  pgp  security)
        "lisp/tm/")
    ("tm-play.el"
        "decoder for tm-view.el"
        (mail  news  mime  multimedia)
        "lisp/tm/")
    ("tm-rmail.el"
        "MIME extension for RMAIL"
        (mail  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("tm-setup.el"
        "setup file for tm viewer."
        (mail  news  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("tm-view.el"
        "interactive MIME viewer for GNU Emacs"
        (mail  news  mime  multimedia)
        "lisp/tm/")
    ("tm-vm.el"
        "tm-MUA (MIME Extension module) for VM"
        (mail  mime  multimedia  multilingual  encoded-word)
        "lisp/tm/")
    ("tmh-comp.el"
        "tm-mh-e functions for composing messages"
        (mail  mh  mime  multimedia  encoded-word  multilingual)
        "lisp/tm/")
    ("abbrevlist.el"
        "list one abbrev table alphabetically ordered."
        (abbrev)
        "lisp/utils/")
    ("advice.el"
        "an overloading mechanism for Emacs Lisp functions"
        (extensions  lisp  tools)
        "lisp/utils/")
    ("annotations.el"
        "interface to marginal annotations"
        (extensions  hypermedia  outlining)
        "lisp/utils/")
    ("assoc.el"
        "insert/delete/sort functions on association lists"
        (extensions)
        "lisp/utils/")
    ("atomic-extents.el"
        "treat regions of text as a single object"
        (extensions)
        "lisp/utils/")
    ("autoload.el"
        "maintain autoloads in loaddefs.el."
        (maint)
        "lisp/utils/")
    ("bench.el"
        "benchmarking utility for emacsen"
        (internal  maint)
        "lisp/utils/")
    ("blessmail.el"
        "Decide whether movemail needs special privileges."
        (internal)
        "lisp/utils/")
    ("browse-url.el"
        "ask a WWW browser to load a URL"
        (hypertext)
        "lisp/utils/")
    ("build-report.el"
        "Automatically formatted build reports for XEmacs"
        (internal)
        "lisp/utils/")
    ("config.el"
        "access configuration parameters"
        (configure)
        "lisp/utils/")
    ("delbs.el"
        "a small lisp package to allow you to swap around DEL/BS keys"
        (lisp  terminals)
        "lisp/utils/")
    ("derived.el"
        "allow inheritance of major modes."
        nil
        "lisp/utils/")
    ("detached-minibuf.el"
        "Support a detached minibuffer for XEmacs."
        (extensions)
        "lisp/utils/")
    ("docref.el"
        "Simple cross references for Elisp documentation strings"
        (docs  help  lisp)
        "lisp/utils/")
    ("edit-toolbar.el"
        "Interactive toolbar editing mode for XEmacs"
        (tools)
        "lisp/utils/")
    ("edmacro.el"
        "keyboard macro editor"
        (abbrev  internal)
        "lisp/utils/")
    ("eldoc.el"
        "show function arglist or variable docstring in echo area"
        (extensions)
        "lisp/utils/")
    ("elp.el"
        "Emacs Lisp Profiler"
        (debugging lisp tools)
        "lisp/utils/")
    ("facemenu.el"
        "create a face menu for interactively adding fonts to text"
        (faces)
        "lisp/utils/")
    ("find-gc.el"
        "detect functions that call the garbage collector"
        (maint)
        "lisp/utils/")
    ("finder.el"
        "topic & keyword-based code finder"
        (help)
        "lisp/utils/")
    ("floating-toolbar.el"
        "popup toolbar support for XEmacs."
        (lisp)
        "lisp/utils/")
    ("flow-ctrl.el"
        "help for lusers on cu(1) or ttys with wired-in ^S/^Q flow control"
        (hardware)
        "lisp/utils/")
    ("foldout.el"
        "Folding extensions for outline-mode and outline-minor-mode."
        (folding  outline)
        "lisp/utils/")
    ("forms-d2.el"
        "demo forms-mode"
        nil
        "lisp/utils/")
    ("forms-pass.el"
        "passwd file demo for forms-mode"
        nil
        "lisp/utils/")
    ("forms.el"
        "Forms mode: edit a file as a form to fill in"
        (extensions)
        "lisp/utils/")
    ("hide-copyleft.el"
        "hide obnoxious copyright prologs"
        nil
        "lisp/utils/")
    ("highlight-headers.el"
        "highlighting message headers."
        (mail  news)
        "lisp/utils/")
    ("hippie-exp.el"
        "expand text trying various ways to find its expansion."
        (abbrev)
        "lisp/utils/")
    ("lib-complete.el"
        "Completion on the lisp search path"
        (lisp  extensions)
        "lisp/utils/")
    ("live-icon.el"
        "make frame icons represent the current frame contents"
        nil
        "lisp/utils/")
    ("loadhist.el"
        "lisp functions for working with feature groups"
        (internal)
        "lisp/utils/")
    ("mail-extr.el"
        "extract full name and address from RFC 822 mail header."
        (mail)
        "lisp/utils/")
    ("mail-utils.el"
        "utility functions used both by rmail and rnews"
        (mail  news)
        "lisp/utils/")
    ("map-ynp.el"
        "General-purpose boolean question-asker."
        (lisp  extensions)
        "lisp/utils/")
    ("passwd.el"
        "Prompting for passwords semi-securely"
        (comm  extensions)
        "lisp/utils/")
    ("ph.el"
        "Client for the CCSO directory system (aka PH/QI)"
        (help)
        "lisp/utils/")
    ("pp.el"
        "pretty printer for Emacs Lisp"
        (lisp  tools  language  extensions)
        "lisp/utils/")
    ("redo.el"
        "Redo/undo system for XEmacs"
        (lisp  extensions)
        "lisp/utils/")
    ("regexp-opt.el"
        "generate efficient regexps to match strings."
        (strings  regexps)
        "lisp/utils/")
    ("regi.el"
        "REGular expression Interpreting engine"
        (extensions  matching)
        "lisp/utils/")
    ("reporter.el"
        "customizable bug reporting of lisp programs"
        (maint mail tools)
        "lisp/utils/")
    ("rfc822.el"
        "hairy rfc822 parser for mail and news and suchlike"
        (mail)
        "lisp/utils/")
    ("ring.el"
        "handle rings of items"
        (extensions)
        "lisp/utils/")
    ("savehist.el"
        "Save minibuffer history"
        (minibuffer)
        "lisp/utils/")
    ("shadow.el"
        "Locate Emacs Lisp file shadowings."
        (lisp)
        "lisp/utils/")
    ("shadowfile.el"
        "automatic file copying for Emacs 19"
        (comm)
        "lisp/utils/")
    ("skeleton.el"
        "Lisp language extension for writing statement skeletons"
        (extensions  abbrev  languages  tools)
        "lisp/utils/")
    ("soundex.el"
        "implement Soundex algorithm"
        (matching)
        "lisp/utils/")
    ("speedbar.el"
        "quick access to files and tags -*-byte-compile-warnings:nil;-*-"
        (file  tags  tools)
        "lisp/utils/")
    ("speedbspec.el"
        "Buffer specialized configurations for speedbar"
        (file  tags  tools)
        "lisp/utils/")
    ("symbol-syntax.el"
        "find chars with symbol syntax"
        (matching)
        "lisp/utils/")
    ("sysdep.el"
        "consolidate Emacs-version dependencies in one file."
        (lisp  tools)
        "lisp/utils/")
    ("text-props.el"
        "implements properties of characters"
        (extensions  wp  faces)
        "lisp/utils/")
    ("thing.el"
        "find language-specific contiguous pieces of text"
        (extensions  languages)
        "lisp/utils/")
    ("timezone.el"
        "time zone package for GNU Emacs"
        (news)
        "lisp/utils/")
    ("toolbar-utils.el"
        "Toolbar utility functions for XEmacs"
        (extensions)
        "lisp/utils/")
    ("tq.el"
        "utility to maintain a transaction queue"
        (extensions)
        "lisp/utils/")
    ("trace.el"
        "tracing facility for Emacs Lisp functions"
        (tools  lisp)
        "lisp/utils/")
    ("uniquify.el"
        "unique buffer names dependent on file name"
        nil
        "lisp/utils/")
    ("xemacs-build-report.el"
        "Automatically formatted build reports for XEmacs"
        (internal)
        "lisp/utils/")
    ("xpm-button.el"
        "create XPM buttons"
        (frames  internal)
        "lisp/utils/")
    ("vc-hooks.el"
        "resident support for version-control"
        nil
        "lisp/vc/")
    ("vc.el"
        "drive a version-control system from within Emacs"
        nil
        "lisp/vc/")
    ("viper-cmd.el"
        "Vi command support for Viper"
        nil
        "lisp/viper/")
    ("viper-ex.el"
        "functions implementing the Ex commands for Viper"
        nil
        "lisp/viper/")
    ("viper-init.el"
        "some common definitions for Viper"
        nil
        "lisp/viper/")
    ("viper-keym.el"
        "Viper keymaps"
        nil
        "lisp/viper/")
    ("viper-macs.el"
        "functions implementing keyboard macros for Viper"
        nil
        "lisp/viper/")
    ("viper-mous.el"
        "mouse support for Viper"
        nil
        "lisp/viper/")
    ("viper-util.el"
        "Utilities used by viper.el"
        nil
        "lisp/viper/")
    ("viper.el"
        "A full-featured Vi emulator for GNU Emacs and XEmacs,"
        (emulations)
        "lisp/viper/")
    ("vm-easymenu.el"
        "support the easymenu interface for defining a menu."
        (emulations)
        "lisp/vm/")
    ("base64.el"
        "Base64 encoding functions"
        (extensions)
        "lisp/w3/")
    ("css.el"
        "Cascading Style Sheet parser"
        nil
        "lisp/w3/")
    ("devices.el"
        "XEmacs device API emulation"
        nil
        "lisp/w3/")
    ("dsssl-flow.el"
        "DSSSL flow objects"
        nil
        "lisp/w3/")
    ("dsssl.el"
        "DSSSL parser"
        nil
        "lisp/w3/")
    ("font.el"
        "New font model"
        (faces)
        "lisp/w3/")
    ("images.el"
        "Automatic image converters"
        (images)
        "lisp/w3/")
    ("md5.el"
        "MD5 Message Digest Algorithm"
        nil
        "lisp/w3/")
    ("mm.el"
        "Mailcap parsing routines, and MIME handling"
        (mail  news  hypermedia)
        "lisp/w3/")
    ("mule-sysdp.el"
        "consolidate MULE-version dependencies in one file."
        (lisp  tools)
        "lisp/w3/")
    ("socks.el"
        "A Socks v5 Client for Emacs"
        (comm  firewalls)
        "lisp/w3/")
    ("ssl.el"
        "ssl functions for emacsen without them builtin"
        (comm)
        "lisp/w3/")
    ("url-auth.el"
        "Uniform Resource Locator authorization modules"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("url-cache.el"
        "Uniform Resource Locator retrieval tool"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("url-cookie.el"
        "Netscape Cookie support"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("url-file.el"
        "File retrieval code"
        (comm  data  processes)
        "lisp/w3/")
    ("url-gopher.el"
        "Gopher Uniform Resource Locator retrieval code"
        (comm  data  processes)
        "lisp/w3/")
    ("url-gw.el"
        "Gateway munging for URL loading"
        (comm  data  processes)
        "lisp/w3/")
    ("url-http.el"
        "HTTP Uniform Resource Locator retrieval code"
        (comm  data  processes)
        "lisp/w3/")
    ("url-irc.el"
        "IRC URL interface"
        (comm  data  processes)
        "lisp/w3/")
    ("url-mail.el"
        "Mail Uniform Resource Locator retrieval code"
        (comm  data  processes)
        "lisp/w3/")
    ("url-misc.el"
        "Misc Uniform Resource Locator retrieval code"
        (comm  data  processes)
        "lisp/w3/")
    ("url-news.el"
        "News Uniform Resource Locator retrieval code"
        (comm  data  processes)
        "lisp/w3/")
    ("url-nfs.el"
        "NFS URL interface"
        (comm  data  processes)
        "lisp/w3/")
    ("url-ns.el"
        "Various netscape-ish functions for proxy definitions"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("url-parse.el"
        "Uniform Resource Locator parser"
        (comm  data  processes)
        "lisp/w3/")
    ("url-vars.el"
        "Variables for Uniform Resource Locator tool"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("url.el"
        "Uniform Resource Locator retrieval tool"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("w3-about.el"
        "About pages for emacs-w3"
        (hypermedia)
        "lisp/w3/")
    ("w3-display.el"
        "display engine v99999"
        (faces  help  hypermedia)
        "lisp/w3/")
    ("w3-e19.el"
        "Emacs 19.xx specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3-e20.el"
        "Emacs 20.xx specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3-elisp.el"
        "Scripting support for emacs-lisp"
        (hypermedia  scripting)
        "lisp/w3/")
    ("w3-emulate.el"
        "All variable definitions for emacs-w3"
        (comm  help  hypermedia)
        "lisp/w3/")
    ("w3-forms.el"
        "Emacs-w3 forms parsing code for new display engine"
        (faces  help  comm  data  languages)
        "lisp/w3/")
    ("w3-hot.el"
        "Main functions for emacs-w3 on all platforms/versions"
        (faces  help  comm  news  mail  processes  mouse  hypermedia)
        "lisp/w3/")
    ("w3-imap.el"
        "Imagemap functions"
        (hypermedia)
        "lisp/w3/")
    ("w3-jscript.el"
        "Scripting support for javascript"
        (hypermedia  scripting)
        "lisp/w3/")
    ("w3-keyword.el"
        "Emacs-W3 binding style sheet mechanism"
        (hypermedia)
        "lisp/w3/")
    ("w3-latex.el"
        "Emacs-W3 printing via LaTeX"
        (hypermedia  printing  typesetting)
        "lisp/w3/")
    ("w3-menu.el"
        "Menu functions for emacs-w3"
        (menu  hypermedia)
        "lisp/w3/")
    ("w3-mouse.el"
        "Mouse specific functions for emacs-w3"
        (mouse  hypermedia)
        "lisp/w3/")
    ("w3-prefs.el"
        "Preferences panels for Emacs-W3"
        (hypermedia  preferences)
        "lisp/w3/")
    ("w3-print.el"
        "Printing support for emacs-w3"
        (faces  help  printing  hypermedia)
        "lisp/w3/")
    ("w3-props.el"
        "Additional text property stuff"
        (faces)
        "lisp/w3/")
    ("w3-script.el"
        "Scripting support"
        (hypermedia  scripting)
        "lisp/w3/")
    ("w3-speak.el"
        "Emacs-W3 speech interface"
        (hypermedia  speech)
        "lisp/w3/")
    ("w3-style.el"
        "Emacs-W3 binding style sheet mechanism"
        (faces  hypermedia)
        "lisp/w3/")
    ("w3-sysdp.el"
        "consolidate Emacs-version dependencies in one file."
        (lisp  tools)
        "lisp/w3/")
    ("w3-toolbar.el"
        "Toolbar functions for emacs-w3"
        (mouse  toolbar)
        "lisp/w3/")
    ("w3-vars.el"
        "All variable definitions for emacs-w3"
        (comm  help  hypermedia)
        "lisp/w3/")
    ("w3-widget.el"
        "An image widget"
        (faces  images)
        "lisp/w3/")
    ("w3-xemac.el"
        "XEmacs specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3.el"
        "Main functions for emacs-w3 on all platforms/versions"
        (faces  help  comm  news  mail  processes  mouse  hypermedia)
        "lisp/w3/")
    ("x-compose.el"
        "Compose-key processing in XEmacs"
        (i18n)
        "lisp/x11/")
    ("x-faces.el"
        "X-specific face frobnication, aka black magic."
        nil
        "lisp/x11/")
    ("x-font-menu.el"
        "Managing menus of X fonts."
        nil
        "lisp/x11/")
    ("x-init.el"
        "initialization code for X windows"
        (terminals)
        "lisp/x11/")
    ("x-menubar.el"
        "Menubar and popup-menu support for X."
        nil
        "lisp/x11/")
    ("x-misc.el"
        "miscellaneous X functions."
        nil
        "lisp/x11/")
    ("x-scrollbar.el"
        "scrollbar resourcing and such."
        nil
        "lisp/x11/")
    ("x-select.el"
        "Elisp interface to X Selections."
        nil
        "lisp/x11/")
    ("x-toolbar.el"
        "Runtime initialization of XEmacs toolbar"
        (frames)
        "lisp/x11/")
    ("x-win-sun.el"
        "runtime initialization for Sun X servers and keyboards"
        (terminals)
        "lisp/x11/")
    ("x-win-xfree86.el"
        "runtime initialization for XFree86 servers"
        (terminals)
        "lisp/x11/")
))

(provide 'finder-inf)

;;; finder-inf.el ends here
