require '_h2ph_pre.ph';

unless(defined(&_SYS_PROC_H_)) {
    eval 'sub _SYS_PROC_H_ () {1;}' unless defined(&_SYS_PROC_H_);
    require 'machine/proc.ph';
    require 'sys/select.ph';
    require 'sys/queue.ph';
    require 'sys/timeout.ph';
    eval 'sub p_ucred () { ($p_cred->{pc_ucred});}' unless defined(&p_ucred);
    eval 'sub p_rlimit () { ($p_limit->{pl_rlimit});}' unless defined(&p_rlimit);
    eval 'sub p_startzero () { &p_oppid;}' unless defined(&p_startzero);
    eval 'sub p_endzero () { &p_startcopy;}' unless defined(&p_endzero);
    eval 'sub p_startcopy () { &p_sigmask;}' unless defined(&p_startcopy);
    eval 'sub p_endcopy () { &p_thread;}' unless defined(&p_endcopy);
    eval 'sub p_session () { ($p_pgrp->{pg_session});}' unless defined(&p_session);
    eval 'sub p_pgid () { ($p_pgrp->{pg_id});}' unless defined(&p_pgid);
    eval 'sub SIDL () {1;}' unless defined(&SIDL);
    eval 'sub SRUN () {2;}' unless defined(&SRUN);
    eval 'sub SSLEEP () {3;}' unless defined(&SSLEEP);
    eval 'sub SSTOP () {4;}' unless defined(&SSTOP);
    eval 'sub SZOMB () {5;}' unless defined(&SZOMB);
    eval 'sub P_ADVLOCK () {0x000001;}' unless defined(&P_ADVLOCK);
    eval 'sub P_CONTROLT () {0x000002;}' unless defined(&P_CONTROLT);
    eval 'sub P_INMEM () {0x000004;}' unless defined(&P_INMEM);
    eval 'sub P_NOCLDSTOP () {0x000008;}' unless defined(&P_NOCLDSTOP);
    eval 'sub P_PPWAIT () {0x000010;}' unless defined(&P_PPWAIT);
    eval 'sub P_PROFIL () {0x000020;}' unless defined(&P_PROFIL);
    eval 'sub P_SELECT () {0x000040;}' unless defined(&P_SELECT);
    eval 'sub P_SINTR () {0x000080;}' unless defined(&P_SINTR);
    eval 'sub P_SUGID () {0x000100;}' unless defined(&P_SUGID);
    eval 'sub P_SYSTEM () {0x000200;}' unless defined(&P_SYSTEM);
    eval 'sub P_TIMEOUT () {0x000400;}' unless defined(&P_TIMEOUT);
    eval 'sub P_TRACED () {0x000800;}' unless defined(&P_TRACED);
    eval 'sub P_WAITED () {0x001000;}' unless defined(&P_WAITED);
    eval 'sub P_WEXIT () {0x002000;}' unless defined(&P_WEXIT);
    eval 'sub P_EXEC () {0x004000;}' unless defined(&P_EXEC);
    eval 'sub P_OWEUPC () {0x008000;}' unless defined(&P_OWEUPC);
    eval 'sub P_FSTRACE () {0x010000;}' unless defined(&P_FSTRACE);
    eval 'sub P_SSTEP () {0x020000;}' unless defined(&P_SSTEP);
    eval 'sub P_SUGIDEXEC () {0x040000;}' unless defined(&P_SUGIDEXEC);
    eval 'sub P_NOCLDWAIT () {0x080000;}' unless defined(&P_NOCLDWAIT);
    eval 'sub P_NOZOMBIE () {0x100000;}' unless defined(&P_NOZOMBIE);
    eval 'sub PSCHED_SEENRR () {0x0001;}' unless defined(&PSCHED_SEENRR);
    eval 'sub PSCHED_SHOULDYIELD () {0x0002;}' unless defined(&PSCHED_SHOULDYIELD);
    eval 'sub PSCHED_SWITCHCLEAR () {( &PSCHED_SEENRR| &PSCHED_SHOULDYIELD);}' unless defined(&PSCHED_SWITCHCLEAR);
    if(defined(&_KERNEL)) {
	eval 'sub PID_MAX () {32766;}' unless defined(&PID_MAX);
	eval 'sub NO_PID () {( &PID_MAX+1);}' unless defined(&NO_PID);
	eval 'sub SESS_LEADER {
	    local($p) = @_;
    	    eval q((($p)-> ($p_session->{s_leader}) == ($p)));
	}' unless defined(&SESS_LEADER);
	eval 'sub SESSHOLD {
	    local($s) = @_;
    	    eval q((($s)-> &s_count++));
	}' unless defined(&SESSHOLD);
	eval 'sub SESSRELE {
	    local($s) = @_;
    	    eval q({  &if (--($s)-> &s_count == 0)  &FREE($s,  &M_SESSION); });
	}' unless defined(&SESSRELE);
	if(defined( &UVM)) {
	    eval 'sub PHOLD {
	        local($p) = @_;
    		eval q({  &if (($p)-> &p_holdcnt++ == 0 && (($p)-> &p_flag &  &P_INMEM) == 0)  &uvm_swapin($p); });
	    }' unless defined(&PHOLD);
	} else {
	    eval 'sub PHOLD {
	        local($p) = @_;
    		eval q({  &if (($p)-> &p_holdcnt++ == 0 && (($p)-> &p_flag &  &P_INMEM) == 0)  &swapin($p); });
	    }' unless defined(&PHOLD);
	}
	eval 'sub PRELE {
	    local($p) = @_;
    	    eval q((--($p)-> &p_holdcnt));
	}' unless defined(&PRELE);
	eval 'sub FORK_FORK () {0x00000001;}' unless defined(&FORK_FORK);
	eval 'sub FORK_VFORK () {0x00000002;}' unless defined(&FORK_VFORK);
	eval 'sub FORK_RFORK () {0x00000004;}' unless defined(&FORK_RFORK);
	eval 'sub FORK_PPWAIT () {0x00000008;}' unless defined(&FORK_PPWAIT);
	eval 'sub FORK_SHAREFILES () {0x00000010;}' unless defined(&FORK_SHAREFILES);
	eval 'sub FORK_CLEANFILES () {0x00000020;}' unless defined(&FORK_CLEANFILES);
	eval 'sub FORK_NOZOMBIE () {0x00000040;}' unless defined(&FORK_NOZOMBIE);
	eval 'sub FORK_SHAREVM () {0x00000080;}' unless defined(&FORK_SHAREVM);
	eval 'sub PIDHASH {
	    local($pid) = @_;
    	    eval q(( $pidhashtbl[($pid) &  &pidhash]));
	}' unless defined(&PIDHASH);
	eval 'sub PGRPHASH {
	    local($pgid) = @_;
    	    eval q(( $pgrphashtbl[($pgid) &  &pgrphash]));
	}' unless defined(&PGRPHASH);
	eval 'sub NQS () {32;}' unless defined(&NQS);
	if(defined( &UVM)) {
	} else {
	}
    }
}
1;
