require '_h2ph_pre.ph';

unless(defined(&ETHER_MAX_LEN)) {
    eval 'sub ETHER_MAX_LEN () {1518;}' unless defined(&ETHER_MAX_LEN);
}
unless(defined(&ETHER_MIN_LEN)) {
    eval 'sub ETHER_MIN_LEN () {64;}' unless defined(&ETHER_MIN_LEN);
}
unless(defined(&ETHER_CRC_LEN)) {
    eval 'sub ETHER_CRC_LEN () {4;}' unless defined(&ETHER_CRC_LEN);
}
unless(defined(&TX_RING_SIZE)) {
    sub TX_RING_SIZE () {	16;}
}
unless(defined(&RX_RING_SIZE)) {
    sub RX_RING_SIZE () {	16;}
}
unless(defined(&TX_RING_MASK)) {
    sub TX_RING_MASK () {	( &TX_RING_SIZE - 1);}
}
unless(defined(&RX_RING_MASK)) {
    sub RX_RING_MASK () {	( &RX_RING_SIZE - 1);}
}
unless(defined(&EPIC_FULL_DUPLEX)) {
    sub EPIC_FULL_DUPLEX () {	1;}
}
unless(defined(&EPIC_HALF_DUPLEX)) {
    sub EPIC_HALF_DUPLEX () {	0;}
}
unless(defined(&ETHER_MAX_FRAME_LEN)) {
    sub ETHER_MAX_FRAME_LEN () {	( &ETHER_MAX_LEN +  &ETHER_CRC_LEN);}
}
unless(defined(&EPIC_LINK_DOWN)) {
    sub EPIC_LINK_DOWN () {	0x00000001;}
}
unless(defined(&SMC_VENDORID)) {
    sub SMC_VENDORID () {	0x10b8;}
}
unless(defined(&CHIPID_83C170)) {
    sub CHIPID_83C170 () {	0x0005;}
}
unless(defined(&PCI_VENDORID)) {
    sub PCI_VENDORID {
	local($x) = @_;
	eval q((($x) & 0xffff));
    }
}
unless(defined(&PCI_CHIPID)) {
    sub PCI_CHIPID {
	local($x) = @_;
	eval q(((($x) >> 16) & 0xffff));
    }
}
unless(defined(&PCI_CFID)) {
    sub PCI_CFID () {	0x00;}
}
unless(defined(&PCI_CFCS)) {
    sub PCI_CFCS () {	0x04;}
}
unless(defined(&PCI_CFRV)) {
    sub PCI_CFRV () {	0x08;}
}
unless(defined(&PCI_CFLT)) {
    sub PCI_CFLT () {	0x0c;}
}
unless(defined(&PCI_CBIO)) {
    sub PCI_CBIO () {	0x10;}
}
unless(defined(&PCI_CBMA)) {
    sub PCI_CBMA () {	0x14;}
}
unless(defined(&PCI_CFIT)) {
    sub PCI_CFIT () {	0x3c;}
}
unless(defined(&PCI_CFDA)) {
    sub PCI_CFDA () {	0x40;}
}
unless(defined(&PCI_CFCS_IOEN)) {
    sub PCI_CFCS_IOEN () {	0x0001;}
}
unless(defined(&PCI_CFCS_MAEN)) {
    sub PCI_CFCS_MAEN () {	0x0002;}
}
unless(defined(&PCI_CFCS_BMEN)) {
    sub PCI_CFCS_BMEN () {	0x0004;}
}
unless(defined(&PCI_CONF_WRITE)) {
    sub PCI_CONF_WRITE {
	local($r, $v) = @_;
	eval q( &pci_conf_write( &config_id, ($r), ($v)));
    }
}
unless(defined(&PCI_CONF_READ)) {
    sub PCI_CONF_READ {
	local($r) = @_;
	eval q( &pci_conf_read( &config_id, ($r)));
    }
}
unless(defined(&COMMAND)) {
    sub COMMAND () {	0x0000;}
}
unless(defined(&INTSTAT)) {
    sub INTSTAT () {	0x0004;}
}
unless(defined(&INTMASK)) {
    sub INTMASK () {	0x0008;}
}
unless(defined(&GENCTL)) {
    sub GENCTL () {	0x000c;}
}
unless(defined(&NVCTL)) {
    sub NVCTL () {	0x0010;}
}
unless(defined(&EECTL)) {
    sub EECTL () {	0x0014;}
}
unless(defined(&TEST1)) {
    sub TEST1 () {	0x001c;}
}
unless(defined(&CRCCNT)) {
    sub CRCCNT () {	0x0020;}
}
unless(defined(&ALICNT)) {
    sub ALICNT () {	0x0024;}
}
unless(defined(&MPCNT)) {
    sub MPCNT () {	0x0028;}
}
unless(defined(&MIICTL)) {
    sub MIICTL () {	0x0030;}
}
unless(defined(&MIIDATA)) {
    sub MIIDATA () {	0x0034;}
}
unless(defined(&MIICFG)) {
    sub MIICFG () {	0x0038;}
}
unless(defined(&IPG)) {
    sub IPG () {	0x003c;}
}
unless(defined(&LAN0)) {
    sub LAN0 () {	0x0040;}
}
unless(defined(&LAN1)) {
    sub LAN1 () {	0x0044;}
}
unless(defined(&LAN2)) {
    sub LAN2 () {	0x0048;}
}
unless(defined(&ID_CHK)) {
    sub ID_CHK () {	0x004c;}
}
unless(defined(&MC0)) {
    sub MC0 () {	0x0050;}
}
unless(defined(&MC1)) {
    sub MC1 () {	0x0054;}
}
unless(defined(&MC2)) {
    sub MC2 () {	0x0058;}
}
unless(defined(&MC3)) {
    sub MC3 () {	0x005c;}
}
unless(defined(&RXCON)) {
    sub RXCON () {	0x0060;}
}
unless(defined(&TXCON)) {
    sub TXCON () {	0x0070;}
}
unless(defined(&TXSTAT)) {
    sub TXSTAT () {	0x0074;}
}
unless(defined(&PRCDAR)) {
    sub PRCDAR () {	0x0084;}
}
unless(defined(&PRSTAT)) {
    sub PRSTAT () {	0x00a4;}
}
unless(defined(&PRCPTHR)) {
    sub PRCPTHR () {	0x00b0;}
}
unless(defined(&PTCDAR)) {
    sub PTCDAR () {	0x00c4;}
}
unless(defined(&ETXTHR)) {
    sub ETXTHR () {	0x00dc;}
}
unless(defined(&COMMAND_STOP_RX)) {
    sub COMMAND_STOP_RX () {	0x01;}
}
unless(defined(&COMMAND_START_RX)) {
    sub COMMAND_START_RX () {	0x02;}
}
unless(defined(&COMMAND_TXQUEUED)) {
    sub COMMAND_TXQUEUED () {	0x04;}
}
unless(defined(&COMMAND_RXQUEUED)) {
    sub COMMAND_RXQUEUED () {	0x08;}
}
unless(defined(&COMMAND_NEXTFRAME)) {
    sub COMMAND_NEXTFRAME () {	0x10;}
}
unless(defined(&COMMAND_STOP_TDMA)) {
    sub COMMAND_STOP_TDMA () {	0x20;}
}
unless(defined(&COMMAND_STOP_RDMA)) {
    sub COMMAND_STOP_RDMA () {	0x40;}
}
unless(defined(&COMMAND_TXUGO)) {
    sub COMMAND_TXUGO () {	0x80;}
}
unless(defined(&TX_FIFO_THRESH)) {
    sub TX_FIFO_THRESH () {	0x80;}
}
unless(defined(&INTSTAT_RCC)) {
    sub INTSTAT_RCC () {	0x00000001;}
}
unless(defined(&INTSTAT_HCC)) {
    sub INTSTAT_HCC () {	0x00000002;}
}
unless(defined(&INTSTAT_RQE)) {
    sub INTSTAT_RQE () {	0x00000004;}
}
unless(defined(&INTSTAT_OVW)) {
    sub INTSTAT_OVW () {	0x00000008;}
}
unless(defined(&INTSTAT_RXE)) {
    sub INTSTAT_RXE () {	0x00000010;}
}
unless(defined(&INTSTAT_TXC)) {
    sub INTSTAT_TXC () {	0x00000020;}
}
unless(defined(&INTSTAT_TCC)) {
    sub INTSTAT_TCC () {	0x00000040;}
}
unless(defined(&INTSTAT_TQE)) {
    sub INTSTAT_TQE () {	0x00000080;}
}
unless(defined(&INTSTAT_TXU)) {
    sub INTSTAT_TXU () {	0x00000100;}
}
unless(defined(&INTSTAT_CNT)) {
    sub INTSTAT_CNT () {	0x00000200;}
}
unless(defined(&INTSTAT_PREI)) {
    sub INTSTAT_PREI () {	0x00000400;}
}
unless(defined(&INTSTAT_RCT)) {
    sub INTSTAT_RCT () {	0x00000800;}
}
unless(defined(&INTSTAT_FATAL)) {
    sub INTSTAT_FATAL () {	0x00001000;}
}
unless(defined(&INTSTAT_UNUSED1)) {
    sub INTSTAT_UNUSED1 () {	0x00002000;}
}
unless(defined(&INTSTAT_UNUSED2)) {
    sub INTSTAT_UNUSED2 () {	0x00004000;}
}
unless(defined(&INTSTAT_GP2)) {
    sub INTSTAT_GP2 () {	0x00008000;}
}
unless(defined(&INTSTAT_INT_ACTV)) {
    sub INTSTAT_INT_ACTV () {	0x00010000;}
}
unless(defined(&INTSTAT_RXIDLE)) {
    sub INTSTAT_RXIDLE () {	0x00020000;}
}
unless(defined(&INTSTAT_TXIDLE)) {
    sub INTSTAT_TXIDLE () {	0x00040000;}
}
unless(defined(&INTSTAT_RCIP)) {
    sub INTSTAT_RCIP () {	0x00080000;}
}
unless(defined(&INTSTAT_TCIP)) {
    sub INTSTAT_TCIP () {	0x00100000;}
}
unless(defined(&INTSTAT_RBE)) {
    sub INTSTAT_RBE () {	0x00200000;}
}
unless(defined(&INTSTAT_RCTS)) {
    sub INTSTAT_RCTS () {	0x00400000;}
}
unless(defined(&INTSTAT_RSV)) {
    sub INTSTAT_RSV () {	0x00800000;}
}
unless(defined(&INTSTAT_DPE)) {
    sub INTSTAT_DPE () {	0x01000000;}
}
unless(defined(&INTSTAT_APE)) {
    sub INTSTAT_APE () {	0x02000000;}
}
unless(defined(&INTSTAT_PMA)) {
    sub INTSTAT_PMA () {	0x04000000;}
}
unless(defined(&INTSTAT_PTA)) {
    sub INTSTAT_PTA () {	0x08000000;}
}
unless(defined(&GENCTL_SOFT_RESET)) {
    sub GENCTL_SOFT_RESET () {	0x00000001;}
}
unless(defined(&GENCTL_ENABLE_INTERRUPT)) {
    sub GENCTL_ENABLE_INTERRUPT () {	0x00000002;}
}
unless(defined(&GENCTL_SOFTWARE_INTERRUPT)) {
    sub GENCTL_SOFTWARE_INTERRUPT () {	0x00000004;}
}
unless(defined(&GENCTL_POWER_DOWN)) {
    sub GENCTL_POWER_DOWN () {	0x00000008;}
}
unless(defined(&GENCTL_ONECOPY)) {
    sub GENCTL_ONECOPY () {	0x00000010;}
}
unless(defined(&GENCTL_BIG_ENDIAN)) {
    sub GENCTL_BIG_ENDIAN () {	0x00000020;}
}
unless(defined(&GENCTL_RECEIVE_DMA_PRIORITY)) {
    sub GENCTL_RECEIVE_DMA_PRIORITY () {	0x00000040;}
}
unless(defined(&GENCTL_TRANSMIT_DMA_PRIORITY)) {
    sub GENCTL_TRANSMIT_DMA_PRIORITY () {	0x00000080;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD128)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD128 () {	0x00000300;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD96)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD96 () {	0x00000200;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD64)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD64 () {	0x00000100;}
}
unless(defined(&GENCTL_RECEIVE_FIFO_THRESHOLD32)) {
    sub GENCTL_RECEIVE_FIFO_THRESHOLD32 () {	0x00000000;}
}
unless(defined(&GENCTL_MEMORY_READ_LINE)) {
    sub GENCTL_MEMORY_READ_LINE () {	0x00000400;}
}
unless(defined(&GENCTL_MEMORY_READ_MULTIPLE)) {
    sub GENCTL_MEMORY_READ_MULTIPLE () {	0x00000800;}
}
unless(defined(&GENCTL_SOFTWARE1)) {
    sub GENCTL_SOFTWARE1 () {	0x00001000;}
}
unless(defined(&GENCTL_SOFTWARE2)) {
    sub GENCTL_SOFTWARE2 () {	0x00002000;}
}
unless(defined(&GENCTL_RESET_PHY)) {
    sub GENCTL_RESET_PHY () {	0x00004000;}
}
unless(defined(&NVCTL_ENABLE_MEMORY_MAP)) {
    sub NVCTL_ENABLE_MEMORY_MAP () {	0x00000001;}
}
unless(defined(&NVCTL_CLOCK_RUN_SUPPORTED)) {
    sub NVCTL_CLOCK_RUN_SUPPORTED () {	0x00000002;}
}
unless(defined(&NVCTL_GP1_OUTPUT_ENABLE)) {
    sub NVCTL_GP1_OUTPUT_ENABLE () {	0x00000004;}
}
unless(defined(&NVCTL_GP2_OUTPUT_ENABLE)) {
    sub NVCTL_GP2_OUTPUT_ENABLE () {	0x00000008;}
}
unless(defined(&NVCTL_GP1)) {
    sub NVCTL_GP1 () {	0x00000010;}
}
unless(defined(&NVCTL_GP2)) {
    sub NVCTL_GP2 () {	0x00000020;}
}
unless(defined(&NVCTL_CARDBUS_MODE)) {
    sub NVCTL_CARDBUS_MODE () {	0x00000040;}
}
unless(defined(&NVCTL_IPG_DELAY_MASK)) {
    sub NVCTL_IPG_DELAY_MASK {
	local($x) = @_;
	eval q((($x&0xf)<<7));
    }
}
unless(defined(&RXCON_SAVE_ERRORED_PACKETS)) {
    sub RXCON_SAVE_ERRORED_PACKETS () {	0x00000001;}
}
unless(defined(&RXCON_RECEIVE_RUNT_FRAMES)) {
    sub RXCON_RECEIVE_RUNT_FRAMES () {	0x00000002;}
}
unless(defined(&RXCON_RECEIVE_BROADCAST_FRAMES)) {
    sub RXCON_RECEIVE_BROADCAST_FRAMES () {	0x00000004;}
}
unless(defined(&RXCON_RECEIVE_MULTICAST_FRAMES)) {
    sub RXCON_RECEIVE_MULTICAST_FRAMES () {	0x00000008;}
}
unless(defined(&RXCON_RECEIVE_INVERSE_INDIVIDUAL_ADDRESS_FRAMES)) {
    sub RXCON_RECEIVE_INVERSE_INDIVIDUAL_ADDRESS_FRAMES () {	0x00000010;}
}
unless(defined(&RXCON_PROMISCUOUS_MODE)) {
    sub RXCON_PROMISCUOUS_MODE () {	0x00000020;}
}
unless(defined(&RXCON_MONITOR_MODE)) {
    sub RXCON_MONITOR_MODE () {	0x00000040;}
}
unless(defined(&RXCON_EARLY_RECEIVE_ENABLE)) {
    sub RXCON_EARLY_RECEIVE_ENABLE () {	0x00000080;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_DISABLE)) {
    sub RXCON_EXTERNAL_BUFFER_DISABLE () {	0x00000000;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_16K)) {
    sub RXCON_EXTERNAL_BUFFER_16K () {	0x00000100;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_32K)) {
    sub RXCON_EXTERNAL_BUFFER_32K () {	0x00000200;}
}
unless(defined(&RXCON_EXTERNAL_BUFFER_128K)) {
    sub RXCON_EXTERNAL_BUFFER_128K () {	0x00000300;}
}
unless(defined(&TXCON_EARLY_TRANSMIT_ENABLE)) {
    sub TXCON_EARLY_TRANSMIT_ENABLE () {	0x00000001;}
}
unless(defined(&TXCON_LOOPBACK_DISABLE)) {
    sub TXCON_LOOPBACK_DISABLE () {	0x00000000;}
}
unless(defined(&TXCON_LOOPBACK_MODE_INT)) {
    sub TXCON_LOOPBACK_MODE_INT () {	0x00000002;}
}
unless(defined(&TXCON_LOOPBACK_MODE_PHY)) {
    sub TXCON_LOOPBACK_MODE_PHY () {	0x00000004;}
}
unless(defined(&TXCON_LOOPBACK_MODE)) {
    sub TXCON_LOOPBACK_MODE () {	0x00000006;}
}
unless(defined(&TXCON_FULL_DUPLEX)) {
    sub TXCON_FULL_DUPLEX () {	0x00000006;}
}
unless(defined(&TXCON_SLOT_TIME)) {
    sub TXCON_SLOT_TIME () {	0x00000078;}
}
unless(defined(&MIICFG_SMI_ENABLE)) {
    sub MIICFG_SMI_ENABLE () {	0x00000010;}
}
unless(defined(&TEST1_CLOCK_TEST)) {
    sub TEST1_CLOCK_TEST () {	0x00000008;}
}
unless(defined(&TXCON_DEFAULT)) {
    sub TXCON_DEFAULT () {	( &TXCON_SLOT_TIME |  &TXCON_EARLY_TRANSMIT_ENABLE);}
}
unless(defined(&TRANSMIT_THRESHOLD)) {
    sub TRANSMIT_THRESHOLD () {	0x80;}
}
if(defined( &EARLY_RX)) {
    eval 'sub RXCON_DEFAULT () {( &RXCON_EARLY_RECEIVE_ENABLE |  &RXCON_SAVE_ERRORED_PACKETS);}' unless defined(&RXCON_DEFAULT);
} else {
    eval 'sub RXCON_DEFAULT () {(0);}' unless defined(&RXCON_DEFAULT);
}
unless(defined(&DP83840_OUI)) {
    sub DP83840_OUI () {	0x080017;}
}
unless(defined(&DP83840_BMCR)) {
    sub DP83840_BMCR () {	0x00;}
}
unless(defined(&DP83840_BMSR)) {
    sub DP83840_BMSR () {	0x01;}
}
unless(defined(&DP83840_ANAR)) {
    sub DP83840_ANAR () {	0x04;}
}
unless(defined(&DP83840_LPAR)) {
    sub DP83840_LPAR () {	0x05;}
}
unless(defined(&DP83840_ANER)) {
    sub DP83840_ANER () {	0x06;}
}
unless(defined(&DP83840_PAR)) {
    sub DP83840_PAR () {	0x19;}
}
unless(defined(&DP83840_PHYIDR1)) {
    sub DP83840_PHYIDR1 () {	0x02;}
}
unless(defined(&DP83840_PHYIDR2)) {
    sub DP83840_PHYIDR2 () {	0x03;}
}
unless(defined(&BMCR_RESET)) {
    sub BMCR_RESET () {	0x8000;}
}
unless(defined(&BMCR_LOOPBACK)) {
    sub BMCR_LOOPBACK () {	0x4000;}
}
unless(defined(&BMCR_100MBPS)) {
    sub BMCR_100MBPS () {	0x2000;}
}
unless(defined(&BMCR_AUTONEGOTIATION)) {
    sub BMCR_AUTONEGOTIATION () {	0x1000;}
}
unless(defined(&BMCR_POWERDOWN)) {
    sub BMCR_POWERDOWN () {	0x0800;}
}
unless(defined(&BMCR_ISOLATE)) {
    sub BMCR_ISOLATE () {	0x0400;}
}
unless(defined(&BMCR_RESTART_AUTONEG)) {
    sub BMCR_RESTART_AUTONEG () {	0x0200;}
}
unless(defined(&BMCR_FULL_DUPLEX)) {
    sub BMCR_FULL_DUPLEX () {	0x0100;}
}
unless(defined(&BMCR_COL_TEST)) {
    sub BMCR_COL_TEST () {	0x0080;}
}
unless(defined(&BMSR_100BASE_T4)) {
    sub BMSR_100BASE_T4 () {	0x8000;}
}
unless(defined(&BMSR_100BASE_TX_FD)) {
    sub BMSR_100BASE_TX_FD () {	0x4000;}
}
unless(defined(&BMSR_100BASE_TX)) {
    sub BMSR_100BASE_TX () {	0x2000;}
}
unless(defined(&BMSR_10BASE_T_FD)) {
    sub BMSR_10BASE_T_FD () {	0x1000;}
}
unless(defined(&BMSR_10BASE_T)) {
    sub BMSR_10BASE_T () {	0x0800;}
}
unless(defined(&BMSR_AUTONEG_COMPLETE)) {
    sub BMSR_AUTONEG_COMPLETE () {	0x0020;}
}
unless(defined(&BMSR_AUTONEG_ABLE)) {
    sub BMSR_AUTONEG_ABLE () {	0x0008;}
}
unless(defined(&BMSR_LINK_STATUS)) {
    sub BMSR_LINK_STATUS () {	0x0004;}
}
unless(defined(&PAR_FULL_DUPLEX)) {
    sub PAR_FULL_DUPLEX () {	0x0400;}
}
unless(defined(&ANER_MULTIPLE_LINK_FAULT)) {
    sub ANER_MULTIPLE_LINK_FAULT () {	0x10;}
}
unless(defined(&ANAR_10)) {
    sub ANAR_10 () {	0x0020;}
}
unless(defined(&ANAR_10_FD)) {
    sub ANAR_10_FD () {	0x0040;}
}
unless(defined(&ANAR_100_TX)) {
    sub ANAR_100_TX () {	0x0080;}
}
unless(defined(&ANAR_100_TX_FD)) {
    sub ANAR_100_TX_FD () {	0x0100;}
}
unless(defined(&ANAR_100_T4)) {
    sub ANAR_100_T4 () {	0x0200;}
}
unless(defined(&QS6612_OUI)) {
    sub QS6612_OUI () {	0x006051;}
}
unless(defined(&QS6612_MCTL)) {
    sub QS6612_MCTL () {	17;}
}
unless(defined(&QS6612_INTSTAT)) {
    sub QS6612_INTSTAT () {	29;}
}
unless(defined(&QS6612_INTMASK)) {
    sub QS6612_INTMASK () {	30;}
}
unless(defined(&QS6612_BPCR)) {
    sub QS6612_BPCR () {	31;}
}
unless(defined(&MCTL_T4_PRESENT)) {
    sub MCTL_T4_PRESENT () {	0x1000;}
}
unless(defined(&MCTL_BTEXT)) {
    sub MCTL_BTEXT () {	0x0800;}
}
unless(defined(&INTSTAT_AN_COMPLETE)) {
    sub INTSTAT_AN_COMPLETE () {	0x40;}
}
unless(defined(&INTSTAT_RF_DETECTED)) {
    sub INTSTAT_RF_DETECTED () {	0x20;}
}
unless(defined(&INTSTAT_LINK_STATUS)) {
    sub INTSTAT_LINK_STATUS () {	0x10;}
}
unless(defined(&INTSTAT_AN_LP_ACK)) {
    sub INTSTAT_AN_LP_ACK () {	0x08;}
}
unless(defined(&INTSTAT_PD_FAULT)) {
    sub INTSTAT_PD_FAULT () {	0x04;}
}
unless(defined(&INTSTAT_AN_PAGE)) {
    sub INTSTAT_AN_PAGE () {	0x04;}
}
unless(defined(&INTSTAT_RE_CNT_FULL)) {
    sub INTSTAT_RE_CNT_FULL () {	0x01;}
}
unless(defined(&INTMASK_THUNDERLAN)) {
    sub INTMASK_THUNDERLAN () {	0x8000;}
}
unless(defined(&EPIC_MAX_FRAGS)) {
    sub EPIC_MAX_FRAGS () {	63;}
}
if(defined( &__OpenBSD__)) {
} else {
    if(defined( &EPIC_USEIOSPACE)) {
    } else {
    }
}
if(!defined( &EPIC_NOIFMEDIA)) {
}
if(defined( &__FreeBSD__)) {
    eval 'sub EPIC_FORMAT () {"tx%d";}' unless defined(&EPIC_FORMAT);
    eval 'sub EPIC_ARGS {
        local($sc) = @_;
	    eval q(( ($sc->{unit})));
    }' unless defined(&EPIC_ARGS);
    eval 'sub sc_if () { ($arpcom->{ac_if});}' unless defined(&sc_if);
    eval 'sub sc_macaddr () { ($arpcom->{ac_enaddr});}' unless defined(&sc_macaddr);
    if(defined( &EPIC_USEIOSPACE)) {
	eval 'sub CSR_WRITE_4 {
	    local($sc,$reg,$val) = @_;
    	    eval q( &outl( -> &iobase + ($reg), ($val) ));
	}' unless defined(&CSR_WRITE_4);
	eval 'sub CSR_WRITE_2 {
	    local($sc,$reg,$val) = @_;
    	    eval q( &outw( -> &iobase + ($reg), ($val) ));
	}' unless defined(&CSR_WRITE_2);
	eval 'sub CSR_WRITE_1 {
	    local($sc,$reg,$val) = @_;
    	    eval q( &outb( -> &iobase + ($reg), ($val) ));
	}' unless defined(&CSR_WRITE_1);
	eval 'sub CSR_READ_4 {
	    local($sc,$reg) = @_;
    	    eval q( &inl( -> &iobase + ($reg) ));
	}' unless defined(&CSR_READ_4);
	eval 'sub CSR_READ_2 {
	    local($sc,$reg) = @_;
    	    eval q( &inw( -> &iobase + ($reg) ));
	}' unless defined(&CSR_READ_2);
	eval 'sub CSR_READ_1 {
	    local($sc,$reg) = @_;
    	    eval q( &inb( -> &iobase + ($reg) ));
	}' unless defined(&CSR_READ_1);
    } else {
	eval 'sub CSR_WRITE_1 {
	    local($sc,$reg,$val) = @_;
    	    eval q(((*(-> &csr + )) = ($val)));
	}' unless defined(&CSR_WRITE_1);
	eval 'sub CSR_WRITE_2 {
	    local($sc,$reg,$val) = @_;
    	    eval q(((*(-> &csr + )) = ($val)));
	}' unless defined(&CSR_WRITE_2);
	eval 'sub CSR_WRITE_4 {
	    local($sc,$reg,$val) = @_;
    	    eval q(((*(-> &csr + )) = ($val)));
	}' unless defined(&CSR_WRITE_4);
	eval 'sub CSR_READ_1 {
	    local($sc,$reg) = @_;
    	    eval q((*(-> &csr + ($reg))));
	}' unless defined(&CSR_READ_1);
	eval 'sub CSR_READ_2 {
	    local($sc,$reg) = @_;
    	    eval q((*(-> &csr + ($reg))));
	}' unless defined(&CSR_READ_2);
	eval 'sub CSR_READ_4 {
	    local($sc,$reg) = @_;
    	    eval q((*(-> &csr + ($reg))));
	}' unless defined(&CSR_READ_4);
    }
} else {
    eval 'sub EPIC_FORMAT () {"%s";}' unless defined(&EPIC_FORMAT);
    eval 'sub EPIC_ARGS {
        local($sc) = @_;
	    eval q(( ($sc->{sc_dev}->{dv_xname})));
    }' unless defined(&EPIC_ARGS);
    eval 'sub sc_if () { ($arpcom->{ac_if});}' unless defined(&sc_if);
    eval 'sub sc_macaddr () { ($arpcom->{ac_enaddr});}' unless defined(&sc_macaddr);
    eval 'sub CSR_WRITE_4 {
        local($sc,$reg,$val) = @_;
	    eval q( &bus_space_write_4( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val) ));
    }' unless defined(&CSR_WRITE_4);
    eval 'sub CSR_WRITE_2 {
        local($sc,$reg,$val) = @_;
	    eval q( &bus_space_write_2( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val) ));
    }' unless defined(&CSR_WRITE_2);
    eval 'sub CSR_WRITE_1 {
        local($sc,$reg,$val) = @_;
	    eval q( &bus_space_write_1( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val) ));
    }' unless defined(&CSR_WRITE_1);
    eval 'sub CSR_READ_4 {
        local($sc,$reg) = @_;
	    eval q( &bus_space_read_4( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg) ));
    }' unless defined(&CSR_READ_4);
    eval 'sub CSR_READ_2 {
        local($sc,$reg) = @_;
	    eval q( &bus_space_read_2( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg) ));
    }' unless defined(&CSR_READ_2);
    eval 'sub CSR_READ_1 {
        local($sc,$reg) = @_;
	    eval q( &bus_space_read_1( ($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg) ));
    }' unless defined(&CSR_READ_1);
}
unless(defined(&PHY_READ_2)) {
    sub PHY_READ_2 {
	local($sc,$reg) = @_;
	eval q( &epic_read_phy_register($sc,$reg));
    }
}
unless(defined(&PHY_WRITE_2)) {
    sub PHY_WRITE_2 {
	local($sc,$reg,$val) = @_;
	eval q( &epic_write_phy_register($sc,$reg,$val));
    }
}
1;
