require '_h2ph_pre.ph';

unless(defined(&SIS_CSR)) {
    sub SIS_CSR () {	0x00;}
}
unless(defined(&SIS_CFG)) {
    sub SIS_CFG () {	0x04;}
}
unless(defined(&SIS_EECTL)) {
    sub SIS_EECTL () {	0x08;}
}
unless(defined(&SIS_PCICTL)) {
    sub SIS_PCICTL () {	0x0c;}
}
unless(defined(&SIS_ISR)) {
    sub SIS_ISR () {	0x10;}
}
unless(defined(&SIS_IMR)) {
    sub SIS_IMR () {	0x14;}
}
unless(defined(&SIS_IER)) {
    sub SIS_IER () {	0x18;}
}
unless(defined(&SIS_PHYCTL)) {
    sub SIS_PHYCTL () {	0x1c;}
}
unless(defined(&SIS_TX_LISTPTR)) {
    sub SIS_TX_LISTPTR () {	0x20;}
}
unless(defined(&SIS_TX_CFG)) {
    sub SIS_TX_CFG () {	0x24;}
}
unless(defined(&SIS_RX_LISTPTR)) {
    sub SIS_RX_LISTPTR () {	0x30;}
}
unless(defined(&SIS_RX_CFG)) {
    sub SIS_RX_CFG () {	0x34;}
}
unless(defined(&SIS_FLOWCTL)) {
    sub SIS_FLOWCTL () {	0x38;}
}
unless(defined(&SIS_RXFILT_CTL)) {
    sub SIS_RXFILT_CTL () {	0x48;}
}
unless(defined(&SIS_RXFILT_DATA)) {
    sub SIS_RXFILT_DATA () {	0x4c;}
}
unless(defined(&SIS_PWRMAN_CTL)) {
    sub SIS_PWRMAN_CTL () {	0xb0;}
}
unless(defined(&SIS_PWERMAN_WKUP_EVENT)) {
    sub SIS_PWERMAN_WKUP_EVENT () {	0xb4;}
}
unless(defined(&SIS_WKUP_FRAME_CRC)) {
    sub SIS_WKUP_FRAME_CRC () {	0xbc;}
}
unless(defined(&SIS_WKUP_FRAME_MASK0)) {
    sub SIS_WKUP_FRAME_MASK0 () {	0xc0;}
}
unless(defined(&SIS_WKUP_FRAME_MASKXX)) {
    sub SIS_WKUP_FRAME_MASKXX () {	0xec;}
}
unless(defined(&SIS_SILICON_REV)) {
    sub SIS_SILICON_REV () {	0x5c;}
}
unless(defined(&SIS_MIB_CTL0)) {
    sub SIS_MIB_CTL0 () {	0x60;}
}
unless(defined(&SIS_MIB_CTL1)) {
    sub SIS_MIB_CTL1 () {	0x64;}
}
unless(defined(&SIS_MIB_CTL2)) {
    sub SIS_MIB_CTL2 () {	0x68;}
}
unless(defined(&SIS_MIB_CTL3)) {
    sub SIS_MIB_CTL3 () {	0x6c;}
}
unless(defined(&SIS_MIB)) {
    sub SIS_MIB () {	0x80;}
}
unless(defined(&SIS_LINKSTS)) {
    sub SIS_LINKSTS () {	0xa0;}
}
unless(defined(&SIS_TIMEUNIT)) {
    sub SIS_TIMEUNIT () {	0xa4;}
}
unless(defined(&SIS_GPIO)) {
    sub SIS_GPIO () {	0xb8;}
}
unless(defined(&SIS_CSR_TX_ENABLE)) {
    sub SIS_CSR_TX_ENABLE () {	0x00000001;}
}
unless(defined(&SIS_CSR_TX_DISABLE)) {
    sub SIS_CSR_TX_DISABLE () {	0x00000002;}
}
unless(defined(&SIS_CSR_RX_ENABLE)) {
    sub SIS_CSR_RX_ENABLE () {	0x00000004;}
}
unless(defined(&SIS_CSR_RX_DISABLE)) {
    sub SIS_CSR_RX_DISABLE () {	0x00000008;}
}
unless(defined(&SIS_CSR_TX_RESET)) {
    sub SIS_CSR_TX_RESET () {	0x00000010;}
}
unless(defined(&SIS_CSR_RX_RESET)) {
    sub SIS_CSR_RX_RESET () {	0x00000020;}
}
unless(defined(&SIS_CSR_SOFTINTR)) {
    sub SIS_CSR_SOFTINTR () {	0x00000080;}
}
unless(defined(&SIS_CSR_RESET)) {
    sub SIS_CSR_RESET () {	0x00000100;}
}
unless(defined(&SIS_CFG_BIGENDIAN)) {
    sub SIS_CFG_BIGENDIAN () {	0x00000001;}
}
unless(defined(&SIS_CFG_PERR_DETECT)) {
    sub SIS_CFG_PERR_DETECT () {	0x00000008;}
}
unless(defined(&SIS_CFG_DEFER_DISABLE)) {
    sub SIS_CFG_DEFER_DISABLE () {	0x00000010;}
}
unless(defined(&SIS_CFG_OUTOFWIN_TIMER)) {
    sub SIS_CFG_OUTOFWIN_TIMER () {	0x00000020;}
}
unless(defined(&SIS_CFG_SINGLE_BACKOFF)) {
    sub SIS_CFG_SINGLE_BACKOFF () {	0x00000040;}
}
unless(defined(&SIS_CFG_PCIREQ_ALG)) {
    sub SIS_CFG_PCIREQ_ALG () {	0x00000080;}
}
unless(defined(&SIS_EECTL_DIN)) {
    sub SIS_EECTL_DIN () {	0x00000001;}
}
unless(defined(&SIS_EECTL_DOUT)) {
    sub SIS_EECTL_DOUT () {	0x00000002;}
}
unless(defined(&SIS_EECTL_CLK)) {
    sub SIS_EECTL_CLK () {	0x00000004;}
}
unless(defined(&SIS_EECTL_CSEL)) {
    sub SIS_EECTL_CSEL () {	0x00000008;}
}
unless(defined(&SIS_EECMD_WRITE)) {
    sub SIS_EECMD_WRITE () {	0x140;}
}
unless(defined(&SIS_EECMD_READ)) {
    sub SIS_EECMD_READ () {	0x180;}
}
unless(defined(&SIS_EECMD_ERASE)) {
    sub SIS_EECMD_ERASE () {	0x1c0;}
}
unless(defined(&SIS_EE_NODEADDR)) {
    sub SIS_EE_NODEADDR () {	0x8;}
}
unless(defined(&SIS_PCICTL_SRAMADDR)) {
    sub SIS_PCICTL_SRAMADDR () {	0x0000001f;}
}
unless(defined(&SIS_PCICTL_RAMTSTENB)) {
    sub SIS_PCICTL_RAMTSTENB () {	0x00000020;}
}
unless(defined(&SIS_PCICTL_TXTSTENB)) {
    sub SIS_PCICTL_TXTSTENB () {	0x00000040;}
}
unless(defined(&SIS_PCICTL_RXTSTENB)) {
    sub SIS_PCICTL_RXTSTENB () {	0x00000080;}
}
unless(defined(&SIS_PCICTL_BMTSTENB)) {
    sub SIS_PCICTL_BMTSTENB () {	0x00000200;}
}
unless(defined(&SIS_PCICTL_RAMADDR)) {
    sub SIS_PCICTL_RAMADDR () {	0x001f0000;}
}
unless(defined(&SIS_PCICTL_ROMTIME)) {
    sub SIS_PCICTL_ROMTIME () {	0x0f000000;}
}
unless(defined(&SIS_PCICTL_DISCTEST)) {
    sub SIS_PCICTL_DISCTEST () {	0x40000000;}
}
unless(defined(&SIS_ISR_RX_OK)) {
    sub SIS_ISR_RX_OK () {	0x00000001;}
}
unless(defined(&SIS_ISR_RX_DESC_OK)) {
    sub SIS_ISR_RX_DESC_OK () {	0x00000002;}
}
unless(defined(&SIS_ISR_RX_ERR)) {
    sub SIS_ISR_RX_ERR () {	0x00000004;}
}
unless(defined(&SIS_ISR_RX_EARLY)) {
    sub SIS_ISR_RX_EARLY () {	0x00000008;}
}
unless(defined(&SIS_ISR_RX_IDLE)) {
    sub SIS_ISR_RX_IDLE () {	0x00000010;}
}
unless(defined(&SIS_ISR_RX_OFLOW)) {
    sub SIS_ISR_RX_OFLOW () {	0x00000020;}
}
unless(defined(&SIS_ISR_TX_OK)) {
    sub SIS_ISR_TX_OK () {	0x00000040;}
}
unless(defined(&SIS_ISR_TX_DESC_OK)) {
    sub SIS_ISR_TX_DESC_OK () {	0x00000080;}
}
unless(defined(&SIS_ISR_TX_ERR)) {
    sub SIS_ISR_TX_ERR () {	0x00000100;}
}
unless(defined(&SIS_ISR_TX_IDLE)) {
    sub SIS_ISR_TX_IDLE () {	0x00000200;}
}
unless(defined(&SIS_ISR_TX_UFLOW)) {
    sub SIS_ISR_TX_UFLOW () {	0x00000400;}
}
unless(defined(&SIS_ISR_SOFTINTR)) {
    sub SIS_ISR_SOFTINTR () {	0x00000800;}
}
unless(defined(&SIS_ISR_HIBITS)) {
    sub SIS_ISR_HIBITS () {	0x00008000;}
}
unless(defined(&SIS_ISR_RX_FIFO_OFLOW)) {
    sub SIS_ISR_RX_FIFO_OFLOW () {	0x00010000;}
}
unless(defined(&SIS_ISR_TGT_ABRT)) {
    sub SIS_ISR_TGT_ABRT () {	0x00100000;}
}
unless(defined(&SIS_ISR_BM_ABRT)) {
    sub SIS_ISR_BM_ABRT () {	0x00200000;}
}
unless(defined(&SIS_ISR_SYSERR)) {
    sub SIS_ISR_SYSERR () {	0x00400000;}
}
unless(defined(&SIS_ISR_PARITY_ERR)) {
    sub SIS_ISR_PARITY_ERR () {	0x00800000;}
}
unless(defined(&SIS_ISR_RX_RESET_DONE)) {
    sub SIS_ISR_RX_RESET_DONE () {	0x01000000;}
}
unless(defined(&SIS_ISR_TX_RESET_DONE)) {
    sub SIS_ISR_TX_RESET_DONE () {	0x02000000;}
}
unless(defined(&SIS_ISR_TX_PAUSE_START)) {
    sub SIS_ISR_TX_PAUSE_START () {	0x04000000;}
}
unless(defined(&SIS_ISR_TX_PAUSE_DONE)) {
    sub SIS_ISR_TX_PAUSE_DONE () {	0x08000000;}
}
unless(defined(&SIS_ISR_WAKE_EVENT)) {
    sub SIS_ISR_WAKE_EVENT () {	0x10000000;}
}
unless(defined(&SIS_IMR_RX_OK)) {
    sub SIS_IMR_RX_OK () {	0x00000001;}
}
unless(defined(&SIS_IMR_RX_DESC_OK)) {
    sub SIS_IMR_RX_DESC_OK () {	0x00000002;}
}
unless(defined(&SIS_IMR_RX_ERR)) {
    sub SIS_IMR_RX_ERR () {	0x00000004;}
}
unless(defined(&SIS_IMR_RX_EARLY)) {
    sub SIS_IMR_RX_EARLY () {	0x00000008;}
}
unless(defined(&SIS_IMR_RX_IDLE)) {
    sub SIS_IMR_RX_IDLE () {	0x00000010;}
}
unless(defined(&SIS_IMR_RX_OFLOW)) {
    sub SIS_IMR_RX_OFLOW () {	0x00000020;}
}
unless(defined(&SIS_IMR_TX_OK)) {
    sub SIS_IMR_TX_OK () {	0x00000040;}
}
unless(defined(&SIS_IMR_TX_DESC_OK)) {
    sub SIS_IMR_TX_DESC_OK () {	0x00000080;}
}
unless(defined(&SIS_IMR_TX_ERR)) {
    sub SIS_IMR_TX_ERR () {	0x00000100;}
}
unless(defined(&SIS_IMR_TX_IDLE)) {
    sub SIS_IMR_TX_IDLE () {	0x00000200;}
}
unless(defined(&SIS_IMR_TX_UFLOW)) {
    sub SIS_IMR_TX_UFLOW () {	0x00000400;}
}
unless(defined(&SIS_IMR_SOFTINTR)) {
    sub SIS_IMR_SOFTINTR () {	0x00000800;}
}
unless(defined(&SIS_IMR_HIBITS)) {
    sub SIS_IMR_HIBITS () {	0x00008000;}
}
unless(defined(&SIS_IMR_RX_FIFO_OFLOW)) {
    sub SIS_IMR_RX_FIFO_OFLOW () {	0x00010000;}
}
unless(defined(&SIS_IMR_TGT_ABRT)) {
    sub SIS_IMR_TGT_ABRT () {	0x00100000;}
}
unless(defined(&SIS_IMR_BM_ABRT)) {
    sub SIS_IMR_BM_ABRT () {	0x00200000;}
}
unless(defined(&SIS_IMR_SYSERR)) {
    sub SIS_IMR_SYSERR () {	0x00400000;}
}
unless(defined(&SIS_IMR_PARITY_ERR)) {
    sub SIS_IMR_PARITY_ERR () {	0x00800000;}
}
unless(defined(&SIS_IMR_RX_RESET_DONE)) {
    sub SIS_IMR_RX_RESET_DONE () {	0x01000000;}
}
unless(defined(&SIS_IMR_TX_RESET_DONE)) {
    sub SIS_IMR_TX_RESET_DONE () {	0x02000000;}
}
unless(defined(&SIS_IMR_TX_PAUSE_START)) {
    sub SIS_IMR_TX_PAUSE_START () {	0x04000000;}
}
unless(defined(&SIS_IMR_TX_PAUSE_DONE)) {
    sub SIS_IMR_TX_PAUSE_DONE () {	0x08000000;}
}
unless(defined(&SIS_IMR_WAKE_EVENT)) {
    sub SIS_IMR_WAKE_EVENT () {	0x10000000;}
}
unless(defined(&SIS_INTRS)) {
    sub SIS_INTRS () {	( &SIS_IMR_RX_OFLOW| &SIS_IMR_TX_UFLOW| &SIS_IMR_TX_OK|  &SIS_IMR_TX_IDLE| &SIS_IMR_RX_OK| &SIS_IMR_RX_ERR|  &SIS_IMR_SYSERR);}
}
unless(defined(&SIS_IER_INTRENB)) {
    sub SIS_IER_INTRENB () {	0x00000001;}
}
unless(defined(&SIS_PHYCTL_ACCESS)) {
    sub SIS_PHYCTL_ACCESS () {	0x00000010;}
}
unless(defined(&SIS_PHYCTL_OP)) {
    sub SIS_PHYCTL_OP () {	0x00000020;}
}
unless(defined(&SIS_PHYCTL_REGADDR)) {
    sub SIS_PHYCTL_REGADDR () {	0x000007c0;}
}
unless(defined(&SIS_PHYCTL_PHYADDR)) {
    sub SIS_PHYCTL_PHYADDR () {	0x0000f800;}
}
unless(defined(&SIS_PHYCTL_PHYDATA)) {
    sub SIS_PHYCTL_PHYDATA () {	0xffff0000;}
}
unless(defined(&SIS_PHYOP_READ)) {
    sub SIS_PHYOP_READ () {	0x00000020;}
}
unless(defined(&SIS_PHYOP_WRITE)) {
    sub SIS_PHYOP_WRITE () {	0x00000000;}
}
unless(defined(&SIS_TXCFG_DRAIN_THRESH)) {
    sub SIS_TXCFG_DRAIN_THRESH () {	0x0000003f;}
}
unless(defined(&SIS_TXCFG_FILL_THRESH)) {
    sub SIS_TXCFG_FILL_THRESH () {	0x00003f00;}
}
unless(defined(&SIS_TXCFG_DMABURST)) {
    sub SIS_TXCFG_DMABURST () {	0x00700000;}
}
unless(defined(&SIS_TXCFG_AUTOPAD)) {
    sub SIS_TXCFG_AUTOPAD () {	0x10000000;}
}
unless(defined(&SIS_TXCFG_LOOPBK)) {
    sub SIS_TXCFG_LOOPBK () {	0x20000000;}
}
unless(defined(&SIS_TXCFG_IGN_HBEAT)) {
    sub SIS_TXCFG_IGN_HBEAT () {	0x40000000;}
}
unless(defined(&SIS_TXCFG_IGN_CARR)) {
    sub SIS_TXCFG_IGN_CARR () {	0x80000000;}
}
unless(defined(&SIS_TXCFG_DRAIN)) {
    sub SIS_TXCFG_DRAIN {
	local($x) = @_;
	eval q(((($x) >> 5) &  &SIS_TXCFG_DRAIN_THRESH));
    }
}
unless(defined(&SIS_TXCFG_FILL)) {
    sub SIS_TXCFG_FILL {
	local($x) = @_;
	eval q((((($x) >> 5) << 8) &  &SIS_TXCFG_FILL_THRESH));
    }
}
unless(defined(&SIS_TXDMA_512BYTES)) {
    sub SIS_TXDMA_512BYTES () {	0x00000000;}
}
unless(defined(&SIS_TXDMA_4BYTES)) {
    sub SIS_TXDMA_4BYTES () {	0x00100000;}
}
unless(defined(&SIS_TXDMA_8BYTES)) {
    sub SIS_TXDMA_8BYTES () {	0x00200000;}
}
unless(defined(&SIS_TXDMA_16BYTES)) {
    sub SIS_TXDMA_16BYTES () {	0x00300000;}
}
unless(defined(&SIS_TXDMA_32BYTES)) {
    sub SIS_TXDMA_32BYTES () {	0x00400000;}
}
unless(defined(&SIS_TXDMA_64BYTES)) {
    sub SIS_TXDMA_64BYTES () {	0x00500000;}
}
unless(defined(&SIS_TXDMA_128BYTES)) {
    sub SIS_TXDMA_128BYTES () {	0x00600000;}
}
unless(defined(&SIS_TXDMA_256BYTES)) {
    sub SIS_TXDMA_256BYTES () {	0x00700000;}
}
unless(defined(&SIS_TXCFG)) {
    sub SIS_TXCFG () {	( &SIS_TXDMA_64BYTES| &SIS_TXCFG_AUTOPAD|  &SIS_TXCFG_FILL(64)| &SIS_TXCFG_DRAIN(1500));}
}
unless(defined(&SIS_RXCFG_DRAIN_THRESH)) {
    sub SIS_RXCFG_DRAIN_THRESH () {	0x0000003e;}
}
unless(defined(&SIS_RXCFG_DMABURST)) {
    sub SIS_RXCFG_DMABURST () {	0x00700000;}
}
unless(defined(&SIS_RXCFG_RX_JABBER)) {
    sub SIS_RXCFG_RX_JABBER () {	0x08000000;}
}
unless(defined(&SIS_RXCFG_RX_TXPKTS)) {
    sub SIS_RXCFG_RX_TXPKTS () {	0x10000000;}
}
unless(defined(&SIS_RXCFG_RX_RUNTS)) {
    sub SIS_RXCFG_RX_RUNTS () {	0x40000000;}
}
unless(defined(&SIS_RXCFG_RX_GIANTS)) {
    sub SIS_RXCFG_RX_GIANTS () {	0x80000000;}
}
unless(defined(&SIS_RXCFG_DRAIN)) {
    sub SIS_RXCFG_DRAIN {
	local($x) = @_;
	eval q((((($x) >> 3) << 1) &  &SIS_RXCFG_DRAIN_THRESH));
    }
}
unless(defined(&SIS_RXDMA_512BYTES)) {
    sub SIS_RXDMA_512BYTES () {	0x00000000;}
}
unless(defined(&SIS_RXDMA_4BYTES)) {
    sub SIS_RXDMA_4BYTES () {	0x00100000;}
}
unless(defined(&SIS_RXDMA_8BYTES)) {
    sub SIS_RXDMA_8BYTES () {	0x00200000;}
}
unless(defined(&SIS_RXDMA_16BYTES)) {
    sub SIS_RXDMA_16BYTES () {	0x00300000;}
}
unless(defined(&SIS_RXDMA_32BYTES)) {
    sub SIS_RXDMA_32BYTES () {	0x00400000;}
}
unless(defined(&SIS_RXDMA_64BYTES)) {
    sub SIS_RXDMA_64BYTES () {	0x00500000;}
}
unless(defined(&SIS_RXDMA_128BYTES)) {
    sub SIS_RXDMA_128BYTES () {	0x00600000;}
}
unless(defined(&SIS_RXDMA_256BYTES)) {
    sub SIS_RXDMA_256BYTES () {	0x00700000;}
}
unless(defined(&SIS_RXCFG)) {
    sub SIS_RXCFG () {	( &SIS_RXCFG_DRAIN(64)| &SIS_RXDMA_256BYTES);}
}
unless(defined(&SIS_RXFILTCTL_ADDR)) {
    sub SIS_RXFILTCTL_ADDR () {	0x000f0000;}
}
unless(defined(&SIS_RXFILTCTL_ALLPHYS)) {
    sub SIS_RXFILTCTL_ALLPHYS () {	0x10000000;}
}
unless(defined(&SIS_RXFILTCTL_ALLMULTI)) {
    sub SIS_RXFILTCTL_ALLMULTI () {	0x20000000;}
}
unless(defined(&SIS_RXFILTCTL_BROAD)) {
    sub SIS_RXFILTCTL_BROAD () {	0x40000000;}
}
unless(defined(&SIS_RXFILTCTL_ENABLE)) {
    sub SIS_RXFILTCTL_ENABLE () {	0x80000000;}
}
unless(defined(&SIS_FILTADDR_PAR0)) {
    sub SIS_FILTADDR_PAR0 () {	0x00000000;}
}
unless(defined(&SIS_FILTADDR_PAR1)) {
    sub SIS_FILTADDR_PAR1 () {	0x00010000;}
}
unless(defined(&SIS_FILTADDR_PAR2)) {
    sub SIS_FILTADDR_PAR2 () {	0x00020000;}
}
unless(defined(&SIS_FILTADDR_MAR0)) {
    sub SIS_FILTADDR_MAR0 () {	0x00040000;}
}
unless(defined(&SIS_FILTADDR_MAR1)) {
    sub SIS_FILTADDR_MAR1 () {	0x00050000;}
}
unless(defined(&SIS_FILTADDR_MAR2)) {
    sub SIS_FILTADDR_MAR2 () {	0x00060000;}
}
unless(defined(&SIS_FILTADDR_MAR3)) {
    sub SIS_FILTADDR_MAR3 () {	0x00070000;}
}
unless(defined(&SIS_FILTADDR_MAR4)) {
    sub SIS_FILTADDR_MAR4 () {	0x00080000;}
}
unless(defined(&SIS_FILTADDR_MAR5)) {
    sub SIS_FILTADDR_MAR5 () {	0x00090000;}
}
unless(defined(&SIS_FILTADDR_MAR6)) {
    sub SIS_FILTADDR_MAR6 () {	0x000a0000;}
}
unless(defined(&SIS_FILTADDR_MAR7)) {
    sub SIS_FILTADDR_MAR7 () {	0x000b0000;}
}
unless(defined(&sis_rxstat)) {
    sub sis_rxstat () {	 &sis_cmdsts;}
}
unless(defined(&sis_txstat)) {
    sub sis_txstat () {	 &sis_cmdsts;}
}
unless(defined(&sis_ctl)) {
    sub sis_ctl () {	 &sis_cmdsts;}
}
unless(defined(&SIS_CMDSTS_BUFLEN)) {
    sub SIS_CMDSTS_BUFLEN () {	0x00000fff;}
}
unless(defined(&SIS_CMDSTS_PKT_OK)) {
    sub SIS_CMDSTS_PKT_OK () {	0x08000000;}
}
unless(defined(&SIS_CMDSTS_CRC)) {
    sub SIS_CMDSTS_CRC () {	0x10000000;}
}
unless(defined(&SIS_CMDSTS_INTR)) {
    sub SIS_CMDSTS_INTR () {	0x20000000;}
}
unless(defined(&SIS_CMDSTS_MORE)) {
    sub SIS_CMDSTS_MORE () {	0x40000000;}
}
unless(defined(&SIS_CMDSTS_OWN)) {
    sub SIS_CMDSTS_OWN () {	0x80000000;}
}
unless(defined(&SIS_LASTDESC)) {
    sub SIS_LASTDESC {
	local($x) = @_;
	eval q((!(($x)-> &sis_ctl &  &SIS_CMDSTS_MORE))));
    }
}
unless(defined(&SIS_OWNDESC)) {
    sub SIS_OWNDESC {
	local($x) = @_;
	eval q((($x)-> &sis_ctl &  &SIS_CMDSTS_OWN));
    }
}
unless(defined(&SIS_INC)) {
    sub SIS_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&SIS_RXBYTES)) {
    sub SIS_RXBYTES {
	local($x) = @_;
	eval q((($x)-> &sis_ctl &  &SIS_CMDSTS_BUFLEN));
    }
}
unless(defined(&SIS_RXSTAT_COLL)) {
    sub SIS_RXSTAT_COLL () {	0x00010000;}
}
unless(defined(&SIS_RXSTAT_LOOPBK)) {
    sub SIS_RXSTAT_LOOPBK () {	0x00020000;}
}
unless(defined(&SIS_RXSTAT_ALIGNERR)) {
    sub SIS_RXSTAT_ALIGNERR () {	0x00040000;}
}
unless(defined(&SIS_RXSTAT_CRCERR)) {
    sub SIS_RXSTAT_CRCERR () {	0x00080000;}
}
unless(defined(&SIS_RXSTAT_SYMBOLERR)) {
    sub SIS_RXSTAT_SYMBOLERR () {	0x00100000;}
}
unless(defined(&SIS_RXSTAT_RUNT)) {
    sub SIS_RXSTAT_RUNT () {	0x00200000;}
}
unless(defined(&SIS_RXSTAT_GIANT)) {
    sub SIS_RXSTAT_GIANT () {	0x00400000;}
}
unless(defined(&SIS_RXSTAT_DSTCLASS)) {
    sub SIS_RXSTAT_DSTCLASS () {	0x01800000;}
}
unless(defined(&SIS_RXSTAT_OVERRUN)) {
    sub SIS_RXSTAT_OVERRUN () {	0x02000000;}
}
unless(defined(&SIS_RXSTAT_RX_ABORT)) {
    sub SIS_RXSTAT_RX_ABORT () {	0x04000000;}
}
unless(defined(&SIS_DSTCLASS_REJECT)) {
    sub SIS_DSTCLASS_REJECT () {	0x00000000;}
}
unless(defined(&SIS_DSTCLASS_UNICAST)) {
    sub SIS_DSTCLASS_UNICAST () {	0x00800000;}
}
unless(defined(&SIS_DSTCLASS_MULTICAST)) {
    sub SIS_DSTCLASS_MULTICAST () {	0x01000000;}
}
unless(defined(&SIS_DSTCLASS_BROADCAST)) {
    sub SIS_DSTCLASS_BROADCAST () {	0x02000000;}
}
unless(defined(&SIS_TXSTAT_COLLCNT)) {
    sub SIS_TXSTAT_COLLCNT () {	0x000f0000;}
}
unless(defined(&SIS_TXSTAT_EXCESSCOLLS)) {
    sub SIS_TXSTAT_EXCESSCOLLS () {	0x00100000;}
}
unless(defined(&SIS_TXSTAT_OUTOFWINCOLL)) {
    sub SIS_TXSTAT_OUTOFWINCOLL () {	0x00200000;}
}
unless(defined(&SIS_TXSTAT_EXCESS_DEFER)) {
    sub SIS_TXSTAT_EXCESS_DEFER () {	0x00400000;}
}
unless(defined(&SIS_TXSTAT_DEFERED)) {
    sub SIS_TXSTAT_DEFERED () {	0x00800000;}
}
unless(defined(&SIS_TXSTAT_CARR_LOST)) {
    sub SIS_TXSTAT_CARR_LOST () {	0x01000000;}
}
unless(defined(&SIS_TXSTAT_UNDERRUN)) {
    sub SIS_TXSTAT_UNDERRUN () {	0x02000000;}
}
unless(defined(&SIS_TXSTAT_TX_ABORT)) {
    sub SIS_TXSTAT_TX_ABORT () {	0x04000000;}
}
unless(defined(&SIS_RX_LIST_CNT)) {
    sub SIS_RX_LIST_CNT () {	64;}
}
unless(defined(&SIS_TX_LIST_CNT)) {
    sub SIS_TX_LIST_CNT () {	128;}
}
unless(defined(&SIS_VENDORID)) {
    sub SIS_VENDORID () {	0x1039;}
}
unless(defined(&SIS_DEVICEID_900)) {
    sub SIS_DEVICEID_900 () {	0x0900;}
}
unless(defined(&SIS_DEVICEID_7016)) {
    sub SIS_DEVICEID_7016 () {	0x7016;}
}
unless(defined(&SIS_TYPE_900)) {
    sub SIS_TYPE_900 () {	1;}
}
unless(defined(&SIS_TYPE_7016)) {
    sub SIS_TYPE_7016 () {	2;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{sis_btag}),  ($sc->{sis_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{sis_btag}),  ($sc->{sis_bhandle}), $reg));
    }
}
unless(defined(&SIS_TIMEOUT)) {
    sub SIS_TIMEOUT () {	1000;}
}
unless(defined(&ETHER_ALIGN)) {
    sub ETHER_ALIGN () {	2;}
}
unless(defined(&SIS_RXLEN)) {
    sub SIS_RXLEN () {	1536;}
}
unless(defined(&SIS_MIN_FRAMELEN)) {
    sub SIS_MIN_FRAMELEN () {	60;}
}
unless(defined(&SIS_PCI_VENDOR_ID)) {
    sub SIS_PCI_VENDOR_ID () {	0x00;}
}
unless(defined(&SIS_PCI_DEVICE_ID)) {
    sub SIS_PCI_DEVICE_ID () {	0x02;}
}
unless(defined(&SIS_PCI_COMMAND)) {
    sub SIS_PCI_COMMAND () {	0x04;}
}
unless(defined(&SIS_PCI_STATUS)) {
    sub SIS_PCI_STATUS () {	0x06;}
}
unless(defined(&SIS_PCI_REVID)) {
    sub SIS_PCI_REVID () {	0x08;}
}
unless(defined(&SIS_PCI_CLASSCODE)) {
    sub SIS_PCI_CLASSCODE () {	0x09;}
}
unless(defined(&SIS_PCI_CACHELEN)) {
    sub SIS_PCI_CACHELEN () {	0x0c;}
}
unless(defined(&SIS_PCI_LATENCY_TIMER)) {
    sub SIS_PCI_LATENCY_TIMER () {	0x0d;}
}
unless(defined(&SIS_PCI_HEADER_TYPE)) {
    sub SIS_PCI_HEADER_TYPE () {	0x0e;}
}
unless(defined(&SIS_PCI_LOIO)) {
    sub SIS_PCI_LOIO () {	0x10;}
}
unless(defined(&SIS_PCI_LOMEM)) {
    sub SIS_PCI_LOMEM () {	0x14;}
}
unless(defined(&SIS_PCI_BIOSROM)) {
    sub SIS_PCI_BIOSROM () {	0x30;}
}
unless(defined(&SIS_PCI_INTLINE)) {
    sub SIS_PCI_INTLINE () {	0x3c;}
}
unless(defined(&SIS_PCI_INTPIN)) {
    sub SIS_PCI_INTPIN () {	0x3d;}
}
unless(defined(&SIS_PCI_MINGNT)) {
    sub SIS_PCI_MINGNT () {	0x3e;}
}
unless(defined(&SIS_PCI_MINLAT)) {
    sub SIS_PCI_MINLAT () {	0x0f;}
}
unless(defined(&SIS_PCI_RESETOPT)) {
    sub SIS_PCI_RESETOPT () {	0x48;}
}
unless(defined(&SIS_PCI_EEPROM_DATA)) {
    sub SIS_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&SIS_PCI_CAPID)) {
    sub SIS_PCI_CAPID () {	0x50;}
}
unless(defined(&SIS_PCI_NEXTPTR)) {
    sub SIS_PCI_NEXTPTR () {	0x51;}
}
unless(defined(&SIS_PCI_PWRMGMTCAP)) {
    sub SIS_PCI_PWRMGMTCAP () {	0x52;}
}
unless(defined(&SIS_PCI_PWRMGMTCTRL)) {
    sub SIS_PCI_PWRMGMTCTRL () {	0x54;}
}
unless(defined(&SIS_PSTATE_MASK)) {
    sub SIS_PSTATE_MASK () {	0x0003;}
}
unless(defined(&SIS_PSTATE_D0)) {
    sub SIS_PSTATE_D0 () {	0x0000;}
}
unless(defined(&SIS_PSTATE_D1)) {
    sub SIS_PSTATE_D1 () {	0x0001;}
}
unless(defined(&SIS_PSTATE_D2)) {
    sub SIS_PSTATE_D2 () {	0x0002;}
}
unless(defined(&SIS_PSTATE_D3)) {
    sub SIS_PSTATE_D3 () {	0x0003;}
}
unless(defined(&SIS_PME_EN)) {
    sub SIS_PME_EN () {	0x0010;}
}
unless(defined(&SIS_PME_STATUS)) {
    sub SIS_PME_STATUS () {	0x8000;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap($va));
    }' unless defined(&vtophys);
}
1;
