#!/usr/local/bin/perl

$PI = 3.141592653;

$CYGWIN = 0;
$BASE = "file:$0";
($CGI = $0) =~ s@.*/@@;

$IMG = '<img src="-" alt="*">';
$DIR = '<input type=submit name=dir value="%s">';
$FILE = '<a href="file:%s">%s</a>';

$query = $ENV{'QUERY_STRING'};
$cmd = '';
$cgi = 0;
if ($query eq '') {
  $_ = `pwd`;
  chop;
  s/\r$//;
  $dir = $_;
  $cgi = 0;
} elsif ($query =~ /^(cdir|dir)=/) {
  foreach(split(/\&/, $query)) {
    if (s/^dir=//) {
      $dir = &form_decode($_);
    } elsif (s/^cdir=//) {
      $cdir = &form_decode($_);
    }
  }
  $dir = "$cdir/$dir";
  $cgi = 1;
} else {
  $dir = $query;
  if (($dir !~ m@^/@) &&
      ($CYGWIN && $dir !~ /^[a-z]:/i)) {
    $_ = `pwd`;
    chop;
    s/\r$//;
    $dir = "$_/$dir";
  }
  $cgi = -1;
}
if ($dir !~ m@/$@) {
  $dir .= '/';
}
$ROOT = '';
if ($CYGWIN) {
  if (($dir =~ s@^//[^/]+@@) || ($dir =~ s@^[a-z]:@@i)) {
    $ROOT = $&;
  }
}
if ($cgi) {
  $dir = &cleanup($dir);
}

$qdir = &html_quote("$ROOT$dir");
$edir = &html_quote(&form_encode("$ROOT$dir"));
if (! opendir(DIR, "$ROOT$dir")) {
  print <<EOF;
Content-Type: text/html

<html>
<head>
<title>Directory list of $qdir</title>
</head>
<body>
<b>$qdir</b>: $! !
</body>
</html>
EOF
  exit 1;
}

($cgi > 0) && print <<EOF;
w3m-control: DELETE_PREVBUF
EOF
print <<EOF;
Content-Type: text/html

<html>
<head>
<base url="$BASE">
<title>Directory list of $qdir</title>
</head>
<body>
EOF

%isdir = ();
$size = 0;
while($_ = readdir(DIR)) {
	($_ eq '.') && next;
	$f = "$ROOT$dir/$_";
	@st = stat($f);
	if ($st[2] & 0040000) {
		$isdir{$_} = 2;
	} else {
		$isdir{$_} = 0;
	}
	$size += length($_) + $isdir{$_} + 3;
}
close(DIR);

@file = sort { length($b) <=> length($a) } keys %isdir;

$l = 4 * $size / $PI;
$Y = int(sqrt($l / 2) * 0.8 / 2) * 2;
$NY = $Y + 1;
$l = 4 * ($size + $NY) / $PI;
$X = int($l / $NY + 0.5);

@L = ();
@N = ();
@C = ();
@D = ();
foreach(0 .. $Y) {
	$n = int($X * sqrt(1 - ($_ + 0.5 - $NY / 2)**2 / ($NY / 2)**2) + 0.5);
	push(@L, $n || 1);
	push(@N, 0);
	push(@C, 0);
	push(@D, '');
}

print <<EOF;
<form action="$CGI">
<input type=hidden name=cdir value="$ROOT$qdir">
<pre>
EOF
foreach(@file) {
	$y = $Y / 2;
	$m = 2;
	foreach $i (0 .. $Y) {
		$c = ($N[$i] || 0.01) / $L[$i];
		if ($c < $m) {
			$y = $i;
			$m = $c;
		}
	}
	$q = &html_quote($_);
	if ($isdir{$_}) {
		$a = sprintf($DIR, "$q");
	} else {
		$a = sprintf($FILE, "$ROOT$qdir/$q", $q);
	}
	if ($C[$y] == 0) {
		$D[$y] = "\0$a\0";
		$N[$y] += 1;
	} elsif ($C[$y] % 2) {
		$D[$y] = "\0$a$D[$y]";
	} else {
		$D[$y] .= "$a\0";
	}
	$C[$y]++;
	$N[$y] += length($_) + $isdir{$_} + 3;
}
foreach $i (0 .. $Y) {
	$_ = $D[$i];
	@c = /\0/g;
	$c = $#c + 1;
	if ($c) {
		$n = int(($L[$i] - $N[$i]) / ($c - 1) + 0.5);
		if ($n <= 0) {
			$n = 0;
		}
		$n1 = $n - int($n / 2);
		$n2 = $n - $n1 + 1;
		$x = " " x $n2 . $IMG . " " x $n1;
		s/\0/$x/g;
		$N[$i] += ($c - 1) * $n;
		s/^ +//;
		s/ +$//;
		$n = $L[$i] - $N[$i];
		if ($n > 0) {
			$n1 = int($n / 2);
			$n2 = $n - $n1;
			$x1 = " " x $n1;
			$x2 = " " x $n2;
			s/^[^>]+>/$&$x1/;
			s/ <[^<]+$/$x2$&/;
			$N[$i] += $n;
		}
	}
	$n = int(($X - $N[$i]) / 2 + 4);
	if ($n > 0) {
		$_ = " " x $n . $_;
	}
	print "$_\n";
}
print <<EOF;
</pre>
</form>
</body>
</html>
EOF

sub html_quote {
  local($_) = @_;
  local(%QUOTE) = (
    '<', '&lt;',
    '>', '&gt;',
    '&', '&amp;',
    '"', '&quote;',
  );
  s/[<>&"]/$QUOTE{$&}/g;
  return $_;
}

sub form_encode {
  local($_) = @_;
  s/[\t\r\n%&=+]/sprintf('%%%2x', unpack('c', $&))/eg;
  s/ /+/g;
  return $_;
}

sub form_decode {
  local($_) = @_;
  s/\+/ /g;
  s/%([\da-f][\da-f])/pack('c', hex($1))/egi;
  return $_;
}

sub cleanup {
  local($_) = @_;

  s@//+@/@g;
  s@/\./@/@g;
  while(m@/\.\./@) {
    s@^/(\.\./)+@/@;
    s@/[^/]+/\.\./@/@;
  }
  return $_;
}
