#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Netscape Server ?PageServices bug";
 name["francais"] = "Netscape Server ?PageServices bug";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "Requesting an URL with '?PageServices' at its end
makes some Netscape servers dump the listing of the page 
directory, thus showing potentially sensitive files.

Risk factor : Medium/High.

Solution : Upgrade your Netscape server";

 desc["francais"] = "Demander une URL finissant par '?PageServices' 
force certains serveurs Netscape  afficher le contenu du rpertoire
de la page, montrant ainsi des fichiers potentiellement sensibles.

Facteur de risque : Moyen/Elev.

Solution : Mettez  jour votre serveur Netscape";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Make a request like http://foo.bar.edu/?PageServices";
 summary["francais"] = "Fait une requte du type http://foo.bar.edu/?PageServices";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port) port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = string("GET /?PageServices HTTP/1.0\r\n\r\n");
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:2048);
  data_low = tolower(data);
  seek = "<title>index of /</title>";
  if(seek >< data_low)
  {
   security_hole(port);
  }
  close(soc);
 }
}
