#
# This script was written by Alexis de Bernis <alexisb@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "RedHat 6.0 cachemgr.cgi";
 name["francais"] = "RedHat 6.0 cachemgr.cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The RedHat 6.0 installs by default a squid cache manager cgi script with no restricted access permissions. This script could be used to perform a portscan from the cgi-host machine.

Solution : 
If you are not using the box as a Squid www proxy/cache server then
uninstall the package by executing 
/etc/rc.d/init.d/squid stop ; rpm -e squid

If you are indeed using the Squid proxy server software, then make the
following actions to at least minimally secure access to the manager
interface:

mkdir /home/httpd/protected-cgi-bin
mv /home/httpd/cgi-bin/cachemgr.cgi /home/httpd/protected-cgi-bin/

and add the following directives to /etc/httpd/conf/access.conf and
srm.conf

--- start access.conf segment ---

# Protected cgi-bin directory for programs that
# should not have public access

<Directory /home/httpd/protected-cgi-bin>
order deny,allow
deny from all
allow from localhost
#allow from .your_domain.com
AllowOverride None
Options ExecCGI
</Directory>

--- end access.conf segment ---

--- start srm.conf segment ---
ScriptAlias /protected-cgi-bin/ /home/httpd/protected-cgi-bin/
--- end srm.conf segment ---


Risk Factor : Serious";


 desc["francais"] = "Le script cachemgr.cgi est accessible, celui-ci permets de scanner les ports d'une machine distante  partie de la machine hbergeant le script cgi.
 
Solution : 
Si vous n'utilisez pas Squid alors dsinstallez le package en tapant
/etc/rc.d/init.d/squid stop ; rpm -e squid

Si vous utilisez Squid comme proxy, pour au moins scuriser l'accs  ce script
tapez :
mkdir /home/httpd/protected-cgi-bin
mv /home/httpd/cgi-bin/cachemgr.cgi /home/httpd/protected-cgi-bin/

et ajoutez les directives suivantes  /etc/httpd/conf/access.conf et
srm.conf

--- start access.conf segment ---

# Protected cgi-bin directory for programs that
# should not have public access

<Directory /home/httpd/protected-cgi-bin>
order deny,allow
deny from all
allow from localhost
#allow from .your_domain.com
AllowOverride None
Options ExecCGI
</Directory>

--- end access.conf segment ---

--- start srm.conf segment ---
ScriptAlias /protected-cgi-bin/ /home/httpd/protected-cgi-bin/
--- end srm.conf segment ---


Facteur de risque : Srieux"; 
 
 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks wether the cachemgr.cgi is installed and accessible."; 
 summary["francais"] =  "Vrifie si le cgi cachemgr.cgi est install et accessible.";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 A. de Bernis",
		francais:"Ce script est Copyright (C) 1999 A. de Bernis");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

cgi = "cachemgr.cgi";
if(is_cgi_installed(cgi))
{
	port=get_kb_item("Services/www");
	if(!port) port = 80;
	security_hole(port);
}
