/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import symantec.tools.debug.Agent;
import symantec.tools.debug.AgentConstants;
import symantec.tools.debug.BreakpointQueue;
import symantec.tools.debug.BreakpointSet;
import symantec.tools.debug.InvalidPCException;
import symantec.tools.debug.LineNumber;
import symantec.tools.debug.SymDbgExprHandler;
import symantec.tools.debug.SymDbgNotify;

class BreakpointHandler
extends Thread
implements AgentConstants {
    static BreakpointQueue the_bkptQ;
    static Hashtable the_bkptHash;
    private Agent agent;
    private Hashtable catchHash;
    private Vector skipLines;
    static final boolean debug = true;
    static final int EXPR_COMPLETE = 1;
    static final int EXPR_AT_BPT = 2;
    static final int POP_COMPLETE = 4;
    boolean inSingleStep = false;
    boolean wasSingleStep = false;

    native int setBreakpoint(int var1) throws InvalidPCException;

    native void clrBreakpoint(int var1, int var2) throws InvalidPCException;

    native int getOpcodeAtPC(int var1) throws InvalidPCException;

    native int checkDynBptComplete(Throwable var1);

    public static int getBptOpCode(int n) {
        BreakpointSet breakpointSet = (BreakpointSet)the_bkptHash.get(new Integer(n));
        if (breakpointSet == null) {
            return -1;
        }
        return breakpointSet.opcode;
    }

    synchronized void addBreakpoint(Class clazz, int n, int n2, int n3, int n4) throws IOException {
        BreakpointSet breakpointSet;
        if (n2 == 2 || n2 == 4) {
            this.inSingleStep = true;
        }
        if ((breakpointSet = (BreakpointSet)the_bkptHash.get(new Integer(n))) == null) {
            int n5;
            Agent.message("Adding breakpoint for pc " + n + ", type " + n2);
            if (clazz == null) {
                Agent.message("Invalid classObj in addBreakpoint");
                return;
            }
            try {
                n5 = this.getOpcodeAtPC(n) & 0xFF;
            }
            catch (InvalidPCException invalidPCException) {
                throw new IOException("invalid PC");
            }
            breakpointSet = new BreakpointSet(n, n5, clazz, n2, n3, n4);
            the_bkptHash.put(new Integer(n), breakpointSet);
            try {
                n5 = this.setBreakpoint(n);
                return;
            }
            catch (InvalidPCException invalidPCException) {
                throw new IOException("invalid PC");
            }
        }
        Agent.message("Breakpoint merge: pc=" + n + ", new type=" + (breakpointSet.type | n2));
        breakpointSet.type |= n2;
        the_bkptHash.put(new Integer(n), breakpointSet);
    }

    synchronized void deleteBreakpoint(Class clazz, int n) throws IOException {
        BreakpointSet breakpointSet = (BreakpointSet)the_bkptHash.get(new Integer(n));
        if (breakpointSet == null) {
            return;
        }
        try {
            this.clrBreakpoint(n, breakpointSet.opcode);
        }
        catch (InvalidPCException invalidPCException) {
            throw new IOException("invalid PC");
        }
        the_bkptHash.remove(new Integer(n));
    }

    synchronized void deleteBreakpoints() {
        BreakpointSet[] breakpointSetArray = this.listBreakpoints();
        int n = 0;
        while (n < breakpointSetArray.length) {
            try {
                BreakpointSet breakpointSet = breakpointSetArray[n];
                int n2 = breakpointSet.pc;
                this.clrBreakpoint(n2, breakpointSet.opcode);
                the_bkptHash.remove(new Integer(n2));
            }
            catch (InvalidPCException invalidPCException) {
                Agent.error("Internal error: invalid PC" + this.agent.exceptionStackTrace(invalidPCException));
            }
            catch (NoSuchElementException noSuchElementException) {
                Agent.error("Internal error" + this.agent.exceptionStackTrace(noSuchElementException));
            }
            ++n;
        }
    }

    synchronized BreakpointSet[] listBreakpoints() {
        BreakpointSet[] breakpointSetArray = new BreakpointSet[the_bkptHash.size()];
        Enumeration enumeration = the_bkptHash.elements();
        int n = 0;
        while (n < breakpointSetArray.length) {
            try {
                breakpointSetArray[n] = (BreakpointSet)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                Agent.error("Internal error" + this.agent.exceptionStackTrace(noSuchElementException));
                return null;
            }
            ++n;
        }
        return breakpointSetArray;
    }

    synchronized int getCondBptCurCount(Class clazz, int n) throws InvalidPCException {
        BreakpointSet breakpointSet = (BreakpointSet)the_bkptHash.get(new Integer(n));
        if (breakpointSet == null) {
            throw new InvalidPCException();
        }
        return breakpointSet.count;
    }

    synchronized void catchExceptionClass(Class clazz) {
        if (this.catchHash.get(clazz) == null) {
            this.catchHash.put(clazz, clazz);
        }
    }

    synchronized void ignoreExceptionClass(Class clazz) {
        this.catchHash.remove(clazz);
    }

    Class[] getCatchList() {
        Class[] classArray = new Class[this.catchHash.size()];
        Enumeration enumeration = this.catchHash.elements();
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = (Class)enumeration.nextElement();
            ++n;
        }
        return classArray;
    }

    void addSkipLine(LineNumber lineNumber) {
        Agent.message("addSkipLine: thread=" + lineNumber.thread.getName() + ", startPC=" + lineNumber.startPC + ", endPC = " + lineNumber.endPC);
        this.skipLines.addElement(lineNumber);
    }

    void removeSkipLine(LineNumber lineNumber) {
        this.skipLines.removeElement(lineNumber);
    }

    boolean ignoreSingleStep(Thread thread, int n) {
        Agent.message("ignoreSingleStep(" + thread.getName() + ", " + n + ")");
        Enumeration enumeration = this.skipLines.elements();
        while (enumeration.hasMoreElements()) {
            LineNumber lineNumber = (LineNumber)enumeration.nextElement();
            Agent.message("   ln: thread=" + lineNumber.thread.getName() + ", startPC=" + lineNumber.startPC + ", endPC = " + lineNumber.endPC);
            if (lineNumber.thread != thread) continue;
            if (n >= lineNumber.startPC && n <= lineNumber.endPC) {
                return true;
            }
            this.removeSkipLine(lineNumber);
        }
        Agent.message("   no match.");
        return false;
    }

    BreakpointHandler(Agent agent) {
        super("Breakpoint handler");
        if (the_bkptQ == null) {
            the_bkptQ = new BreakpointQueue();
        }
        if (the_bkptHash == null) {
            the_bkptHash = new Hashtable();
        }
        this.catchHash = new Hashtable();
        this.skipLines = new Vector();
        this.agent = agent;
    }

    private boolean clearOneShotBpts(int n) {
        Enumeration enumeration = the_bkptHash.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            BreakpointSet breakpointSet = (BreakpointSet)enumeration.nextElement();
            if ((breakpointSet.type & 2) == 0 && (breakpointSet.type & 4) == 0) continue;
            Agent.message("clearing one-shot bpt at " + breakpointSet.pc);
            if (breakpointSet.pc == n) {
                bl = true;
            }
            if ((breakpointSet.type & 1) != 0) {
                breakpointSet.type = 1;
                Agent.message("restoring original bpt at " + breakpointSet.pc + ", type=" + breakpointSet.type);
                the_bkptHash.put(new Integer(breakpointSet.pc), breakpointSet);
                continue;
            }
            try {
                this.clrBreakpoint(breakpointSet.pc, breakpointSet.opcode);
            }
            catch (Exception exception) {}
            the_bkptHash.remove(new Integer(breakpointSet.pc));
        }
        return bl;
    }

    private void continueApp() {
        SecurityManager.enablePrivilege((String)"UniversalThreadAccess");
        this.agent.resumeLastSuspendedThreads();
        SymDbgNotify.notifyInterpDebug(3);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = false;
        var2_2 = false;
        try {
            this.wasSingleStep = false;
            SecurityManager.enablePrivilege((String)"UniversalThreadAccess");
            while (true) {
                if (!BreakpointHandler.the_bkptQ.nextEvent()) {
                    return;
                }
                if (var1_1) {
                    var1_1 = false;
                    Agent.message("Skipping bpt at " + BreakpointHandler.the_bkptQ.pc);
                    SymDbgNotify.notifyInterpDebug(3);
                    continue;
                }
                this.agent.suspendAllThreads();
                var4_6 = this.checkDynBptComplete(BreakpointHandler.the_bkptQ.exception);
                if ((var4_6 & 1) != 0) {
                    var1_1 = (var4_6 & 2) != 0;
                    Agent.message("Expr evaluation complete, pc=" + BreakpointHandler.the_bkptQ.pc);
                    if (var1_1) {
                        Agent.message("Evaluate at bpt, setting skip");
                    }
                    this.agent.suspendThread(BreakpointHandler.the_bkptQ.thread);
                    this.agent.resumeLastSuspendedThreads();
                    continue;
                }
                if ((var4_6 & 4) != 0) {
                    Agent.message("Pop complete, pc=" + BreakpointHandler.the_bkptQ.pc);
                    var2_2 = true;
                } else {
                    var2_2 = false;
                }
                if (this.agent.asyncOutputStream == null || Agent.systemThread(BreakpointHandler.the_bkptQ.thread)) {
                    this.wasSingleStep = false;
                    this.continueApp();
                    continue;
                }
                if (BreakpointHandler.the_bkptQ.exception != null) {
                    this.agent.setSingleStep(BreakpointHandler.the_bkptQ.thread, false);
                    if (BreakpointHandler.the_bkptQ.exception instanceof ThreadDeath) {
                        Agent.message("Received ThreadDeath event, pc=" + BreakpointHandler.the_bkptQ.pc);
                        var5_9 = this.agent.asyncOutputStream;
                        synchronized (var5_9) {
                            this.agent.asyncOutputStream.write(66);
                            this.agent.writeObject(BreakpointHandler.the_bkptQ.thread, this.agent.asyncOutputStream);
                            this.agent.asyncOutputStream.flush();
                        }
                        this.wasSingleStep = false;
                        this.continueApp();
                        continue;
                    }
                    Agent.message("Received exception " + BreakpointHandler.the_bkptQ.exception.toString() + ", pc=" + BreakpointHandler.the_bkptQ.pc);
                    var5_10 = BreakpointHandler.the_bkptQ.exception.getClass();
                    if (this.catchHash.containsKey(var5_10)) {
                        var6_15 = BreakpointHandler.the_bkptQ.exception.toString();
                        var7_16 = this.agent.asyncOutputStream;
                        synchronized (var7_16) {
                            this.agent.asyncOutputStream.write(52);
                            this.agent.writeObject(BreakpointHandler.the_bkptQ.thread, this.agent.asyncOutputStream);
                            this.agent.asyncOutputStream.writeUTF((String)var6_15);
                            this.agent.asyncOutputStream.flush();
                        }
                    }
                    this.wasSingleStep = false;
                    this.continueApp();
                    continue;
                }
                if (!var2_2 && BreakpointHandler.the_bkptQ.setbpt) {
                    var3_3 = (BreakpointSet)BreakpointHandler.the_bkptHash.get(new Integer(BreakpointHandler.the_bkptQ.pc));
                    this.addBreakpoint(null, BreakpointHandler.the_bkptQ.pc, var3_3 != null ? var3_3.type : 1, 0, 0);
                    BreakpointHandler.the_bkptQ.setbpt = false;
                    this.continueApp();
                    continue;
                }
                var3_3 = (BreakpointSet)BreakpointHandler.the_bkptHash.get(new Integer(BreakpointHandler.the_bkptQ.pc));
                if (var3_3 == null) {
                    this.wasSingleStep = true;
                    Agent.message("Single step event: pc=" + BreakpointHandler.the_bkptQ.pc);
                    if (this.ignoreSingleStep(BreakpointHandler.the_bkptQ.thread, BreakpointHandler.the_bkptQ.pc)) {
                        this.continueApp();
                        continue;
                    }
                    if (BreakpointHandler.the_bkptQ.thread.countStackFrames() == 0) {
                        this.continueApp();
                        continue;
                    }
                    this.agent.inInterpStep = false;
                    this.agent.setSingleStep(BreakpointHandler.the_bkptQ.thread, false);
                } else {
                    if (var3_3.thread != null && var3_3.thread != BreakpointHandler.the_bkptQ.thread) {
                        this.continueApp();
                        continue;
                    }
                    Agent.message("Received a breakpoint event: pc=" + BreakpointHandler.the_bkptQ.pc);
                    BreakpointHandler.the_bkptQ.opcode = var3_3.opcode;
                    var5_11 = false;
                    if ((var3_3.type & 8) != 0) {
                        if (var3_3.expr_pc != 0) {
                            var6_15 = SymDbgExprHandler.evaluate(BreakpointHandler.the_bkptQ.thread, var3_3.expr_pc, true);
                            if (var6_15 == null) {
                                var1_1 = true;
                                if (!this.agent.getExprResultBoolean(BreakpointHandler.the_bkptQ.thread) && !this.inSingleStep) {
                                    this.continueApp();
                                    continue;
                                }
                                if (var3_3.limit != 0 && var3_3.count < var3_3.limit) {
                                    ++var3_3.count;
                                    if (!this.inSingleStep) {
                                        this.continueApp();
                                        continue;
                                    }
                                    var5_11 = true;
                                }
                            }
                            this.agent.suspendThread(BreakpointHandler.the_bkptQ.thread);
                        }
                        if (!var5_11 && var3_3.limit != 0 && var3_3.count < var3_3.limit) {
                            ++var3_3.count;
                            if (!this.inSingleStep) {
                                this.continueApp();
                                continue;
                            }
                        }
                    }
                }
                this.inSingleStep = false;
                v2 = var5_12 = var3_3 != null && (var3_3.type & 4) != 0;
                if (this.clearOneShotBpts(BreakpointHandler.the_bkptQ.pc)) {
                    this.wasSingleStep = true;
                }
                if (var5_12) {
                    this.agent.setSingleStep(BreakpointHandler.the_bkptQ.thread, true);
                    this.continueApp();
                    continue;
                }
                this.ignoreSingleStep(BreakpointHandler.the_bkptQ.thread, BreakpointHandler.the_bkptQ.pc);
                if (this.agent.inInterpStep) {
                    this.agent.inInterpStep = false;
                    this.agent.setSingleStep(BreakpointHandler.the_bkptQ.thread, false);
                    this.continueApp();
                    continue;
                }
                var6_15 = this.agent.asyncOutputStream;
                synchronized (var6_15) {
                    this.agent.asyncOutputStream.write(this.wasSingleStep != false ? 83 : 46);
                    this.agent.writeObject(BreakpointHandler.the_bkptQ.thread, this.agent.asyncOutputStream);
                    this.agent.asyncOutputStream.flush();
                }
                this.wasSingleStep = false;
            }
        }
        catch (ThreadDeath var3_4) {
            Agent.message("BreakpointHandler: ThreadDeath received.");
            var4_7 = BreakpointHandler.the_bkptHash.elements();
            ** while (var4_7.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            var5_13 = (BreakpointSet)var4_7.nextElement();
            try {
                this.clrBreakpoint(var5_13.pc, var5_13.opcode);
            }
            catch (Exception v4) {}
            BreakpointHandler.the_bkptHash.remove(new Integer(var5_13.pc));
            continue;
        }
lbl149:
        // 1 sources

        this.continueApp();
        throw var3_4;
        catch (Exception var3_5) {
            Agent.error(this.agent.exceptionStackTrace(var3_5));
            var4_8 = BreakpointHandler.the_bkptHash.elements();
            ** while (var4_8.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            var5_14 = (BreakpointSet)var4_8.nextElement();
            try {
                this.clrBreakpoint(var5_14.pc, var5_14.opcode);
            }
            catch (Exception v5) {}
            BreakpointHandler.the_bkptHash.remove(new Integer(var5_14.pc));
            continue;
        }
lbl163:
        // 1 sources

        this.continueApp();
    }
}

