%define mysql_version		3.22.22
%define shared_lib_version	6:0:0
%define release			1
%define mysqld_user		mysql

%define see_base For a description of MySQL see the base MySQL RPM or http://www.mysql.com

Name: MySQL
Summary:	MySQL: a very fast and reliable SQL database engine
Group:		Applications/Databases
Summary(pt_BR): MySQL: Um servidor SQL rpido e confivel.
Group(pt_BR):	Aplicaes/Banco_de_Dados
Version: %{mysql_version}
Release: %{release}
Copyright: MySQL FREE PUBLIC LICENSE (See the file PUBLIC)
Source: http://www.mysql.com/Downloads/MySQL-3.22/mysql-%{mysql_version}.tar.gz
Icon: mysql.gif
URL: http://www.mysql.com/
Packager: David Axmark <david@mysql.com>
Provides: msqlormysql MySQL-server
Obsoletes: mysql

# Think about what you use here since the first step is to
# run a rm -rf
BuildRoot:	/var/tmp/mysql

# From the manual
%description
MySQL is a true multi-user, multi-threaded SQL (Structured Query
Language) database server. SQL is the most popular database language
in the world. MySQL is a client/server implementation that consists of
a server daemon mysqld and many different client programs/libraries.

The main goals of MySQL are speed, robustness and easy to use.  MySQL
was originally developed because we at Tcx needed a SQL server that
could handle very big databases with magnitude higher speed than what
any database vendor could offer to us. We have now been using MySQL
since 1996 in a environment with more than 40 databases, 10,000
tables, of which more than 500 have more than 7 million rows. This is
about 50G of mission critical data.

The base upon which MySQL is built is a set of routines that have been
used in a highly demanding production environment for many
years. While MySQL is still in development, it already offers a rich
and highly useful function set.

See the documentation for more information"


%description -l pt_BR
O MySQL  um servidor de banco de dados SQL realmente multiusurio e\
multi-tarefa. A linguagem SQL  a mais popular linguagem para banco de\
dados no mundo. O MySQL  uma implementao cliente/servidor que\
consiste de um servidor chamado mysqld e diversos\
programas/bibliotecas clientes. Os principais objetivos do MySQL so:\
velocidade, robustez e facilidade de uso.  O MySQL foi originalmente\
desenvolvido porque ns na Tcx precisvamos de um servidor SQL que\
pudesse lidar com grandes bases de dados e com uma velocidade muito\
maior do que a que qualquer vendedor podia nos oferecer. Estamos\
usando\
o MySQL desde 1996 em um ambiente com mais de 40 bases de dados com 10.000\
tabelas, das quais mais de 500 tm mais de 7 milhes de linhas. Isto  o\
equivalente a aproximadamente 50G de dados crticos. A base da construo do\
MySQL  uma srie de rotinas que foram usadas em um ambiente de produo com\
alta demanda por muitos anos. Mesmo o MySQL estando ainda em desenvolvimento,\
ele j oferece um conjunto de funes muito ricas e teis. Veja a documentao\
para maiores informaes.

%package client
Release: %{release}
Summary: MySQL - Client
Group: Applications/Databases
Summary(pt_BR): MySQL - Cliente
Group(pt_BR): Aplicaes/Banco_de_Dados
Obsoletes: mysql-client

%description client
This package contains the standard MySQL clients. 

%{see_base}

%description client -l pt_BR
Este pacote contm os clientes padro para o MySQL.

%package bench
Release: %{release}
Requires: MySQL-client MySQL-DBI-perl-bin perl
Summary: MySQL - Benchmarks
Group: Applications/Databases
Summary(pt_BR): MySQL - Medies de desempenho
Group(pt_BR): Aplicaes/Banco_de_Dados
Obsoletes: mysql-bench

%description bench
This package contains MySQL benchmark scripts and data.

%{see_base}

%description bench -l pt_BR
Este pacote contm medies de desempenho de scripts e dados do MySQL.

%package devel
Release: %{release}
Requires: MySQL MySQL-client
Summary: MySQL - Development header files and libraries
Group: Applications/Databases
Summary(pt_BR): MySQL - Medies de desempenho
Group(pt_BR): Aplicaes/Banco_de_Dados
Obsoletes: mysql-devel

%description devel
This package contains the development header files and libraries
necessary to develop MySQL client applications.

%{see_base}

%description devel -l pt_BR
Este pacote contm os arquivos de cabealho (header files) e bibliotecas 
necessrias para desenvolver aplicaes clientes do MySQL. 

%prep
%setup -n mysql-%{mysql_version}

%build
# CFLAGS="-g -DEXTRA_DBUG" \
# CXXFLAGS="-g -DEXTRA_DBUG" \
# --with-debug \
# --without-perl \

# The all-static flag is to make the RPM work on different
# distributions.  To compile a version with shared libraries remove
# the following lines below. You also need to uncomment some lines
# further down.
# 
# --disable-shared
# --with-mysqld-ldflags="-all-static"
# --with-client-ldflags="-all-static"

sh -c  'PATH=${MYSQL_BUILD_PATH:-"/bin:/usr/bin"} \
	CC=${MYSQL_BUILD_CC:-egcs} \
	CFLAGS=${MYSQL_BUILD_CFLAGS:-"-O6 -fomit-frame-pointer"} \
	CXX=${MYSQL_BUILD_CXX:-egcs} \
	CXXFLAGS=${MYSQL_BUILD_CXXFLAGS:-"-O6 -fomit-frame-pointer \
	          -felide-constructors -fno-exceptions -fno-rtti"} \
	./configure \
            --enable-shared \
	    --enable-assembler \
	    --disable-shared \
	    --with-mysqld-ldflags="-all-static" \
	    --with-client-ldflags="-all-static" \
            --with-mysqld-user=%{mysqld_user} \
            --with-unix-socket-path=/var/lib/mysql/mysql.sock \
            --prefix=/ \
            --exec-prefix=/usr \
            --libexecdir=/usr/sbin \
            --sysconfdir=/etc \
            --datadir=/usr/share \
            --localstatedir=/var/lib/mysql \
            --infodir=/usr/info \
            --includedir=/usr/include \
            --mandir=/usr/man' \
	    --with-comment='Official MySQL RPM'
# benchdir does not fit in above model. Fix when we make a separate package
make benchdir=$RPM_BUILD_ROOT/usr/share/sql-bench

%install -n mysql-%{mysql_version}
RBR=$RPM_BUILD_ROOT
MBD=$RPM_BUILD_DIR/mysql-%{mysql_version}
if test -z "$RBR" -o "$RBR" = "/"
then
	echo "RPM_BUILD_ROOT has stupid value"
	exit 1
fi
rm -rf $RBR
# Ensure that needed directories exists
install -d $RBR/etc/{logrotate.d,rc.d/init.d}
install -d $RBR/var/lib/mysql/mysql
install -d $RBR/usr/share/sql-bench
install -d $RBR/usr/{sbin,share,man,include}
install -d $RBR/usr/doc/MySQL-%{mysql_version}
install -d $RBR/usr/lib
# Make install
make install DESTDIR=$RBR benchdir=/usr/share/sql-bench

# Move shared libraries (Disabled by default)
# mv $RBR/usr/lib/mysql/*.so* $RBR/usr/lib

# Install logrotate and autostart
install -m644 $MBD/support-files/mysql-log-rotate $RBR/etc/logrotate.d/mysql
install -m755 $MBD/support-files/mysql.server $RBR/etc/rc.d/init.d/mysql

# Install docs
install -m644 $RPM_BUILD_DIR/mysql-%{mysql_version}/Docs/mysql.info \
 $RBR/usr/info/mysql.info
for file in README PUBLIC Docs/manual_toc.html Docs/manual.html \
    Docs/manual.txt Docs/manual.texi Docs/manual.ps
do
    b=`basename $file`
    install -m644 $MBD/$file $RBR/usr/doc/MySQL-%{mysql_version}/$b
done

%pre
if test -x /etc/rc.d/init.d/mysql
then
  /etc/rc.d/init.d/mysql stop > /dev/null 2>&1
  echo "Giving mysqld a couple of seconds to exit nicely"
  sleep 5
fi

%post
mysql_datadir=/var/lib/mysql

# Create data directory if needed
if test ! -d $mysql_datadir;		then mkdir $mysql_datadir; fi
if test ! -d $mysql_datadir/mysql;	then mkdir $mysql_datadir/mysql; fi
if test ! -d $mysql_datadir/test;	then mkdir $mysql_datadir/test; fi

# Make MySQL start/shutdown automatically when the machine does it.
/sbin/chkconfig --add mysql

# Create a MySQL user. Do not report any problems if it already
# exists.
useradd -M -r -d $mysql_datadir -s /bin/bash -c "MySQL server" mysql 2> /dev/null || true 

# Change permissions so that the user that will run the MySQL daemon
# owns all database files.
chown -R mysql $mysql_datadir

# Initiate databases
mysql_install_db -IN-RPM

# Change permissions again to fix any new files.
chown -R mysql $mysql_datadir

# Restart in the same way that mysqld will be started normally.
/etc/rc.d/init.d/mysql start

# Allow safe_mysqld to start mysqld and print a message before we exit
sleep 2

%preun
if test -x /etc/rc.d/init.d/mysql
then
  /etc/rc.d/init.d/mysql stop > /dev/null
fi
# Remove autostart of mysql
if test $1 = 0
then
   /sbin/chkconfig --del mysql
fi
# We do not remove the mysql user since it may still own a lot of
# database files.

%files
%attr(-, root, root) %doc /usr/doc/MySQL-%{mysql_version}/

%attr(755, root, root) /usr/bin/isamchk
%attr(755, root, root) /usr/bin/isamlog
%attr(755, root, root) /usr/bin/mysql_fix_privilege_tables
%attr(755, root, root) /usr/bin/mysql_install_db
%attr(755, root, root) /usr/bin/mysql_setpermission
%attr(755, root, root) /usr/bin/mysql_zap
%attr(755, root, root) /usr/bin/mysqlbug
%attr(755, root, root) /usr/bin/perror
%attr(755, root, root) /usr/bin/replace
%attr(755, root, root) /usr/bin/resolveip
%attr(755, root, root) /usr/bin/safe_mysqld

%attr(644, root, root) /usr/info/mysql.info

%attr(755, root, root) /usr/sbin/mysqld

%attr(644, root, root) /etc/logrotate.d/mysql
%attr(755, root, root) /etc/rc.d/init.d/mysql

%attr(755, root, root) /usr/share/mysql/

%files client
%attr(755, root, root) /usr/bin/msql2mysql
%attr(755, root, root) /usr/bin/mysql
%attr(755, root, root) /usr/bin/mysqlaccess
%attr(755, root, root) /usr/bin/mysqladmin
%attr(755, root, root) /usr/bin/mysqlbug
%attr(755, root, root) /usr/bin/mysqldump
%attr(755, root, root) /usr/bin/mysqlimport
%attr(755, root, root) /usr/bin/mysqlshow

# Shared libraries (Disabled by default)
# %attr(755, root, root) /usr/lib/*.so*

%attr(644, root, man) %doc /usr/man/man1/mysql.1

%post client
/sbin/ldconfig

%postun client
/sbin/ldconfig

%files devel
%attr(755, root, root) /usr/bin/comp_err
%attr(755, root, root) /usr/include/mysql/
%attr(755, root, root) /usr/lib/mysql/

%files bench
%attr(-, root, root) /usr/share/sql-bench

%changelog

* Mon Feb 22 1999 David Axmark <david@detron.se>

- Removed unportable cc switches from the spec file. The defaults can
  now be overridden with environment variables. This feature is used
  to compile the official RPM with optimal (but compiler version
  specific) switches.

- Removed the repetitive description parts for the sub rpms. Maybe add
  again if RPM gets a multiline macro capability.

- Added support for a pt_BR translation. Translation contributed by
  Jorge Godoy <jorge@bestway.com.br>.

* Wed Nov 4 1998 David Axmark <david@detron.se>

- A lot of changes in all the rpm and install scripts. This may even
  be a working RPM :-)

* Sun Aug 16 1998 David Axmark <david@detron.se>

- A developers changelog for MySQL is available in the source RPM. And
  there is a history of major user visible changed in the Reference
  Manual.  Only RPM specific changes will be documented here.
