/* $Id: internal.h,v 1.20 1998/12/24 00:56:23 marcus Exp $
******************************************************************************

   LibGGI internal functions and macros

   ??? Add yourself in ???
   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_INTERNAL_H
#define _GGI_INTERNAL_H

#define _BUILDING_LIBGGI

#include <ggi/types.h>
#include <ggi/internal/gii.h>
#include <ggi/internal/plat.h>
#include <ggi/internal/debug.h>
#include <ggi/internal/structs.h>

/*
******************************************************************************
 Library internal functions and variables
******************************************************************************
*/

/* conf.c */
extern void *_ggiConfigHandle;

/* db.c */
ggi_directbuffer *_ggi_db_get_new(void);
void _ggi_db_free(ggi_directbuffer *db);
int _ggi_db_add_buffer(ggi_db_list *dbl, ggi_directbuffer *buf);
int _ggi_db_del_buffer(ggi_db_list *dbl, int idx);
int _ggi_db_move_buffer(ggi_db_list *dst, ggi_db_list *src, int idx);
ggi_directbuffer *_ggi_db_find_frame(ggi_visual *vis, int frameno);

/* dl.c */
ggi_dlhandle *_ggiOpenDL(ggi_visual *vis, const char *driver, 
			 const char *args,void *argptr);
void _ggiCloseDL(ggi_visual *vis,ggi_uint types);
ggi_dlhandle *_ggiAddDL(ggi_visual *, const char *drv, const char *args,
			void *argptr,int type);
void _ggiRemoveDL(ggi_visual *,ggi_dlhandle_l **lib);

/* internal.c */
void _ggi_build_pixfmt(ggi_pixelformat *pixfmt);
int _ggi_match_palette(ggi_color *pal, int pal_len, ggi_color *col);
ggifunc_setreadframe _ggi_default_setreadframe;
ggifunc_setwriteframe _ggi_default_setwriteframe;

/* mode.c */
void _ggiSetDefaultMode(const char *str);

/* stubs.c */
int _ggiInternFlush(ggi_visual *vis, int tryflag);
int _ggiPutPixelNC(ggi_visual *vis,int x,int y,ggi_pixel p);
int _ggiDrawPixelNC(ggi_visual *vis,int x,int y);
int _ggiDrawHLineNC(ggi_visual *vis,int x,int y,int w);
int _ggiDrawVLineNC(ggi_visual *vis,int x,int y,int h);
int _ggiSendKGICommand(ggi_visual *vis,int cmd,void *arg);

/* visual.c */
void *_ggi_malloc(size_t siz);
void *_ggi_calloc(size_t siz);
void *_ggi_realloc(void *ptr, size_t siz);
void _ggi_mem_error(void);
int _ggi_alloc_drvpriv(void);
void _ggi_free_drvpriv(int id);
void _ggiZapMode(ggi_visual *vis,ggi_uint types);

ggi_visual *_ggiNewVisual(void);
void _ggiDestroyVisual(ggi_visual *vis);


/*
******************************************************************************
 Macros to access members of LibGGI structures.
 Please use these instead of directly reference the members.
******************************************************************************
*/

#define LIBGGI_EXT(vis,extid)	(vis->extlist[(extid)].private)

#define LIBGGI_FLAGS(vis)	(vis->flags)
#define LIBGGI_FD(vis)		(vis->fd)

#define LIBGGI_MODE(vis)	(vis->mode)
#define LIBGGI_PIXFMT(vis)	(vis->pixfmt)
#define LIBGGI_GC(vis)		(vis->gc)
#define LIBGGI_GC_FGCOLOR(vis)	(vis->gc->fg_color)
#define LIBGGI_GC_BGCOLOR(vis)	(vis->gc->bg_color)

#define LIBGGI_APPLIST(vis)	(vis->app_dbs)
#define LIBGGI_PRIVLIST(vis)	(vis->priv_dbs)
#define LIBGGI_APPBUFS(vis)	(LIBGGI_APPLIST(vis)->bufs)
#define LIBGGI_PRIVBUFS(vis)	(LIBGGI_PRIVLIST(vis)->bufs)
#define LIBGGI_CURREAD(vis)	(vis->r_frame->read)
#define LIBGGI_CURWRITE(vis)	(vis->w_frame->write)

#define LIBGGI_DLHANDLE(vis)	(vis->dlhandle)
#define LIBGGI_PRIVATE(vis)	(vis->targetpriv)
#define LIBGGI_DRVPRIV(vis,idx)	(vis->drvpriv[(idx)])

#define LIBGGI_X(vis)		(vis->mode->visible.x)
#define LIBGGI_Y(vis)		(vis->mode->visible.y)
#define LIBGGI_VIRTX(vis)	(vis->mode->virt.x)
#define LIBGGI_VIRTY(vis)	(vis->mode->virt.y)
#define LIBGGI_GT(vis)		(vis->mode->graphtype)

#define LIBGGI_FB_SIZE(mode)	(((GT_SIZE(mode->graphtype)*mode->virt.x*mode->virt.y)+7)/8)
#define LIBGGI_FB_R_STRIDE(vis)	(vis->r_frame->buffer.plb.stride)
#define LIBGGI_FB_W_STRIDE(vis)	(vis->w_frame->buffer.plb.stride)

#define LIBGGI_R_PLAN(vis)	(vis->r_frame->buffer.plan)
#define LIBGGI_W_PLAN(vis)	(vis->w_frame->buffer.plan)


#endif /* _GGI_INTERNAL_H */
