/* $Id: debug.h,v 1.5 1998/11/19 01:37:40 marcus Exp $
******************************************************************************

   LibGGI debugging macros

   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_INTERNAL_DEBUG_H
#define _GGI_INTERNAL_DEBUG_H

#include <stdio.h>
#include <stdarg.h>
#include <ggi/types.h>
#include <ggi/gg.h>

extern uint32 _ggiDebugState;
extern int _ggiDebugSync;

/* Debugging types
 * bit 0 is reserved! */

#define GGIDEBUG_CORE		(1<<1)	/*   2 */
#define GGIDEBUG_MODE		(1<<2)	/*   4 */
#define GGIDEBUG_COLOR		(1<<3)	/*   8 */
#define GGIDEBUG_DRAW		(1<<4)	/*  16 */
#define GGIDEBUG_MISC		(1<<5)	/*  32 */
#define GGIDEBUG_LIBS		(1<<6)	/*  64 */
#define GGIDEBUG_EVENTS		(1<<7)	/* 128 */

#define GGIDEBUG_ALL	0xffffffff

#ifndef __GNUC__
#define DPRINT_MODE	DPRINT
#define DPRINT_COLOR	DPRINT
#define DPRINT_DRAW	DPRINT

#else /* !__GNUC__ */

#ifdef DEBUG
#define DPRINT_MODE(form,args...)   if (_ggiDebugState & GGIDEBUG_MODE) { ggDPrintf(_ggiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_COLOR(form,args...)  if (_ggiDebugState & GGIDEBUG_COLOR) { ggDPrintf(_ggiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_DRAW(form,args...)   if (_ggiDebugState & GGIDEBUG_DRAW) { ggDPrintf(_ggiDebugSync,__FILE__,__LINE__,form, ##args); }
#else /* DEBUG */
#define DPRINT(form,args...)		do { } while (0)
#define DPRINT_MODE(form,args...)	do { } while (0)
#define DPRINT_COLOR(form,args...)	do { } while (0)
#define DPRINT_DRAW(form,args...)	do { } while (0)
#endif /* DEBUG */
#endif /* !__GNUC__ */

#ifdef DEBUG
#define LIBGGI_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGGI:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define LIBGGI_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGGI:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else 
#define LIBGGI_ASSERT(x,str)	do { } while (0)
#define LIBGGI_APPASSERT(x,str)	do { } while (0)
#endif /* DEBUG */

#endif /* _GGI_INTERNAL_DEBUG_H */
