/* $Id: xf86dga.h,v 1.1 1998/12/18 21:36:24 marcus Exp $
******************************************************************************

   XFree86 Direct Graphics Access target for LibGGI

   Copyright (C) 1998 Steve Cheng   [steve@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   ---------------------------------------------------------------------
   README:

   Programs need SUID root. You really should use KGI :-)

   This target makes a number of assumptions about the XFree86
   implementation of X Window System. So if DGA actually gets outside of
   XFree86 this target might not work. Blame it on XF86DGA's stupid design.

   When using the XF86DGA target, LibGGI programs will always segfault at
   the end. This happens because XF86DGA puts an atexit function to do some
   'cleanup' when the program exits.  However, the XF86DGA static library
   would be unloaded along with the target by ggiClose(), and calling the
   then-non-existent atexit function causes the segfault. A 'solution' used
   here is to _exit() when SIGSEGV is received.

   Likewise, XF86DGA will install a couple of new signal handlers; these are
   removed automatically on unloading of this target.

   See source for miscellaneous stuff.

******************************************************************************
*/

#ifndef _GGI_DISPLAY_XF86DGA_H
#define _GGI_DISPLAY_XF86DGA_H

#include <ggi/internal/ggi-dl.h>
#include <ggi/input/xwin.h>
#include <ggi/display/modelist.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>

/* Never prevent apps from segfaulting on exit */
/*
#define ALWAYS_SEGFAULT_ON_EXIT
*/

/* Macros to gain and give up root privs, for mmapping /dev/mem. Note that
   they use the non-POSIX (but BSD 4.3 conformant) call seteuid() because
   regular setuid() does not allow regaining root privs when they have
   already been given up. */

#define GET_ROOT		seteuid(0)
#define GIVE_UP_ROOT		seteuid(getuid())
#define PERM_GIVE_UP_ROOT	setuid(getuid())

/* LIBGGI_PRIVATE info */

struct Xhooks { 
	Display *display;
	int screen;
	XF86VidModeModeInfo **dgamodes;
	ggi_modelistmode *modes;
	int num_modes;
	unsigned width;
	unsigned height;
	unsigned depth;
	unsigned size;
	Colormap cmap;
	Colormap cmap2; /* We need two colormaps to work around a bug
			   in XFree86 DGA... */
	int     activecmap;
        int     nocols;	    /* Number of colors in the colormap */
	int     pixperframe;
	void   *fb;
	int     stride;
	int     bank_size;
	int     mem_size;

	gii_input *inp;
        
	void *XLibLock;
};

/* prototypes
 */
ggifunc_getmode		GGI_xf86dga_getmode;
ggifunc_setmode		GGI_xf86dga_setmode;
ggifunc_checkmode	GGI_xf86dga_checkmode;
ggifunc_getapi		GGI_xf86dga_getapi;
ggifunc_setflags	GGI_xf86dga_setflags;

ggifunc_setpalvec	GGI_xf86dga_setpalvec;

ggifunc_setreadframe	GGI_xf86dga_setreadframe;
ggifunc_setwriteframe	GGI_xf86dga_setwriteframe;

void _GGI_xf86dga_freedbs(ggi_visual *);

#define XLIB_PRIV(vis) ((struct Xhooks *)LIBGGI_PRIVATE(vis))

#endif /* _GGI_DISPLAY_XF86DGA_H */
