/*
 * Decompiled with CFR 0.152.
 */
package pizza.v39;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import pizza.lang.ListBuffer;
import pizza.pizzadoc.Doc;
import pizza.pizzadoc.DocCollector;
import pizza.pizzadoc.DocSwitches;
import pizza.support.ObjectArray;
import pizza.support.array;
import pizza.v39.AST;
import pizza.v39.ASTgen;
import pizza.v39.Attr;
import pizza.v39.Basic;
import pizza.v39.ByteCodeGen;
import pizza.v39.ClassReader;
import pizza.v39.ClassWriter;
import pizza.v39.Constants;
import pizza.v39.Continuations;
import pizza.v39.Enter;
import pizza.v39.Gen;
import pizza.v39.Mangle;
import pizza.v39.Name;
import pizza.v39.Parser;
import pizza.v39.Pretty;
import pizza.v39.Report;
import pizza.v39.ResolveError;
import pizza.v39.Scanner;
import pizza.v39.Switches;
import pizza.v39.Symbol;
import pizza.v39.Symtab;
import pizza.v39.TransClosures;
import pizza.v39.TransInner;
import pizza.v39.TransPatterns;
import pizza.v39.TransTypes;
import pizza.v39.Type;

public class Main
implements Constants {
    static int nerrors;
    static boolean justJava;

    public static int errorCount() {
        return nerrors;
    }

    static void help() {
        if (Switches.pizzadoc) {
            DocSwitches.help();
            return;
        }
        System.out.println("Usage: pc [ options ] file[s]\n");
        System.out.println("where options include:");
        System.out.println("  -classpath pathname     use given classpath");
        System.out.println("  -d filename             redirect classfile output");
        System.out.println("  -experimental           enable experimental features");
        System.out.println("  -g                      include debug information");
        System.out.println("  -java                   accept only standard Java input");
        System.out.println("  -nowarn                 suppress warning messages");
        System.out.println("  -pizza                  accept standard Pizza input");
        System.out.println("  -printsearch            print information where classfiles are searched");
        System.out.println("  -prompt                 stop after each error");
        System.out.println("  -s                      emit java sources instead of classfiles");
        System.out.println("  -scramble               scramble private identifiers in bytecode");
        System.out.println("  -scrambleall            scramble package visible identifiers in bytecode");
        System.out.println("  -switchcheck            warn about fall-through in switches");
        System.out.println("  -verbose                print detailed log");
        System.out.println("  -version                version information");
        System.out.println("  -pizzadoc               run pizzadoc");
        System.out.println();
    }

    public static boolean argument(String string) {
        if (string.equals("-diagnostics")) {
            Switches.diagnostics = true;
        } else if (string.equals("-experimental")) {
            Switches.experimental = true;
        } else if (string.equals("-g")) {
            Switches.debugInfo = true;
        } else if (string.equals("-java")) {
            justJava = true;
        } else if (string.equals("-moreinfo")) {
            Switches.moreInfo = true;
        } else if (string.equals("-O")) {
            Switches.optimize = true;
        } else if (string.equals("-nowarn")) {
            Switches.nowarn = true;
        } else if (string.equals("-pizza")) {
            Switches.pizza = true;
        } else if (string.equals("-printsearch")) {
            Switches.printSearch = true;
        } else if (string.equals("-printtree")) {
            Switches.printTree = true;
        } else if (string.equals("-prompt")) {
            Switches.promptOnError = true;
        } else if (string.equals("-s")) {
            Switches.emitSource = true;
        } else if (string.equals("-scramble")) {
            Switches.scramble = true;
        } else if (string.equals("-scrambleall")) {
            Switches.scrambleAll = true;
        } else if (string.equals("-switchcheck")) {
            Switches.switchCheck = true;
        } else if (string.equals("-verbose")) {
            Switches.verbose = true;
        } else if (string.equals("-pizzadoc")) {
            Switches.pizzadoc = true;
        } else if (!Switches.pizzadoc || !DocSwitches.argument(string)) {
            return false;
        }
        return true;
    }

    public static void setDestinationDir(String string) {
        Basic.outDir = string;
    }

    public static void setClassPath(String string) {
        ClassReader.classPath = String.valueOf(string).concat(String.valueOf(ClassReader.pathSep));
    }

    static int option(String[] stringArray, int n) {
        String string = stringArray[n];
        stringArray[n] = null;
        if (string.equals("-classpath") && n + 1 < stringArray.length) {
            Main.setClassPath(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-d") && n + 1 < stringArray.length) {
            Main.setDestinationDir(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-version")) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Pizza ").concat(String.valueOf(Main.version()))).concat(String.valueOf(", "))).concat(String.valueOf(Main.date()))).concat(String.valueOf(", Copyright (c) 1996-98 Martin Odersky.")));
            System.out.println("further information at http://www.cis.unisa.edu.au/~pizza/");
        } else if (!Main.argument(string)) {
            System.out.println(String.valueOf("unrecognized option: ").concat(String.valueOf(string)));
        }
        return n + 1;
    }

    static FileInputStream openIn(String string) {
        try {
            File file = new File(string);
            Switches.inputFiles.pizza$util$Set$put(file);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            Report.error(0, String.valueOf("can't read: ").concat(String.valueOf(string)));
            return null;
        }
    }

    static AST.TopLevel parse(String string) {
        AST[] aSTArray;
        long l = System.currentTimeMillis();
        FileInputStream fileInputStream = Main.openIn(string);
        if (fileInputStream != null) {
            if (Switches.verbose) {
                System.out.print(String.valueOf(String.valueOf("[parsing ").concat(String.valueOf(string))).concat(String.valueOf(" ")));
                System.out.flush();
            }
            Name name = Report.useSource(Name.fromString(string));
            Scanner scanner = new Scanner(fileInputStream);
            Parser parser = new Parser(scanner);
            aSTArray = parser.compilationUnit();
            if (Switches.pizzadoc) {
                DocCollector.hash(aSTArray);
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Switches.verbose) {
                System.out.println(String.valueOf(System.currentTimeMillis() - l).concat(String.valueOf("ms]")));
            }
            Report.useSource(name);
        } else {
            aSTArray = new AST[]{};
        }
        return ASTgen.at(1025).TopLevel(Name.fromString(string), aSTArray);
    }

    static AST.TopLevel translate(AST.TopLevel topLevel) {
        if (Switches.verbose) {
            System.out.println(String.valueOf(String.valueOf("[translating ").concat(String.valueOf(topLevel.sourcefile))).concat(String.valueOf("]")));
        }
        topLevel = new TransPatterns().translate(topLevel);
        topLevel = new TransClosures().translate(topLevel);
        topLevel = new TransTypes().translate(topLevel);
        return topLevel;
    }

    static void process(AST.TopLevel[] topLevelArray) {
        ListBuffer listBuffer = new ListBuffer();
        Enter.compiled.clear();
        for (int i = 0; i < topLevelArray.length; ++i) {
            Enter.classEnter(topLevelArray[i]);
        }
        if (Symtab.init()) {
            for (int i = 0; i < topLevelArray.length; ++i) {
                Enter.prologue(topLevelArray[i]);
            }
            for (int i = 0; i < topLevelArray.length; ++i) {
                Enter.memberEnter(topLevelArray[i]);
            }
            if (!Switches.pizzadoc) {
                int n;
                for (int i = 0; i < topLevelArray.length; ++i) {
                    n = Attr.attribute(topLevelArray[i]);
                    if (Report.nerrors != 0) continue;
                    if (Switches.pizza) {
                        topLevelArray[i] = Main.translate(topLevelArray[i]);
                        if (!Switches.emitSource) continue;
                        Pretty.output(topLevelArray[i]);
                        continue;
                    }
                    if (n != 0) {
                        listBuffer.pizza$lang$ListBuffer$append(topLevelArray[i]);
                        continue;
                    }
                    boolean bl = Switches.errorsPossible;
                    Switches.errorsPossible = true;
                    ByteCodeGen.generate(topLevelArray[i]);
                    Switches.errorsPossible = bl;
                }
                Switches.errorsPossible = false;
                if (Report.nerrors == 0) {
                    if (Switches.pizza) {
                        if (!Switches.emitSource) {
                            Switches.pizza = false;
                            Main.process(topLevelArray);
                            Switches.pizza = true;
                        }
                    } else {
                        n = listBuffer.length();
                        if (n > 0) {
                            AST.TopLevel[] topLevelArray2 = (AST.TopLevel[])array.asObject(listBuffer.pizza$lang$ListBuffer$toList().pizza$lang$List$copy(ObjectArray.make(new AST.TopLevel[n])).ObjectElems());
                            for (int i = 0; i < n; ++i) {
                                topLevelArray2[i] = new TransInner().translate(topLevelArray2[i]);
                                if (!Switches.printTree) continue;
                                Pretty.output(topLevelArray2[i]);
                            }
                            Switches.classesNest = false;
                            Main.process(topLevelArray2);
                            Switches.classesNest = true;
                        }
                    }
                }
                Switches.errorsPossible = true;
            }
        }
    }

    public static void init() {
        Symbol.init();
        Symtab.reader = new ClassReader();
        Symtab.writer = new ClassWriter();
        Type.init();
    }

    public static void compile(String[] stringArray) {
        long l = System.currentTimeMillis();
        Enter.init();
        Report.init();
        Mangle.init();
        Continuations.init();
        AST.TopLevel[] topLevelArray = new AST.TopLevel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            topLevelArray[i] = Main.parse(stringArray[i]);
        }
        try {
            Main.process(topLevelArray);
        }
        catch (ResolveError resolveError) {
            // empty catch block
        }
        if (Switches.pizzadoc) {
            Doc.setDestinationDir(Basic.outDir);
            Doc.process(topLevelArray);
        }
        if (Switches.verbose) {
            System.out.println(String.valueOf(String.valueOf("[total ").concat(String.valueOf(System.currentTimeMillis() - l))).concat(String.valueOf("ms]")));
        }
        Main.printCount("error", Report.nerrors);
        Main.printCount("warning", Report.nwarnings);
        if (Gen.statistics) {
            Gen.stats();
        }
    }

    static void printCount(String string, int n) {
        if (n != 0) {
            System.out.print(n);
            System.out.println(String.valueOf(String.valueOf(" ").concat(String.valueOf(string))).concat(String.valueOf(n == 1 ? "" : "s")));
        }
    }

    static void bugMessage() {
        System.out.println(String.valueOf(String.valueOf("\n\nAn exception has occurred in the compiler. (").concat(String.valueOf(Main.version()))).concat(String.valueOf(")")));
        Report.inviteBugReport();
    }

    public static String version() {
        return "v0.39g";
    }

    public static String date() {
        return "15-August-98";
    }

    public static void main(String[] stringArray) throws Throwable {
        try {
            Main.init();
            int n = 0;
            int n2 = 0;
            justJava = false;
            while (n2 < stringArray.length) {
                if (stringArray[n2].startsWith("-")) {
                    n2 = Main.option(stringArray, n2);
                    continue;
                }
                if (!stringArray[n2].endsWith(".java") && !justJava) {
                    Switches.pizza = true;
                }
                ++n;
                ++n2;
            }
            if (n > 0) {
                String[] stringArray2 = new String[n];
                n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    stringArray2[n++] = stringArray[i];
                }
                Main.compile(stringArray2);
            } else {
                Main.help();
            }
            nerrors = Report.nerrors;
        }
        catch (Throwable throwable) {
            System.out.flush();
            Main.bugMessage();
            throw throwable;
        }
    }
}

