/*
 * Decompiled with CFR 0.152.
 */
package pizza.v39;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import pizza.lang.List;
import pizza.lang.ListBuffer;
import pizza.support.ObjectArray;
import pizza.support.array;
import pizza.util.Enumeration;
import pizza.util.Set;
import pizza.v39.Basic;
import pizza.v39.ClassFileUtil;
import pizza.v39.ClassSymbol;
import pizza.v39.Code;
import pizza.v39.Constants;
import pizza.v39.DoubleConst;
import pizza.v39.FloatConst;
import pizza.v39.FunSymbol;
import pizza.v39.IntConst;
import pizza.v39.LongConst;
import pizza.v39.Mangle;
import pizza.v39.Name;
import pizza.v39.NameAndType;
import pizza.v39.Pool;
import pizza.v39.StringConst;
import pizza.v39.Switches;
import pizza.v39.Symbol;
import pizza.v39.Type;
import pizza.v39.TypeSymbol;
import pizza.v39.VarSymbol;

class ClassWriter
extends ClassFileUtil
implements Constants {
    private static final int DATA_BUF_SIZE = 65536;
    private static final int POOL_BUF_SIZE = 65536;
    private byte[] databuf = new byte[65536];
    private byte[] poolbuf = new byte[65536];
    private Set innerClasses;
    private ListBuffer innerClassesBuf;
    private int innerClassesIdx;
    private byte[] out;
    private int op;

    private void doubleOut() {
        byte[] byArray = new byte[this.out.length * 2];
        System.arraycopy(this.out, 0, byArray, 0, this.out.length);
        this.out = byArray;
    }

    private void writeByte(int n) {
        if (this.op == this.out.length) {
            this.doubleOut();
        }
        this.out[this.op++] = (byte)n;
    }

    private void writeBytes(byte[] byArray, int n, int n2) {
        while (this.op + n2 > this.out.length) {
            this.doubleOut();
        }
        System.arraycopy(byArray, n, this.out, this.op, n2);
        this.op += n2;
    }

    private void writeChar(int n) {
        if (this.op + 2 > this.out.length) {
            this.doubleOut();
        }
        this.out[this.op++] = (byte)(n >> 8 & 0xFF);
        this.out[this.op++] = (byte)(n & 0xFF);
    }

    private void writeInt(int n) {
        if (this.op + 4 > this.out.length) {
            this.doubleOut();
        }
        this.putInt(this.op, n);
        this.op += 4;
    }

    private void putInt(int n, int n2) {
        this.out[n] = (byte)(n2 >> 24 & 0xFF);
        this.out[n + 1] = (byte)(n2 >> 16 & 0xFF);
        this.out[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.out[n + 3] = (byte)(n2 & 0xFF);
    }

    private static char getChar(byte[] byArray, int n) {
        return (char)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    private void writeLong(long l) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            this.writeBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    private void writeFloat(float f) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeFloat(f);
            this.writeBytes(byteArrayOutputStream.toByteArray(), 0, 4);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    private void writeDouble(double d) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeDouble(d);
            this.writeBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new InternalError("write");
        }
    }

    private void putChar(int n, int n2) {
        this.out[n] = (byte)(n2 >> 8 & 0xFF);
        this.out[n + 1] = (byte)(n2 & 0xFF);
    }

    private static void putChar(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    public static Name typeSig(Type type, boolean bl) {
        Type type2 = type.deref();
        switch (type2.pizza$v39$Type$$tag) {
            case 1: {
                int n = ((Type.NumType)type2).tag;
                switch (n) {
                    case 1: {
                        return ClassFileUtil.BYTEsig;
                    }
                    case 3: {
                        return ClassFileUtil.SHORTsig;
                    }
                    case 2: {
                        return ClassFileUtil.CHARsig;
                    }
                    case 4: {
                        return ClassFileUtil.INTsig;
                    }
                    case 5: {
                        return ClassFileUtil.LONGsig;
                    }
                    case 6: {
                        return ClassFileUtil.FLOATsig;
                    }
                    case 7: {
                        return ClassFileUtil.DOUBLEsig;
                    }
                    case 8: {
                        return ClassFileUtil.BOOLEANsig;
                    }
                }
                throw new InternalError();
            }
            case 2: {
                return ClassFileUtil.VOIDsig;
            }
            case 3: {
                Type[] typeArray = type.args();
                Type type3 = type.outer();
                Name name = type.tsym().fullname;
                byte[] byArray = new byte[name.len + 2];
                byArray[0] = 76;
                name.copyAscii(byArray, 1);
                byArray[byArray.length - 1] = 59;
                Name name2 = Name.fromAscii(ClassFileUtil.externalize(byArray, 0, byArray.length), 0, byArray.length);
                if (typeArray.length != 0) {
                    name2 = ClassWriter.compoundSig(name2.append(ClassFileUtil.PARBEGINsig), typeArray, ClassFileUtil.PARENDsig);
                }
                if (type3 instanceof Type.ClassType) {
                    name2 = ClassWriter.typeSig(type3, bl).append(Basic.periodS).append(name2);
                }
                return name2;
            }
            case 4: {
                Type type4 = ((Type.ArrayType)type2).elemtype;
                return ClassFileUtil.ARRAYsig.append(ClassWriter.typeSig(type4, true));
            }
            case 5: {
                Type.FunType funType = (Type.FunType)type2;
                List list = funType.thrown;
                Type type5 = funType.restype;
                Type[] typeArray = funType.argtypes;
                Name name = ClassWriter.compoundSig(ClassFileUtil.ARGBEGINsig, typeArray, ClassFileUtil.ARGENDsig);
                if (bl && !list.isEmpty()) {
                    name = ClassWriter.compoundSig(name.append(ClassFileUtil.PARBEGINsig), (Type[])array.asObject(list.pizza$lang$List$copy(ObjectArray.make(new Type[list.length()])).ObjectElems()), ClassFileUtil.PARENDsig);
                }
                return name.append(ClassWriter.typeSig(type5, true));
            }
            case 7: {
                return ClassFileUtil.TYPEVARsig.append(type.tsym().name).append(Basic.semicolonS);
            }
            case 8: {
                Type.ForAll forAll = (Type.ForAll)type2;
                Type type6 = forAll.qtype;
                Type.TypeVar[] typeVarArray = forAll.tvars;
                return ClassWriter.tvarsSig((Type[])array.asObject(typeVarArray)).append(ClassWriter.typeSig(type6, bl));
            }
        }
        throw new InternalError(String.valueOf("typeSig").concat(String.valueOf(type.tag())));
    }

    public static Name compoundSig(Name name, Type[] typeArray, Name name2) {
        Name[] nameArray = new Name[typeArray.length + 2];
        nameArray[0] = name;
        for (int i = 0; i < typeArray.length; ++i) {
            nameArray[i + 1] = ClassWriter.typeSig(typeArray[i], true);
        }
        nameArray[typeArray.length + 1] = name2;
        return Name.concat(nameArray);
    }

    public static Name tvarsSig(Type[] typeArray) {
        Name[] nameArray = new Name[typeArray.length * 3 + 1];
        nameArray[0] = ClassFileUtil.PARBEGINsig;
        nameArray[1] = typeArray[0].tsym().name;
        int n = 2;
        for (int i = 1; i < typeArray.length; ++i) {
            nameArray[n++] = Basic.commaS;
            nameArray[n++] = typeArray[i].tsym().name;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            List list = ((Type.TypeVar)typeArray[i]).bounds;
            nameArray[n++] = ClassWriter.compoundSig(ClassFileUtil.PARBEGINsig, (Type[])array.asObject(list.pizza$lang$List$copy(ObjectArray.make(new Type[list.length()])).ObjectElems()), ClassFileUtil.PARENDsig);
        }
        nameArray[n++] = ClassFileUtil.PARENDsig;
        return Name.concat(nameArray);
    }

    static Name xClassName(Type type) {
        Type type2 = type.deref();
        switch (type2.pizza$v39$Type$$tag) {
            case 3: {
                return type.tsym().fullname;
            }
            case 4: {
                return ClassWriter.typeSig(type, false);
            }
        }
        throw new InternalError("xClassName");
    }

    private void putInner(Pool pool, TypeSymbol typeSymbol) {
        Mangle mangle = (Mangle)Mangle.mangled.pizza$util$Hashtable$get(typeSymbol.fullname);
        if (mangle != null && !this.innerClasses.pizza$util$Set$contains(typeSymbol.fullname)) {
            if (this.innerClassesIdx == 0) {
                this.innerClassesIdx = pool.put(ClassFileUtil.InnerClassesS);
            }
            this.putInner(pool, mangle.owner);
            this.innerClasses.pizza$util$Set$put(typeSymbol.fullname);
            this.innerClassesBuf.pizza$lang$ListBuffer$append(new int[]{pool.put(typeSymbol), pool.put(mangle.owner), pool.put(mangle.name), mangle.mods});
        }
    }

    private void writeInnerClasses(int n, Pool pool, ListBuffer listBuffer) {
        if (this.innerClassesIdx != 0) {
            ClassWriter.putChar(this.out, n, ClassWriter.getChar(this.out, n) + '\u0001');
            int n2 = this.writeAttr(pool, ClassFileUtil.InnerClassesS);
            this.writeChar(listBuffer.length());
            Enumeration enumeration = listBuffer.pizza$lang$ListBuffer$elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.pizza$util$Enumeration$nextElement();
                this.writeChar(nArray[0]);
                this.writeChar(nArray[1]);
                this.writeChar(nArray[2]);
                this.writeChar(nArray[3]);
            }
            this.endAttr(n2);
        }
    }

    private void writePool(Pool pool) {
        int n = this.op;
        this.writeChar(0);
        for (int i = 1; i < pool.pp; ++i) {
            byte[] byArray;
            Object object;
            Object object2 = pool.pool[i];
            Basic.assert(object2 != null);
            if (object2 instanceof Name) {
                this.writeByte(1);
                object = ((Name)object2).toAscii();
                this.writeChar(((Object)object).length);
                this.writeBytes((byte[])object, 0, ((Object)object).length);
                continue;
            }
            if (object2 instanceof ClassSymbol) {
                object = (ClassSymbol)object2;
                this.writeByte(7);
                byArray = ((TypeSymbol)object).fullname.toAscii();
                this.writeChar(pool.put(Name.fromAscii(ClassFileUtil.externalize(byArray, 0, byArray.length), 0, byArray.length)));
                this.putInner(pool, (TypeSymbol)object);
                continue;
            }
            if (object2 instanceof FunSymbol) {
                object = (FunSymbol)object2;
                if ((((Symbol)object).owner.modifiers & 0x200) != 0) {
                    this.writeByte(11);
                } else {
                    this.writeByte(10);
                }
                this.writeChar(pool.put(((Symbol)object).owner));
                this.writeChar(pool.put(ClassWriter.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof VarSymbol) {
                object = (VarSymbol)object2;
                this.writeByte(9);
                this.writeChar(pool.put(((Symbol)object).owner));
                this.writeChar(pool.put(ClassWriter.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof NameAndType) {
                object = (NameAndType)object2;
                this.writeByte(12);
                this.writeChar(pool.put(((NameAndType)object).name));
                this.writeChar(pool.put(((NameAndType)object).sig));
                continue;
            }
            if (object2 instanceof IntConst) {
                this.writeByte(3);
                this.writeInt(((IntConst)object2).intValue());
                continue;
            }
            if (object2 instanceof LongConst) {
                this.writeByte(5);
                this.writeLong(((LongConst)object2).longValue());
                ++i;
                continue;
            }
            if (object2 instanceof FloatConst) {
                this.writeByte(4);
                this.writeFloat(((FloatConst)object2).floatValue());
                continue;
            }
            if (object2 instanceof DoubleConst) {
                this.writeByte(6);
                this.writeDouble(((DoubleConst)object2).doubleValue());
                ++i;
                continue;
            }
            if (object2 instanceof StringConst) {
                this.writeByte(8);
                this.writeChar(pool.put(((StringConst)object2).value));
                continue;
            }
            if (object2 instanceof Type) {
                object = (Type)object2;
                this.writeByte(7);
                byArray = ClassWriter.xClassName((Type)object2).toAscii();
                this.writeChar(pool.put(Name.fromAscii(ClassFileUtil.externalize(byArray, 0, byArray.length), 0, byArray.length)));
                continue;
            }
            throw new InternalError(String.valueOf("writePool ").concat(String.valueOf(object2)));
        }
        this.putChar(n, pool.pp);
    }

    private int writeAttr(Pool pool, Name name) {
        this.writeChar(pool.put(name));
        this.writeInt(0);
        return this.op;
    }

    private void endAttr(int n) {
        this.putInt(n - 4, this.op - n);
    }

    private void writeCode(Pool pool, Code code) {
        int n;
        int n2;
        int n3 = 0;
        if (code.nlines > 0) {
            ++n3;
        }
        if (code.nvars > 0) {
            ++n3;
        }
        int n4 = this.writeAttr(pool, ClassFileUtil.CodeS);
        this.writeChar(code.max_stack);
        this.writeChar(code.max_locals);
        this.writeInt(code.cp);
        this.writeBytes(code.code, 0, code.cp);
        this.writeChar(code.ncatches);
        for (int i = 0; i < code.ncatches; ++i) {
            this.writeChar(code.exc_start_pc[i]);
            this.writeChar(code.exc_end_pc[i]);
            this.writeChar(code.exc_handler_pc[i]);
            this.writeChar(code.exc_catch_type[i]);
        }
        this.writeChar(n3);
        if (code.nlines > 0) {
            n2 = this.writeAttr(pool, ClassFileUtil.LineNumberTableS);
            this.writeChar(code.nlines);
            for (n = 0; n < code.nlines; ++n) {
                this.writeChar(code.line_start_pc[n]);
                this.writeChar(code.line_number[n]);
            }
            this.endAttr(n2);
        }
        if (code.nvars > 0) {
            n2 = this.writeAttr(pool, ClassFileUtil.LocalVariableTableS);
            this.writeChar(code.nvars);
            n = code.nvars;
            int n5 = 0;
            while (n > 0) {
                if (code.lvar[n5] != null) {
                    this.writeChar(code.lvar_start_pc[n5]);
                    this.writeChar(code.lvar_length[n5]);
                    this.writeChar(pool.put(code.lvar[n5].name));
                    this.writeChar(pool.put(ClassWriter.typeSig(code.lvar[n5].type, false)));
                    this.writeChar(code.lvar_reg[n5]);
                    --n;
                }
                ++n5;
            }
            this.endAttr(n2);
        }
        this.endAttr(n4);
    }

    private static Name fieldName(Symbol symbol) {
        if ((symbol.modifiers & 2) != 0 && Switches.scramble || (symbol.modifiers & 5) == 0 && Switches.scrambleAll) {
            return Name.fromString(String.valueOf("_$").concat(String.valueOf(symbol.name.index)));
        }
        return symbol.name;
    }

    private static NameAndType nameType(Symbol symbol) {
        return new NameAndType(ClassWriter.fieldName(symbol), ClassWriter.typeSig(symbol.type, false));
    }

    private void writeField(Pool pool, VarSymbol varSymbol) {
        int n;
        this.writeChar(varSymbol.modifiers);
        this.writeChar(pool.put(ClassWriter.fieldName(varSymbol)));
        this.writeChar(pool.put(ClassWriter.typeSig(varSymbol.type, true)));
        int n2 = 0;
        if (varSymbol.type.isConstant()) {
            ++n2;
        }
        if ((varSymbol.modifiers & 0x10000) != 0) {
            ++n2;
        }
        if ((varSymbol.modifiers & 0x20000) != 0) {
            ++n2;
        }
        if (varSymbol.caseNum() != 0) {
            ++n2;
        }
        this.writeChar(n2);
        if (varSymbol.type.isConstant()) {
            n = this.writeAttr(pool, ClassFileUtil.ConstantValueS);
            this.writeChar(pool.put(varSymbol.type.constValue()));
            this.endAttr(n);
        }
        if ((varSymbol.modifiers & 0x20000) != 0) {
            n = this.writeAttr(pool, ClassFileUtil.DeprecatedS);
            this.endAttr(n);
        }
        if ((varSymbol.modifiers & 0x10000) != 0) {
            n = this.writeAttr(pool, ClassFileUtil.SyntheticS);
            this.endAttr(n);
        }
        if (varSymbol.caseNum() != 0) {
            n = this.writeAttr(pool, ClassFileUtil.PizzaCaseS);
            this.writeChar(varSymbol.caseNum());
            this.endAttr(n);
        }
    }

    private void writeMethod(Pool pool, FunSymbol funSymbol) {
        int n;
        this.writeChar(funSymbol.modifiers);
        this.writeChar(pool.put(ClassWriter.fieldName(funSymbol)));
        this.writeChar(pool.put(ClassWriter.typeSig(funSymbol.type, false)));
        List list = funSymbol.type.thrown();
        int n2 = 0;
        if (funSymbol.code != null) {
            ++n2;
        }
        if (!list.isEmpty()) {
            ++n2;
        }
        if ((funSymbol.modifiers & 0x10000) != 0) {
            ++n2;
        }
        if ((funSymbol.modifiers & 0x20000) != 0) {
            ++n2;
        }
        if (funSymbol.caseNum() != 0) {
            ++n2;
        }
        this.writeChar(n2);
        if (funSymbol.code != null) {
            this.writeCode(pool, funSymbol.code);
            funSymbol.code = null;
        }
        if (!list.isEmpty()) {
            n = list.length();
            int n3 = this.writeAttr(pool, ClassFileUtil.ExceptionsS);
            this.writeChar(n);
            for (int i = 0; i < n; ++i) {
                this.writeChar(pool.put(((Type)list.pizza$lang$List$head()).tsym()));
                list = list.pizza$lang$List$tail();
            }
            this.endAttr(n3);
        }
        if ((funSymbol.modifiers & 0x10000) != 0) {
            n = this.writeAttr(pool, ClassFileUtil.SyntheticS);
            this.endAttr(n);
        }
        if ((funSymbol.modifiers & 0x20000) != 0) {
            n = this.writeAttr(pool, ClassFileUtil.DeprecatedS);
            this.endAttr(n);
        }
        if (funSymbol.caseNum() != 0) {
            n = this.writeAttr(pool, ClassFileUtil.PizzaCaseS);
            this.writeChar(funSymbol.caseNum());
            this.endAttr(n);
        }
    }

    private void writeFields(Pool pool, Symbol symbol) {
        if (symbol != null) {
            this.writeFields(pool, symbol.sibling);
            if (symbol.sym.kind == 4) {
                this.writeField(pool, (VarSymbol)symbol.sym);
            }
        }
    }

    private void writeMethods(Pool pool, Symbol symbol) {
        if (symbol != null) {
            this.writeMethods(pool, symbol.sibling);
            if (symbol.sym.kind == 8 && !symbol.sym.isContinuation()) {
                this.writeMethod(pool, (FunSymbol)symbol.sym);
            }
        }
    }

    int writeClass(ClassSymbol classSymbol) {
        int n;
        boolean bl;
        Symbol symbol;
        this.writeChar(classSymbol.modifiers);
        this.writeChar(classSymbol.pool.put(classSymbol));
        if (classSymbol.supertype() == null) {
            this.writeChar(0);
        } else if (Switches.pizza) {
            this.writeChar(classSymbol.pool.put(ClassWriter.typeSig(classSymbol.supertype(), false)));
        } else {
            this.writeChar(classSymbol.pool.put(classSymbol.supertype().tsym()));
        }
        Type[] typeArray = classSymbol.interfaces();
        this.writeChar(typeArray.length);
        for (int i = 0; i < typeArray.length; ++i) {
            if (Switches.pizza) {
                this.writeChar(classSymbol.pool.put(ClassWriter.typeSig(typeArray[i], false)));
                continue;
            }
            this.writeChar(classSymbol.pool.put(typeArray[i].tsym()));
        }
        int n2 = 0;
        int n3 = 0;
        Symbol symbol2 = symbol = classSymbol.locals().elems;
        while (symbol2 != null) {
            switch (symbol2.sym.kind) {
                case 4: {
                    ++n2;
                    break;
                }
                case 8: {
                    if (symbol2.sym.isContinuation()) break;
                    ++n3;
                    break;
                }
                case 2: {
                    this.putInner(classSymbol.pool, (ClassSymbol)symbol2.sym);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            symbol2 = symbol2.sibling;
        }
        this.writeChar(n2);
        this.writeFields(classSymbol.pool, symbol);
        this.writeChar(n3);
        this.writeMethods(classSymbol.pool, symbol);
        int n4 = 0;
        if (classSymbol.sourcefile != null) {
            ++n4;
        }
        if (classSymbol.caseNum() != 0) {
            ++n4;
        }
        if ((classSymbol.modifiers & 0x10000) != 0) {
            ++n4;
        }
        if ((classSymbol.modifiers & 0x20000) != 0) {
            ++n4;
        }
        boolean bl2 = bl = !Switches.pizza && classSymbol.locals_p != null;
        if (bl) {
            ++n4;
        }
        int n5 = this.op;
        this.writeChar(n4);
        if (classSymbol.sourcefile != null) {
            n = this.writeAttr(classSymbol.pool, ClassFileUtil.SourceFileS);
            this.writeChar(classSymbol.pool.put(classSymbol.sourcefile));
            this.endAttr(n);
        }
        if (classSymbol.caseNum() != 0) {
            n = this.writeAttr(classSymbol.pool, ClassFileUtil.PizzaCaseS);
            this.writeChar(classSymbol.caseNum());
            this.endAttr(n);
        }
        if ((classSymbol.modifiers & 0x10000) != 0) {
            n = this.writeAttr(classSymbol.pool, ClassFileUtil.SyntheticS);
            this.endAttr(n);
        }
        if ((classSymbol.modifiers & 0x20000) != 0) {
            n = this.writeAttr(classSymbol.pool, ClassFileUtil.DeprecatedS);
            this.endAttr(n);
        }
        if (bl) {
            Switches.pizza = true;
            n = this.writeAttr(classSymbol.pool, ClassFileUtil.PizzaS);
            Type[] typeArray2 = classSymbol.type.args();
            if (typeArray2.length == 0) {
                this.writeChar(0);
            } else {
                this.writeChar(classSymbol.pool.put(ClassWriter.tvarsSig(typeArray2)));
            }
            this.writeClass(classSymbol);
            this.endAttr(n);
        }
        return n5;
    }

    void writeClassFile(ClassSymbol classSymbol) throws IOException {
        this.innerClasses = new Set();
        this.innerClassesBuf = new ListBuffer();
        this.innerClassesIdx = 0;
        this.out = this.databuf;
        this.op = 0;
        boolean bl = Switches.pizza;
        Switches.pizza = false;
        int n = this.writeClass(classSymbol);
        Switches.pizza = bl;
        this.databuf = this.out;
        int n2 = this.op;
        if (classSymbol.pool.pp > 65535) {
            throw new IOException("too many constants");
        }
        this.out = this.poolbuf;
        this.op = 0;
        this.writeInt(-889275714);
        this.writeChar(3);
        this.writeChar(45);
        this.writePool(classSymbol.pool);
        int n3 = this.op;
        this.writeBytes(this.databuf, 0, n2);
        this.writeInnerClasses(n3 + n, classSymbol.pool, this.innerClassesBuf);
        this.poolbuf = this.out;
        File file = Basic.openOutput(classSymbol.sourcefile, classSymbol.fullname, ".class");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(this.out, 0, this.op);
        fileOutputStream.close();
        if (Switches.verbose) {
            System.out.println(String.valueOf(String.valueOf("[wrote ").concat(String.valueOf(file.getPath()))).concat(String.valueOf("]")));
        }
    }

    ClassWriter() {
    }
}

