/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashtableEnumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import kaffe.util.NotImplemented;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULTCAPACITY = 101;
    private static final float DEFAULTLOADFACTOR = 0.75f;
    private static final Object removed = new Object();
    private static final Object free;
    private static final long serialVersionUID = 1421746759512286392L;
    private Object[] keys;
    private Object[] elements;
    private float loadFactor;
    private int numberOfKeys;
    private int rehashLimit;

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        return this.numberOfKeys == 0;
    }

    public synchronized Enumeration keys() {
        Vector vector = new Vector(this.numberOfKeys);
        int n = this.keys.length - 1;
        while (n >= 0) {
            if (this.keys[n] != null && this.keys[n] != removed) {
                vector.addElement(this.keys[n]);
            }
            --n;
        }
        return new HashtableEnumeration(vector);
    }

    public synchronized Enumeration elements() {
        Vector vector = new Vector(this.numberOfKeys);
        int n = this.elements.length - 1;
        while (n >= 0) {
            if (this.keys[n] != null && this.keys[n] != removed) {
                vector.addElement(this.elements[n]);
            }
            --n;
        }
        return new HashtableEnumeration(vector);
    }

    public synchronized boolean contains(Object object) {
        int n = this.elements.length - 1;
        while (n >= 0) {
            if (object.equals(this.elements[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    private int calculateBucket(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.keys.length;
    }

    public synchronized Object get(Object object) {
        Object object2;
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        int n3 = n;
        while (n3 < n2) {
            object2 = this.keys[n3];
            if (object.equals(object2)) {
                return this.elements[n3];
            }
            if (object2 == null) {
                return null;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            object2 = this.keys[n3];
            if (object.equals(object2)) {
                return this.elements[n3];
            }
            if (object2 == null) {
                return null;
            }
            ++n3;
        }
        return null;
    }

    protected synchronized void rehash() {
        int n = this.keys.length * 2;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.elements;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.rehashLimit = (int)(this.loadFactor * (float)n);
        this.numberOfKeys = 0;
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            if (objectArray[n2] != null && objectArray[n2] != removed) {
                this.put(objectArray[n2], objectArray2[n2]);
            }
            --n2;
        }
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3;
        if (this.numberOfKeys >= this.rehashLimit) {
            this.rehash();
        }
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            object3 = this.keys[n4];
            if (object.equals(object3)) {
                Object object4 = this.elements[n4];
                this.elements[n4] = object2;
                return object4;
            }
            if (object3 == removed) {
                if (n3 == -1) {
                    n3 = n4;
                }
            } else if (object3 == null) {
                if (n3 == -1) {
                    n3 = n4;
                }
                this.keys[n3] = object;
                this.elements[n3] = object2;
                ++this.numberOfKeys;
                return null;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            object3 = this.keys[n4];
            if (object.equals(object3)) {
                Object object5 = this.elements[n4];
                this.elements[n4] = object2;
                return object5;
            }
            if (object3 == removed) {
                if (n3 == -1) {
                    n3 = n4;
                }
            } else if (object3 == null) {
                if (n3 == -1) {
                    n3 = n4;
                }
                this.keys[n3] = object;
                this.elements[n3] = object2;
                ++this.numberOfKeys;
                return null;
            }
            ++n4;
        }
        if (n3 != -1) {
            this.keys[n3] = object;
            this.elements[n3] = object2;
            ++this.numberOfKeys;
            return null;
        }
        throw new Error("Inconsistent Hashtable");
    }

    public synchronized Object remove(Object object) {
        Object object2;
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        int n3 = n;
        while (n3 < n2) {
            object2 = this.keys[n3];
            if (object.equals(object2)) {
                Object object3 = this.elements[n3];
                this.elements[n3] = removed;
                this.keys[n3] = removed;
                --this.numberOfKeys;
                return object3;
            }
            if (object2 == null) {
                return null;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            object2 = this.keys[n3];
            if (object.equals(object2)) {
                Object object4 = this.elements[n3];
                this.elements[n3] = removed;
                this.keys[n3] = removed;
                --this.numberOfKeys;
                return object4;
            }
            if (object2 == null) {
                return null;
            }
            ++n3;
        }
        return null;
    }

    public synchronized void clear() {
        int n = this.keys.length - 1;
        while (n >= 0) {
            this.keys[n] = null;
            this.elements[n] = null;
            --n;
        }
        this.numberOfKeys = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object clone() {
        Hashtable hashtable;
        try {
            hashtable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        hashtable.numberOfKeys = 0;
        hashtable.loadFactor = this.loadFactor;
        hashtable.keys = new Object[this.keys.length];
        hashtable.elements = new Object[this.elements.length];
        int n = this.keys.length - 1;
        while (n >= 0) {
            if (this.keys[n] != null && this.keys[n] != removed) {
                hashtable.put(this.keys[n], this.elements[n]);
            }
            --n;
        }
        return hashtable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        n = (int)((float)this.rehashLimit / this.loadFactor);
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.numberOfKeys = 0;
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.keys.length);
        objectOutputStream.writeInt(this.numberOfKeys);
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != null && this.keys[n] != removed) {
                objectOutputStream.writeObject(this.keys[n]);
                objectOutputStream.writeObject(this.elements[n]);
            }
            ++n;
        }
    }

    public synchronized String toString() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != null && this.keys[n] != removed) {
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
            }
            ++n;
        }
        while (n < this.keys.length) {
            if (this.keys[n] != null && this.keys[n] != removed) {
                stringBuffer.append(", ");
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public void putAll(Map map) {
        Object[] objectArray = map.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.put(objectArray[n], map.get(objectArray[n]));
            ++n;
        }
    }

    public Set entrySet() {
        throw new NotImplemented();
    }

    public Set keySet() {
        throw new NotImplemented();
    }

    public Collection values() {
        throw new NotImplemented();
    }

    /* synthetic */ float access$0() {
        return this.loadFactor;
    }

    /* synthetic */ void access$1(float f) {
        this.loadFactor = f;
    }

    /* synthetic */ int access$2() {
        return this.rehashLimit;
    }

    /* synthetic */ void access$3(int n) {
        this.rehashLimit = n;
    }

    public Hashtable() {
        this(101, 0.75f);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        if (n <= 0) {
            throw new Error("Initial capacity is <= 0");
        }
        if ((double)f <= 0.0) {
            throw new Error("Load Factor is <= 0");
        }
        this.loadFactor = f;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.numberOfKeys = 0;
        this.rehashLimit = (int)(f * (float)n);
    }

    class DefaultSerialization {
        private float loadFactor;
        private int threshold;

        private void readDefaultObject() {
            Hashtable.this.access$1(this.loadFactor);
            Hashtable.this.access$3(this.threshold);
        }

        private void writeDefaultObject() {
            this.loadFactor = Hashtable.this.access$0();
            this.threshold = Hashtable.this.access$2();
        }

        DefaultSerialization() {
        }
    }
}

